#ifndef SHADER_INLINE_INCLUDED
#define SHADER_INLINE_INCLUDED

/*
Copyright (C) 2000 Jason Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#if   defined(WIN32)
  #define _SH_INLINE __inline
#elif defined(__GNUC__)
  #define _SH_INLINE static inline
#else 
  #define _SH_INLINE static
#endif



/* is_blend_filter
 ***************************************************************************/
_SH_INLINE bool sh_is_blend_filter(sh_stage_t* s)
{
   return (((s->blend_src == SH_BLEND_ZERO) && (s->blend_dst == SH_BLEND_SRC_COLOR)) ||
           ((s->blend_src == SH_BLEND_DST_COLOR) && (s->blend_dst == SH_BLEND_ZERO)));
}



/* is_blend_blend
 ***************************************************************************/
_SH_INLINE bool sh_is_blend_blend(sh_stage_t* s)
{
   return ((s->blend_src == SH_BLEND_SRC_ALPHA) &&
           (s->blend_dst == SH_BLEND_ONE_MINUS_SRC_ALPHA));
}



/* is_blend_add
 ***************************************************************************/
_SH_INLINE bool sh_is_blend_add(sh_stage_t* s)
{
   return ((s->blend_src == SH_BLEND_ONE) && (s->blend_dst == SH_BLEND_ONE));
}



/* is_blend_src_only
 ***************************************************************************/
_SH_INLINE bool sh_is_blend_src_only(sh_stage_t* s)
{
   return ((s->blend_src == SH_BLEND_ONE) && (s->blend_dst == SH_BLEND_ZERO));
}



/* is_blend_dst_only
 ***************************************************************************/
_SH_INLINE bool sh_is_blend_dst_only(sh_stage_t* s)
{
   return ((s->blend_src == SH_BLEND_ZERO) && (s->blend_dst == SH_BLEND_ONE));
}



/* is_opaque_stage
 ***************************************************************************/
_SH_INLINE bool sh_is_opaque_stage(sh_stage_t* s)
{
   return !((s->flags & SH_STAGE_BLENDFUNC) || (s->flags & SH_STAGE_ALPHAFUNC));
}



#endif
