#-------------------------------------------------------------------------------
#
#       Module:         mapteamdup.py
#       Subsystem:      mapteamdup
#       Program:        mapteamdup
#
#       Copyright (c) 1998 - Descartes Systems Sciences
#
#-------------------------------------------------------------------------------
#
#       Description:
#
#-------------------------------------------------------------------------------
#
#	$History: mapteamdup $
#       
#-------------------------------------------------------------------------------


Info = {
   "plug-in":       "Team duplication",
   "desc":          "Duplicate a team, available from the Search menu.",
   "date":          "9 nov 98",
   "author":        "Tim Smith",
   "author e-mail": "etsmith@mindspring.com",
   "quark":         "Version 5.1" }


import quarkx
import quarkpy.qmacro
import quarkpy.qtoolbar
import quarkpy.mapentities
import quarkpy.qhandles
from quarkpy.maputils import *
import regex

pattTarget = regex .compile ("\([a-zA-A0-9_]+\)\([0-9]+\)")

#
# Class used to perform the duplication
#

class TeamDuplicate:

    #
    # __init__ initialize the object
    #

    def __init__(self, form):
	pass

    #
    # Locate the origin
    #
    
    def LocateOrigin (self, e):
	
	#
	# Locate the origin
	#

	origin = e .findshortname ("origin");
	if not (origin is None):
	    origin = quarkpy .mapentities .ObjectOrigin (origin)
	if origin is None:
	    msg = "Origin not defined for '%s'" % e .shortname
	    quarkx .msgbox(msg, MT_ERROR, MB_OK)
	    return None
	return origin
	    
    #
    # Locate the team and the origin
    #

    def LocateTeamAndOrigin (self, number, editor):

	#
	# Locate the team object
	#

	teamname = "team%d" % number
	team = editor .Root .findshortname (teamname);
	if team is None:
	    msg = "'%s' group not found in worldspawn" % teamname
	    quarkx .msgbox(msg, MT_ERROR, MB_OK)
	    return None, None

	#
	# Locate the origin
	#

	teamorigin = self .LocateOrigin (team)
	if teamorigin is None:
	    return None, None

	#
	# Return the objects
	#

	return team, teamorigin

    #
    # Adjust target names
    #

    def AdjustTargetNames (self, list, number, name, undo):

	#
	# Loop through the objects
	#

	for e in list:

	    #
	    # Get the spec
	    #

	    try:
		text = e [name]
	    except KeyError:
		text = None

	    #
	    # If found
	    #

	    if not (text is None):

		#
		# Parse the target for a "text_number" format
		#

		if pattTarget .match (text) >= 0:

		    #
		    # Extract the root name and the number
		    #

		    rootname = pattTarget .group (1)
		    fromnumber = int (pattTarget .group (2))

		    #
		    # Adjust the number as required
		    #

		    if fromnumber == 1:
			newtext = rootname + str (number)
			e [name] = newtext
		    elif fromnumber == number:
			newtext = rootname + "1"
			e [name] = newtext
		    else:
			print "Unable to convert " + name + text

	    #
	    # Do the same to the children
	    #
	    		 
	    self .AdjustTargetNames (e .subitems, number, name, undo)
	return

    #
    # Adjust spec values
    #

    def AdjustSpecValue (self, list, oldval, newval, name, undo):

	#
	# Loop through the objects
	#

	for e in list:

	    #
	    # Get the spawn flags
	    #

	    try:
		spec = e [name]
	    except KeyError:
		spec = None

	    #
	    # If found
	    #

	    if not (spec is None):
		if spec == oldval:
		    e [name] = newval
		elif spec == newval:
		    e [name] = oldval

	    #
	    # Do the same to the children
	    #
	    		 
	    self .AdjustSpecValue (e .subitems, oldval, newval, name, undo)
	return
    #
    # Adjust entity names
    #

    def AdjustEntityNames (self, list, oldent, newent, undo):

	#
	# Loop through the objects
	#

	for e in list:

	    #
	    # If found, replace
	    #

	    if e .shortname == oldent:
		e .shortname = newent

	    #
	    # Do the same to the children
	    #
	    		 
	    self .AdjustEntityNames (e .subitems, oldent, newent, undo)
	return

    #
    # Adjust spawn flags
    #

    def AdjustSpawnFlags (self, list, oldval, newval, name, undo):

	#
	# Loop through the objects
	#

	for e in list:

	    #
	    # If the entity name matches
	    #

	    if e .shortname == name:

		#
		# Get the spawn flags
		#

		try:
		    flags = e ["spawnflags"]
		except KeyError:
		    flags = None

		#
		# If found
		#

		if not (flags is None):
		    flags = int (flags)
		    if flags & oldval:
			newflags = (flags & ~ oldval) | newval
			e ["spawnflags"] = str (newflags)
		    elif flags & newval:
			newflags = (flags & ~ newval) | oldval
			e ["spawnflags"] = str (newflags)

	    #
	    # Do the same to the children
	    #
	    		 
	    self .AdjustSpawnFlags (e .subitems, oldval, newval, name, undo)
	return

    #
    # Adjust textures
    #

    def AdjustTexture (self, list, oldval, newval, undo):

	#
	# Loop through the objects
	#

	for e in list:

	    #
	    # Change the texture
	    #
	    
	    e .replacetex (oldval, newval)

	    #
	    # Do the same to the children
	    #
	    		 
	    self .AdjustTexture (e .subitems, oldval, newval, undo)
	return

    #
    # Adjust currents
    #

    def AdjustCurrent (self, list, symmetry, undo):

	#
	# Loop through the objects
	#

	for e in list:

	    #
	    # If a face
	    #

	    if e .type == ":f":

		#
		# Get the contents
		#

		try:
		    flags = e ["contents"]
		except KeyError:
		    flags = None

		#
		# If found
		#

		if not (flags is None):
		    flags = int (flags)
		    newflags = flags
		    if symmetry == "Y" or symmetry == "XY":
			if flags & 262144:
			    newflags = (newflags & ~ 262144) | 1048576
			elif flags & 1048576:
			    newflags = (newflags & ~ 1048576) | 262144
		    if symmetry == "X" or symmetry == "XY":
			if flags & 524288:
			    newflags = (newflags & ~ 524288) | 2097152
			elif flags & 2097152:
			    newflags = (newflags & ~ 2097152) | 524288
		    if newflags != flags:
			e ["contents"] = str (newflags)

	    #
	    # Do the same to the children
	    #
	    		 
	    self .AdjustCurrent (e .subitems, symmetry, undo)
	return

    #
    # Collect a list of objects
    #

    def CollectObjects (self, list):

	#
	# Loop through the objects
	#

	for e in list:

	    #
	    # Add object to proper list
	    #

	    if e .shortname == "turret_breach":
		self .breaches .append (e)
	    elif e .shortname == "turret_base":
		self .bases .append (e)
	    elif e .shortname == "turret_driver":
		self .drivers .append (e)
	    elif e .shortname == "info_notnull":
		self .notnulls .append (e)
	    elif e .shortname == "func_door_rotating":
		self .drotates .append (e)

	    #
	    # Do the same to the children
	    #

	    self .CollectObjects (e .subitems)
	return

    #
    # Duplicate the team
    #

    def DuplicateTeam (self, team1, team1origin, number, editor, undo):

	#
	# Test for the next team
	#

	teamname = "team%d" % number
	team = editor .Root .findshortname (teamname);
	if team is None:
	    return 0

	#
	# Locate the new team and origin
	#

	teamx, teamxorigin = self .LocateTeamAndOrigin (number, editor)
	if (teamx is None) or (teamxorigin is None):
	    return 0

	#
	# Get the symmetry of the team
	#
	try:
	    symmetry = teamx ["Symmetry"]
	except KeyError:
	    symmetry = None
	if symmetry is None:
	    msg = "Symmetry specific not set for '%s'" % teamname
	    quarkx .msgbox(msg, MT_ERROR, MB_OK)
	    return 0

	#
	# Get the matrix based on the symmetry
	#

	if symmetry == "X":
	    matrix = quarkx .matrix ((-1,0,0), (0,1,0), (0,0,1))
	elif symmetry == "Y":
	    matrix = quarkx .matrix ((1,0,0), (0,-1,0), (0,0,1))
	elif symmetry == "XY":
	    matrix = quarkx .matrix ((-1,0,0), (0,-1,0), (0,0,1))
	else:
	    msg = "Symmetry setting for '%s' is not valid" % teamname
	    quarkx .msgbox(msg, MT_ERROR, MB_OK)
	    return 0

	#
	# Compute the offset
	#

	offset = teamxorigin - team1origin 

	#
	# Delete all of the objects from the team
	#

	subitems = teamx .subitems
	for s in subitems:
	    undo .exchange (s, None)

	#
	# Duplicate the team1 objects
	#

	subitems = team1 .subitems
	newitems = [];
	for s in subitems:
	    sc = s .copy ()
	    sc .linear (team1origin, matrix)
	    sc .translate (offset)
	    undo .put (teamx, sc)
	    newitems .append (sc)

	#
	# Loop through all of the objects in the set looking for 
	# targets and targetnames that need to change
	#

	self .AdjustTargetNames (newitems, number, "targetname", undo)
	self .AdjustTargetNames (newitems, number, "target", undo)
	self .AdjustTargetNames (newitems, number, "team", undo)

	#
	# Next, loop through the spec changes
	#

	index = 1
	while 1:
	    text = "spec%d" % index
	    try:
		spec1 = team1 [text]
		specx = teamx [text]
		specname = team1 [text + "name"]
	    except KeyError:
		spec1 = None
	    if (spec1 is None) or (specx is None) or (specname is None):
		break
	    self .AdjustSpecValue (newitems, spec1, specx, specname, undo)
	    index = index + 1

	#
	# Next, loop through the name adjusts
	#

	index = 1
	while 1:
	    text = "entity%d" % index
	    try:
		entity1 = team1 [text]
		entityx = teamx [text]
	    except KeyError:
		entity1 = None
	    if (entity1 is None) or (entityx is None):
		break
	    self .AdjustEntityNames (newitems, entity1, entityx, undo)
	    index = index + 1

	#
	# Next, loop through the spawnflags changes
	#

	index = 1
	while 1:
	    text = "spawnflag%d" % index
	    try:
		spawn1 = team1 [text]
		spawnx = teamx [text]
		spawnname = team1 [text + "name"]
	    except KeyError:
		spawn1 = None
	    if (spawn1 is None) or (spawnx is None) or (spawnname is None):
		break
	    self .AdjustSpawnFlags (newitems, int (spawn1), int (spawnx), spawnname, undo)
	    index = index + 1

	#
	# Next, loop through the texture changes
	#

	index = 1
	while 1:
	    text = "texture%d" % index
	    try:
		tex1 = team1 [text]
		texx = teamx [text]
	    except KeyError:
		tex1 = None
	    if (tex1 is None) or (texx is None):
		break
	    self .AdjustTexture (newitems, tex1, texx, undo)
	    index = index + 1

	#
	# Collect a list of objects needing special changes
	#

	self .breaches = []
	self .bases = []
	self .drivers = []
	self .notnulls = []
	self .drotates = []
	self .CollectObjects (newitems)

	#
	# Loop through the breaches
	#

	for breach in self .breaches:

	    #
	    # Get the specifics
	    #
	    try:
		targetname = breach ["targetname"]
		target = breach ["target"]
		team = breach ["team"]
	    except KeyError:
		targetname = None
	    if (targetname is None) or (target is None) or (team is None):
		continue

	    #
	    # Locate the base
	    #

	    for base in self .bases:
		try:
		    t = base ["team"]
		except:
		    t = None
		if t is None:
		    base = None
		    break
		if t == team:
		    break
	    if base is None:
		continue

	    #
	    # Locate the driver
	    #

	    for driver in self .drivers:
		try:
		    t = driver ["target"]
		except:
		    t = None
		if t is None:
		    driver = None
		    break
		if t == targetname:
		    break
	    if driver is None:
		continue

	    #
	    # Locate the info_notnull
	    #

	    for notnull in self .notnulls:
		try:
		    t = notnull ["targetname"]
		except:
		    t = None
		if t is None:
		    notnull = None
		    break
		if t == target:
		    break
	    if notnull is None:
		continue

	    #
	    # Get the origins
	    #

	    breachorigin = self .LocateOrigin (breach)
	    baseorigin = self .LocateOrigin (base)
	    if (breachorigin is None) or (baseorigin is None):
		continue

	    #
	    # Rotate the objects
	    #

	    breach .linear (breachorigin, matrix)
	    notnull .linear (breachorigin, matrix)
	    base .linear (baseorigin, matrix)
	    qmacro .MACRO_applylinear (breach, matrix)
	    qmacro .MACRO_applylinear (notnull, matrix)
	    qmacro .MACRO_applylinear (driver, matrix)
	    qmacro .MACRO_applylinear (base, matrix)

	    #
	    # Adjust the turret's yaw
	    #

	    v2a = quarkpy .qhandles .vec2angle
	    a2v = quarkpy .qhandles .angle2vec
            minyaw = breach ["minyaw"]
	    maxyaw = breach ["maxyaw"]
            if minyaw and maxyaw:
#                try:
                minyaw = v2a (matrix * a2v (minyaw))
		maxyaw = v2a (matrix * a2v (maxyaw))
		if int (minyaw) > int (maxyaw):
		    minyaw = str (int (minyaw) - 360)
		breach ["minyaw"] = minyaw
		breach ["maxyaw"] = maxyaw
#                except:
#		    print "Exception"
#		    pass

	#
	# Loop through the rotating doors
	#

	for e in self .drotates:
	
	    #
	    # Get the spawnflags
	    #

	    try:
		flags = e ["spawnflags"]
	    except KeyError:
		flags = None

	    #
	    # If found
	    #

	    if not (flags is None):
		flags = int (flags)
		if (flags & 64) != 0 and (symmetry == "Y" or symmetry == "XY"):
		    newflags = flags ^ 2
		    e ["spawnflags"] = str (newflags)
		elif (flags & 128) != 0 and (symmetry == "X" or symmetry == "XY"):
		    newflags = flags ^ 2
		    e ["spawnflags"] = str (newflags)

	#
	# Change the currents
	#

	self .AdjustCurrent (newitems, symmetry, undo)
	return 1

    #
    # Perform the actual duplication
    #

    def Duplicate (self, editor):

	#
	# Locate team1 information
	#

	team1, team1origin = self .LocateTeamAndOrigin (1, editor)
	if team1 is None: 
	    return

	#
	# Begin an undo
	#

        undo = quarkx .action()

	#
	# Loop through the teams
	#

	number = 2
	while 1:
	    if not self .DuplicateTeam (team1, team1origin, number, editor, undo):
		break
	    number = number + 1

	#
	# Accept or reject the undo
	#

	if number == 2:
	    undo .cancel ()
	else:
	    undo .ok (editor .Root, "team duplicate")

	#
	# The end
	#

	return

#
# Function to start the replace dialog
#
	
def TempDuplicateClick (m):
    editor = mapeditor ()
    if editor is None: return
    dup = TeamDuplicate (quarkx.clickform)
    dup .Duplicate (editor)

#
# Register the replace texture menu item
#

quarkpy.mapcommands.items.append(quarkpy.qmenu.sep)   # separator
quarkpy.mapcommands.items.append(quarkpy.qmenu.item("Team Duplicate", TempDuplicateClick))

