/*
 * Copyright (C) 1996 by Chris Johnson.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation.  If more than a few
 * lines of this code are used in a program which displays a copyright
 * notice or credit notice, the following acknowledgment must also be
 * displayed on the same screen: "This product includes software
 * developed by Chris Johnson for use in the QuakeDef Tools package."
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESSED OR IMPLIED
 * WARRANTY.
 *
 * (Thanks to Raphael Quinet for this nifty disclaimer!)
 */

#include <stdio.h>
#include <stdlib.h>

#include "qdexport.h"
#include "fileutil.h"
#include "qdfunct.h"

int main(int argc, char *argv[])
{
	FILE *	bsp;
	FILE *	qdf;
	long *	addr;

	if (argc < 3)
	{
		show_help();
		return (OKAY);
	}

	// in file
	if ((bsp = safeopen(argv[1], "rb")) == NULL)
		exit(ERROR);

	// out file
	if ((qdf = safeopen(argv[2], "wt")) == NULL)
		exit(ERROR);

	// Get BSP header file
	if ((addr = grab_addresses(bsp)) == NULL)
		exit(ERROR);

	fseek(bsp, addr[BH_QD_ELEM], SEEK_SET);

	if (export_quake_def(bsp, qdf, addr[BH_QDSIZE_ELEM]) == EOF)
	{
		fprintf(stderr, "\nError -- premature end of file in file:");
		fprintf(stderr, "\n%s\n", argv[1]);
		exit(ERROR);
	}

	// Tidy up
	free(addr);
	fclose(bsp);
	fclose(qdf);

	fprintf(stderr, "\nExport of BSP file successful!\n");

	return (OKAY);
}

void show_help(void)
{
	printf("\nQuakeDef Exporter v1.0.  Copyright 1996 by Chris Johnson.");
	printf("\n\nUsage:");
	printf("\n\nqdexport <drive:><\\path\\><mapfile.bsp> "
			"<drive:><\\path\\><deffile.def>");
	printf("\n\n<drive:> and <\\path\\> unnecessary if "
			"current directory is adequate");
	printf("\n<mapfile.bsp> is the filename of the .BSP "
			"file to extract from");
	printf("\n<deffile.def> is the filename for the ASCII dump\n");
}