#include "stdafx.h"
#include "crispdc.h"


CSmartDC SmartDC;


CSmartDC::CSmartDC()
{
  LockedDC = 0;
  PrevLockedDC =0;
  m_pWorkField = NULL;
  OutputToOtherWindow = FALSE;
  m_pOtherWindow = NULL;
  ColorFixed = ColorSet = FALSE;
  LockedForPainting = FALSE;
  m_pOutputDC = NULL;
  m_pCurrentPen = NULL;
  m_pCurrentBrush = NULL;
  m_bUseBitmap = FALSE;
  m_pBmpOldPalette = NULL;
  m_pBitmap = NULL;
  m_pCurrentPalette = NULL;
  m_pOldPalette = NULL;
  DC_Created = FALSE;
  m_DrawMode = R2_COPYPEN;

  TextParamsDefined = FALSE;
  m_pOldFont = NULL;
  m_pBmpOldFont = NULL;
  m_bTextAlignChanged = FALSE;
  m_bBMPTextAlignChanged = FALSE;
  m_bBkModeChanged = FALSE;
  m_bBMPBkModeChanged = FALSE;
  m_bTextColorChanged = FALSE;
  m_bBMPTextColorChanged = FALSE;
  m_bBkColorChanged = FALSE;
  m_bBMPBkColorChanged = FALSE;
}

CSmartDC::~CSmartDC()
{
  if (LockedDC)
    DestroyDC();
}

void CSmartDC::Initialize(CWnd *pWorkField,CPalette** aPalette)
{
  m_pCurrentPalette = aPalette;
  m_pWorkField = pWorkField;
  ASSERT(m_pWorkField != NULL); // Invalid initialization !!!
}
      
void CSmartDC::LockDC(BOOL ForTextOut /*= FALSE*/)
{                    
  ASSERT(m_pWorkField != NULL); // Must be initialized first !!!
  ASSERT(LockedDC>=0);  // Invalid Lock/Unlock sequence
  if (!LockedDC)
    CreateDC();
  LockedDC++;
}

void CSmartDC::UnLockDC()
{
  ASSERT(m_pWorkField != NULL); // Must be initialized first !!!
  ASSERT(LockedDC>0);  // Invalid Lock/Unlock sequence
  if (LockedDC == 1)
    DestroyDC();
  LockedDC--;
}


void CSmartDC::LockWMPaintDC()
{
  ASSERT(!LockedForPainting); // Subsequential WM_PAINT, how do you imagine that ???
  ASSERT(LockedDC == 0);      // DC already in use for output while WM_PAINT received !
  LockedForPainting = TRUE;
  LockDC();
}

void CSmartDC::UnLockWMPaintDC()
{
  ASSERT(LockedForPainting);  // bad WM_PAINT process sequense
  ASSERT(LockedDC == 1);      // Mismatching in Lock/Unlock calls
  UnLockDC();
  LockedForPainting = FALSE;
}

void CSmartDC::LockAttachedDC()
{
  ASSERT(!LockedForAttach);
  LockedForAttach = TRUE;
  LockDC();
}

void CSmartDC::UnLockAttachedDC()
{
  ASSERT(LockedForAttach);
  UnLockDC();
  LockedForAttach = FALSE;
}


void CSmartDC::SetOutputWindow(CWnd *pNewWindow)
{
  ASSERT(!OutputToOtherWindow); // Subsequential output windows not allowed !!
  ASSERT(pNewWindow != NULL); // Invalid initialization !!!
  OutputToOtherWindow = TRUE;
  m_pOtherWindow = pNewWindow;
  m_BmpWasUsed = m_bUseBitmap;
  m_bUseBitmap = FALSE;
  PrevLockedDC = LockedDC;
  if (LockedDC)
    DestroyDC();
  LockedDC = 0;
}

void CSmartDC::ReleaseOutputWindow()
{
  ASSERT(OutputToOtherWindow); // output window not initialized !!
  OutputToOtherWindow = FALSE;
  m_pOtherWindow = NULL;
  
  LockedDC = PrevLockedDC;
  m_bUseBitmap = m_BmpWasUsed;

  if (LockedDC)
    CreateDC();
  PrevLockedDC = 0;
}

void CSmartDC::AttachDC(HDC hDC)
{
  OutputToAttached = TRUE;
  m_BmpWasUsed = m_bUseBitmap;
  m_bUseBitmap = FALSE;
  PrevLockedDC = LockedDC;
  if (LockedDC)
    DestroyDC();
  LockedDC = 0;
  m_hDCToAttach = hDC;
}

void CSmartDC::DetachDC()
{
  OutputToAttached = FALSE;
  LockedDC = PrevLockedDC;
  m_bUseBitmap = m_BmpWasUsed;
  m_hDCToAttach = NULL;
  if (LockedDC)
    CreateDC();
  PrevLockedDC = 0;
}

void CSmartDC::CreateDC()
{
  CWnd *pWnd = OutputToOtherWindow ? m_pOtherWindow : m_pWorkField;
  ASSERT_VALID(pWnd);

  if(LockedForPainting)
    m_pOutputDC = pWnd->BeginPaint(&m_ps);
  else 
    if(LockedForAttach)
    {
      m_pOutputDC = new CDC;
      m_pOutputDC->Attach(m_hDCToAttach);
    }
   else m_pOutputDC = new CClientDC(pWnd);
    
  if(!LockedForAttach && m_pCurrentPalette)
  {
    m_pOldPalette = m_pOutputDC->SelectPalette(*m_pCurrentPalette,FALSE);
    m_pOutputDC->RealizePalette();
  }  

  if (m_bUseBitmap)
    EnableBitmap();

  DC_Created = TRUE;
  ColorSet = FALSE;
  if (ColorFixed)
     SetColor(CurrColor,TRUE);
  if (m_DrawMode != R2_COPYPEN)
     SetROP2(m_DrawMode);
}

void CSmartDC::DestroyDC()
{
  CWnd *pWnd = OutputToOtherWindow ? m_pOtherWindow : m_pWorkField;
  ASSERT_VALID(pWnd);
    
  if (ColorSet) 
  {
    RestorePen();
    RestoreBrush();
    ColorSet = FALSE; 
  }
   
  DisableBitmap();

  if(m_pCurrentPalette)
  {
    m_pOutputDC->SelectPalette(m_pOldPalette,FALSE);
    m_pOldPalette = NULL;
  }
      
  if(LockedForPainting)
    pWnd->EndPaint(&m_ps); 
  else
    if(LockedForAttach)
    { 
      m_pOutputDC->Detach();
      delete m_pOutputDC;
    }
    else  
      delete ((CClientDC *)m_pOutputDC);
  
  DC_Created = FALSE;    
  m_pOutputDC = NULL;
}


void CSmartDC::DisableBitmap()
{
  if (!m_bUseBitmap)
    return;
  
  m_bUseBitmap = FALSE;  
  if (DC_Created)  
  { // DC Already created
    //        m_bmpDC.SelectPalette(m_pBmpOldPalette,FALSE);
    //        m_bmpDC.SelectObject(m_pOldBitmap);
    if (ColorSet) 
    {
      if (m_pBmpOldPen) 
      {
        m_bmpDC.SelectObject(m_pBmpOldPen);
        m_pBmpOldPen = NULL; 
      }
      if (m_pBmpOldBrush) 
      {
        m_bmpDC.SelectObject(m_pBmpOldBrush); 
        m_pBmpOldBrush = NULL; 
      }
    }
    m_bmpDC.DeleteDC();
  }
}
      
void CSmartDC::EnableBitmap(CBitmap *pBitmap)
{
  if (pBitmap) 
  {
    m_bUseBitmap = TRUE;
    m_pBitmap = pBitmap;
    if (DC_Created)  // DC Already created
      EnableBitmap();
  }
  else
    m_bUseBitmap = FALSE;
}
      

void CSmartDC::EnableBitmap()
{
  m_bmpDC.CreateCompatibleDC(m_pOutputDC);
  
  if(m_pCurrentPalette)
  {
    m_pBmpOldPalette = m_bmpDC.SelectPalette(*m_pCurrentPalette,FALSE);
    m_bmpDC.RealizePalette();
  }

  m_pOldBitmap = m_bmpDC.SelectObject(m_pBitmap);
  if (ColorSet) 
  {
    m_pBmpOldPen = m_bmpDC.SelectObject(m_pCurrentPen);
    m_pBmpOldBrush = m_bmpDC.SelectObject(m_pCurrentBrush); 
  }
}
      
void CSmartDC::SetColor(COLORREF crColor,BOOL UseDefinedPen /*=FALSE*/)
{
  if (UseDefinedPen)
    SetNewPen(m_nPenStyle, m_nPenWidth, crColor);
  else
    SetNewPen(PS_SOLID, 0, crColor);
         
  if (DC_Created)  
  { // DC Already created
     SetNewBrush(crColor);
     ColorSet = TRUE; 
  }
}
    
void CSmartDC::SetNewPen(int nPenStyle, int nWidth, COLORREF crColor)
{
  ColorFixed = TRUE;
  m_nPenStyle = nPenStyle;
  m_nPenWidth = nWidth;
  CurrColor = crColor;
      
  if (!DC_Created)
    return;
      
  CPen *pNewPen = new CPen(nPenStyle, nWidth, crColor);
  if (!pNewPen) 
    return;
    
  CPen* pOldPen = m_pOutputDC->SelectObject(pNewPen);
    
  CPen* pBmpOldPen = NULL;
  if (m_bUseBitmap)
    pBmpOldPen = m_bmpDC.SelectObject(pNewPen);
    
  if (m_pCurrentPen)
    delete m_pCurrentPen;
  m_pCurrentPen = pNewPen;
  if (!m_pOldPen)
    m_pOldPen = pOldPen;
    
  if (m_bUseBitmap && !m_pBmpOldPen)
    m_pBmpOldPen = pBmpOldPen;
}
    
void CSmartDC::SetNewBrush(COLORREF crColor)
{
  CBrush *pNewBrush = new CBrush();
  if (!pNewBrush->CreateSolidBrush(crColor))
    return;
    
  CBrush* pOldBrush = m_pOutputDC->SelectObject(pNewBrush);
    
  CBrush* pBmpOldBrush = NULL;
  if (m_bUseBitmap)
    pBmpOldBrush = m_bmpDC.SelectObject(pNewBrush);
    
  if (m_pCurrentBrush)
    delete m_pCurrentBrush;
  m_pCurrentBrush = pNewBrush;
  if (!m_pOldBrush)
    m_pOldBrush = pOldBrush;
    
  if (m_bUseBitmap && !m_pBmpOldBrush)
    m_pBmpOldBrush = pBmpOldBrush;
}
    
void CSmartDC::RestorePen()
{
  if (m_pOldPen) 
  {
    m_pOutputDC->SelectObject(m_pOldPen);
    m_pOldPen = NULL; 
  }

  if (m_bUseBitmap && m_pBmpOldPen) 
  {
    m_bmpDC.SelectObject(m_pBmpOldPen);
    m_pBmpOldPen = NULL; 
  }

  if (m_pCurrentPen) 
  {
     delete m_pCurrentPen;
     m_pCurrentPen = NULL; 
  }
}
    
void CSmartDC::RestoreBrush()
{
  if (m_pOldBrush) 
  {
    m_pOutputDC->SelectObject(m_pOldBrush);
    m_pOldBrush = NULL; 
  }

  if (m_bUseBitmap && m_pBmpOldBrush) 
  {
    m_bmpDC.SelectObject(m_pBmpOldBrush);
    m_pBmpOldBrush = NULL; 
  }

  if (m_pCurrentBrush) 
  {
    delete m_pCurrentBrush;
    m_pCurrentBrush = NULL; 
  }
}

void CSmartDC::SelectClipRgn(CRgn *pRgn)
{
  m_pOutputDC->SelectClipRgn(pRgn);
  if (m_bUseBitmap)
  {
    m_bmpDC.SelectClipRgn(pRgn);
  }  
}
        
void CSmartDC::Line(int x1, int y1, int x2, int y2)
{
  LockDC();

  m_pOutputDC->MoveTo(x1,y1); 
  m_pOutputDC->LineTo(x2,y2); 
  m_pOutputDC->LineTo(x2+1,y2);
  if (m_bUseBitmap)
  {
    m_bmpDC.MoveTo(x1,y1); m_bmpDC.LineTo(x2,y2); m_bmpDC.LineTo(x2+1,y2);
  }
  UnLockDC();
}

void CSmartDC::Polyline(POINT *p,int nCount)
{
  LockDC();
  m_pOutputDC->Polyline(p,nCount);
  if (m_bUseBitmap)
  {
    m_bmpDC.Polyline(p,nCount);
  }
  UnLockDC();
}

void CSmartDC::DrawPolyPoly(POINT *lppt,int *lpnPolyCount,int cIntegers)
{
  LockDC();
  if(cIntegers == 1)
  {
    m_pOutputDC->SetPolyFillMode(WINDING);
    m_pOutputDC->Polygon(lppt,*lpnPolyCount);           
    if(m_bUseBitmap)
    { 
      m_bmpDC.SetPolyFillMode(WINDING);
      m_bmpDC.Polygon(lppt,*lpnPolyCount);
    }  
  }
  else
  {
    CRect clipRect;
  
    CRgn hrgn;
    hrgn.CreatePolyPolygonRgn(lppt,lpnPolyCount,cIntegers,ALTERNATE);
    // cia tikimes jog priest tai buves clip regionas buvo staciakampis 
    m_pOutputDC->GetClipBox(&clipRect);
  
    m_pOutputDC->SelectObject(&hrgn);
    m_pOutputDC->PaintRgn(&hrgn);
  
    CRgn hrgn2;
    hrgn2.CreateRectRgn(clipRect.left,clipRect.top,clipRect.right,clipRect.bottom);
  
    m_pOutputDC->SelectClipRgn(&hrgn2);
 
    if (m_bUseBitmap)
    {
      m_bmpDC.SelectObject(&hrgn);
      m_bmpDC.PaintRgn(&hrgn);
      m_bmpDC.SelectClipRgn(&hrgn2);
    }        
  }  
  UnLockDC();
}

void CSmartDC::DrawPolyPolyExt(POINT *lppt,int *lpnPolyCount,int cIntegers)
{
 // jeigu turime vien polygon jokio regiono kurti nereikia ...
  if(cIntegers == 1)
  {
    m_pOutputDC->Polygon(lppt,*lpnPolyCount);           
    if(m_bUseBitmap)
      m_bmpDC.Polygon(lppt,*lpnPolyCount);
  }
  else
  {
    int total = 0;
    for(int i = 0; i < cIntegers; i++)
      total += lpnPolyCount[i];
  
    m_pOutputDC->LPtoDP(lppt,total);
    int oldMode = m_pOutputDC->SetMapMode(MM_TEXT);
  
    CRgn hrgn;    // jeigu nepavyko sukurti regiono, pvz. pritrko atminties
                  // paiome visus polygonus, nepaisant skyls jie ar ne
    if(hrgn.CreatePolyPolygonRgn(lppt,lpnPolyCount,cIntegers,ALTERNATE))
    {
      m_pOutputDC->FillRgn(&hrgn,m_pCurrentBrush);
      if(m_bUseBitmap)
        m_bmpDC.FillRgn(&hrgn,m_pCurrentBrush);
    }
    else
    {
/*
      m_pOutputDC->PolyPolygon(lppt,lpnPolyCount, cIntegers);
      if(m_bUseBitmap)
        m_bmpDC.PolyPolygon(lppt,lpnPolyCount, cIntegers);
*/        
    }
    hrgn.DeleteObject();
    m_pOutputDC->SetMapMode(oldMode);
  }  
}


    
void CSmartDC::FilledCircle(int cx, int cy, int radius)
{
  if (radius <= 0)
    radius = 1;
  LockDC();
  // use current pen and brush
  m_pOutputDC->Ellipse(cx-radius, cy-radius, cx+radius+1, cy+radius+1);
  if (m_bUseBitmap)
     m_bmpDC.Ellipse(cx-radius, cy-radius, cx+radius+1, cy+radius+1);
  UnLockDC();
}
    
void CSmartDC::Circle(int cx, int cy, int radius)
{
  if (radius <= 0)
    radius = 1;
  
  LockDC();

  CBrush brush;
  LOGBRUSH logBrush;
    
  logBrush.lbStyle = BS_HOLLOW;
  if (!brush.CreateBrushIndirect(&logBrush))
    return;
  CBrush* pOldBrush = m_pOutputDC->SelectObject(&brush);
    
  m_pOutputDC->Ellipse(cx-radius, cy-radius, cx+radius+1, cy+radius+1);

  if (pOldBrush)
    m_pOutputDC->SelectObject(pOldBrush);
    
  if (m_bUseBitmap)
  {
    pOldBrush = m_bmpDC.SelectObject(&brush);
    
    m_bmpDC.Ellipse(cx-radius, cy-radius, cx+radius+1, cy+radius+1);
    
    if (pOldBrush)
      m_bmpDC.SelectObject(pOldBrush);
  }
  UnLockDC();
}
    
void CSmartDC::Box(int x1, int y1, int x2, int y2)
{
  LockDC();

  POINT theLine[5];
    
  theLine[0].x = x1;  theLine[0].y = y1;
  theLine[1].x = x2;  theLine[1].y = y1;
  theLine[2].x = x2;  theLine[2].y = y2;
  theLine[3].x = x1;  theLine[3].y = y2;
  theLine[4].x = x1;  theLine[4].y = y1;
    
  m_pOutputDC->Polyline(theLine, sizeof(theLine)/sizeof(POINT));
  if (m_bUseBitmap)
    m_bmpDC.Polyline(theLine, sizeof(theLine)/sizeof(POINT));
  UnLockDC();
}
    
void CSmartDC::Bar(int x1, int y1, int x2, int y2)
{
  LockDC();

   // use current pen and brush
  m_pOutputDC->Rectangle(x1, y1, x2+1, y2+1);
  if (m_bUseBitmap)
    m_bmpDC.Rectangle(x1, y1, x2+1, y2+1);
  UnLockDC();
}

void CSmartDC::OutBitmap(CBitmap *pBitmap)
{
  LockDC();
  CRect Rc;
    
  CWnd *pWnd = OutputToOtherWindow ? m_pOtherWindow : m_pWorkField;
  ASSERT_VALID(pWnd);
  pWnd->GetClientRect(&Rc);
    
  CDC MDC;
  MDC.CreateCompatibleDC(m_pOutputDC);
  CBitmap *pOldBitmap = MDC.SelectObject(pBitmap);
  CPalette *pOldPalette2;
  if(m_pCurrentPalette)
  {
    pOldPalette2 = MDC.SelectPalette(*m_pCurrentPalette,FALSE);
    MDC.RealizePalette();
  }
  m_pOutputDC->BitBlt(0, 0, Rc.right, Rc.bottom, &MDC, 0, 0, SRCCOPY);
  if(m_pCurrentPalette)
  {
    MDC.SelectPalette(pOldPalette2,FALSE);
  }

  UnLockDC();
}

void CSmartDC::OutBitmapEx(int x,int y,CBitmap *pBitmap,DWORD op)
{
  LockDC();
  
  BITMAP bmpInfo;
  pBitmap->GetObject(sizeof(bmpInfo),&bmpInfo);
    
  CDC MDC;
  MDC.CreateCompatibleDC(m_pOutputDC);
  CBitmap *pOldBitmap = MDC.SelectObject(pBitmap);
  CPalette *pOldPalette2;
  if(m_pCurrentPalette)
  {
    pOldPalette2 = MDC.SelectPalette(*m_pCurrentPalette,FALSE);
    MDC.RealizePalette();
  }
  m_pOutputDC->BitBlt(x, y, bmpInfo.bmWidth, bmpInfo.bmHeight, &MDC, 0, 0, op);
  if(m_pCurrentPalette)
  {
    MDC.SelectPalette(pOldPalette2,FALSE);
  }
  UnLockDC();
}

void CSmartDC::SetROP2(int DrawMode)
{
  m_DrawMode = DrawMode;
  if (DC_Created)
    m_pOutputDC->SetROP2(DrawMode);
}


void CSmartDC::DrawFocusRect(CRect *focusRect)
{
  LockDC();

  m_pOutputDC->DrawFocusRect(focusRect);

  UnLockDC();
}

CSize CSmartDC::GetTextExtent(const char *szText)
{
  LockDC(TRUE);

  CSize ret = m_pOutputDC->GetTextExtent(szText,strlen(szText));

  UnLockDC();
  return ret;
}


    
// ==================================================================================
    
void VertLine(int x1, int y1, int y2)
{ 
  SmartDC.Line(x1,y1,x1,y2);
}
    
void HorLine(int x1, int x2, int y1)
{
  SmartDC.Line(x1,y1,x2,y1);
}
    
void Line(int x1, int y1, int x2, int y2)
{
  SmartDC.Line(x1,y1,x2,y2);
}

void Polyline(POINT *p,int c)
{
  SmartDC.Polyline(p,c);
}
    
void Box(int x1, int y1, int x2, int y2)
{
  SmartDC.Box(x1,y1,x2,y2);
}

void Circle(int cx, int cy, int radius)
{
  SmartDC.Circle(cx,cy,radius);
}
 
void Bar(int x1, int y1, int x2, int y2)
{
  SmartDC.Bar(x1,y1,x2,y2);
}
 
 
void FilledCircle(int cx, int cy, int radius)
{
  SmartDC.FilledCircle(cx,cy,radius);
}


void SetColor(COLORREF crColor)
{                      
  SmartDC.SetColor(crColor);
}


// ==============================================================================

void DC_Initialize(CWnd *pWorkField,CPalette** aPalette)
{
  SmartDC.Initialize(pWorkField,aPalette);
}
   
void DC_SetOutputWindow(CWnd *pNewWindow)
{
  SmartDC.SetOutputWindow(pNewWindow);
}
   
   
void DC_ReleaseOutputWindow()
{
  SmartDC.ReleaseOutputWindow();
}
   
   
void DC_DisableBitmap()
{
  SmartDC.DisableBitmap();
}
   
   
void DC_EnableBitmap(CBitmap *pBitmap)
{
  SmartDC.EnableBitmap(pBitmap);
}
   
   
void OutBitmap(CBitmap *pBitmap)
{    
  SmartDC.OutBitmap(pBitmap);
}

void OutBitmapEx(int x,int y,CBitmap *pBitmap,DWORD op)
{    
  SmartDC.OutBitmapEx(x,y,pBitmap,op);
}

void SetNewPen(int nPenStyle, int nWidth, COLORREF crColor)
{
  SmartDC.SetNewPen(nPenStyle,nWidth,crColor);
}
   
void SetROP2(int DrawMode)
{
  SmartDC.SetROP2(DrawMode);
}
   
   
void DrawPolyPoly(POINT *lppt,int *lpnPolyCount,int cIntegers) 
{
  SmartDC.DrawPolyPoly(lppt,lpnPolyCount,cIntegers);
}

void DrawPolyPolyExt(POINT *lppt,int *lpnPolyCount,int cIntegers) 
{
  SmartDC.DrawPolyPolyExt(lppt,lpnPolyCount,cIntegers);
}

   
void DrawFocusRect(CRect *focusRect)
{
  SmartDC.DrawFocusRect(focusRect);
}

void DC_TextOut(int x,int y,const char *szText)
{
  SmartDC.TextOut(x,y,szText);
}

void DC_LockDC()
{
  SmartDC.LockDC();
}

void DC_UnLockDC()
{
  SmartDC.UnLockDC();   
}   

void DC_SelectClipRgn(CRgn *pRgn)
{
  SmartDC.SelectClipRgn(pRgn);
}

void DC_AttachDC(HDC hDC) 
{
  SmartDC.AttachDC(hDC);
}

void DC_DetachDC()
{
  SmartDC.DetachDC();
}
  
void DC_LockAttachedDC()
{
  SmartDC.LockAttachedDC();
}  

void DC_UnLockAttachedDC()
{
  SmartDC.UnLockAttachedDC();
}

CSize DC_GetTextExtent(const char *szText)
{
  return SmartDC.GetTextExtent(szText);

}

void DC_SetFont(const char *font,int size)
{
  SmartDC.SetFont(font,size);
}

void CSmartDC::SetFont(const char *fName,int size)
{
  m_strFont = fName;
  m_nFontSize = size;
}

void CSmartDC::TextOut(int x,int y,const char *text)
{
  LockDC();
  CFont textFont;
  textFont.CreateFont(m_nFontSize,0,0,0,FW_NORMAL,FALSE,FALSE,FALSE,
        ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,m_strFont);
  m_pOutputDC->SetBkMode(TRANSPARENT);
  if (m_bUseBitmap)
    m_bmpDC.SetBkMode(TRANSPARENT);
  m_pOldFont = m_pOutputDC->SelectObject(&textFont);
  if(m_bUseBitmap)
    m_pBmpOldFont = m_bmpDC.SelectObject(&textFont);
  m_pOutputDC->TextOut(x,y,text);
  if(m_bUseBitmap)
    m_bmpDC.TextOut(x,y,text);
  m_pOutputDC->SelectObject(m_pOldFont);
  if(m_bUseBitmap)
    m_bmpDC.SelectObject(m_pBmpOldFont);
  UnLockDC();
}