    #ifndef __CRISPDC_H__
    #define __CRISPDC_H__
    
    #include <afxwin.h>

  
   void VertLine(int x1, int y1, int y2);
   void HorLine(int x1, int x2, int y1);
   void Line(int x1, int y1, int x2, int y2);
   void Polyline(POINT *,int);
   void Box(int x1, int y1, int x2, int y2);
   void Circle(int cx, int cy, int radius);
   void Bar(int x1, int y1, int x2, int y2);
   void FilledCircle(int cx, int cy, int radius);
   void SetColor(COLORREF crColor);
   void OutBitmap(CBitmap *pBitmap);
   void OutBitmapEx(int x,int y,CBitmap *,DWORD op = SRCCOPY);
   void SetNewPen(int nPenStyle, int nWidth, COLORREF crColor);
   void SetROP2(int DrawMode);
   void DrawPolyPoly(POINT *lppt,int *lpnPolyCount,int cIntegers) ;
   void DrawFocusRect(CRect *focusRect);
                   
   void DC_Initialize(CWnd *pWorkField,CPalette* &aPalette);
   void DC_SetOutputWindow(CWnd *pNewWindow);
   void DC_ReleaseOutputWindow();
   void DC_DisableBitmap();
   void DC_EnableBitmap(CBitmap *pBitmap);

   void DC_TextOut(int x,int y,const char *szText);
   CSize DC_GetTextExtent(const char *szText);
   void DC_SetFont(const char *,int);
   void DC_AttachDC(HDC); 
   void DC_DetachDC();
   void DC_LockAttachedDC(); 
   void DC_UnLockAttachedDC();

//   Macro LOCK_DC();
//   Macro LOCK_WMPAINT_DC();

    class CSmartDC
    {
      friend class CDCConstructor;
      friend void VertLine(int x1, int y1, int y2);
      friend void HorLine(int x1, int x2, int y1);
      friend void Line(int x1, int y1, int x2, int y2);
      friend void Polyline(POINT *,int);
      friend void Box(int x1, int y1, int x2, int y2);
      friend void Circle(int cx, int cy, int radius);
      friend void Bar(int x1, int y1, int x2, int y2);
      friend void FilledCircle(int cx, int cy, int radius);
      friend void SetColor(int crColor);
      friend void SetColor(COLORREF crColor);
      friend void SetROP2(int DrawMode);
      friend void DrawFocusRect(CRect *focusRect);

      friend void DC_Initialize(CWnd *pWorkField,CPalette** aPalette);
      friend void DC_SetOutputWindow(CWnd *pNewWindow);
      friend void DC_ReleaseOutputWindow();
      friend void DC_DisableBitmap();
      friend void DC_EnableBitmap(CBitmap *pBitmap);
      friend void OutBitmap(CBitmap *pBitmap);          
      friend void OutBitmapEx(int x,int y,CBitmap *,DWORD op);
      friend void SetNewPen(int nPenStyle, int nWidth, COLORREF crColor);
      friend void DrawPolyPoly(POINT *lppt,int *lpnPolyCount,int cIntegers);
      friend void DrawPolyPolyExt(POINT *lppt,int *lpnPolyCount,int cIntegers);
      
      friend void DC_TextOut(int x,int y,const char *szText);
      friend CSize DC_GetTextExtent(const char *szText);
      friend void DC_SetFont(const char *,int);
      friend void DC_LockDC();
      friend void DC_UnLockDC();
      friend void DC_SelectClipRgn(CRgn *);
      friend void DC_AttachDC(HDC); 
      friend void DC_DetachDC();
      friend void DC_LockAttachedDC(); 
      friend void DC_UnLockAttachedDC();
    
    private:

      int LockedDC;
      int PrevLockedDC;
      CWnd *m_pWorkField;
      CWnd *m_pOtherWindow;
      BOOL OutputToOtherWindow;
      COLORREF CurrColor;
      BOOL ColorSet,ColorFixed;
      BOOL LockedForPainting;
      CDC *m_pOutputDC;
      CBitmap *m_pBitmap;

      CPen *m_pCurrentPen, *m_pOldPen;
      CBrush *m_pCurrentBrush, *m_pOldBrush;
      CPalette  **m_pCurrentPalette;
      CPalette  *m_pOldPalette,*m_pBmpOldPalette;
      CPen *m_pBmpOldPen;
      CBrush *m_pBmpOldBrush;

      CDC m_bmpDC;
      CBitmap *m_pOldBitmap;
      BOOL m_bUseBitmap,m_BmpWasUsed,DC_Created;

      int m_nPenStyle;
      int m_nPenWidth;
      int m_DrawMode;

      CFont *m_pOldFont,*m_pBmpOldFont;
      BOOL TextParamsDefined,m_bTextAlignChanged,m_bBMPTextAlignChanged,
           m_bBkModeChanged,m_bBMPBkModeChanged,m_bTextColorChanged,
           m_bBMPTextColorChanged,m_bBkColorChanged,m_bBMPBkColorChanged;
      UINT m_uPrevTextAlign,m_uBMPPrevTextAlign;
      int m_iPrevBkMode,m_iBMPPrevBkMode;
      COLORREF m_cPrevTextColor,m_cBMPPrevTextColor,m_cPrevBkColor,m_cBMPPrevBkColor;

      PAINTSTRUCT m_ps;
      
      BOOL OutputToAttached,LockedForAttach;
      HDC m_hDCToAttach;
      CString m_strFont;
      int m_nFontSize;

    public:
      CSmartDC();
      ~CSmartDC();
                  
    private:

      void Initialize(CWnd *pWorkField,CPalette** aPalette);
      void SetOutputWindow(CWnd *pNewWindow);
      void ReleaseOutputWindow();
      
      void AttachDC(HDC); 
      void DetachDC();
      
      void DisableBitmap();
      void EnableBitmap(CBitmap *pBitmap);

      void OutBitmap(CBitmap *pBitmap);
      void OutBitmapEx(int x,int y,CBitmap *,DWORD op);
      void EnableBitmap();
      void LockDC(BOOL ForTextOut = FALSE);
      void UnLockDC();
      void LockWMPaintDC();
      void UnLockWMPaintDC();
      void LockAttachedDC(); 
      void UnLockAttachedDC();
      
      void CreateDC();
      void DestroyDC();

      void SetColor(COLORREF crColor,BOOL UseDefinedPen = FALSE);
      void SetColor(int nColor);
      void SetNewPen(int nPenStyle, int nWidth, COLORREF crColor);
      void SetNewBrush(COLORREF crColor);
      void RestorePen();
      void RestoreBrush();
      void SetROP2(int DrawMode);
      void SelectClipRgn(CRgn *);
      
      void Line(int x1, int y1, int x2, int y2);
      void Polyline(POINT *,int);
      void Box(int x1, int y1, int x2, int y2);
      void Circle(int cx, int cy, int radius);
      void Bar(int x1, int y1, int x2, int y2);
      void FilledCircle(int cx, int cy, int radius);
      void DrawPolyPoly(POINT *lppt,int *lpnPolyCount,int cIntegers); 
      void DrawPolyPolyExt(POINT *lppt,int *lpnPolyCount,int cIntegers);
      void DrawFocusRect(CRect *focusRect);

      void TextOut(int x,int y,const char *text);
      void SetFont(const char*,int);
      CSize GetTextExtent(const char *szText);
      
    };


    extern CSmartDC SmartDC;
    
    class CDCConstructor
    {
    public:
      enum ConstrType { LockNormal, LockForPaint };
    private:
      ConstrType Type;
    public:
      CDCConstructor(ConstrType aType)
                  { Type = aType; 
                    if (Type == LockNormal) SmartDC.LockDC();
                    else SmartDC.LockWMPaintDC(); }
      ~CDCConstructor()
                  { if (Type == LockNormal) SmartDC.UnLockDC();
                    else SmartDC.UnLockWMPaintDC(); }
    };


   #define LOCK_DC() CDCConstructor DCConstructor(CDCConstructor::LockNormal)
   #define LOCK_WMPAINT_DC() CDCConstructor DCConstructor(CDCConstructor::LockForPaint)

//===============================================================


#endif //__CRISPDC_H__
