#include "stdafx.h"
#include "math.h"

Clipper	*clipper_i = NULL;

Clipper::Clipper()
{
	clipper_i = this;
  num = 0;
}

BOOL Clipper::hide()
{
	int		oldnum;
	
	oldnum = num;
	num = 0;
	return (oldnum > 0);
}

void Clipper::flipNormal()
{
	vec3_t	temp;
	
	if (num == 2)
	{
		VectorCopy (pos[0], temp);
		VectorCopy (pos[1], pos[0]);
		VectorCopy (temp, pos[1]);
	}
	else if (num == 3)
	{
		VectorCopy (pos[0], temp);
		VectorCopy (pos[2], pos[0]);
		VectorCopy (temp, pos[2]);
	}	
	else
	{
		qprintf ("no clipplane");
		MessageBeep(MB_ICONEXCLAMATION);
	}
}

BOOL Clipper::getFace(face_t *f)
{
	vec3_t	v1, v2, norm;
	int		i;
	
	VectorCopy (vec3_origin, plane.normal);
	plane.dist = 0;
	if (num < 2)
		return NO;
	if (num == 2)
	{
		VectorCopy (pos[0], pos[2]);
		pos[2][2] += 16;
	}
	
	for (i=0 ; i<3 ; i++)
		VectorCopy (pos[i], f->planepts[i]);
		
	VectorSubtract (pos[2], pos[0], v1);
	VectorSubtract (pos[1], pos[0], v2);
	
	CrossProduct (v1, v2, norm);
	VectorNormalize (norm);
	
	if ( !norm[0] && !norm[1] && !norm[2] )
		return NO;
	
	texturepalette_i->getTextureDef(&f->texture);

	return YES;
}

/*
================
XYClick
================
*/
void Clipper::XYClick(CPoint *point)
{
	int		i;
	vec3_t	newp;
		
	newp[0] = xyview_i->snapToGrid(point->x);
	newp[1] = xyview_i->snapToGrid(point->y);
	newp[2] = map_i->currentMinZ();

// see if a point is allready there
	for (i=0 ; i<num ; i++)
	{
		if (newp[0] == pos[i][0] && newp[1] == pos[i][1])
		{
			if (pos[i][2] == map_i->currentMinZ())
				pos[i][2] = map_i->currentMaxZ();
			else
				pos[i][2] = map_i->currentMinZ();
			quakeed_i->updateAll();
			return;
		}
	}
	
	
	if (num == 3)
		num = 0;
	
	VectorCopy (newp, pos[num]);
	num++;

	quakeed_i->updateAll();
}

/*
================
XYDrag
================
*/
BOOL Clipper::XYDrag(CPoint *pt)
{
	int		i;
	
	for (i=0 ; i<3 ; i++)
	{
		if (fabs(pt->x - pos[i][0]) > 10 || fabs(pt->y - pos[i][1]) > 10)
			continue;
	// drag this point
	
	}
	
	return NO;
}

void ZClick(CPoint *pt)
{
}

//=============================================================================

void Clipper::carve()
{
	map_i->makeSelectedPerform(BRUSH_CARVEBYCLIPPER);
	num = 0;
}


void Clipper::cameraDrawSelf()
{
  vec3_t		mid;
	int			i;
	
	CameraSetColor(COLOR_CLIPPER);

	for (i=0 ; i<num ; i++)
	{
		VectorCopy (pos[i], mid);
		mid[0] -= 8;
		mid[1] -= 8;
		CameraMoveto (mid);
		mid[0] += 16;
		mid[1] += 16;
		CameraLineto (mid);
		CameraEndLine();

		VectorCopy (pos[i], mid);
		mid[0] -= 8;
		mid[1] += 8;
		CameraMoveto (mid);
		mid[0] += 16;
		mid[1] -= 16;
		CameraLineto (mid);
    CameraEndLine();
	}
}

void Clipper::XYDrawSelf()
{
	int		i;
	char	text[8];
	
	SetColor(COLOR_CLIPPER);

	DC_SetFont("MS Sans Serif",int(10 / xyview_i->GetScale()));

	for (i=0 ; i<num ; i++)
	{
    sprintf (text, "%i", i);
    DC_TextOut(pos[i][0]-4, pos[i][1]-4, text);
		Circle( pos[i][0], pos[i][1], 10);
	}
}

void Clipper::ZDrawSelf()
{
	int		i;
	char	text[8];
	
	SetColor(COLOR_CLIPPER);
	
  DC_SetFont("MS Sans Serif",int(10 / zview_i->GetScale()));

	for (i=0 ; i<num ; i++)
	{
    sprintf (text, "%i", i);
    DC_TextOut(-28+i*8 - 4, pos[i][2]-4, text);
		Circle( -28+i*8, pos[i][2], 10);
	}
}
