#include "stdafx.h"
#include "qedefs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


vec3_t bad_mins = {-8, -8, -8};
vec3_t bad_maxs = {8, 8, 8};

Entity::Entity()
{
  epairs = NULL;
  modifiable = YES;
}

void Entity::createFixedBrush(vec3_t org)
{
  vec3_t  emins, emaxs;
  float *v, *v2, *color;
  EntityClass   *newCl;
  texturedef_t  td;
  
// get class
  newCl = entity_classes_i->classForName(valueForQKey("classname"));
  if (newCl)
  {
    v = newCl->getMins();
    v2 = newCl->getMaxs();
  }
  else
  {
    v = bad_mins;
    v2 = bad_maxs;
  }

  color = newCl->drawColor();

  modifiable = NO;
  memset(&td,0,sizeof(td));
  strcpy (td.texture,"entity");

  VectorAdd (org, v, emins);
  VectorAdd (org, v2, emaxs);
  
  SetBrush *newBr = new SetBrush;
  newBr->initOwner(this,emins,emaxs,&td);
  newBr->setEntityColor(color);
  Add(newBr);
}

void Entity::initClass(char *classname)
{
  EntityClass   *newCl;
  esize_t esize;
  char  value[80];
  vec3_t  min, max;
  float *v;
  
  modifiable = YES;

  setKey("classname",classname);

// get class
  newCl = entity_classes_i->classForName(valueForQKey("classname"));
  if (!newCl)
    esize = esize_model;
  else
    esize = newCl->getesize();
  
// create a brush if needed
  if (esize == esize_fixed)
  {
    v = newCl->getMins();
    map_i->selectedBrush()->getMins(min,max); 
    VectorSubtract (min, v, min);
  
    sprintf (value, "%i %i %i",(int)min[0], (int)min[1], (int)min[2]);
    setKey("origin",value);

    createFixedBrush(min);
  }
  else
    modifiable = YES;
}


Entity::~Entity()
{
  epair_t *e, *n;
  
  for (e=epairs ; e ; e=n)
  {
    n = e->next;
    ::free (e);
  }
  for(int i = 0; i < GetSize(); i++)
    delete GetAt(i);
  RemoveAll();
}

BOOL Entity::getModifiable()
{
  return modifiable;
}

void Entity::setModifiable(BOOL m)
{
  modifiable = m;
}

void Entity::removeObject(CObject *o)
{
  for(int i = 0; i < GetSize(); i++)
    if(GetAt(i) == o)
      RemoveAt(i);
      
  if (GetSize())
    return;

// the entity is empty, so remove the entire thing
  if ( this == map_i->GetAt(0))
    return; // never remove the world
    
  map_i->removeObject(this);
}


char *Entity::valueForQKey(char *k)
{
  epair_t *e;
  static char ret[64];
  
  for (e=epairs ; e ; e=e->next)
    if (!strcmp(k,e->key))
    {
      strcpy (ret, e->value);
      return ret;
    }
  return "";
}

void Entity::getVector(vec3_t v,char *k)
{
  char  *c;
  
  c = valueForQKey(k);

  v[0] = v[1] = v[2] = 0;
    
  sscanf (c, "%f %f %f", &v[0], &v[1], &v[2]);

}

void Entity::setKey(char *k, char *v)
{
  epair_t *e;

  if (strlen(k) > MAX_KEY)
    Error ("setKey: %s > MAX_KEY", k);
  if (strlen(v) > MAX_VALUE)
    Error ("setKey: %s > MAX_VALUE", v);
    
  while (*k && *k <= ' ')
    k++;
  if (!*k)
    return ;  // don't set NULL values
    
  for (e=epairs ; e ; e=e->next)
    if (!strcmp(k,e->key))
    {
      memset (e->value, 0, sizeof(e->value));
      strcpy (e->value, v);
      return;
    }

  e = (epair_t *) malloc (sizeof(epair_t));
  memset (e, 0, sizeof(epair_t));
  
  strcpy (e->key, k);
  strcpy (e->value, v);
  e->next = epairs;
  epairs = e;
}

int Entity::numPairs()
{
  int i;
  epair_t *e;
  
  i=0;
  for (e=epairs ; e ; e=e->next)
    i++;
  return i;
}

epair_t *Entity::getepairs()
{
  return epairs;
}

void Entity::removeKeyPair(char *key)
{
  epair_t *e, *e2;
  
  if (!epairs)
    return;
  e = epairs;
  if (!strcmp(e->key, key))
  {
    epairs = e->next;
    ::free (e);
    return;
  }
  
  for (; e ; e=e->next)
  {
    if (e->next && !strcmp(e->next->key, key))
    {
      e2 = e->next;
      e->next = e2->next;
      ::free (e2);
      return;
    }
  }
  
  printf ("WARNING: removeKeyPair: %s not found", key);
}


/*
=============
targetname

If the entity does not have a "targetname" key, a unique one is generated
=============
*/
char *Entity::targetname()
{
  char  *t;
  int   i, count;
  Entity    *ent;
  int   tval, maxt;
  char  name[20];
  
  t = valueForQKey("targetname");
  if (t && t[0])
    return t;
    
// make a unique name of the form t<number>
  count = map_i->GetSize();
  maxt = 0;
  for (i=1 ; i<count ; i++)
  {
    ent = map_i->GetAt(i);
    t = ent->valueForQKey("targetname");
    if (!t || t[0] != 't')
      continue;
    tval = atoi (t+1);
    if (tval > maxt)
      maxt = tval;
  }
  
  sprintf (name,"t%i",maxt+1);
  
  setKey("targetname",name);
  
  return valueForQKey("targetname"); // so it's not on the stack
}

/*
==============================================================================

FILE METHODS

==============================================================================
*/

int nument;

BOOL Entity::initFromTokens()
{
  char  key[MAXTOKEN];
  EntityClass  *eclass; 
  SetBrush * brush;
  char  *spawn;
  vec3_t  emins, emaxs;
  vec3_t  org;
  texturedef_t  td;
  esize_t esize;
  int   i, c;
  float *color;
  
  if (!GetToken (TRUE))
  {
    delete this;
    return FALSE;
  }

  if (strcmp (token, "{") )
    Error ("initFromFileP: { not found");
    
  do
  {
    if (!GetToken (TRUE))
      break;
    if (!strcmp (token, "}") )
      break;
    if (!strcmp (token, "{") )
    { // read a brush
      brush = new SetBrush;
      brush->initFromTokens(this);
      Add(brush);
    }
    else
    { // read a key / value pair
      strcpy (key, token);
      GetToken (FALSE);
      setKey(key,token);
    }
  } while (1);
  
  nument++;

// get class
  spawn = valueForQKey("classname");
  eclass = entity_classes_i->classForName(spawn);

  esize = eclass->getesize();

  getVector(org,"origin");
  
  if (GetSize() && esize != esize_model)
  {
    printf ("WARNING:Entity with brushes and wrong model type"); 
    RemoveAll(); // empty
  }
  
  if (!GetSize() && esize == esize_model && strcmp(spawn,"worldspawn"))
  {
    printf ("WARNING:Entity with no brushes and esize_model"); 
	  texturepalette_i->getTextureDef(&td);
    for (i=0 ; i<3 ; i++)
    {
      emins[i] = org[i] - 8;
      emaxs[i] = org[i] + 8;
    }
    brush = new SetBrush;
    brush->initOwner(this,emins,emaxs,&td);
    Add(brush);
  }
  
// create a brush if needed
  if (esize == esize_fixed)
    createFixedBrush(org);
  else
    modifiable = YES;

// set all the brush colors
  color = eclass->drawColor();

  c = GetSize();
  for (i=0 ; i<c ; i++)
  {
    brush = GetAt(i);
    brush->setEntityColor(color);
  }
  return TRUE;
}


void Entity::writeToFILE(FILE *f,BOOL reg)
{
  epair_t *e;
  int   i;
  EntityClass    *newCl;
  char  value[80];
  vec3_t  mins, maxs, org;
  float *v;
  BOOL  temporg;
  char  oldang[80];
  
  temporg = NO;
  if (reg)
  {
    if ( !strcmp (valueForQKey("classname"), "info_player_start") )
    { // move the playerstart temporarily to the camera position
      temporg = YES;
      strcpy (oldang, valueForQKey("angle"));
	    sprintf (value, "%i", int(cameraview_i->yawAngle()*180/M_PI));
      setKey("angle",value);
    }
    else if ( this != map_i->GetAt(0) 
    && (GetAt(0))->getRegioned())
      return;  // skip the entire entity definition
  }
  
  fprintf (f,"{\n");

// set an origin epair
  if (!modifiable)
  {
    (GetAt(0))->getMins(mins,maxs);
    if (temporg)
    {
  	  cameraview_i->getOrigin(mins);
      mins[0] -= 16;
      mins[1] -= 16;
      mins[2] -= 48;
    }
    newCl = entity_classes_i->classForName(valueForQKey("classname"));
    if (newCl)
      v = newCl->getMins();
    else
      v = vec3_origin;
      
    VectorSubtract (mins, v, org);
    sprintf (value, "%i %i %i",(int)org[0], (int)org[1], (int)org[2]);
    setKey("origin",value);
  }
    
  for (e=epairs ; e ; e=e->next)
    fprintf (f,"\"%s\"\t\"%s\"\n", e->key, e->value);
    
// fixed size entities don't save out brushes
  if ( modifiable )
  {
    for (i=0 ; i< GetSize() ; i++)
      (GetAt(i))->writeToFILE(f, reg);
  }
  
  fprintf (f,"}\n");
  
  if (temporg)
    setKey("angle",oldang);
}

Entity *Entity::copy()
{
  Entity *e = new Entity;
  e->modifiable = modifiable;
  e->epairs = NULL;
  epair_t *p = epairs;
  
  while(p)
  {
    e->setKey(p->key,p->value);
    p= p->next;
  }

  for(int i = 0; i < GetSize(); i++)
  {
    SetBrush *b = GetAt(i)->copy();
    e->Add(b);
    b->setParent(e);
  }
  
  return e;
}