#ifndef ENTITY_H
#define ENTITY_H

#define MAX_KEY   64
#define MAX_VALUE 128

typedef struct epair_s
{
  struct epair_s  *next;
  char  key[MAX_KEY];
  char  value[MAX_VALUE];
} epair_t;

// an Entity is a list of brush objects, with additional key / value info
class SetBrush;
class Entity : public CTypedPtrArray<CPtrArray,SetBrush *>
{
protected: 
  epair_t *epairs;
  BOOL  modifiable;
public:
  Entity();
  ~Entity();
  Entity *copy();
  void initClass(char *classname);
  BOOL initFromTokens();

  void free();

  BOOL getModifiable();
  void setModifiable(BOOL m);

  char * targetname();

  void writeToFILE(FILE *f,BOOL reg);

  char *valueForQKey(char *k);
  void getVector(vec3_t v,char * k);
  void setKey(char *k,char *v);
  int numPairs();
  epair_t *getepairs();
  void removeKeyPair(char *key);
  void createFixedBrush(vec3_t org);
  void removeObject(CObject *o);
};

#endif
