#include "stdafx.h"
#include "qedefs.h"
#include "io.h"

/*

the classname, color triple, and bounding box are parsed out of comments
A ? size means take the exact brush size.

 QUAKED <classname> (0 0 0) ?
 QUAKED <classname> (0 0 0) (-8 -8 -8) (8 8 8)

Flag names can follow the size description:

QUAKED func_door (0 .5 .8) ? START_OPEN STONE_SOUND DOOR_DONT_LINK GOLD_KEY SILVER_KEY

*/

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


char  *debugname;

void EntityClass::initFromText(char *text)
{
  char  *t;
  int   len;
  int   r, i;
  char  parms[256], *p;
  
  text += strlen("/*QUAKED ");

// grab the name
  text = COM_Parse (text);
  name = (char *)malloc (strlen(com_token)+1);
  strcpy (name, com_token);
  debugname = name;
  
// grab the color
  r = sscanf (text," (%f %f %f)", &color[0], &color[1], &color[2]);
  if (r != 3)
    return;
  
  while (*text != ')')
  {
    if (!*text)
      return;
    text++;
  }
  text++;
  
// get the size 
  text = COM_Parse (text);
  if (com_token[0] == '(')
  { // parse the size as two vectors
    esize = esize_fixed;
    r = sscanf (text,"%f %f %f) (%f %f %f)", &mins[0], &mins[1], &mins[2], &maxs[0], &maxs[1], &maxs[2]);
    if (r != 6)
      return;

    for (i=0 ; i<2 ; i++)
    {
      while (*text != ')')
      {
        if (!*text)
          return;
        text++;
      }
      text++;
    }
  }
  else
  { // use the brushes
    esize = esize_model;
  }
  
// get the flags
  

// copy to the first /n
  p = parms;
  while (*text && *text != '\n')
    *p++ = *text++;
  *p = 0;
  text++;
  
// any remaining words are parm flags
  p = parms;
  for (i=0 ; i<8 ; i++)
  {
    p = COM_Parse (p);
    if (!p)
      break;
    strcpy (flagnames[i], com_token);
  } 

// find the length until close comment
  for (t=text ; t[0] && !(t[0]=='*' && t[1]=='/') ; t++)
  ;
  
// copy the comment block out
  len = t-text;
  comments = (char *)malloc (len+1);
  memcpy (comments, text, len);
  comments[len] = 0;
}

esize_t EntityClass::getesize()
{
  return esize;
}



char * EntityClass::classname()
{
  return name;
}

float *EntityClass::getMins()
{
  return mins;
}

float *EntityClass::getMaxs()
{
  return maxs;
}

float *EntityClass::drawColor()
{
  return color;
}

char *EntityClass::getComments()
{
  return comments;
}


char *EntityClass::flagName(unsigned flagnum)
{
  if (flagnum >= MAX_FLAGS)
    Error ("EntityClass flagName: bad number");
  return flagnames[flagnum];
}

//===========================================================================

/*
=================
insertEC:
=================
*/
void EntityClassList::insertEC(EntityClass *ec)
{
  char  *name;
  int   i;
  
  name = ec->classname();
  for (i=0 ; i<GetSize() ; i++)
  {
    if (strcmpi (name, GetAt(i)->classname()) < 0)
    {
      InsertAt(i,ec);
      return;
    }
  }
  Add(ec);
}


/*
=================
scanFile
=================
*/

void EntityClassList::scanFile(char *filename)
{
  int   size;
  char  *data;
  EntityClass    *cl;
  int   i;
  char  path[1024];
  
  sprintf (path,"%s\\%s", source_path, filename);
  
  size = LoadFile (path, (void **)&data);
  
  for (i=0 ; i<size ; i++)
    if (!strncmp(data+i, "/*QUAKED",8))
    {
      cl = new EntityClass;
      cl->initFromText(data+i);
      if (cl)
        insertEC(cl);
      else
        printf ("Error parsing: %s in %s\n",debugname, filename);
    }
    
  free (data);
}


/*
=================
scanDirectory
=================
*/


void EntityClassList::scanDirectory()
{
  char buffer[_MAX_PATH];
  int  i;
  
  for(i = 0; i < GetSize(); i++)
    delete GetAt(i);
  RemoveAll();
 
  strcpy(buffer,source_path);
  if(buffer[strlen(buffer) - 1] != '\\')
    strcat(buffer,"\\");
  strcat(buffer,"*.QC");
  
  _finddata_t fd;

  long lHandle = _findfirst(buffer,&fd);
  if (lHandle == -1)
    _findclose(lHandle);
  else
  {
    do{
        scanFile(fd.name);
      }while(_findnext(lHandle,&fd) ==0);
    _findclose(lHandle);
  }
}


EntityClassList *entity_classes_i;

EntityClassList::~EntityClassList()
{
  for(int i = 0; i < GetSize(); i++)
    delete GetAt(i);
  RemoveAll();
  if (nullclass)
    delete nullclass;
}

EntityClassList::EntityClassList()
{
  entity_classes_i = this;
  nullclass = NULL;
}

void EntityClassList::initForSourceDirectory(char *path)
{
  source_path = path; 
  scanDirectory();
  
  nullclass = new EntityClass;
  nullclass->initFromText("/*QUAKED UNKNOWN_CLASS (0 0.5 0) ?");
}

EntityClass *EntityClassList::classForName(char *name)
{
  int   i;
  EntityClass   *o;
  
  for (i=0 ; i<GetSize() ; i++)
  {
    o = GetAt(i);
    if (!strcmp (name,o->classname()) )
      return o;
  }
  
  return nullclass;
}


