#ifndef ECLASS_H
#define ECLASS_H

#include "mathlib.h"

typedef enum {esize_model, esize_fixed} esize_t;

#define MAX_FLAGS 8

class EntityClass : public CObject
{
protected:
  char  *name;
  esize_t esize;
  vec3_t  mins, maxs;
  vec3_t  color;
  char  *comments;
  char  flagnames[MAX_FLAGS][32];
public:
  
  EntityClass()
  {
    name = NULL;
    comments = NULL;
    for(int i = 0; i < MAX_FLAGS; i++)
      flagnames[i][0] = 0;
  }
  ~EntityClass()
  {
    if(name) free(name);
    if(comments) free(comments);
  }
  void initFromText(char *text);
  char *classname();
  esize_t getesize();
  float *getMins();    // only for esize_fixed
  float *getMaxs();    // only for esize_fixed
  float *drawColor();
  char *getComments();
  char *flagName(unsigned flagnum);
  
};



class EntityClassList : public CTypedPtrArray<CPtrArray,EntityClass*>
{
protected:  
  EntityClass   *nullclass;
  char  *source_path;
  
public:  
  EntityClassList();
  ~EntityClassList();
  void initForSourceDirectory(char *path);
  EntityClass *classForName(char *name);
  void scanDirectory();
  void insertEC(EntityClass *ec);
  void scanFile(char *filename);
};  

extern  EntityClassList  *entity_classes_i;
#endif
