// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "QuakeEdit.h"
#include "qedefs.h"
#include "MainFrm.h"
#include "QZView.h"
#include "QXYView.h"
#include "Splash.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BOOL	autodirty;
BOOL	filter_light, filter_path, filter_entities;
BOOL	filter_clip_brushes, filter_water_brushes, filter_world;

CMainFrame *quakeed_i = NULL;

BOOL	running;

int bsppid;

#define CTRLBARS "Control Bars"

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_ZOOMIN, OnZoomin)
	ON_COMMAND(ID_ZOOMOUT, OnZoomout)
	ON_COMMAND(ID_APP_DEFINED, OnAppDefined)
	ON_COMMAND(ID_UPDATEALL, OnUpdateall)
	ON_COMMAND(ID_BRUSH_CLONE, OnBrushClone)
	ON_COMMAND(ID_BRUSH_SELECTCOMPLETEENTITY, OnBrushSelectCompleteEntity)
	ON_COMMAND(ID_BRUSH_SELECTCOMPLETEINSIDE, OnBrushSelectCompleteInside)
	ON_COMMAND(ID_BRUSH_SELECTPARTIALINSIDE, OnBrushSelectPartialInside)
	ON_COMMAND(ID_BRUSH_SHORT, OnBrushShort)
	ON_COMMAND(ID_BRUSH_SUBSTRACT, OnBrushSubstract)
	ON_COMMAND(ID_BRUSH_TALL, OnBrushTall)
	ON_COMMAND(ID_BRUSH_CARVEBYCLIPPER, OnBrushCarveByClipper)
	ON_COMMAND(ID_BRUSH_DELETE, OnBrushDelete)
	ON_COMMAND(ID_BRUSH_DESELECT, OnBrushDeselect)
	ON_COMMAND(ID_CLIPPER_FLIPNORMAL, OnClipperFlipNormal)
	ON_COMMAND(ID_VIEW_THINGS, OnViewThings)
	ON_UPDATE_COMMAND_UI(ID_VIEW_THINGS, OnUpdateViewThings)
	ON_COMMAND(ID_VIEW_TEXTURES, OnViewTextures)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TEXTURES, OnUpdateViewTextures)
	ON_COMMAND(ID_VIEW_CONSOLE, OnViewConsole)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CONSOLE, OnUpdateViewConsole)
	ON_WM_CLOSE()
	ON_COMMAND(ID_CAMERA_FLOORUP, OnCameraFloorup)
	ON_COMMAND(ID_CAMERA_FLOORDOWN, OnCameraFloordown)
	ON_COMMAND(ID_VIEW_VIEWCONTROL, OnViewViewcontrol)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VIEWCONTROL, OnUpdateViewViewcontrol)
	ON_COMMAND(ID_SETTINGS, OnSettings)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_FLIPX, OnFlipx)
	ON_COMMAND(ID_FLIPY, OnFlipy)
	ON_COMMAND(ID_FLIPZ, OnFlipz)
	ON_COMMAND(ID_ROTATEX, OnRotatex)
	ON_COMMAND(ID_ROTATEY, OnRotatey)
	ON_COMMAND(ID_ROTATEZ, OnRotatez)
	ON_COMMAND(ID_CAMERA_TEX, OnCameraTex)
	ON_UPDATE_COMMAND_UI(ID_CAMERA_TEX, OnUpdateCameraTex)
	ON_COMMAND(ID_CAMERA_WIRE, OnCameraWire)
	ON_UPDATE_COMMAND_UI(ID_CAMERA_WIRE, OnUpdateCameraWire)
	ON_COMMAND(ID_CAMERA_FLAT, OnCameraFlat)
	ON_UPDATE_COMMAND_UI(ID_CAMERA_FLAT, OnUpdateCameraFlat)
  ON_UPDATE_COMMAND_UI(ID_BRUSHES,OnUpdateBrushes)
  ON_UPDATE_COMMAND_UI(ID_ENTITIES,OnUpdateEntities)
	ON_COMMAND(ID_MISC_CAMERA_HOMEVIEW, OnMiscCameraHomeview)
	ON_COMMAND(ID_MISC_CENTERZCHECKERINXY, centerZChecker)
	ON_COMMAND(ID_MISC_CAMERA_CENTER, centerCamera)
	//}}AFX_MSG_MAP
#ifdef XY_CAMERA
  ON_COMMAND(ID_XY_SOLID, OnXySolid)
	ON_UPDATE_COMMAND_UI(ID_XY_SOLID, OnUpdateXySolid)
	ON_COMMAND(ID_XY_TEX, OnXyTex)
	ON_UPDATE_COMMAND_UI(ID_XY_TEX, OnUpdateXyTex)
	ON_COMMAND(ID_XY_WIRE, OnXyWire)
	ON_UPDATE_COMMAND_UI(ID_XY_WIRE, OnUpdateXyWire)
#endif

END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
  ID_BRUSHES,
  ID_ENTITIES
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	quakeed_i = this;
	dirty = autodirty = NO;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	m_wndToolBar.Create(this);
	m_wndToolBar.LoadToolBar(IDR_MAINFRAME);

	m_wndStatusBar.Create(this);
	
  HFONT hStatusFont = HFONT(m_wndStatusBar.SendMessage(WM_GETFONT,0,0));

  TEXTMETRIC tm;
  
  {
    CDC dc;
    dc.CreateIC("DISPLAY", 0, 0, 0);
    dc.GetTextMetrics(&tm);
  }

  m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT));
	
  m_wndStatusBar.SetPaneInfo(1, ID_BRUSHES, SBPS_NORMAL,tm.tmAveCharWidth*15);
  m_wndStatusBar.SetPaneInfo(2, ID_ENTITIES, SBPS_NORMAL,tm.tmAveCharWidth*15);

	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

  if(!m_wndThings.Create(this))
  {
		TRACE0("Failed to create things dialog bar\n");
		return -1;      // fail to create
  }
  m_wndThings.EnableDocking(0);

  if(!m_wndTextures.Create(this))
  {
		TRACE0("Failed to create textures dialog bar\n");
		return -1;      // fail to create
  }
  m_wndTextures.EnableDocking(0);

  if(!m_wndConsole.Create(this))
  {
		TRACE0("Failed to create console dialog bar\n");
		return -1;      // fail to create
  }
  m_wndConsole.EnableDocking(0);

  m_wndViewControl.Create(this);
  m_wndViewControl.EnableDocking(0);

  m_wndThings.initEntities();
  m_wndTextures.initPaletteFromWadfile(preferences_i->getStartWad());
	
  LoadBarState(CTRLBARS);

	// CG: The following line was added by the Splash Screen component.
	CSplashWnd::ShowSplashScreen(this);
  return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style |= WS_MAXIMIZE;
	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	m_wndSplitter.CreateStatic(this,1,2);
	m_wndSplitter.CreateView(0,0,RUNTIME_CLASS(ZView),CSize(100,200),pContext);

  m_wndSplitter2.CreateStatic(&m_wndSplitter,2,1,WS_CHILD | WS_VISIBLE | WS_BORDER,  // style, WS_BORDER is needed
	                            m_wndSplitter.IdFromRowCol(0, 1));
	m_wndSplitter2.CreateView(0,0,RUNTIME_CLASS(XYView),CSize(0,max(lpcs->cy - 150, 100)),pContext);								
  m_wndSplitter2.CreateView(1,0,RUNTIME_CLASS(CameraView),CSize(0,0),pContext);								

	SetActiveView((CView*)m_wndSplitter.GetPane(0,0));
	return TRUE;
}

void CMainFrame::OnZoomin() 
{
	CView *pView = GetActiveView();
	if(pView)
    if(pView->IsKindOf(RUNTIME_CLASS(CQuakeView)))
  {
    CQuakeView *pQView = (CQuakeView *)pView;
    pQView->SetScale(pQView->GetScale() * 2);
  }
}

void CMainFrame::OnZoomout() 
{
	CView *pView = GetActiveView();
	if(pView)
    if(pView->IsKindOf(RUNTIME_CLASS(CQuakeView)))
  {
    CQuakeView *pQView = (CQuakeView *)pView;
    pQView->SetScale(pQView->GetScale() / 2);
  }
}

void CMainFrame::setDefaultFilename()
{	
	strcpy (filename, FN_TEMPSAVE);
	
  GetActiveView()->GetDocument()->SetTitle(filename);
}

BOOL	updateinflight;

BOOL	clearinstance;

BOOL	updatexy;
BOOL	updatez;
BOOL	updatecamera;


void CMainFrame::postappdefined()
{
  PostMessage(WM_COMMAND,MAKELPARAM(ID_APP_DEFINED,0),0);
}

int	c_updateall;
void CMainFrame::updateAll()			// when a model has been changed
{
	updatecamera = updatexy = updatez = YES;
//	c_updateall++;
	postappdefined ();
}

void CMainFrame::updateCamera()		// when the camera has moved
{
	updatecamera = YES;
	clearinstance = YES;
	
	postappdefined ();
}

void CMainFrame::updateXY()
{
	updatexy = YES;
	postappdefined ();
}

void CMainFrame::updateZ()
{
	updatez = YES;
	postappdefined ();
}


void CMainFrame::newinstance()
{
//	clearinstance = YES;
}

void CMainFrame::redrawInstance()
{
//	clearinstance = YES;
	flushWindow(TRUE);
}

void CMainFrame::flushWindow(BOOL bXorMode)
{
  cameraview_i->lockFocus(bXorMode);	// TT bug
	map_i->makeSelectedPerform(BRUSH_CAMERADRAWSELF);
	clipper_i->cameraDrawSelf();
	cameraview_i->unlockFocus();	
  
  xyview_i->lockFocus(bXorMode);
  map_i->makeSelectedPerform(BRUSH_XYDRAW_SELF);
  cameraview_i->XYDrawSelf();
	zview_i->XYDrawSelf();
  clipper_i->XYDrawSelf();
	xyview_i->unlockFocus();

	zview_i->lockFocus(bXorMode);
	map_i->makeSelectedPerform(BRUSH_ZDRAW_SELF);
  cameraview_i->ZDrawSelf();
	clipper_i->ZDrawSelf();
	zview_i->unlockFocus();
}

void CMainFrame::updateCameraInstance(BOOL bXorMode)
{
  xyview_i->lockFocus(bXorMode);
  cameraview_i->XYDrawSelf();
	xyview_i->unlockFocus();

	zview_i->lockFocus(bXorMode);
  cameraview_i->ZDrawSelf();
	zview_i->unlockFocus();
}


void CMainFrame::updateZCheckerInstance(BOOL bXorMode)
{
  xyview_i->lockFocus(bXorMode);
  zview_i->XYDrawSelf();
	xyview_i->unlockFocus();
}

void CMainFrame::OnAppDefined()
{
	updateinflight = NO;

	if (updatecamera)
  {
    cameraview_i->Invalidate();
    cameraview_i->UpdateWindow();
  }

	if (updatexy)
  {
    xyview_i->Invalidate();
    xyview_i->UpdateWindow();
  }
	if (updatez)
  {
    zview_i->Invalidate();
    zview_i->UpdateWindow();
  }

	updatecamera = updatexy = updatez = NO;
}

void CMainFrame::OnUpdateall() 
{
	updateAll();
}

void CMainFrame::OnBrushClone() 
{
	map_i->cloneSelection();
}

void CMainFrame::OnBrushSelectCompleteEntity() 
{
	map_i->selectCompleteEntity();
}

void CMainFrame::OnBrushSelectCompleteInside() 
{
	map_i->selectCompletelyInside();
}

void CMainFrame::OnBrushSelectPartialInside() 
{
	map_i->selectPartiallyInside();
}

void CMainFrame::OnBrushShort() 
{
	map_i->shortBrush();
}

void CMainFrame::OnBrushSubstract() 
{
	map_i->subtractSelection();
}

void CMainFrame::OnBrushTall() 
{
	map_i->tallBrush();
}


void CMainFrame::centerCamera()
{
	CRect visRect = xyview_i->GetVisibleRect();
	
  CPoint origin((visRect.left + visRect.right) / 2,
                (visRect.top + visRect.bottom) / 2);
	
	cameraview_i->setXYOrigin(&origin);
	updateAll();
}

void CMainFrame::centerZChecker()
{
	CRect visRect = xyview_i->GetVisibleRect();
	
  CPoint origin((visRect.left + visRect.right) / 2,
                (visRect.top + visRect.bottom) / 2);
	
	zview_i->setPoint(&origin);
	updateAll();
}

/*
==============================================================================

BSP PROCESSING

==============================================================================
*/

void ExpandCommand (char *in, char *out, char *src, char *dest)
{
	while (*in)
	{
		if (in[0] == '$')
		{
			if (in[1] == '1')
			{
				strcpy (out, src);
				out += strlen(src);
			}
			else if (in[1] == '2')
			{
				strcpy (out, dest);
				out += strlen(dest);
			}
			in += 2;			
			continue;
		}
		*out++ = *in++;
	}
	*out = 0;
}


/*
=============
saveBSP
=============
*/

#ifndef PORTING

- saveBSP:(char *)cmdline dialog:(BOOL)wt
{
	char	expandedcmd[1024];
	char	mappath[1024];
	char	bsppath[1024];
	int		oldLightFilter;
	int		oldPathFilter;
	char	*destdir;
	
	if (bsppid)
	{
		NXBeep();
		return self;
	}

//
// turn off the filters so all entities get saved
//
	oldLightFilter = [filter_light_i intValue];
	oldPathFilter = [filter_path_i intValue];
	[filter_light_i setIntValue:0];
	[filter_path_i setIntValue:0];
	[self applyRegion: self];
	
	if ([regionbutton_i intValue])
	{
		strcpy (mappath, filename);
		StripExtension (mappath);
		strcat (mappath, ".reg");
		[map_i writeMapFile: mappath useRegion: YES];
		wt = YES;		// allways pop the dialog on region ops
	}
	else
		strcpy (mappath, filename);
		
// save the entire thing, just in case there is a problem
	[self save: self];

	[filter_light_i setIntValue:oldLightFilter];
	[filter_path_i setIntValue:oldPathFilter];
	[self applyRegion: self];

//
// write the command to the bsp host
//	
	destdir = [project_i getFinalMapDirectory];

	strcpy (bsppath, destdir);
	strcat (bsppath, "/");
	ExtractFileBase (mappath, bsppath + strlen(bsppath));
	strcat (bsppath, ".bsp");
	
	ExpandCommand (cmdline, expandedcmd, mappath, bsppath);

	strcat (expandedcmd, " > ");
	strcat (expandedcmd, FN_CMDOUT);
	strcat (expandedcmd, "\n");
	printf ("system: %s", expandedcmd);

	[project_i addToOutput: "\n\n========= BUSY =========\n\n"];
	[project_i addToOutput: expandedcmd];

	if ([preferences_i getShowBSP])
		[inspcontrol_i changeInspectorTo:i_output];
	
	if (wt)
	{
		id		panel;
		
		panel = NXGetAlertPanel("BSP In Progress",expandedcmd,NULL,NULL,NULL);
		[panel makeKeyAndOrderFront:NULL];
		system(expandedcmd);
		NXFreeAlertPanel(panel);
		[self makeKeyAndOrderFront:NULL];
		DisplayCmdOutput ();
	}
	else
	{
		cmdte = DPSAddTimedEntry(1, CheckCmdDone, self, NX_BASETHRESHOLD);
		if (! (bsppid = fork ()) )
		{
			system (expandedcmd);
			exit (0);
		}
	}
	
	return self;
}


- BSP_Full: sender
{
	[self saveBSP:[project_i getFullVisCmd] dialog: NO];
	return self;
}

- BSP_FastVis: sender
{
	[self saveBSP:[project_i getFastVisCmd] dialog: NO];
	return self;
}

- BSP_NoVis: sender
{
	[self saveBSP:[project_i getNoVisCmd] dialog: NO];
	return self;
}

- BSP_relight: sender
{
	[self saveBSP:[project_i getRelightCmd] dialog: NO];
	return self;
}

- BSP_entities: sender
{
	[self saveBSP:[project_i getEntitiesCmd] dialog: NO];
	return self;
}

- BSP_stop: sender
{
	if (!bsppid)
	{
		NXBeep();
		return self;
	}
	
	kill (bsppid, 9);
	CheckCmdDone (cmdte, 0, NULL);
	[project_i addToOutput: "\n\n========= STOPPED =========\n\n"];
	
	return self;
}




/*
===============================================================================

						OTHER METHODS

===============================================================================
*/


//
//	AJR - added this for Project info
//
- (char *)currentFilename
{
	return filename;
}

- deselect: sender
{
	if ([clipper_i hide])	// first click hides clipper only
		return [self updateAll];

	[map_i setCurrentEntity: [map_i objectAt: 0]];	// make world selected
	[map_i makeSelectedPerform: @selector(deselect)];
	[self updateAll];
	
	return self;
}

#endif

void CMainFrame::OnBrushCarveByClipper() 
{
	clipper_i->carve();
	updateAll();
	qprintf ("carved brush");
}

void CMainFrame::OnBrushDelete() 
{
	map_i->makeSelectedPerform(BRUSH_REMOVE);
	clipper_i->hide();
	updateAll();
}

void CMainFrame::OnBrushDeselect() 
{
	if (clipper_i->hide())	// first click hides clipper only
  {
    updateAll();
    return;
  }

	map_i->setCurrentEntity(map_i->GetAt(0));	// make world selected
	map_i->makeSelectedPerform(BRUSH_DESELECT);
	
  updateAll();
}

void CMainFrame::OnClipperFlipNormal() 
{
	clipper_i->flipNormal();
	updateAll();
}

void CMainFrame::OnViewThings() 
{
	BOOL bVis = m_wndThings.IsWindowVisible();
  if (!m_wndThings.IsFloating())
    FloatControlBar(&m_wndThings,CPoint(100,100));
  ShowControlBar(&m_wndThings,!bVis,FALSE);
}

void CMainFrame::OnUpdateViewThings(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_wndThings.IsWindowVisible());
}

void CMainFrame::OnViewTextures() 
{
  BOOL bVis = m_wndTextures.IsWindowVisible();
  if (!m_wndTextures.IsFloating())
    FloatControlBar(&m_wndTextures,CPoint(100,100));
  ShowControlBar(&m_wndTextures,!bVis,FALSE);
}

void CMainFrame::OnUpdateViewTextures(CCmdUI* pCmdUI) 
{
  pCmdUI->SetCheck(m_wndTextures.IsWindowVisible());
}

void CMainFrame::OnViewConsole() 
{
	BOOL bVis = m_wndConsole.IsWindowVisible();
  if (!m_wndConsole.IsFloating())
    FloatControlBar(&m_wndConsole,CPoint(100,100));
  ShowControlBar(&m_wndConsole,!bVis,FALSE);
}

void CMainFrame::OnUpdateViewConsole(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_wndConsole.IsWindowVisible());
}

void CMainFrame::OnClose() 
{
	SaveBarState(CTRLBARS);
	CFrameWnd::OnClose();
}

void CMainFrame::OnCameraFloorup() 
{
	cameraview_i->upFloor();
}

void CMainFrame::OnCameraFloordown() 
{
	cameraview_i->downFloor();
}

void CMainFrame::OnViewViewcontrol() 
{
	BOOL bVis = m_wndViewControl.IsWindowVisible();
  if (!m_wndViewControl.IsFloating())
    FloatControlBar(&m_wndViewControl,CPoint(100,100));
  ShowControlBar(&m_wndViewControl,!bVis,FALSE);
	
}

void CMainFrame::OnUpdateViewViewcontrol(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_wndViewControl.IsWindowVisible());
}

BOOL CMainFrame::showCoordinates()
{
	return m_wndViewControl.m_bShowCoords;;
}

BOOL CMainFrame::showNames()
{
	return m_wndViewControl.m_bShowNames;
}

#include "settingsdlg.h"

void CMainFrame::OnSettings() 
{
	CSettingsDlg dlg(this);
	dlg.m_strWadPath = preferences_i->getProjectPath();
  dlg.m_strStartWad = preferences_i->getStartWad();
  dlg.m_XLight = preferences_i->getXLight();
  dlg.m_YLight = preferences_i->getYLight();
  dlg.m_ZLight = preferences_i->getZLight();
  dlg.m_nFastRender = preferences_i->getFastRender();
  if (dlg.DoModal() == IDOK)
  {
    preferences_i->setProjectPath(dlg.m_strWadPath);
    preferences_i->setStartWad(dlg.m_strStartWad);
    preferences_i->setXLight(dlg.m_XLight);
    preferences_i->setYLight(dlg.m_YLight);
    preferences_i->setZLight(dlg.m_ZLight);
    preferences_i->setFastRender(dlg.m_nFastRender);
  }
}

void CMainFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
// function keys
	switch (nChar)
	{
	case VK_RIGHT:
	case VK_LEFT:
	case VK_UP:
	case VK_DOWN:
  case 'A':
  case 'Z':
  case 'D':
  case 'C':
	case 188:
  case 190:
		cameraview_i->keyDown(nChar,nRepCnt,nFlags);
		break;

	case VK_ESCAPE:	// escape
		OnBrushDeselect();
		return;
		
  case VK_DELETE:	// delete
		map_i->makeSelectedPerform(BRUSH_REMOVE);
		clipper_i->hide();
		updateAll();
		break;

	case '/':
		clipper_i->flipNormal();
		updateAll();
		break;
		
	case VK_RETURN:	// enter
		clipper_i->carve();
		updateAll();
		qprintf ("carved brush");
		break;
		
	case VK_SPACE:
		map_i->cloneSelection();
		break;
		

//
// move selection keys
//		
	case VK_NUMPAD2:
		VectorCopy (vec3_origin, sb_translate);
		sb_translate[1] = -xyview_i->getGridsize();
		map_i->makeSelectedPerform(BRUSH_TRANSLATE);
		updateAll();
		break;
	case VK_NUMPAD8:
		VectorCopy (vec3_origin, sb_translate);
		sb_translate[1] = xyview_i->getGridsize();
		map_i->makeSelectedPerform(BRUSH_TRANSLATE);
		updateAll();
		break;

	case VK_NUMPAD4:
		VectorCopy (vec3_origin, sb_translate);
		sb_translate[0] = -xyview_i->getGridsize();
		map_i->makeSelectedPerform(BRUSH_TRANSLATE);
		updateAll();
		break;
	case VK_NUMPAD6:
		VectorCopy (vec3_origin, sb_translate);
		sb_translate[0] = xyview_i->getGridsize();
		map_i->makeSelectedPerform(BRUSH_TRANSLATE);
		updateAll();
		break;

	case VK_ADD:
		VectorCopy (vec3_origin, sb_translate);
		sb_translate[2] = -xyview_i->getGridsize();
		map_i->makeSelectedPerform(BRUSH_TRANSLATE);
		updateAll();
		break;
	case VK_SUBTRACT:
		VectorCopy (vec3_origin, sb_translate);
		sb_translate[2] = xyview_i->getGridsize();
		map_i->makeSelectedPerform(BRUSH_TRANSLATE);
		updateAll();
		break;
  }
}

void CMainFrame::OnFlipx() 
{
	map_i->flip_x();
}

void CMainFrame::OnFlipy() 
{
	map_i->flip_y();
}

void CMainFrame::OnFlipz() 
{
	map_i->flip_z();
}

void CMainFrame::OnRotatex() 
{
	map_i->rotate_x();
}

void CMainFrame::OnRotatey() 
{
	map_i->rotate_y();
}

void CMainFrame::OnRotatez() 
{
	map_i->rotate_z();
}

void CMainFrame::ActivateFrame(int nCmdShow) 
{
	CFrameWnd::ActivateFrame(SW_SHOWMAXIMIZED);
}

void CMainFrame::OnCameraTex() 
{
	cameraview_i->setDrawMode(dr_texture);
}

void CMainFrame::OnUpdateCameraTex(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(cameraview_i->getDrawMode() == dr_texture);
}

void CMainFrame::OnCameraWire() 
{
  cameraview_i->setDrawMode(dr_wire);	
}

void CMainFrame::OnUpdateCameraWire(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(cameraview_i->getDrawMode() == dr_wire);
}

void CMainFrame::OnXySolid() 
{
	xyview_i->setDrawMode(dr_flat);
}

void CMainFrame::OnUpdateXySolid(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(xyview_i->getDrawMode() == dr_flat);
}

void CMainFrame::OnXyTex() 
{
	xyview_i->setDrawMode(dr_texture);
}

void CMainFrame::OnUpdateXyTex(CCmdUI* pCmdUI) 
{
  pCmdUI->SetRadio(xyview_i->getDrawMode() == dr_texture);
}

void CMainFrame::OnXyWire() 
{
	xyview_i->setDrawMode(dr_wire);
}

void CMainFrame::OnUpdateXyWire(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(xyview_i->getDrawMode() == dr_wire);
}

void CMainFrame::OnCameraFlat() 
{
	cameraview_i->setDrawMode(dr_flat);
}

void CMainFrame::OnUpdateCameraFlat(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(cameraview_i->getDrawMode() == dr_flat);
}

void CMainFrame::OnMiscCameraHomeview() 
{
	cameraview_i->homeView();
}

CString Int2String(int i)
{
  char buf[20];
  sprintf(buf,"%d",i);
  return buf;
}

void CMainFrame::OnUpdateBrushes(CCmdUI* pCmdUI) 
{
	CString str;
  str.LoadString(ID_BRUSHES);

  if (map_i)
    if(map_i->getCurrentEntity())
      str += Int2String(map_i->getCurrentEntity()->GetSize());

  pCmdUI->SetText(str);
}

void CMainFrame::OnUpdateEntities(CCmdUI* pCmdUI) 
{
	CString str;
  str.LoadString(ID_ENTITIES);

  if (map_i)
    str += Int2String(map_i->GetSize());

  pCmdUI->SetText(str);

}

	
