// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////
#ifndef MAINFRAME
#define MAINFRAME

class CMainFrame : public CFrameWnd
{
protected: // create from serialization only
	CSplitterWnd m_wndSplitter,m_wndSplitter2;
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void ActivateFrame(int nCmdShow = -1);
	protected:
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CStatusBar  m_wndStatusBar;
	CToolBar    m_wndToolBar;
  CThings     m_wndThings;
  CTextures   m_wndTextures;
  CConsole    m_wndConsole;
  Clipper     m_Clipper;
  CViewControl m_wndViewControl;
  Preferences m_Preferences;

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnZoomin();
	afx_msg void OnZoomout();
	afx_msg void OnAppDefined();
	afx_msg void OnUpdateall();
	afx_msg void OnBrushClone();
	afx_msg void OnBrushSelectCompleteEntity();
	afx_msg void OnBrushSelectCompleteInside();
	afx_msg void OnBrushSelectPartialInside();
	afx_msg void OnBrushShort();
	afx_msg void OnBrushSubstract();
	afx_msg void OnBrushTall();
	afx_msg void OnBrushCarveByClipper();
	afx_msg void OnBrushDelete();
	afx_msg void OnBrushDeselect();
	afx_msg void OnClipperFlipNormal();
	afx_msg void OnViewThings();
	afx_msg void OnUpdateViewThings(CCmdUI* pCmdUI);
	afx_msg void OnViewTextures();
	afx_msg void OnUpdateViewTextures(CCmdUI* pCmdUI);
	afx_msg void OnViewConsole();
	afx_msg void OnUpdateViewConsole(CCmdUI* pCmdUI);
	afx_msg void OnClose();
	afx_msg void OnCameraFloorup();
	afx_msg void OnCameraFloordown();
	afx_msg void OnViewViewcontrol();
	afx_msg void OnUpdateViewViewcontrol(CCmdUI* pCmdUI);
	afx_msg void OnSettings();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnFlipx();
	afx_msg void OnFlipy();
	afx_msg void OnFlipz();
	afx_msg void OnRotatex();
	afx_msg void OnRotatey();
	afx_msg void OnRotatez();
	afx_msg void OnCameraTex();
	afx_msg void OnUpdateCameraTex(CCmdUI* pCmdUI);
	afx_msg void OnCameraWire();
	afx_msg void OnUpdateCameraWire(CCmdUI* pCmdUI);
	afx_msg void OnXySolid();
	afx_msg void OnUpdateXySolid(CCmdUI* pCmdUI);
	afx_msg void OnXyTex();
	afx_msg void OnUpdateXyTex(CCmdUI* pCmdUI);
	afx_msg void OnXyWire();
	afx_msg void OnUpdateXyWire(CCmdUI* pCmdUI);
	afx_msg void OnCameraFlat();
	afx_msg void OnUpdateCameraFlat(CCmdUI* pCmdUI);
  afx_msg void OnUpdateBrushes(CCmdUI* pCmdUI);
  afx_msg void OnUpdateEntities(CCmdUI* pCmdUI);
	afx_msg void OnMiscCameraHomeview();
	afx_msg void centerZChecker();
	afx_msg void centerCamera();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

  BOOL	dirty;
	char	filename[1024];		// full path with .map extension
public:

  void setDefaultFilename();
  char *currentFilename();

  void updateAll();		// when a model has been changed
  void updateCamera();		// when the camera has moved
  void updateXY();
  void updateZ();


  void newinstance();		// force next flushwindow to clear all instance drawing
  void redrawInstance();	// erase and redraw all instance now

#ifndef PORTING
- changeXYLookUp: sender;

- setBrushRegion: sender;
- setXYRegion: sender;

- saveBSP:(char *)cmdline dialog:(BOOL)wt;

- BSP_Full: sender;
- BSP_FastVis: sender;
- BSP_NoVis: sender;
- BSP_relight: sender;
- BSP_stop: sender;
- BSP_entities: sender;

//
// UI querie for other objects
//
#endif

  BOOL showCoordinates();
  BOOL showNames();
  void postappdefined();
  void flushWindow(BOOL bXorMode = FALSE);
  void updateCameraInstance(BOOL bXorMode = TRUE);
  void updateZCheckerInstance(BOOL bXorMode = TRUE);
};


extern	CMainFrame	*quakeed_i;

extern	BOOL	filter_light, filter_path, filter_entities;
extern	BOOL	filter_clip_brushes, filter_water_brushes, filter_world;


#endif
/////////////////////////////////////////////////////////////////////////////
