#include "stdafx.h"

vec3_t lightaxis={1.0,1.0,1.0};

Preferences	*preferences_i = NULL;


Preferences::Preferences()
{
	preferences_i = this;
  Load();
  m_bGrid = FALSE;
}

Preferences::~Preferences()
{
  Save();
}

void Preferences::setProjectPath(const char *path)
{
	if (!path)
		path = "";
	m_strProjectPath = path;
}

const char *Preferences::getProjectPath()
{
	return m_strProjectPath;
}

void Preferences::setStartWad(const char *path)
{
	if (!path)
		path = "";
	m_strStartWad = path;
}

const char *Preferences::getStartWad()
{
	return m_strStartWad;
}

void Preferences::setClassPath(const char *path)
{
	if (!path)
		path = "";
	m_strClassPath = path;
}

const char *Preferences::getClassPath()
{
	return m_strClassPath;
}


void Preferences::Save()
{
  AfxGetApp()->WriteProfileString("Projects","PrjDir",m_strProjectPath);
  AfxGetApp()->WriteProfileString("Projects","StartWad",m_strStartWad);
  AfxGetApp()->WriteProfileString("Projects","ClassDir",m_strClassPath);
  
  char buffer[64];
  sprintf(buffer,"%f",lightaxis[1]);
  AfxGetApp()->WriteProfileString("Lights","X",buffer);
  sprintf(buffer,"%f",lightaxis[2]);
  AfxGetApp()->WriteProfileString("Lights","Y",buffer);
  sprintf(buffer,"%f",lightaxis[0]);
  AfxGetApp()->WriteProfileString("Lights","Z",buffer);
  AfxGetApp()->WriteProfileInt("Render","Fast",m_nFastRender);

}

void Preferences::Load()
{
  m_strProjectPath = AfxGetApp()->GetProfileString("Projects","PrjDir", "C:\\QCC");
  m_strStartWad = AfxGetApp()->GetProfileString("Projects","StartWad", "BASE.WAD");
  m_strClassPath = AfxGetApp()->GetProfileString("Projects","ClassDir", "C:\\QCC");

  CString temp;
  temp = AfxGetApp()->GetProfileString("Lights","X","1");
  lightaxis[1] = atof(temp);
  temp = AfxGetApp()->GetProfileString("Lights","Y","1");
  lightaxis[2] = atof(temp);
  temp = AfxGetApp()->GetProfileString("Lights","Z","1");
  lightaxis[0] = atof(temp);
  
  m_nFastRender = AfxGetApp()->GetProfileInt("Render","Fast",1);
}


//===============================================
//	X,Y,Z light values
//===============================================
//
//	Set the state
//
void Preferences::setXLight(float value)
{
	float xlight = value;
	if (xlight < 0.25 || xlight > 1)
		xlight = 0.6;
	lightaxis[1] = xlight;
}

void Preferences::setYLight(float value)
{
	float ylight = value;
	if (ylight < 0.25 || ylight > 1)
		ylight = 0.75;
	lightaxis[2] = ylight;
}

void Preferences::setZLight(float value)
{
	float zlight = value;
	if (zlight < 0.25 || zlight > 1)
		zlight = 1;
	lightaxis[0] = zlight;
}

//
//	Get the state
//
float Preferences::getXLight()
{
	return lightaxis[1];
}
float Preferences::getYLight()
{
	return lightaxis[2];
}
float Preferences::getZLight()
{
	return lightaxis[0];
}

int Preferences::getFastRender()
{
  return m_nFastRender;
}

void Preferences::setFastRender(int fast)
{
  m_nFastRender = fast;
}


BOOL Preferences::GetGrid()
{
  return m_bGrid;
}

void Preferences::SetGrid(BOOL grid)
{
  m_bGrid = grid;
}
