// QCameraView.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CameraView view

#ifndef CAMERAVIEW_H
#define CAMERAVIEW_H

void CameraMoveto(vec3_t p);
void CameraLineto(vec3_t p);
void CameraEndLine();
void CameraSetColor(COLORREF);

class CGLMap : public CGL
{
public:  
	void EndRender();
	void BeginRender();
  CGLMap();
  virtual ~CGLMap();
  enum renderMode { render, wire, selection } renMode;
  
  void SetRenderMode(renderMode m) { renMode = m; }

protected:
 	
  // Override
	virtual BOOL OnResize(int cx, int cy) ;
	virtual BOOL OnInit() ;
	virtual BOOL OnRender() ;	
};

extern CGLMap *glmap_i;

class CameraView : public CQuakeView
{
public:

	CameraView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CameraView)

  void WindowToMap(CPoint&,vec3_t vec);

// Attributes
public:

// Operations
public:
 void keyDown(UINT nChar,UINT nRep,UINT nFlags);
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CameraView)
protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
 	virtual void OnInitialUpdate();
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
protected:
  virtual BOOL FlipY();
	virtual ~CameraView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CameraView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
  afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnDestroy();
	afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
	afx_msg BOOL OnQueryNewPalette();
	afx_msg BOOL OnNcCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	float		xa, ya, za;
	float		move;
		
	float		*zbuffer;
	unsigned	*imagebuffer;
	
	BOOL		angleChange;		// JR 6.8.95
	
	vec3_t		origin;
	vec3_t		matrix[3];
	
	CPoint		dragspot;
	
	drawmode_t	drawmode;

public:
  virtual void lockFocus(BOOL bXorMode = TRUE);
  virtual void unlockFocus();
  
  void setXYOrigin(CPoint *pt);
  void setZOrigin(float pt);

  void setOrigin(vec3_t org, float angle);
  void getOrigin(vec3_t org);
  void drawWire();
  float yawAngle();

  void matrixFromAngles();
  void inverseTransform(vec_t *invec,vec_t *outvec);

  void homeView();
  
  void upFloor();
  void downFloor();

  void setDrawMode(drawmode_t mode);
  drawmode_t getDrawMode() { return drawmode; };
  
  void XYDrawSelf();						// for drawing viewpoint in XY view
  void ZDrawSelf();						  // for drawing viewpoint in XY view
  BOOL XYmouseDown(CPoint *pt,UINT flags);	// return YES if brush handled
  BOOL ZmouseDown(CPoint *pt,UINT flags);	// return YES if brush handled
  void modalMoveLoop(CPoint *basept, vec3_t movemod, CQuakeView *converter);
  void viewDrag(CPoint *pt);
  void prepareMatrix();

protected:
  CGLMap* m_pGL;
  void SetMatrices();
};


extern CameraView *cameraview_i;

#endif
/////////////////////////////////////////////////////////////////////////////
