// QZView.h : header file
//
#ifndef ZVIEW_H
#define ZVIEW_H

/////////////////////////////////////////////////////////////////////////////
// ZView view

class ZView : public CQuakeView
{
protected:
	virtual BOOL FlipY();
	float m_Gridsize;
	ZView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(ZView)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(ZView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~ZView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(ZView)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	float		minheight, maxheight;
	float		oldminheight, oldmaxheight;
	float		topbound, bottombound;		// for floor clipping
	
	float		scale;
	
	vec3_t		origin;

  void (*m_Callback)(float);
  void selectionDragFrom(CPoint *pt);
  void dragFrom(CPoint *startevent,BOOL ug,void (*callback)(float));
  BOOL planeDragFrom(CPoint *pt);
  void drawZplane();
  void drawGrid(const CRect *);

public:

  void setXYOrigin(CPoint *pt);

  void setOrigin(CPoint *pt,float sc);
  void getPoint(CPoint *);
  void getPoint(vec3_t p);
  void setPoint(CPoint *);
  BOOL XYmouseDown(CPoint *pt);
  void modalMoveLoop(CPoint *basept, vec3_t movemod, CQuakeView *converter);
  void XYDrawSelf();
};

extern	ZView *zview_i;
extern	float	zplane;
extern	float	zplanedir;

#endif
/////////////////////////////////////////////////////////////////////////////
