// QuakeView.cpp : implementation file
//

#include "stdafx.h"
#include "QuakeEdit.h"
#include "QuakeView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CQuakeView

IMPLEMENT_DYNCREATE(CQuakeView, CView)

CQuakeView::CQuakeView():m_Offset(0,0)
{
  m_nScale = 1;
  m_pClientDC = NULL;
}

CQuakeView::~CQuakeView()
{
}


BEGIN_MESSAGE_MAP(CQuakeView, CView)
  //{{AFX_MSG_MAP(CQuakeView)
  ON_WM_SIZE()
  ON_WM_HSCROLL()
  ON_WM_VSCROLL()
  ON_WM_KEYDOWN()
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQuakeView drawing

void CQuakeView::OnDraw(CDC* pDC)
{
  CDocument* pDoc = GetDocument();
  // TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CQuakeView diagnostics

#ifdef _DEBUG
void CQuakeView::AssertValid() const
{
  CView::AssertValid();
}

void CQuakeView::Dump(CDumpContext& dc) const
{
  CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CQuakeView message handlers

void CQuakeView::OnSize(UINT nType, int cx, int cy) 
{
  CView::OnSize(nType, cx, cy);
  
  GetClientRect(&m_ClientRect);
  if(m_ClientRect.Width() && m_ClientRect.Height())
    UpdateVisRect();
  else m_VisibleRect = m_ClientRect;
 
}

void CQuakeView::SetScale(double nScale)
{
  m_nScale = nScale;
  UpdateVisRect();
  Invalidate(); 
}

double CQuakeView::GetScale()
{
  return m_nScale;
}

CPoint CQuakeView::GetPosition()
{
  return m_Offset;
}

void CQuakeView::SetPosition(CPoint& point)
{
  m_Offset = point;
  UpdateVisRect();
  Invalidate(); 
}

BOOL CQuakeView::PreCreateWindow(CREATESTRUCT& cs) 
{
  cs.style |= (WS_HSCROLL | WS_VSCROLL);
  
  return CView::PreCreateWindow(cs);
}

void CQuakeView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  int nFlip = FlipX() ? -1 : 1;
  switch(nSBCode)
  {
    case SB_TOP:
    case SB_PAGEUP:
      m_Offset.x -= nFlip * int(m_ClientRect.right / m_nScale);
    break;
  case SB_BOTTOM:
  case SB_PAGEDOWN:
      m_Offset.x += nFlip * int(m_ClientRect.right / m_nScale);
    break;
  case SB_LINEUP:
      m_Offset.x -= nFlip * int(40 / m_nScale);
    break;
  case SB_LINEDOWN:
      m_Offset.x += nFlip * int(40 / m_nScale);
    break;
  default: return;
  }
  UpdateVisRect();
  Invalidate();
}

void CQuakeView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  int nFlip = FlipY() ? -1 : 1;
  switch(nSBCode)
  {
    case SB_TOP:
    case SB_PAGEUP:
      m_Offset.y -= nFlip * int(m_ClientRect.bottom / m_nScale);
    break;
  case SB_BOTTOM:
  case SB_PAGEDOWN:
      m_Offset.y += nFlip * int(m_ClientRect.bottom / m_nScale);
    break;
  case SB_LINEUP:
      m_Offset.y -= nFlip * int(40/m_nScale);
    break;
  case SB_LINEDOWN:
      m_Offset.y += nFlip * int(40/m_nScale);
    break;
  default: return;
  }
  UpdateVisRect();
  Invalidate(); 
}

void CQuakeView::OnInitialUpdate() 
{
  CView::OnInitialUpdate();
  
  SetScrollRange(SB_HORZ,0,100,FALSE);
  SetScrollRange(SB_VERT,0,100,FALSE);
  SetScrollPos(SB_HORZ,50);
  SetScrollPos(SB_VERT,50);
  ShowScrollBar(SB_BOTH,TRUE);
}



void CQuakeView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
  pDC->SetMapMode(MM_ISOTROPIC);
  pDC->SetWindowExt(m_MapSize);
  pDC->SetViewportExt(m_ClientRect.Size());
  pDC->SetWindowOrg(m_ViewportOffset);
  pDC->SetViewportOrg(m_ClientRect.right / 2,m_ClientRect.bottom / 2);
}

BOOL CQuakeView::FlipX()
{
  return FALSE;
}

BOOL CQuakeView::FlipY()
{
  return FALSE;
}

CRect CQuakeView::GetVisibleRect()
{
  return m_VisibleRect;
}

void CQuakeView::UpdateVisRect()
{
  m_VisibleRect = m_ClientRect;
  UpdateSizes();
  WindowToMap(m_VisibleRect);
}

void CQuakeView::MapToWindow(CRect& r,CDC *myDC)
{
  CDC *pDC;
  if(myDC == NULL)
    pDC = new CClientDC(this);
  else pDC = myDC;
  OnPrepareDC(pDC);
  pDC->LPtoDP(&r);
  if(myDC == NULL)
    delete pDC;
}

void CQuakeView::MapToWindow(CPoint& p,CDC *myDC)
{
  CDC *pDC;
  if(myDC == NULL)
    pDC = new CClientDC(this);
  else pDC = myDC;
  OnPrepareDC(pDC);
  pDC->LPtoDP(&p);
  if(myDC == NULL)
    delete pDC;
}

void CQuakeView::WindowToMap(CRect& r,CDC *myDC)
{
  CDC *pDC;
  if(myDC == NULL)
    pDC = new CClientDC(this);
  else pDC = myDC;
  OnPrepareDC(pDC);
  pDC->DPtoLP(&r);
  if(myDC == NULL)
    delete pDC;
}

void CQuakeView::WindowToMap(CPoint& p,CDC *myDC)
{
  CDC *pDC;
  if(myDC == NULL)
    pDC = new CClientDC(this);
  else pDC = myDC;
  OnPrepareDC(pDC);
  pDC->DPtoLP(&p);
  if(myDC == NULL)
    delete pDC;
}


void CQuakeView::UpdateSizes()
{
  m_ClientSize = m_ClientRect.Size();
  m_MapSize = m_ClientSize;
  int nFlipX = FlipX() ? -1 : 1;
  int nFlipY = FlipY() ? -1 : 1;
  m_MapSize.cx = nFlipX * int(m_MapSize.cx / m_nScale); 
  m_MapSize.cy = nFlipY * int(m_MapSize.cy / m_nScale);

//  m_ViewportOffset = CPoint(m_Offset.x * nFlipX,m_Offset.y * nFlipY);
  m_ViewportOffset = CPoint(m_Offset.x,m_Offset.y);
}

void CQuakeView::lockFocus(BOOL bXorMode)
{
  m_pDC = m_pClientDC ? m_pClientDC : new CClientDC(this);
  OnPrepareDC(m_pDC);
  DC_AttachDC(m_pDC->m_hDC);
  DC_LockAttachedDC(); 
  if (bXorMode)
    SetROP2(R2_XORPEN);
}

void CQuakeView::unlockFocus()
{
  SetROP2(R2_COPYPEN);
  DC_UnLockAttachedDC();
  DC_DetachDC();
  if (m_pClientDC == NULL)
    delete m_pDC;
}

void CQuakeView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  AfxGetMainWnd()->SendMessage(WM_KEYDOWN,nChar,MAKELONG(nRepCnt,nFlags));
}
