// ViewControl.cpp : implementation file
//

#include "stdafx.h"
#include "QuakeEdit.h"
#include "ViewControl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CViewControl *viewcontrol_i = NULL;

/////////////////////////////////////////////////////////////////////////////
// CViewControl dialog


CViewControl::CViewControl()
{
	//{{AFX_DATA_INIT(CViewControl)
	m_bAllEnt = FALSE;
	m_bClipBrush = FALSE;
	m_bLights = FALSE;
	m_bPaths = FALSE;
	m_bWaterBrush = FALSE;
	m_bWorld = FALSE;
	m_bRegionActive = FALSE;
	m_bShowCoords = FALSE;
	m_bShowNames = FALSE;
	m_bXYLookUp = FALSE;
	//}}AFX_DATA_INIT
  viewcontrol_i = this;

}


void CViewControl::DoDataExchange(CDataExchange* pDX)
{
	CInspector::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CViewControl)
	DDX_Check(pDX, IDC_GRID, m_bGrid);
  DDX_Check(pDX, IDC_FILTER_ALL_ENT, m_bAllEnt);
	DDX_Check(pDX, IDC_FILTER_CLIP_BRUSH, m_bClipBrush);
	DDX_Check(pDX, IDC_FILTER_LIGHTS, m_bLights);
	DDX_Check(pDX, IDC_FILTER_PATHS, m_bPaths);
	DDX_Check(pDX, IDC_FILTER_WATER_BRUSH, m_bWaterBrush);
	DDX_Check(pDX, IDC_FILTER_WORLD, m_bWorld);
	DDX_Check(pDX, IDC_REGION_ACTIVE, m_bRegionActive);
	DDX_Check(pDX, IDC_SHOW_COORDS, m_bShowCoords);
	DDX_Check(pDX, IDC_SHOW_NAMES, m_bShowNames);
	DDX_Check(pDX, IDC_XY_LOOKUP,  m_bXYLookUp);
  DDX_CBIndex(pDX, IDC_GRIDSIZE, m_GridSize);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CViewControl, CInspector)
	//{{AFX_MSG_MAP(CViewControl)
	ON_BN_CLICKED(IDC_FILTER_ALL_ENT, OnUpdateFields)
	ON_BN_CLICKED(IDC_IN_BRUSH, OnInBrush)
	ON_BN_CLICKED(IDC_IN_XY, OnInXy)
	ON_BN_CLICKED(IDC_XY_LOOKUP, OnXyLookup)
	ON_BN_CLICKED(IDC_GRID, OnGrid)
	ON_BN_CLICKED(IDC_FILTER_CLIP_BRUSH, OnUpdateFields)
	ON_BN_CLICKED(IDC_FILTER_LIGHTS, OnUpdateFields)
	ON_BN_CLICKED(IDC_FILTER_PATHS, OnUpdateFields)
	ON_BN_CLICKED(IDC_FILTER_WATER_BRUSH, OnUpdateFields)
	ON_BN_CLICKED(IDC_FILTER_WORLD, OnUpdateFields)
	ON_BN_CLICKED(IDC_SHOW_COORDS, OnUpdateFields)
	ON_BN_CLICKED(IDC_SHOW_NAMES, OnUpdateFields)
  ON_BN_CLICKED(IDC_REGION_ACTIVE, OnUpdateFields)
	ON_CBN_SELCHANGE(IDC_GRIDSIZE, OnSelchangeGridsize)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CViewControl message handlers

void CViewControl::OnUpdateFields() 
{
	UpdateData(TRUE);
}

BOOL CViewControl::Create(CWnd *pParent) 
{
  if(preferences_i)
    m_bGrid = preferences_i->GetGrid();
  else 
    m_bGrid = FALSE;
  if(xyview_i)
  {
    int gridSize = xyview_i->getGridsize();
    m_GridSize = -1;
    gridSize >>= 2;
    while(gridSize)
    {
      m_GridSize++;
      gridSize>>=1;
    }
    if (m_GridSize == -1)
      m_GridSize = 2;
  }
  else
    m_GridSize = 2;

  if(!CInspector::Create(pParent,IDD_VIEW_CONTROL))
  {
		return FALSE;    // fail to create
  }
  SetWindowText("View Control");
  return TRUE;
}

void CViewControl::OnInBrush() 
{
// get the bounds of the current selection
	
	if (map_i->numSelected() != 1)
	{
		qprintf ("must have a single brush selected");
		return;
	} 

	SetBrush *b = map_i->selectedBrush();
	b->getMins(region_min,region_max);
	b->remove();

// turn region on
	m_bRegionActive = TRUE;
  
  UpdateData(FALSE);
	
  applyRegion();
}

void CViewControl::OnInXy() 
{
	CRect	bounds;
	
// get xy size
	bounds = xyview_i->GetVisibleRect();

	region_min[0] = bounds.left;
	region_min[1] = bounds.bottom;
	region_min[2] = -99999;
	region_max[0] = bounds.right;
	region_max[1] = bounds.top;
	region_max[2] = 99999;
	
	applyRegion();
}

void CViewControl::applyRegion()
{
	filter_clip_brushes = m_bClipBrush;
	filter_water_brushes = m_bWaterBrush;
	filter_light = m_bLights;
	filter_path = m_bPaths;
	filter_entities = m_bAllEnt;
	filter_world = m_bWorld;

	if (!m_bRegionActive)
	{
		region_min[0] = region_min[1] = region_min[2] = -9999;
		region_max[0] = region_max[1] = region_max[2] = 9999;
	}

	map_i->makeGlobalPerform(BRUSH_NEWREGION);
	
	quakeed_i->updateAll();
}

void CViewControl::OnXyLookup() 
{
   UpdateData(TRUE);
	  if (m_bXYLookUp)
	  {
		  xy_viewnormal[2] = 1;
	  }
	  else
	  {
		  xy_viewnormal[2] = -1;
	  }
	  quakeed_i->updateAll();
}

void CViewControl::OnGrid() 
{
	UpdateData();
	if(preferences_i)
    preferences_i->SetGrid(m_bGrid);
}

void CViewControl::OnSelchangeGridsize() 
{
	UpdateData(TRUE);
  if(xyview_i)
  {
	  if(m_GridSize == CB_ERR)
      m_GridSize = 2;
    xyview_i->setGridSize(1 << (m_GridSize + 2)); 
  }
}
