#include "g_local.h"
#include "g_class.h"
#include "g_inven.h"

// classes' speeds
int speeds[MAX_CLASSES] = 
{
	PC_SCOUT_MAXSPEED,
	PC_SNIPER_MAXSPEED,
	PC_SOLDIER_MAXSPEED,
	PC_DEMOMAN_MAXSPEED,
	PC_MEDIC_MAXSPEED,
	PC_HVYWEAP_MAXSPEED,
	PC_PYRO_MAXSPEED,
	PC_SPY_MAXSPEED,
	PC_ENGINEER_MAXSPEED
};

// list of all classes' names.
// Used for ent->cl_name
char *cla_names[MAX_CLASSES] =
{
	"scout",
	"sniper",
	"soldier",
	"demoman",
	"medic",
	"hwguy",
	"pyro",
	"engineer",
	"spy"
};

// list of all models
char *models[MAX_CLASSES] = 
{
	"razor/scout",
	"sniper/sniper",
	"grunt/soldier",
	"keel/heavy",
	"ranger/demoman",
	"crash/medic",
	"visor/pyro",
	"mynx/spy",
	"sarge/eng"
};

// red team's suffixes (used by models)
char *red_suffix[MAX_CLASSES] = 
{
	"_red",
	"_red",
	"_red",
	"_red",
	"_red",
	"_red",
	"_red",
	"_red_s",
	"_red"
};

// blue team's suffixes (used by models)
char *blue_suffix[MAX_CLASSES] = 
{
	"_blue",
	"_blue",
	"_blue",
	"_blue",
	"_blue",
	"_blue",
	"_blue",
	"_blue_s",
	"_blue"
};

/*
==============
gr_type

TODO:
Returns the name of the grenade.
==============
*/
char *gr_type (gentity_t *ent, int i)
{
	if (!ent->client)
		return NULL;

	if (!ent->pc || (ent->health < 0))
		return NULL;

	if (!i)
	{
		switch (ent->pc)
		{
		case PC_SCOUT:
			return "Flash";
		break;

		default:
			return "Normal";
		break;
		}
	}
	else
	{
		switch (ent->pc)
		{
		case PC_SCOUT:
		case PC_MEDIC:
			return "Concussion";
		break;

		case PC_SNIPER:
			return "Flare";
		break;

		case PC_SOLDIER:
			return "Nail";
		break;

		case PC_HWGUY:
		case PC_DEMOMAN:
			return "Mirv";
		break;

		case PC_ENGINEER:
			return "EMP";
		break;

		case PC_PYRO:
			return "Napalm";
		break;

		case PC_SPY:
			return "Gas";
		break;
		}
	}

	return "Not recognized";
}

/*
==============
ValidateClass

Ensures everything is alright.
==============
*/
void ValidateClass (int i)
{
	if (i < PC_SCOUT)
		i = PC_SCOUT;
	else if (i > PC_ENGINEER)
		i = PC_ENGINEER;
}

/*
==============
Cmd_Class_Parse

Parses the 'cla_names' table and finds 
the proper index. Returns -1 if failed.
Used for cmd.
==============
*/
int Cmd_Class_Parse (char *s)
{
	int i = -1;

	for (i = 0; i < MAX_CLASSES; i++)
	{
		if (!Q_stricmp(s, cla_names[i]))
			return i;
	}

	return -1;
}

/*
==============
Cmd_SetClass_f

Used for class changing from cmd and the first
spawn (temprorary hack?). Used by the UI.
==============
*/
void Cmd_SetClass_f (gentity_t *ent, int n)
{
	// in case something fails...
	ValidateClass (n);

	if (!ent->pc)
	{
		ent->nextpc = n + 1;

		ClientBegin (ent->client->ps.clientNum);
		return;
	}

	if (ent->nextpc == (n+1))
		return;

	trap_SendServerCommand(ent->client->ps.clientNum, 
		va("print \"After death you will return as a %s.\n\"", cla_names[n]));

	ent->nextpc = n+1;
}

/*
==============
Print_ClassProperties

TODO:
Prints the class info.
==============
*/

/*
#define pr_in(n,m) trap_SendServerCommand(n,m)
void Print_ClassProperties (int n)
{
	switch (ent->pc)
	{
	   case PC_SCOUT:
			pr_in (n, va("SCOUT\n\nWeapons:\nShotgun, Machinegun\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]));
	   break;
	   case PC_SNIPER:
			pr_in (n, "SNIPER\n\nWeapons:\nMachinegun, Sniper Rifle\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]));
	   break;
	   case PC_SOLDIER:
			pr_in (n, "SOLDIER\n\nWeapons:\nShotgun, Super Shotgun, Rocket Launcher\nGrenades: %s and %s\n\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_HWGUY:
			pr_in (n, "HWGUY\n\nWeapons:\nShotgun, Super Shotgun, Assault Cannon\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_DEMOMAN:
			pr_in (n, "DEMOMAN\n\nWeapons:\nShotgun, Grenade Launcher, Pipe Launcher\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_MEDIC:
			pr_in (n, "MEDIC\n\nWeapon:\nShotgun, Super Shotgun, Bioweapon, Chaingun\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_PYRO:
			pr_in (n, "PYRO\n\nWeapons:\nShotgun, Incendiary Cannon, Flamethrower\nGrenades: %s and %s\n\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_ENGINEER:
			pr_in (n, "ENGINEER\n\nWeapons:\nSuper Shotgun, Railgun\nGrenades: %s and %s\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	   case PC_SPY:
			pr_in (n, "SPY\n\nWeapons:\nShotgun, Super Shotgun, Tranquiliser Gun, Knife\nGrenades: %s and %s\nArmor: %i.\nSpeed: %i.\n", gr_type(ent, 0), gr_type(ent, 1), ent->client->pers.max_armor, ent->ClassSpeed[0]);
	   break;
	}
}

//
// Removes all timers belonging to player
//
void RemoveAllTimers (edict_t *ent)
{
	ent->client->ColorTime = 0;
	ent->client->DisguiseTime = 0;
	ent->client->GasedTime = 0;
	ent->client->DrunkTime = 0;
	ent->client->infection_time = 0;
	ent->client->tranq_time = 0;
	ent->client->last_infect_time = 0;
}
*/

/*
==============
ClassFunction

Spawns the player.
==============
*/
void ClassFunction (gentity_t *ent)
{
	int		index;
	vec3_t	spawn_origin, spawn_angles;
	gclient_t	*client;
	int		i;
	clientPersistant_t	saved;
	clientSession_t		savedSess;
	int		persistant[MAX_PERSISTANT];
	gentity_t	*spawnPoint;
	int		flags;
	int		savedPing;
	vec3_t	playerMins = {-15, -15, -24};
	vec3_t	playerMaxs = {15, 15, 32};

	index = ent - g_entities;
	client = ent->client;

	// find a spawn point
	// do it before setting health back up, so farthest
	// ranging doesn't count this client
	if ( client->sess.sessionTeam == TEAM_SPECTATOR ) {
		spawnPoint = SelectSpectatorSpawnPoint ( 
			spawn_origin, spawn_angles);
	} else if (g_gametype.integer == GT_CTF) {
		spawnPoint = SelectCTFSpawnPoint ( 
			client->sess.sessionTeam, 
			client->pers.teamState.state, 
			spawn_origin, spawn_angles);
	} else {
		do {
			// the first spawn should be at a good looking spot
			if ( !client->pers.initialSpawn && client->pers.localClient ) {
				client->pers.initialSpawn = qtrue;
				spawnPoint = SelectInitialSpawnPoint( spawn_origin, spawn_angles );
			} else {
				// don't spawn near existing origin if possible
				spawnPoint = SelectSpawnPoint ( 
					client->ps.origin, 
					spawn_origin, spawn_angles);
			}

			// Tim needs to prevent bots from spawning at the initial point
			// on q3dm0...
			if ( ( spawnPoint->flags & FL_NO_BOTS ) && ( ent->r.svFlags & SVF_BOT ) ) {
				continue;	// try again
			}
			// just to be symetric, we have a nohumans option...
			if ( ( spawnPoint->flags & FL_NO_HUMANS ) && !( ent->r.svFlags & SVF_BOT ) ) {
				continue;	// try again
			}

			break;

		} while ( 1 );
	}
	client->pers.teamState.state = TEAM_ACTIVE;


	// toggle the teleport bit so the client knows to not lerp
	flags = ent->client->ps.eFlags & EF_TELEPORT_BIT;
	flags ^= EF_TELEPORT_BIT;

	// clear everything but the persistant data
	saved = client->pers;
	savedSess = client->sess;
	savedPing = client->ps.ping;
	for ( i = 0 ; i < MAX_PERSISTANT ; i++ ) {
		persistant[i] = client->ps.persistant[i];
	}
	memset (client, 0, sizeof(*client));

	client->pers = saved;
	client->sess = savedSess;
	client->ps.ping = savedPing;
	for ( i = 0 ; i < MAX_PERSISTANT ; i++ ) {
		client->ps.persistant[i] = persistant[i];
	}

	ValidateClass (ent->nextpc);

	if (ent->pc != ent->nextpc)
	{
		ent->pc = ent->nextpc;
		ent->pci = ent->pc-1;

		TA_tprintf (ent->client->sess.sessionTeam, 
		index, va("%s's class is %s\n", 
		client->pers.netname, cla_names[ent->pci]));

//		Print_ClassProperties (client->ps.clientNum);
	}

	// perform this always at spawn.
	TA_SetSpeed (ent);
	TA_SetClassEquipment (client, ent->pci);
	Q_strncpyz (client->pers.clname, cla_names[ent->pci], 8);

	// increment the spawncount so the client will detect the respawn
	client->ps.persistant[PERS_SPAWN_COUNT]++;
	client->ps.persistant[PERS_TEAM] = client->sess.sessionTeam;

	client->airOutTime = level.time + 12000;

	// clear entity values
	client->ps.stats[STAT_MAX_HEALTH] = client->pers.maxHealth;
	client->ps.eFlags = flags;

	ent->s.groundEntityNum = ENTITYNUM_NONE;
	ent->client = &level.clients[index];
	ent->takedamage = qtrue;
	ent->inuse = qtrue;
	ent->classname = "player";
	ent->r.contents = CONTENTS_BODY;
	ent->clipmask = MASK_PLAYERSOLID;
	ent->die = player_die;
	ent->waterlevel = 0;
	ent->watertype = 0;
	ent->flags = 0;
	
	VectorCopy (playerMins, ent->r.mins);
	VectorCopy (playerMaxs, ent->r.maxs);

	client->ps.clientNum = index;

	// health will count down towards max_health
	ent->health = client->ps.stats[STAT_HEALTH] = client->ps.stats[STAT_MAX_HEALTH];

	G_SetOrigin( ent, spawn_origin );
	VectorCopy( spawn_origin, client->ps.origin );

	// the respawned flag will be cleared after the attack and jump keys come up
	client->ps.pm_flags |= PMF_RESPAWNED;

	trap_GetUsercmd( client - level.clients, &ent->client->pers.cmd );
	SetClientViewAngle( ent, spawn_angles );
	G_KillBox( ent );
	trap_LinkEntity (ent);
	client->ps.weaponstate = WEAPON_READY;

	// don't allow full run speed for a bit
	client->ps.pm_flags |= PMF_TIME_KNOCKBACK;
	client->ps.pm_time = 100;

	client->respawnTime = level.time;
	client->inactivityTime = level.time + g_inactivity.integer * 1000;
	client->latched_buttons = 0;

	// set default animations
	client->ps.torsoAnim = TORSO_STAND;
	client->ps.legsAnim = LEGS_IDLE;

	if (level.intermissiontime)
	{
		MoveClientToIntermission(ent);
	}
	else
	{
		// fire the targets of the spawn point
		G_UseTargets( spawnPoint, ent );
	}

	// run a client frame to drop exactly to the floor,
	// initialize animations and other things
	client->ps.commandTime = level.time - 100;
	ent->client->pers.cmd.serverTime = level.time;
	ClientThink( ent-g_entities );

	// positively link the client, even if the command times are weird
	BG_PlayerStateToEntityState( &client->ps, &ent->s, qtrue );
	VectorCopy( ent->client->ps.origin, ent->r.currentOrigin );
	trap_LinkEntity( ent );

	// run the presend to set anything else
	ClientEndFrame( ent );

	// clear entity state values
	BG_PlayerStateToEntityState( &client->ps, &ent->s, qtrue );

	ClientUserinfoChanged (ent->client->ps.clientNum);
}

/*
==============
TA_SetSkin

Returs the full 'model' userinfo.
==============
*/
char *TA_SetSkin (gentity_t *ent)
{
	char model[MAX_QPATH];
	gclient_t *client = ent->client;

	Q_strncpyz(model, models[ent->pci], sizeof(model));

	switch (client->sess.sessionTeam)
	{
		case TEAM_RED:
			Q_strcat (model, MAX_QPATH, red_suffix[ent->pci]);
			break;
		case TEAM_BLUE:
			Q_strcat (model, MAX_QPATH, blue_suffix[ent->pci]);
			break;
	}

	// don't ever use a default skin in teamplay, it would just waste memory
	if ( g_gametype.integer >= GT_TEAM && client->sess.sessionTeam == TEAM_SPECTATOR )
		Q_strcat (model, MAX_QPATH, red_suffix[ent->pci]);

	// just to make compiler happy
	return va("%s", model);
}

/*
==============
TA_SetSpeed

Sets the cl_speed variable of the entity
used for speed at ClientThink.
==============
*/
void TA_SetSpeed (gentity_t *ent)
{
	ent->cl_speed = speeds[ent->pci];
/*
	// 2nd, check for spy hit
	if (ent->client->tranq_time > level.time)
		ent->cl_speed /= 1.5;

	// 3d, check for snipering
	if (ent->ripstate & STATE_ZOOM)
		ent->cl_speed = 80;

	// 4th, check for leg wounds
	if (ent->leg_damage)
	{
		if (ent->leg_damage > 6)
			ent->leg_damage = 6;

		// reduce speed by 10% per leg wound
    	ent->cl_speed *= ((10 - ent->leg_damage) / 10);
	}

	// 5th, check for detpack or disarming
	if ((ent->ripstate & STATE_DETPACK) || (ent->ripstate & STATE_DISARMING))
		ent->cl_speed = 0;
*/
}
