// g_weapon.c

#include "g_local.h"
#include "m_player.h"

qboolean Add_Ammo (edict_t *ent, gitem_t *item, int count);
static qboolean	is_quad;
static byte		is_silenced;

void fire_laser (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int effect);
void pipebomb_throw (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
void weapon_grenade_fire (edict_t *ent, qboolean held); 
void Health_VicMake (edict_t *ent);
void muzzleflash (edict_t *ent, int mz_);
void fire_heat (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed);
void fire_electric (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick);
void fire_tranq (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed);
void NoAmmoWeaponChange (edict_t *ent);
qboolean loc_CanSee (edict_t *targ, edict_t *inflictor);
char *gr_type (edict_t *ent, int i);
qboolean T_Heal (edict_t *e, int healamount, qboolean ignore);
void SpawnDamage (int type, vec3_t origin, vec3_t normal, int damage);
void Detonate_old (int team);

void Cmd_Reload_f (edict_t *ent)
{
     int rds_left; 

	 if (ent->deadflag == DEAD_DEAD)
	 {
		 gi.centerprintf(ent, "Cannot reload while dead.\n");
		 return;
	 }

     rds_left = ent->client->pers.weapon->clips;

	 if (ent->client->pers.inventory[ent->client->ammo_index]) // if we have ammo for the gun
	 {
		 if((ent->client->weaponstate != WEAPON_END_MAG) && (ent->client->pers.inventory[ent->client->ammo_index] < rds_left)) // if we arent on the end of our magazine (trying to reload a half clip) and we dont have enough ammo to reload
		 {
			 gi.centerprintf(ent,"You're on your last magazine!\n");
		 }
		 else // we do have enough ammo
		 {
			 ent->client->weaponstate = WEAPON_RELOADING;
			 ent->client->reload_time = 20; // set the reload timer to 5 seconds, change if you wish (should probably be lower
			 ent->client->weaponstate = WEAPON_START_RELOADING; // set state flag to drop gun next frame
		 }
	 }
	 else // no ammo
          NoAmmoWeaponChange (ent);
} 

static void P_ProjectSource (gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result)
{
	vec3_t	_distance;

	VectorCopy (distance, _distance);
	if (client->pers.hand == LEFT_HANDED)
		_distance[1] *= -1;
	else if (client->pers.hand == CENTER_HANDED)
		_distance[1] = 0;
	G_ProjectSource (point, _distance, forward, right, result);
}

qboolean Pickup_Weapon (edict_t *ent, edict_t *other)
{
	return false;
}

/*
===============
ChangeWeapon

The old weapon has been dropped all the way, so make the new one
current
===============
*/
void ChangeWeapon (edict_t *ent)
{
//	if (ent->client->reload_time)
//	    return;

	if (ent->client->newweapon == FindItem("Assault Cannon"))
	{
		if (ent->client->pers.inventory[ITEMLIST_CELLS] < 4)
		{
			gi.cprintf(ent, PRINT_HIGH, "Insufficient cells to power up the Assault Cannon.\n");
			return;
		}
		else
			ent->client->pers.inventory[ITEMLIST_CELLS] -= 4;
	}

    if (ent->client->grenade_time)
	{
		ent->client->grenade_time = level.time;
		ent->client->weapon_sound = 0;
		weapon_grenade_fire (ent, false);
		ent->client->grenade_time = 0;
	}

	ent->client->pers.lastweapon = ent->client->pers.weapon;
	ent->client->pers.weapon = ent->client->newweapon;

	if (ent->s.modelindex == 255)
	{
		if (ent->client->pers.weapon)
      		ent->s.skinnum = (ent - g_edicts - 1) | ((ent->client->pers.weapon->weapmodel & 0xff) << 8);
		else
	     	ent->s.skinnum = (ent - g_edicts - 1);
	}

	ent->client->current_rds = 0;

    ent->client->newweapon = NULL;
	ent->client->machinegun_shots = 0;

	if (ent->client->pers.weapon && ent->client->pers.weapon->ammo)
		ent->client->ammo_index = ITEM_INDEX(FindItem(ent->client->pers.weapon->ammo));
	else
		ent->client->ammo_index = 0;

	if (!ent->client->pers.weapon)
	{	// dead
		ent->client->ps.gunindex = 0;
		return;
	}

	ent->client->weaponstate = WEAPON_ACTIVATING;
	ent->client->ps.gunframe = 0;

    if (!ent->client->chasetoggle)
        ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);

	ent->client->anim_priority = ANIM_PAIN;

	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
	{
		ent->s.frame = FRAME_crpain1;
		ent->client->anim_end = FRAME_crpain4;
	}
	else
	{
		ent->s.frame = FRAME_pain301;
		ent->client->anim_end = FRAME_pain304;
	}
}

/*
=================
NoAmmoWeaponChange
=================
*/
void NoAmmoWeaponChange (edict_t *ent)
{
	if (ent->client->pers.inventory[ITEMLIST_SLUGS]
		&& ent->client->pers.inventory[ITEMLIST_RAILGUN])
	{
		ent->client->newweapon = FindItem ("railgun");
		return;
	}

	if (ent->client->pers.inventory[ITEMLIST_BULLETS])
	{
		if (ent->client->pers.inventory[ITEMLIST_CHAINGUN])
		{
			ent->client->newweapon = FindItem ("chaingun");
			return;
		}
		if (ent->client->pers.inventory[ITEMLIST_M16])
		{
			ent->client->newweapon = FindItem ("M16");
			return;
		}
		if (ent->client->pers.inventory[ITEMLIST_MACHINEGUN])
		{
			ent->client->newweapon = FindItem ("Machinegun");
			return;
		}
	}

	if (ent->client->pers.inventory[ITEMLIST_SHELLS])
	{
		if (ent->client->pers.inventory[ITEMLIST_SHELLS] > 1)
		{
			if (ent->client->pers.inventory[ITEM_INDEX(FindItem("super shotgun"))])
			{
				ent->client->newweapon = FindItem ("super shotgun");
				return;
			}
			if (ent->client->pers.inventory[ITEMLIST_ASSAULT])
			{
				ent->client->newweapon = FindItem ("Assault Cannon");
				return;
			}
			if (ent->client->pers.inventory[ITEMLIST_SHOTGUN])
			{
				ent->client->newweapon = FindItem ("Shotgun");
				return;
			}
			if (ent->client->pers.inventory[ITEMLIST_SNIPERRIFLE])
			{
				ent->client->newweapon = FindItem ("Sniper Rifle");
				return;
			}
			if (ent->client->pers.inventory[ITEMLIST_TRANQUILISER])
			{
				ent->client->newweapon = FindItem ("Tranquiliser Gun");
				return;
			}
		}
		else
		{
			if (ent->client->pers.inventory[ITEMLIST_ASSAULT])
			{
				ent->client->newweapon = FindItem ("Assault Cannon");
				return;
			}
			if (ent->client->pers.inventory[ITEMLIST_SHOTGUN])
			{
				ent->client->newweapon = FindItem ("Shotgun");
				return;
			}
			if (ent->client->pers.inventory[ITEMLIST_SNIPERRIFLE])
			{
				ent->client->newweapon = FindItem ("Sniper Rifle");
				return;
			}
			if (ent->client->pers.inventory[ITEMLIST_TRANQUILISER])
			{
				ent->client->newweapon = FindItem ("Tranquiliser Gun");
				return;
			}
		}
	}

	if (ent->client->pers.inventory[ITEMLIST_CELLS])
	{
		if (ent->client->pers.inventory[ITEMLIST_GORELKA])
		{
			ent->client->newweapon = FindItem ("Flamethrower");
			return;
		}
	}

	if (ent->client->pers.inventory[ITEMLIST_ROCKETS])
	{
		if (ent->client->pers.inventory[ITEMLIST_ROCKETLAUNCHER])
		{
			ent->client->newweapon = FindItem ("Rocket Launcher");
			return;
		}

		if (ent->client->pers.inventory[ITEMLIST_ROCKETS] >= 3
			&& ent->client->pers.inventory[ITEMLIST_FLAMELAUNCHER])
		{
			ent->client->newweapon = FindItem ("Incendiary Cannon");
			return;
		}
	}

	if (ent->client->pers.inventory[ITEMLIST_GRENADES])
	{
		if (ent->client->pers.inventory[ITEMLIST_GRENADELAUNCHER])
		{
			ent->client->newweapon = FindItem ("Grenade Launcher");
			return;
		}
	}

	// and some special handling
	if (pipes_team[ent->client->resp.s_team-1] < MAX_PIPEBOMBS
		&& ent->client->pers.inventory[ITEMLIST_PIPEBOMBLAUNCHER])
	{
		ent->client->newweapon = FindItem ("Pipebomb Launcher");
		return;
	}

	if (ent->playerclass == PC_SPY)
		ent->client->newweapon = FindItem ("Knife");
	else if (ent->playerclass == PC_MEDIC)
		ent->client->newweapon = FindItem ("BioWeapon");
	else if (ent->playerclass == PC_ENGINEER)
		ent->client->newweapon = FindItem ("Spanner");
	else
		ent->client->newweapon = FindItem ("Axe");
}

/*
=================
Think_Weapon

Called by ClientBeginServerFrame and ClientThink
=================
*/
void Think_Weapon (edict_t *ent)
{
	// if just died, put the weapon away
	if (ent->health < 1)
	{
		ent->client->newweapon = NULL;
		ChangeWeapon (ent);
	}

	if (ent->client->feining || (ent->ripstate & STATE_BUILDING) || (ent->ripstate & STATE_DETPACK) || (ent->ripstate & STATE_DISARMING))
	{
		ent->client->ps.gunindex = 0;
		return;
	}

	// call active weapon think routine
	if (ent->client->pers.weapon && ent->client->pers.weapon->weaponthink)
	{
		is_quad = (ent->client->quad_framenum > level.framenum);
		if (ent->client->silencer_shots)
			is_silenced = MZ_SILENCED;
		else
			is_silenced = 0;
		ent->client->pers.weapon->weaponthink (ent);
	}
}


/*
================
Use_Weapon

Make the weapon ready if there is ammo
================
*/
void Use_Weapon (edict_t *ent, gitem_t *item)
{
	int			ammo_index;
	gitem_t		*ammo_item;

	// see if we're already using it
	if (item == ent->client->pers.weapon)
	    return;

	if (item->ammo && !g_select_empty->value && !(item->flags & IT_AMMO))
	{
		ammo_item = FindItem(item->ammo);
		ammo_index = ITEM_INDEX(ammo_item);

		if (!ent->client->pers.inventory[ammo_index])
		{
			gi.cprintf (ent, PRINT_HIGH, "No %s for %s.\n", ammo_item->pickup_name, item->pickup_name);
			return;
		}

		if (ent->client->pers.inventory[ammo_index] < item->quantity)
		{
			gi.cprintf (ent, PRINT_HIGH, "Not enough %s for %s.\n", ammo_item->pickup_name, item->pickup_name);
			return;
		}
	}

	// change to this weapon when down
	ent->client->newweapon = item;
}



/*
================
Drop_Weapon
================
*/
void Drop_Weapon (edict_t *ent, gitem_t *item)
{
	int		index;

	return;

	if ((int)(dmflags->value) & DF_WEAPONS_STAY)
		return;

	index = ITEM_INDEX(item);
	// see if we're already using it
	if ( ((item == ent->client->pers.weapon) || (item == ent->client->newweapon))&& (ent->client->pers.inventory[index] == 1) )
	{
		gi.cprintf (ent, PRINT_HIGH, "Can't drop current weapon\n");
		return;
	}

	Drop_Item (ent, item);
	ent->client->pers.inventory[index]--;
}


/*
================
Weapon_Generic

A generic function to handle the basics of weapon thinking
================
*/
#define FRAME_FIRE_FIRST		(FRAME_ACTIVATE_LAST + 1)
#define FRAME_IDLE_FIRST		(FRAME_FIRE_LAST + 1)
#define FRAME_DEACTIVATE_FIRST	(FRAME_IDLE_LAST + 1)

void Weapon_Generic (edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int *fire_frames, void (*fire)(edict_t *ent))
{
	int		n;

	if (ent->deadflag || ent->s.modelindex != 255) // VWep animations screw up corpses
		return;

	if (ent->client->weaponstate == WEAPON_RELOADING) // they've pushed reload
	{
		if (ent->client->reload_time < 0 || ent->client->reload_time > 50) // their reload timer is screwed somehow
			ent->client->reload_time = 50; // so set it to 5 seconds remaining

		else if(ent->client->reload_time > 0) // they are still reloading
		{
			ent->client->ps.gunindex = 0; // so make sure their gun model is still gone
			ent->client->reload_time--; // and increment the reload timer
		}
		else // their reload timer is working, and they arent still reloading, so lets fill their clip
		{
			ent->client->ps.gunframe = 0; // set gunframe to ACTIVATE_FIRST (0)
			ent->client->reload_time = 0; // clear reload time
			ent->client->weaponstate = WEAPON_END_RELOADING; // set weaponstate to play gun raise animation
            ent->client->current_rds = 0;
		}  

		// include else if statements for every gun in your entire mod... 

		if (!ent->client->chasetoggle)
			ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);
	}

	if (ent->client->weaponstate == WEAPON_DROPPING)
	{
		if (quickweap->value)
			ent->client->ps.gunframe = FRAME_DEACTIVATE_LAST;

		if (ent->client->ps.gunframe == FRAME_DEACTIVATE_LAST)
		{
			ChangeWeapon (ent);
			return;
		}
		// ### Hentai ### BEGIN
		else if((FRAME_DEACTIVATE_LAST - ent->client->ps.gunframe) == 4)
		{
			ent->client->anim_priority = ANIM_REVERSE;

			if(ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				ent->s.frame = FRAME_crpain4+1;
				ent->client->anim_end = FRAME_crpain1;
			}
			else
			{
				ent->s.frame = FRAME_pain304+1;
				ent->client->anim_end = FRAME_pain301;
				
			}
		}
		// ### Hentai ### END

		ent->client->ps.gunframe++;
		return;
	}

    if (ent->client->weaponstate == WEAPON_START_RELOADING)
	{
		if (ent->client->ps.gunframe < FRAME_DEACTIVATE_FIRST)
			ent->client->ps.gunframe = FRAME_DEACTIVATE_FIRST;
      	else if (ent->client->ps.gunframe == FRAME_DEACTIVATE_LAST)
		{
			ent->client->weaponstate = WEAPON_RELOADING;
			return;
		}  

		ent->client->ps.gunframe++;
		return;
	}  

    if (ent->client->weaponstate == WEAPON_ACTIVATING || ent->client->weaponstate == WEAPON_END_RELOADING)
	{
		if (quickweap->value)
			ent->client->ps.gunframe = FRAME_ACTIVATE_LAST;

		if (ent->client->ps.gunframe == FRAME_ACTIVATE_LAST)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = FRAME_IDLE_FIRST;
			return;
		}

		ent->client->ps.gunframe++;
		return;
	}

	if ((ent->client->newweapon) && (ent->client->weaponstate != WEAPON_FIRING))
	{
		ent->client->weaponstate = WEAPON_DROPPING;
		ent->client->ps.gunframe = FRAME_DEACTIVATE_FIRST;
				// ### Hentai ### BEGIN
		if((FRAME_DEACTIVATE_LAST - FRAME_DEACTIVATE_FIRST) < 4)
		{
			ent->client->anim_priority = ANIM_REVERSE;
			if(ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				ent->s.frame = FRAME_crpain4+1;
				ent->client->anim_end = FRAME_crpain1;
			}
			else
			{
				ent->s.frame = FRAME_pain304+1;
				ent->client->anim_end = FRAME_pain301;
				
			}
		}
		// ### Hentai ### END
		return;
	}

	if (ent->client->weaponstate == WEAPON_READY)
	{
		if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) )
		{
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			if ((!ent->client->ammo_index) || 
				( ent->client->pers.inventory[ent->client->ammo_index] >= ent->client->pers.weapon->quantity))
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;

				// start the animation
				ent->client->anim_priority = ANIM_ATTACK;
				if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
				{
					ent->s.frame = FRAME_crattak1-1;
					ent->client->anim_end = FRAME_crattak9;
				}
				else
				{
					ent->s.frame = FRAME_attack1-1;
					ent->client->anim_end = FRAME_attack8;
				}
			}
			else
			{
				if (level.time >= ent->pain_debounce_time)
				{
					ent->client->weapon_sound = 0; 
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				NoAmmoWeaponChange (ent);
			}
		}
		else
		{
			if (ent->client->ps.gunframe == FRAME_IDLE_LAST)
			{
				ent->client->ps.gunframe = FRAME_IDLE_FIRST;
				return;
			}

			if (pause_frames)
			{
				for (n = 0; pause_frames[n]; n++)
				{
					if (ent->client->ps.gunframe == pause_frames[n])
					{
						if (rand()&15)
							return;
					}
				}
			}

			ent->client->ps.gunframe++;
			return;
		}
	}

	if (ent->client->weaponstate == WEAPON_FIRING)
	{
		for (n = 0; fire_frames[n]; n++)
		{
			if (ent->client->ps.gunframe == fire_frames[n])
			{
				if (ent->client->quad_framenum > level.framenum)
					if (!ent->client->SonicDamage)
						gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage3.wav"), 1, ATTN_NORM, 0);

	            if (ent->client->pers.inventory[ent->client->ammo_index] == 1 || ((ent->client->pers.weapon->clips - ent->client->current_rds) == 1)) // only one round
				{
					ent->client->weaponstate = WEAPON_END_MAG; // set to end mag
					fire (ent);
			  		ent->client->current_rds++; // now there's 0 rounds
					Cmd_Reload_f(ent);
				}
				else
				{
       				fire (ent);
					ent->client->current_rds++; // subtract rounds 
				} 
			
				break;
			}
		}

		if (!fire_frames[n])
			ent->client->ps.gunframe++;

		if (ent->client->ps.gunframe == FRAME_IDLE_FIRST+1)
			ent->client->weaponstate = WEAPON_READY;
	}

	if (ent->client->weaponstate == WEAPON_END_MAG)
	{
		int frame_l = FRAME_FIRE_LAST + 11;

		if (ent->client->ps.gunframe < frame_l || ent->client->ps.gunframe > FRAME_IDLE_LAST)
			ent->client->ps.gunframe = frame_l;
		else if (ent->client->ps.gunframe == FRAME_IDLE_LAST)
		{
			ent->client->ps.gunframe = frame_l;
			return;
		}  

		if (pause_frames)
		{
			for (n = 0; pause_frames[n]; n++)
			{
				if (ent->client->ps.gunframe == pause_frames[n])
				{
					if (rand()&15)
						return;
				}
			}
		} 

		ent->client->ps.gunframe++;
		return;
	} 
}

void Weapon_Generic2 (edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int *fire_frames, void (*fire)(edict_t *ent))
{
	int		n;

	if (ent->deadflag || ent->s.modelindex != 255) // VWep animations screw up corpses
		return;

	if (ent->client->weaponstate == WEAPON_RELOADING) // they've pushed reload
	{
		if(ent->client->reload_time < 0 || ent->client->reload_time > 50) // their reload timer is screwed somehow
			ent->client->reload_time = 50; // so set it to 5 seconds remaining
		else if(ent->client->reload_time > 0) // they are still reloading
		{
			ent->client->ps.gunindex = 0; // so make sure their gun model is still gone
			ent->client->reload_time--; // and increment the reload timer
		}
		else // their reload timer is working, and they arent still reloading, so lets fill their clip
		{
			ent->client->ps.gunframe = 0; // set gunframe to ACTIVATE_FIRST (0)
			ent->client->reload_time = 0; // clear reload time
			ent->client->weaponstate = WEAPON_END_RELOADING; // set weaponstate to play gun raise animation
            ent->client->current_rds = 0;
		}  

		// include else if statements for every gun in your entire mod... 

		if (!ent->client->chasetoggle)
			ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);
	}

    if (ent->client->weaponstate == WEAPON_START_RELOADING)
	{
		if (ent->client->ps.gunframe < FRAME_DEACTIVATE_FIRST)
			ent->client->ps.gunframe = FRAME_DEACTIVATE_FIRST;
      	else if (ent->client->ps.gunframe == FRAME_DEACTIVATE_LAST)
		{
			ent->client->weaponstate = WEAPON_RELOADING;
			return;
		}  

		ent->client->ps.gunframe++;
		return;
	}  

	if (ent->client->weaponstate == WEAPON_DROPPING)
	{
		if (quickweap->value)
			ent->client->ps.gunframe = FRAME_DEACTIVATE_LAST;

		if (ent->client->ps.gunframe == FRAME_DEACTIVATE_LAST)
		{
			ChangeWeapon (ent);
			return;
		}
		// ### Hentai ### BEGIN
		else if((FRAME_DEACTIVATE_LAST - ent->client->ps.gunframe) == 4)
		{
			ent->client->anim_priority = ANIM_REVERSE;

			if(ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				ent->s.frame = FRAME_crpain4+1;
				ent->client->anim_end = FRAME_crpain1;
			}
			else
			{
				ent->s.frame = FRAME_pain304+1;
				ent->client->anim_end = FRAME_pain301;
				
			}
		}
		// ### Hentai ### END

		ent->client->ps.gunframe++;
		return;
	}

    if (ent->client->weaponstate == WEAPON_ACTIVATING || ent->client->weaponstate == WEAPON_END_RELOADING)
	{
		if (quickweap->value)
			ent->client->ps.gunframe = FRAME_ACTIVATE_LAST;

		if (ent->client->ps.gunframe == FRAME_ACTIVATE_LAST)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = FRAME_IDLE_FIRST + 10;
			return;
		}

		ent->client->ps.gunframe++;
		return;
	}

	if ((ent->client->newweapon) && (ent->client->weaponstate != WEAPON_FIRING))
	{
		ent->client->weaponstate = WEAPON_DROPPING;
		ent->client->ps.gunframe = FRAME_DEACTIVATE_FIRST;
				// ### Hentai ### BEGIN
		if((FRAME_DEACTIVATE_LAST - FRAME_DEACTIVATE_FIRST) < 4)
		{
			ent->client->anim_priority = ANIM_REVERSE;
			if(ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				ent->s.frame = FRAME_crpain4+1;
				ent->client->anim_end = FRAME_crpain1;
			}
			else
			{
				ent->s.frame = FRAME_pain304+1;
				ent->client->anim_end = FRAME_pain301;
				
			}
		}
		// ### Hentai ### END
		return;
	}

	if (ent->client->weaponstate == WEAPON_READY)
	{
		if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) )
		{
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			if ((!ent->client->ammo_index) || 
				( ent->client->pers.inventory[ent->client->ammo_index] >= ent->client->pers.weapon->quantity))
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;

				// start the animation
				ent->client->anim_priority = ANIM_ATTACK;
				if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
				{
					ent->s.frame = FRAME_crattak1-1;
					ent->client->anim_end = FRAME_crattak9;
				}
				else
				{
					ent->s.frame = FRAME_attack1-1;
					ent->client->anim_end = FRAME_attack8;
				}
			}
			else
			{
				if (level.time >= ent->pain_debounce_time)
				{
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				NoAmmoWeaponChange (ent);
			}
		}
		else
		{
			if (ent->client->ps.gunframe == FRAME_IDLE_LAST)
			{
				ent->client->ps.gunframe = FRAME_IDLE_FIRST + 10;
				return;
			}

			if (pause_frames)
			{
				for (n = 0; pause_frames[n]; n++)
				{
					if (ent->client->ps.gunframe == pause_frames[n])
					{
						if (rand()&15)
							return;
					}
				}
			}

			ent->client->ps.gunframe++;
			return;
		}
	}

	if (ent->client->weaponstate == WEAPON_FIRING)
	{
		for (n = 0; fire_frames[n]; n++)
		{
			if (ent->client->ps.gunframe == fire_frames[n])
			{
				if (ent->client->quad_framenum > level.framenum)
					gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage3.wav"), 1, ATTN_NORM, 0);

            if (ent->client->pers.inventory[ent->client->ammo_index] == 1 || ((ent->client->pers.weapon->clips - ent->client->current_rds) == 1)) // only one round
			{
				ent->client->weaponstate = WEAPON_END_MAG; // set to end mag
				fire (ent);
         		ent->client->current_rds++; // now there's 0 rounds
         		Cmd_Reload_f(ent);
			}
			else
			{
       			fire (ent);
				ent->client->current_rds++; // subtract rounds 
			} 
			
			break;
			}
		}

		if (!fire_frames[n])
			ent->client->ps.gunframe++;

		if (ent->client->ps.gunframe == FRAME_IDLE_FIRST+1)
			ent->client->weaponstate = WEAPON_READY;
	}

	if( ent->client->weaponstate == WEAPON_END_MAG)
	{
		int frame_l = FRAME_IDLE_FIRST;

		if (ent->client->ps.gunframe < frame_l || ent->client->ps.gunframe > FRAME_IDLE_LAST)
			ent->client->ps.gunframe = frame_l;
		else if (ent->client->ps.gunframe == FRAME_IDLE_LAST)
		{
			ent->client->ps.gunframe = frame_l;
			return;
		}  

		if (pause_frames)
		{
			for (n = 0; pause_frames[n]; n++)
			{
				if (ent->client->ps.gunframe == pause_frames[n])
				{
					if (rand()&15)
						return;
				}
			}
		} 

		ent->client->ps.gunframe++;
		return;
	} 
}

/*
======================================================================

GRENADE

======================================================================
*/

#define GRENADE_TIMER		3.0
#define GRENADE_MINSPEED	400
#define GRENADE_MAXSPEED	800

void weapon_grenade_fire (edict_t *ent, qboolean held)
{
	vec3_t	offset;
	vec3_t	forward, right;
	vec3_t	start;
	int		damage = 125;
	float	timer;
	int		speed;
	float	radius;

	radius = damage+40;
	if (is_quad)
		damage *= 4;

	VectorSet(offset, 8, 8, ent->viewheight-8);
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	timer = ent->client->grenade_time - level.time;
	speed = GRENADE_MINSPEED + (GRENADE_TIMER - timer) * ((GRENADE_MAXSPEED - GRENADE_MINSPEED) / GRENADE_TIMER);

	fire_grenade2 (ent, start, forward, damage, speed, timer, radius, held);
	ent->client->grenade_time = 0;

	// ### Hentai ### BEGIN

	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
	{
		ent->client->anim_priority = ANIM_ATTACK;
		ent->s.frame = FRAME_crattak1-1;
		ent->client->anim_end = FRAME_crattak3;
	}
	else
	{
		ent->client->anim_priority = ANIM_REVERSE;
		ent->s.frame = FRAME_wave08;
		ent->client->anim_end = FRAME_wave01;
	}
	// ### Hentai ### END

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
			ent->client->pers.inventory[ITEMLIST_GRENADES];
}

void Weapon_Grenade (edict_t *ent)
{
	if ((ent->client->newweapon) && (ent->client->weaponstate == WEAPON_READY))
	{
		ChangeWeapon (ent);
		return;
	}

    if (ent->client->ps.gunframe == 15)
    {
		if (ent->client->pers.inventory[ent->client->ammo_index] < 1)
		{
			NoAmmoWeaponChange (ent);
			ent->client->grenade_time = 0;
			ent->client->weaponstate  = WEAPON_READY;
			return;
        }

		if (level.time < ent->client->grenade_time)
			return;
    }

	if (ent->client->weaponstate == WEAPON_ACTIVATING)
	{
		ent->client->weaponstate = WEAPON_READY;
		ent->client->ps.gunframe = 16;
		return;
	}

	if (ent->client->weaponstate == WEAPON_READY)
	{
		if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) )
		{
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			if (ent->client->pers.inventory[ent->client->ammo_index])
			{
				ent->client->ps.gunframe = 1;
				ent->client->weaponstate = WEAPON_FIRING;
				ent->client->grenade_time = 0;
			}
			else
			{
				if (level.time >= ent->pain_debounce_time)
				{
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				NoAmmoWeaponChange (ent);
			}
			return;
		}

		if ((ent->client->ps.gunframe == 29) || (ent->client->ps.gunframe == 34) || (ent->client->ps.gunframe == 39) || (ent->client->ps.gunframe == 48))
		{
			if (rand()&15)
				return;
		}

		if (++ent->client->ps.gunframe > 48)
			ent->client->ps.gunframe = 16;
		return;
	}

	if (ent->client->weaponstate == WEAPON_FIRING)
	{
		if (ent->client->ps.gunframe == 5)
			gi.sound(ent, CHAN_WEAPON, gi.soundindex("weapons/hgrena1b.wav"), 1, ATTN_NORM, 0);

		if (ent->client->ps.gunframe == 11)
		{
			if (!ent->client->grenade_time)
			{
				ent->client->grenade_time = level.time + GRENADE_TIMER + 0.2;
				ent->client->weapon_sound = gi.soundindex("weapons/hgrenc1b.wav");
			}

			// they waited too long, detonate it in their hand
			if (!ent->client->grenade_blew_up && level.time >= ent->client->grenade_time)
			{
				ent->client->weapon_sound = 0;
				weapon_grenade_fire (ent, true);
				ent->client->grenade_blew_up = true;
         		ent->client->grenade_time = 0;
			}


			if (ent->client->buttons & BUTTON_ATTACK)
				return;

			if (ent->client->grenade_blew_up)
			{
				if (level.time >= ent->client->grenade_time)
				{
					ent->client->ps.gunframe = 15;
            		ent->client->grenade_time = 0;
					ent->client->grenade_blew_up = false;
				}
				else
				{
					return;
				}
			}
		}

		if (ent->client->ps.gunframe == 12)
		{
			ent->client->weapon_sound = 0;
			weapon_grenade_fire (ent, false);
       		ent->client->grenade_time = 0;
		}

		if ((ent->client->ps.gunframe == 15) && (level.time < ent->client->grenade_time))
			return;

		ent->client->ps.gunframe++;

		if (ent->client->ps.gunframe == 16)
		{
			ent->client->grenade_time = 0;
			ent->client->weaponstate = WEAPON_READY;
		}
	}
}

void Weapon_Grenade2 (edict_t *ent)
{
	if (level.time > ent->client->grenade_time)
		return;

	weapon_grenade_fire (ent, false);

	ent->client->last_grenade = level.time + 3;
}

void Weapon_Grenade1 (edict_t *ent)
{
	if (!ent->client->pers.inventory[ITEMLIST_GRENADES])
		return;
	if (ent->ripstate & STATE_DISARMING || ent->ripstate & STATE_BUILDING)
		return;
	if (!ent->client->pers.grenades_left[ent->client->gr_type])
	{
		gi.cprintf(ent, PRINT_HIGH, "No %s grenades left\n", gr_type (ent, ent->client->gr_type));
		return;
	}

	if (!ent->client->grenade_time)
	{
		ent->client->grenade_time = level.time + 3;
        ent->client->pers.grenades_left[ent->client->gr_type]--;
		ent->client->pers.inventory[ITEMLIST_GRENADES]--;
		gi.cprintf (ent, PRINT_HIGH, "%s grenade primed, 3 seconds\n", gr_type (ent, ent->client->gr_type));
	}
}

/*
======================================================================

GRENADE LAUNCHER

======================================================================
*/

void weapon_grenadelauncher_fire (edict_t *ent)
{
	vec3_t	offset;
	vec3_t	forward, right;
	vec3_t	start;
	int		damage = 120;
	float	radius;

	radius = damage+40;
	if (is_quad)
		damage *= 4;

	VectorSet(offset, 8, 8, ent->viewheight-8);
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

    fire_grenade (ent, start, forward, damage, 600, 2.5, radius); 

	muzzleflash (ent, MZ_GRENADE | is_silenced);

	ent->client->ps.gunframe++;

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

void Weapon_GrenadeLauncher (edict_t *ent)
{

	static int	pause_frames[]	= {34, 51, 59, 0};
	static int	fire_frames[]	= {6, 0};

	Weapon_Generic (ent, 5, 16, 59, 64, pause_frames, fire_frames, weapon_grenadelauncher_fire);
}

/*
======================================================================

PIPE LAUNCHER

======================================================================
*/

void weapon_pipebomb_fire (edict_t *ent)
{
	vec3_t	offset;
	vec3_t	forward, right;
	vec3_t	start;
	int		damage = 120;
	float	radius;

	radius = damage+40;
	if (is_quad)
		damage *= 4;

	VectorSet(offset, 8, 8, ent->viewheight-8);
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	pipebomb_throw (ent, start, forward, damage, 600, 120, radius);

	if (pipes_team[ent->client->resp.s_team-1] > (MAX_PIPEBOMBS / 2))
        Detonate_old(ent->client->resp.s_team);

	muzzleflash (ent, MZ_GRENADE | is_silenced);

	ent->client->ps.gunframe++;
}

void Weapon_PipeLauncher (edict_t *ent)
{
	static int	pause_frames[]	= {34, 51, 59, 0};
	static int	fire_frames[]	= {9, 0};

	Weapon_Generic (ent, 5, 16, 59, 64, pause_frames, fire_frames, weapon_pipebomb_fire);
}

/*
======================================================================

ROCKET

======================================================================
*/

void Weapon_RocketLauncher_Fire (edict_t *ent)
{
	vec3_t	start;
	vec3_t	forward, right;
	int		damage;
	float	damage_radius;
	int		radius_damage;
	int     rnd;

	rnd = rand()%20;
	damage = 92;
	radius_damage = 92 + rnd;
	damage_radius = 120 + rnd;

	if (is_quad)
	{
		damage *= 4;
		radius_damage *= 4;
	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	VectorClear (start);
    VectorMA (ent->s.origin, 8, forward, start);
	start[2] += (ent->viewheight - 8);
	fire_rocket (ent, start, forward, damage, 1000, damage_radius, radius_damage);

	muzzleflash (ent, MZ_ROCKET | is_silenced);
	ent->client->ps.gunframe++;

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

void Weapon_RocketLauncher (edict_t *ent)
{
	static int	pause_frames[]	= {25, 33, 42, 50, 0};
	static int	fire_frames[]	= {5, 0};

	Weapon_Generic (ent, 4, 12, 50, 54, pause_frames, fire_frames, Weapon_RocketLauncher_Fire);
}

void ICannon_Fire (edict_t *ent)
{
	vec3_t	offset, start;
	vec3_t	forward, right;
	int		damage;
	float	damage_radius;
	int		radius_damage;

	damage = 120 + (int)(random() * 20.0);
	radius_damage = 120;
	damage_radius = 120;
	if (is_quad)
	{
		damage *= 4;
		radius_damage *= 4;
	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	VectorSet(offset, 8, 8, ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	fire_flamerocket (ent, start, forward, damage, 550, damage_radius, radius_damage);

	muzzleflash (ent, MZ_BOOMERGUN);
	gi.sound (ent, CHAN_WEAPON, gi.soundindex ("weapons/flame02.wav"), 1, ATTN_NORM, 0);

	ent->client->ps.gunframe++;

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index] -= 3;
}

void Weapon_Blaster1 (edict_t *ent)
{
	static int	pause_frames[]	= {25, 33, 42, 50, 0};
	static int	fire_frames[]	= {5, 0};

	Weapon_Generic (ent, 4, 12, 50, 54, pause_frames, fire_frames, ICannon_Fire);
}

/*
======================================================================

MACHINEGUN / CHAINGUN

======================================================================
*/

void Machinegun_Fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		angles;
	int			damage = 8;
	int			kick = 2;
	vec3_t		offset;

	if (!(ent->client->buttons & BUTTON_ATTACK))
	{
		ent->client->machinegun_shots = 0;
		ent->client->ps.gunframe++;
		return;
	}

	if (ent->client->ps.gunframe == 5)
		ent->client->ps.gunframe = 4;
	else
		ent->client->ps.gunframe = 5;

	if (ent->client->pers.inventory[ent->client->ammo_index] < 1)
	{
		ent->client->ps.gunframe = 6;
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
		return;
	}

	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}

	// get start / end positions
	VectorAdd (ent->client->v_angle, ent->client->kick_angles, angles);
	AngleVectors (angles, forward, right, NULL);
	VectorSet(offset, 0, 8, ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

   	fire_bullet (ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_MACHINEGUN);

	muzzleflash (ent, MZ_MACHINEGUN | is_silenced);

	// ### Hentai ### BEGIN
	ent->client->anim_priority = ANIM_ATTACK;
	if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
	{
		ent->s.frame = FRAME_crattak1 - (int) (random()+0.25);
		ent->client->anim_end = FRAME_crattak9;
	}
	else
	{
		ent->s.frame = FRAME_attack1 - (int) (random()+0.25);
		ent->client->anim_end = FRAME_attack8;
	}

	// ### Hentai ### END

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index] --;
}

void Weapon_Machinegun (edict_t *ent)
{
	static int	pause_frames[]	= {23, 45, 0};
	static int  fire_frames[] = {4, 5, 0};

	Weapon_Generic (ent, 3, 5, 45, 49, pause_frames, fire_frames, Machinegun_Fire);
}

void Weapon_M16 (edict_t *ent)
{
	static int	pause_frames[]	= {23, 45, 0};
	static int  fire_frames[] = {5, 0};

	Weapon_Generic (ent, 3, 5, 45, 49, pause_frames, fire_frames, Machinegun_Fire);
}

void Chaingun_Fire (edict_t *ent)
{
	int			i;
	int			shots;
	vec3_t		start;
	vec3_t		forward, right, up;
	float		r, u;
	vec3_t		offset;
	int			damage;
	int			kick = 2;

	if (deathmatch->value)
		damage = 6;
	else
		damage = 8;

	if (ent->client->ps.gunframe == 5)
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/chngnu1a.wav"), 1, ATTN_IDLE, 0);

	if ((ent->client->ps.gunframe == 14) && !(ent->client->buttons & BUTTON_ATTACK))
	{
		ent->client->ps.gunframe = 32;
		ent->client->weapon_sound = 0;
		return;
	}
	else if ((ent->client->ps.gunframe == 21) && (ent->client->buttons & BUTTON_ATTACK)
		&& ent->client->pers.inventory[ent->client->ammo_index])
	{
		ent->client->ps.gunframe = 15;
	}
	else
	{
		ent->client->ps.gunframe++;
	}

	if (ent->client->ps.gunframe == 22)
	{
		ent->client->weapon_sound = 0;
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/chngnd1a.wav"), 1, ATTN_IDLE, 0);
	}
	else
	{
		ent->client->weapon_sound = gi.soundindex("weapons/chngnl1a.wav");
	}

	if (ent->client->ps.gunframe <= 9)
		shots = 1;
	else if (ent->client->ps.gunframe <= 14)
	{
		if (ent->client->buttons & BUTTON_ATTACK)
			shots = 2;
		else
			shots = 1;
	}
	else
		shots = 3;

	if (ent->client->pers.inventory[ent->client->ammo_index] < shots)
		shots = ent->client->pers.inventory[ent->client->ammo_index];

	if (!shots)
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
		return;
	}

	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}

	for (i=0 ; i<3 ; i++)
	{
		ent->client->kick_origin[i] = crandom() * 0.35;
		ent->client->kick_angles[i] = crandom() * 0.7;
	}

	for (i=0 ; i<shots ; i++)
	{
		// get start / end positions
		AngleVectors (ent->client->v_angle, forward, right, up);
		r = 7 + crandom()*4;
		u = crandom()*4;
		VectorSet(offset, 0, r, u + ent->viewheight-8);
		P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

		fire_bullet (ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_CHAINGUN);
	}

	muzzleflash (ent, ((MZ_CHAINGUN1 + shots - 1) | is_silenced));

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index] -= shots;
}

void Weapon_Chaingun (edict_t *ent)
{
	static int	pause_frames[]	= {38, 43, 51, 61, 0};
	static int	fire_frames[]	= {5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 0};

	Weapon_Generic (ent, 4, 31, 61, 64, pause_frames, fire_frames, Chaingun_Fire);
}


/*
======================================================================

SHOTGUN / SUPERSHOTGUN

======================================================================
*/

void weapon_shotgun_fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		offset;
	int			damage = 8;
	int			kick = 8;

	if (ent->client->ps.gunframe == 9)
	{
		ent->client->ps.gunframe++;
		return;
	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -2;

	VectorSet(offset, 0, 8,  ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}

	fire_shotgun (ent, start, forward, damage, kick, 500, 500, DEFAULT_DEATHMATCH_SHOTGUN_COUNT, MOD_SHOTGUN);

	muzzleflash (ent, MZ_SHOTGUN | is_silenced);

	ent->client->ps.gunframe++;

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

void Weapon_Shotgun (edict_t *ent)
{
	static int	pause_frames[]	= {22, 28, 34, 0};
	static int	fire_frames[]	= {8, 9, 0};

	Weapon_Generic (ent, 7, 18, 36, 39, pause_frames, fire_frames, weapon_shotgun_fire);
}


void weapon_supershotgun_fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		offset;
	vec3_t		v;
	int			damage = 12;
	int			kick = 18;

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -2;

	VectorSet(offset, 0, 8,  ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}

	v[PITCH] = ent->client->v_angle[PITCH];
	v[YAW]   = ent->client->v_angle[YAW] - 5;
	v[ROLL]  = ent->client->v_angle[ROLL];
	AngleVectors (v, forward, NULL, NULL);
	fire_shotgun (ent, start, forward, damage, kick, DEFAULT_SHOTGUN_HSPREAD, DEFAULT_SHOTGUN_VSPREAD, DEFAULT_SSHOTGUN_COUNT/2, MOD_SSHOTGUN);
	v[YAW]   = ent->client->v_angle[YAW] + 5;
	AngleVectors (v, forward, NULL, NULL);
	fire_shotgun (ent, start, forward, damage, kick, DEFAULT_SHOTGUN_HSPREAD, DEFAULT_SHOTGUN_VSPREAD, DEFAULT_SSHOTGUN_COUNT/2, MOD_SSHOTGUN);

	muzzleflash (ent, MZ_SSHOTGUN | is_silenced);

	ent->client->ps.gunframe++;

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index] -= 2;
}

void Weapon_SuperShotgun (edict_t *ent)
{
	static int	pause_frames[]	= {29, 42, 57, 0};
	static int	fire_frames[]	= {7, 0};

	Weapon_Generic (ent, 6, 17, 57, 61, pause_frames, fire_frames, weapon_supershotgun_fire);
}



/*
======================================================================

RAILGUN

======================================================================
*/

void weapon_railgun_fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		offset;
	int			kick;
	int         damage;

	kick = 100;
	damage = 25;

	if (is_quad)
	{
        ent->client->SonicDamage *= 4;
		kick *= 4;
	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -3, ent->client->kick_origin);
	ent->client->kick_angles[0] = -3;

	VectorSet(offset, 0, 7,  ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	fire_rail (ent, start, forward, damage, kick);

	muzzleflash (ent, MZ_RAILGUN | is_silenced);

	ent->client->ps.gunframe++;

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

void Weapon_Railgun (edict_t *ent)
{
	static int	pause_frames[]	= {56, 0};
	static int	fire_frames[]	= {4, 0};

	Weapon_Generic2 (ent, 3, 8, 56, 61, pause_frames, fire_frames, weapon_railgun_fire);
}

//======================================================================

void Weapon_Gorelka_Fire (edict_t *ent, vec3_t g_offset, int damage, qboolean hyper, int effect)
{
	vec3_t	forward, right;
	vec3_t	start;
	vec3_t	offset;
	vec3_t	direct_damage = {6, 9, 25};
	vec3_t	radius_damage = {6, 4, 25};
    vec3_t  spread = {10, 20, 0};

	if (is_quad)
		damage *= 4;

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorSet(offset, 24, 8, ent->viewheight-8);
	VectorAdd (offset, g_offset, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

    VectorSet (direct_damage, 6, 9, 50);
    VectorSet (radius_damage, 4, 2, 25);

	PBM_FireFlameThrower (ent, start, spread, forward, (rand()%601 + 600), direct_damage, radius_damage, 10, 0);

	muzzleflash (ent, MZ_BOOMERGUN | is_silenced);
	gi.sound (ent, CHAN_WEAPON, gi.soundindex ("weapons/flmfire2.wav"), 1, ATTN_NORM, 0);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index] --;
}

void Gorelka_Fire (edict_t *ent)
{
	int		damage;

	damage = 15;
	Weapon_Gorelka_Fire (ent, vec3_origin, damage, false, 0);
	ent->client->ps.gunframe++;
}

void Weapon_Gorelka (edict_t *ent)
{
	static int	pause_frames[]	= {23, 45, 0};
	static int	fire_frames[]	= {4, 5, 0};

	Weapon_Generic (ent, 3, 5, 45, 49, pause_frames, fire_frames, Gorelka_Fire);
}

void Tranq_Fire (edict_t *ent, vec3_t g_offset, int damage)
{
	vec3_t	forward, right;
	vec3_t	start;
	vec3_t	offset;

	if (is_quad)
		damage *= 4;
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorSet(offset, 24, 8, ent->viewheight-8);
	VectorAdd (offset, g_offset, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	fire_tranq (ent, start, forward, damage, 1500);

	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_BOOMERGUN | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
	gi.sound (ent, CHAN_WEAPON, gi.soundindex("weapons/bow_fire.wav"), 1, ATTN_NORM, 0);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

void Weapon_Tranq_Fire (edict_t *ent)
{
	int		damage;

	damage = 20;
	Tranq_Fire (ent, vec3_origin, damage);
	ent->client->ps.gunframe++;
}

void Weapon_Tranq (edict_t *ent)
{
    static int	pause_frames[]	= {10, 18, 27, 0};
	static int	fire_frames[]	= {6, 0};

	Weapon_Generic (ent, 5, 12, 50, 54, pause_frames, fire_frames, Weapon_Tranq_Fire);
}

/*
======================================================================

RIFLE

======================================================================
*/

void weapon_rifle_fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		offset;
	int			kick;

	kick = 100;

	if (ent->client->buttons & BUTTON_ATTACK)
	{
		if (ent->client->pers.autozoom)
		{
			if (ent->client->SonicDamage == 150)
			{
 				int i;
				char s[16];

                i = ent->client->ps.fov - 10;
				if (i < 30)
					i = 30;

				sprintf (s, "fov %i\n", i);
				stuffcmd (ent, s);
				ent->client->ps.fov = i;
			}
		}

		if (!(ent->ripstate & STATE_ZOOM))
			ent->ripstate |= STATE_ZOOM;

        Rip_SetSpeed (ent);

		if (!ent->client->lasersight)
			SP_LaserSight (ent);

		ent->client->lasersight = true;

		ent->client->SonicDamage += 10;
		kick += 10;

		if (ent->client->SonicDamage > 150)
		{
			ent->client->SonicDamage = 150;	//This is the maximum damage of the Sonic Rail
			kick = 350;
		}
    	return;
	}
	
	if (ent->client->SonicDamage < 70)
	{
		ent->client->SonicDamage = 70;	// This sets the minimum damage of the Sonic Rail
		kick = 170;
	}

	if (is_quad)
	{
        ent->client->SonicDamage *= 4;
		kick *= 4;
	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -3, ent->client->kick_origin);
	ent->client->kick_angles[0] = -3;

	VectorSet(offset, 0, 7,  ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	if (!(ent->client->buttons & BUTTON_ATTACK))
	{
		if (ent->ripstate & STATE_ZOOM)
		{
			stuffcmd (ent, "fov 90\n");
			ent->client->ps.fov = 90;
			ent->ripstate &= ~STATE_ZOOM;
			Rip_SetSpeed (ent);
		}
	}

    ent->client->lasersight = false;

	fire_bullet (ent, start, forward, ent->client->SonicDamage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_SRIFLE);

	muzzleflash (ent, MZ_BOOMERGUN | is_silenced);
	gi.sound (ent, CHAN_WEAPON, gi.soundindex ("weapons/srifle.wav"), 1, ATTN_NORM, 0);

	ent->client->ps.gunframe++;

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;

	ent->client->SonicDamage = 0;	// Will
}

void weapon_autorifle_fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		offset;
	int			kick;
	kick = 100;

	if (!(ent->client->buttons & BUTTON_ATTACK))
	{
		ent->client->ps.gunframe++;
		return;
	}

	if (ent->client->ps.gunframe == 8)
		ent->client->ps.gunframe = 4;

	ent->client->ps.gunframe++;

	if (ent->client->pers.inventory[ent->client->ammo_index] < 1)
	{
		ent->client->ps.gunframe = 6;
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
		return;
	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -3, ent->client->kick_origin);
	ent->client->kick_angles[0] = -3;

	VectorSet(offset, 0, 7,  ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	fire_bullet (ent, start, forward, ent->client->SonicDamage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_AUTORIFLE);

	muzzleflash (ent, MZ_BOOMERGUN | is_silenced);

	gi.sound (ent, CHAN_WEAPON, gi.soundindex ("weapons/sentry.wav"), 1, ATTN_NORM, 0);

	ent->client->ps.gunframe++;

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;
}

void Weapon_SRifle (edict_t *ent)
{
	static int	pause_frames[]	= {5, 15, 35, 0};

	if (ent->ripstate & STATE_AUTO)
	{
     	static int	fire_frames[]	= {2, 3, 4, 5, 6, 7, 8, 0};
    	Weapon_Generic (ent, 3, 18, 56, 61, pause_frames, fire_frames, weapon_autorifle_fire);
	}
	else
	{
    	static int	fire_frames[]	= {8, 0};
    	Weapon_Generic (ent, 3, 18, 56, 61, pause_frames, fire_frames, weapon_rifle_fire);
	}
}

void Cannon_Fire (edict_t *ent)
{
	int			i;
	int			shots, damage;
	vec3_t		start;
	vec3_t		forward, right, up;
	float		r, u;
	vec3_t		offset;
	int			kick = 2;

	damage = 9;

	if (ent->velocity[0] || ent->velocity[1] || ent->velocity[2])
	{
       	if (ent->client->ps.gunframe >= 15 && !(ent->client->buttons & BUTTON_ATTACK)) 
		{
       		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/asscan3.wav"), 1, ATTN_NORM, 0);
 			ent->client->ps.gunframe = 32;
			ent->client->weapon_sound = 0;
			return;
		}

		if (ent->client->buttons & BUTTON_ATTACK)
		{
			if (ent->client->ps.gunframe == 31)
				ent->client->ps.gunframe = 10;
		}

      	if (ent->client->ps.gunframe == 32)
		{
			ent->client->weapon_sound = 0;
			gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/asscan3.wav"), 1, ATTN_NORM, 0);
		}
     	else
			ent->client->weapon_sound = gi.soundindex("weapons/asscan4.wav");

		ent->client->ps.gunframe++;
		return;
	}

	if (ent->client->ps.gunframe == 5)
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/asscan1.wav"), 1, ATTN_IDLE, 0);

	if ((ent->client->ps.gunframe == 14) && !(ent->client->buttons & BUTTON_ATTACK))
	{
		ent->client->ps.gunframe = 32;
		ent->client->weapon_sound = 0;
		return;
	}
	else if ((ent->client->ps.gunframe == 21) && (ent->client->buttons & BUTTON_ATTACK)
		&& ent->client->pers.inventory[ent->client->ammo_index])
	{
		ent->client->ps.gunframe = 15;
	}
	else
		ent->client->ps.gunframe++;

	if (ent->client->ps.gunframe == 32)
	{
		ent->client->weapon_sound = 0;
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/asscan3.wav"), 1, ATTN_IDLE, 0);
	}
	else
	{
		ent->client->weapon_sound = gi.soundindex("weapons/asscan4.wav");
	}

	if (ent->client->ps.gunframe <= 9)
		shots = 1;
	else if (ent->client->ps.gunframe <= 14)
	{
		if (ent->client->buttons & BUTTON_ATTACK)
			shots = 2;
		else
		{
			shots = 1;
			ent->client->weapon_sound = 0;
		}
	}
	else
		shots = 3;

	if (ent->client->pers.inventory[ent->client->ammo_index] < shots)
		shots = ent->client->pers.inventory[ent->client->ammo_index];

	if (!shots)
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		ent->client->weapon_sound = 0;
		NoAmmoWeaponChange (ent);
		return;
	}

	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}

	for (i=0 ; i<3 ; i++)
	{
		ent->client->kick_origin[i] = crandom() * 0.35;
		ent->client->kick_angles[i] = crandom() * 0.7;
	}

	// make a big pitch kick with an inverse fall
	ent->client->v_dmg_pitch = -shots*10;
	ent->client->v_dmg_roll = crandom()*5;
	ent->client->v_dmg_time = level.time + DAMAGE_TIME;

	for (i=0 ; i<shots ; i++)
	{
		// get start / end positions
		AngleVectors (ent->client->v_angle, forward, right, up);
		r = 7 + crandom()*4;
		u = crandom()*4;
		VectorSet(offset, 0, r, u + ent->viewheight-8);
		P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

		fire_bullet (ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_CHAINGUN);
	}

	muzzleflash (ent, (MZ_BOOMERGUN | is_silenced));
	
	if (level.time > ent->pain_debounce_time)
	{
		// flash the screen
		ent->client->bonus_alpha = 0.25;	
		gi.sound (ent, CHAN_AUTO, gi.soundindex("weapons/asscan2.wav"), 1, ATTN_NORM, 0);
		ent->pain_debounce_time = level.time + 0.3;
	}

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO ) )
		ent->client->pers.inventory[ent->client->ammo_index] -= shots;
}

void Weapon_Cannon (edict_t *ent)
{
	static int	pause_frames[]	= {38, 43, 51, 61, 0};
	static int	fire_frames[]	= {5, 7, 9, 11, 13, 15, 17, 18, 19, 21, 23, 25, 27, 29, 31, 0};

	Weapon_Generic (ent, 4, 31, 61, 64, pause_frames, fire_frames, Cannon_Fire);
}

/*
================
W_FireAxe
================
*/

void W_FireAxe (edict_t *self)
{
	vec3_t	source, offset, forward, right, start, _source, org, __source;
	trace_t tr;

	gi.sound (self, CHAN_WEAPON, gi.soundindex("weapons/ax1.wav"), 1, ATTN_NORM, 0);

	AngleVectors (self->client->v_angle, forward, right, NULL);

	VectorSet(offset, 0, 7,  self->viewheight-8);
	P_ProjectSource (self->client, self->s.origin, offset, forward, right, start);

	VectorClear (source);
    VectorCopy (self->s.origin, source);
	source[2] += 16;

    VectorMA (source, 64, forward, _source);

	tr = gi.trace (source, NULL, NULL, _source, self, MASK_SHOT);

	if (tr.fraction == 1.0)
	{
     	self->client->ps.gunframe ++;
		return;
	}
	
	VectorClear (__source);
    VectorMA (vec3_origin, 4, forward, __source);
    VectorSubtract (tr.endpos, __source, org);

	if (tr.ent->takedamage)
	{
		if (self->playerclass != PC_SPY || !tr.ent->client)
			T_Damage (tr.ent, self, self, forward, _source, vec3_origin, 20, 10, 0, MOD_AXE);
		else	// spy can try for the backstab!
		{
			// Backstab
			if (!loc_CanSee (self, tr.ent))
				T_Damage (tr.ent, self, self, forward, _source, vec3_origin, 120, 120, DAMAGE_NO_ARMOR, MOD_BACKSTAB);
			else
				T_Damage (tr.ent, self, self, forward, _source, vec3_origin, 40, 10, 0, MOD_AXE);
		}
	}
	else
	{	// hit wall
		if (strncmp (tr.surface->name, "sky", 3) != 0)
		{
          	gi.sound (self, CHAN_AUTO, gi.soundindex("weapons/axhit2.wav"), 1, ATTN_NORM, 0);

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SHOTGUN);
			gi.WritePosition (tr.endpos);
			gi.WriteDir (tr.plane.normal);
			gi.multicast (tr.endpos, MULTICAST_PVS);
		}
	}
	self->client->ps.gunframe ++;
}

void Weapon_Axe (edict_t *ent)
{
	if (ent->playerclass == PC_SPY)
	{
		static int	pause_frames[] = {10, 20, 30, 0};
	   	static int	fire_frames[] = {7, 0};
		Weapon_Generic (ent, 5, 12, 52, 59, pause_frames, fire_frames, W_FireAxe);
	}
	else
	{
		static int	pause_frames[] = {9, 0};
	   	static int	fire_frames[] = {4, 0};
		Weapon_Generic (ent, 1, 6, 8, 10, pause_frames, fire_frames, W_FireAxe);
	}
}

/*
================
W_FireAxe
================
*/

void val (edict_t *ent, edict_t *other);
void val3 (edict_t *self, edict_t *other);

void W_FireSpanner (edict_t *self)
{
	vec3_t	source, offset, forward, right, start, _source, org, __source;
	trace_t tr;

	gi.sound (self, CHAN_WEAPON, gi.soundindex("weapons/ax1.wav"), 1, ATTN_NORM, 0);

	AngleVectors (self->client->v_angle, forward, right, NULL);

	VectorSet(offset, 0, 7,  self->viewheight-8);
	P_ProjectSource (self->client, self->s.origin, offset, forward, right, start);

	VectorClear (source);
    VectorCopy (self->s.origin, source);
	source[2] += 16;

    VectorMA (source, 64, forward, _source);

	tr = gi.trace (source, NULL, NULL, _source, self, MASK_SHOT);

	if (tr.fraction == 1.0)
	{
     	self->client->ps.gunframe ++;
		return;
	}
	
	VectorClear (__source);
    VectorMA (vec3_origin, 4, forward, __source);
    VectorSubtract (tr.endpos, __source, org);

	if (tr.ent->takedamage)
	{
		if (stricmp (tr.ent->classname, "sentry") == 0)
		{
			gi.cprintf (self, PRINT_HIGH, "Level %i Sentry Gun has %i health, %i shells", tr.ent->playerclass, tr.ent->health, tr.ent->bullets);

			if (tr.ent->playerclass == 3)
				gi.cprintf (self, PRINT_HIGH, ", %i rockets\n", tr.ent->rockets);
			else
				gi.cprintf (self, PRINT_HIGH, "\n");

			val (tr.ent, self);
			self->client->ps.gunframe++;
			return;
		}
		else if (stricmp (tr.ent->classname, "dispencer") == 0)
		{
			gi.cprintf (self, PRINT_HIGH, "Dispencer has %i health, %i shells, %i bullets, %i grenades, %i rockets, %i cells, %i slugs, and %i armor\n", tr.ent->health, tr.ent->bounces, tr.ent->bullets, tr.ent->leg_damage, tr.ent->rockets, tr.ent->cells, tr.ent->slugs, tr.ent->count);
			val3 (tr.ent, self);
			self->client->ps.gunframe++;
			return;
		}
		else
		{
			if (tr.ent->client)
			{
				if (tr.ent->client->resp.s_team == self->client->resp.s_team && teamplay->value)
				{
					int healam;

					healam = 10;
						
					if (self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < healam)
						healam = self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))];

					// Only fix armor if they've got some
					if (!ArmorIndex(tr.ent))
						return;

					if (tr.ent->client->pers.max_armor - tr.ent->client->pers.inventory[ArmorIndex(tr.ent)] < (healam * 4))
      					healam = ceil(tr.ent->client->pers.max_armor - tr.ent->client->pers.inventory[ArmorIndex(tr.ent)] / 4);

					if (healam > 0)
					{
						tr.ent->client->pers.inventory[ArmorIndex(tr.ent)] += (healam * 4);
						if (tr.ent->client->pers.inventory[ArmorIndex(tr.ent)] > tr.ent->client->pers.max_armor)
							tr.ent->client->pers.inventory[ArmorIndex(tr.ent)] = tr.ent->client->pers.max_armor;

						self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= healam;
						gi.sound(tr.ent, CHAN_AUTO, gi.soundindex("misc/ar1_pkup.wav"), 1, ATTN_NORM, 0);

						gi.WriteByte (svc_temp_entity);
						gi.WriteByte (TE_SHOTGUN);
						gi.WritePosition (tr.endpos);
						gi.WriteDir (tr.plane.normal);
						gi.multicast (tr.endpos, MULTICAST_PVS);
					}
					return;
				}
			}
				T_Damage (tr.ent, self, self, forward, _source, vec3_origin, 20, 10, 0, MOD_SPANNER);
		}
	}
	else
	{	// hit wall
		if (strncmp (tr.surface->name, "sky", 3) != 0)
		{
			gi.sound (self, CHAN_AUTO, gi.soundindex("weapons/axhit2.wav"), 1, ATTN_NORM, 0);
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SHOTGUN);
			gi.WritePosition (tr.endpos);
			gi.WriteDir (tr.plane.normal);
			gi.multicast (tr.endpos, MULTICAST_PVS);
		}
	}

	self->client->ps.gunframe ++;
}

void Weapon_Spanner (edict_t *ent)
{
	static int	pause_frames[]	= {9, 0};
   	static int	fire_frames[]	= {4, 0};

   	Weapon_Generic (ent, 1, 6, 8, 10, pause_frames, fire_frames, W_FireSpanner);
}

void item_megahealth_rot (edict_t *self)
{
	if (!self->owner || !self->owner->inuse || !self->owner->client)
		return;

	if (self->owner->health > self->owner->max_health)
	{
		self->nextthink = level.time + 1;
		self->owner->health -= 1;
		return;
	}

	self->owner->ripstate &= ~STATE_MEGAHEALTH;
	G_FreeEdict (self);
}

void W_FireBio (edict_t *self)
{
	vec3_t	source, offset, forward, right, start, _source, org, __source;
	trace_t tr;

	gi.sound (self, CHAN_WEAPON, gi.soundindex("weapons/ax1.wav"), 1, ATTN_NORM, 0);

	AngleVectors (self->client->v_angle, forward, right, NULL);

	VectorSet(offset, 0, 7,  self->viewheight-8);
	P_ProjectSource (self->client, self->s.origin, offset, forward, right, start);

	VectorClear (source);
    VectorCopy (self->s.origin, source);
	source[2] += 16;

    VectorMA (source, 64, forward, _source);

	tr = gi.trace (source, NULL, NULL, _source, self, MASK_SHOT);

	if (tr.fraction == 1.0)
	{
     	self->client->ps.gunframe ++;
		return;
	}
	
	VectorClear (__source);
    VectorMA (vec3_origin, 4, forward, __source);
    VectorSubtract (tr.endpos, __source, org);

	if (tr.ent->client && tr.ent->takedamage)
	{
		int healam;

		if ((tr.ent->client->resp.s_team == self->client->resp.s_team && self->client->resp.s_team))
		{
			healam = WEAP_MEDIKIT_HEAL;

			if (tr.ent->client->DrunkTime > level.time)
			{
				// remove concussion from player
				// Try to find a concusstimer entity for this player
				SpawnDamage (TE_BLOOD, tr.endpos, tr.plane.normal, 20);
				gi.cprintf(tr.ent, PRINT_HIGH, "You have been healed of your concussion\n");
				tr.ent->client->DrunkTime = 0;

				// Give the medic a frag for doing it, only if it was caused by an enemy
				if (!(int) tflags->value & RF_NO_FRAG)
					self->client->resp.score++;
			}

			// remove hallucination from player
			// Try to find a hallucination timer entity for this player
			if (tr.ent->client->GasedTime > level.time)
			{
				tr.ent->client->GasedTime = 0;

				SpawnDamage (TE_BLOOD, tr.endpos, tr.plane.normal, 20);
				gi.cprintf(tr.ent, PRINT_HIGH, "You have been healed of your hallucinations\n");

				// Give the medic a frag for doing it, only if it was caused by an enemy
   				if (!(int) tflags->value & RF_NO_FRAG)
     				self->client->resp.score++;
			}

			// remove tranquilisation from player
			// Try to find a tranquilisation timer entity for this player
			if (tr.ent->client->tranq_time > level.time)
			{
				tr.ent->client->tranq_time = 0;
				Rip_SetSpeed(tr.ent);

				SpawnDamage (TE_BLOOD, tr.endpos, tr.plane.normal, 20);

				gi.cprintf (tr.ent, PRINT_HIGH, "You have been healed of your tranquilisation\n");

				// Give the medic a frag for doing it, only if it was caused by an enemy
                if (!(int) tflags->value & RF_NO_FRAG)
					self->client->resp.score++;
			}

			// check if the healed player is blinded
			if (tr.ent->client->blindTime > level.time)
			{
				tr.ent->client->blindTime = 0;
				Rip_SetSpeed(tr.ent);

				SpawnDamage (TE_BLOOD, tr.endpos, tr.plane.normal, 20);

				gi.cprintf (tr.ent, PRINT_HIGH, "You have been healed of your blindness\n");

				// Give the medic a frag for doing it, only if it was caused by an enemy
                if (!(int) tflags->value & RF_NO_FRAG)
					self->client->resp.score++;
			}

			// check if the healed player is infected
			if (tr.ent->client->infection_time > level.time)
			{
				healam = (int)(tr.ent->health / 2);

				// remove the infection
				tr.ent->client->infection_time = 0;

				// some damage is caused (because of the use of leeches!)
				// remove half their remaining health
				T_Damage (tr.ent, self, self, vec3_origin, tr.endpos, tr.plane.normal, healam, 0, DAMAGE_NO_KNOCKBACK, MOD_MEDIKIT);
				SpawnDamage (TE_BLOOD, tr.endpos, tr.plane.normal, 30);

				gi.cprintf(tr.ent, PRINT_HIGH, "Your infection is cured!\n");
      			gi.cprintf(self, PRINT_HIGH, "You have healed %s of the infection.\n", tr.ent->client->pers.netname);

				// Give the medic a frag for doing it, only if it was caused by an enemy
                if (!(int) tflags->value & RF_NO_FRAG)
					self->client->resp.score++;
				return;
			}

			// put out the fire if they are burning
			if (tr.ent->burnout)
			{
				gi.sound(tr.ent, CHAN_AUTO, gi.soundindex("items/n_health.wav.wav"), 1, ATTN_NORM, 0);

				tr.ent->burnout = 0;
				tr.ent->burner = NULL;

				gi.cprintf(tr.ent, PRINT_HIGH, "The flames have been doused!\n");
				gi.cprintf(self, PRINT_MEDIUM, "You have put out %s's fire.\n", tr.ent->client->pers.netname);
						
				return;
			}

			if (healam > 0 && tr.ent->health < tr.ent->max_health)
			{
				gi.sound(tr.ent, CHAN_AUTO, gi.soundindex("items/n_health.wav"), 1, ATTN_NORM, 0);
				SpawnDamage (TE_BLOOD, tr.endpos, tr.plane.normal, 20);
				T_Heal(tr.ent, healam, false);
			}
			else if (tr.ent->health >= tr.ent->max_health && tr.ent->health < (tr.ent->max_health + WEAP_MEDIKIT_OVERHEAL))
			{
				healam = 5;
				if (healam > (self->client->pers.inventory[ITEM_INDEX(FindItem("Medikit"))] * 5))
					healam = (self->client->pers.inventory[ITEM_INDEX(FindItem("Medikit"))] * 5);
				if (healam > 0)
				{
					gi.sound(tr.ent, CHAN_ITEM, gi.soundindex("items/r_item2.wav"), 1, ATTN_NORM, 0);

					T_Heal(tr.ent, healam, true);

					self->client->pers.inventory[ITEM_INDEX(FindItem("Medikit"))] = self->client->pers.inventory[ITEM_INDEX(FindItem("Medikit"))] - (int)(healam / 5);

					if (!(tr.ent->ripstate & STATE_MEGAHEALTH))
					{
						edict_t *newmis;

						tr.ent->ripstate |= STATE_MEGAHEALTH;
						newmis = G_Spawn();
						newmis->classname = "medikit_rot";
						newmis->nextthink = level.time + 5;
						newmis->think = item_megahealth_rot;
						newmis->owner = tr.ent;
						gi.linkentity (newmis);
					}
				}
			}
		}
		else  // musn't be on their team, so we infect them
		{
			SpawnDamage (TE_BLOOD, tr.endpos, tr.plane.normal, 20);

			T_Damage (tr.ent, self, self, vec3_origin, tr.endpos, tr.plane.normal, 10, 0, DAMAGE_NO_KNOCKBACK, MOD_BIOWEAPON_ATT);

			if (tr.ent->playerclass == PC_MEDIC)
				return;

			tr.ent->client->infection_time = level.time + 1000;
		}
	}
}

void Healgun_Fire (edict_t *ent)
{
	W_FireBio (ent);
	gi.sound (ent, CHAN_WEAPON, gi.soundindex ("weapons/stim.wav"), 1, ATTN_NORM, 0);

	ent->client->ps.gunframe++;
}

void Weapon_Healgun (edict_t *ent)
{
    static int	pause_frames[]	= {10, 18, 27, 0};
	static int	fire_frames[]	= {6, 0};

	Weapon_Generic (ent, 5, 12, 50, 54, pause_frames, fire_frames, Healgun_Fire);
}

void shell_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

	gi.sound (ent, CHAN_VOICE, gi.soundindex("weapons/shellhit.wav"), 1, ATTN_NORM, 0);
}

void eject_shell (edict_t *self)
{
	float  flip;
	vec3_t forward, right;
    edict_t *newmis;

	if (!shell_ejection->value || !self->client)
		return;

    // Spawn one shell
	newmis = G_Spawn ();
	AngleVectors (self->client->v_angle, forward, right, NULL);
	P_ProjectSource (self->client, self->s.origin, tv(10, 8, self->viewheight + 1), forward, right, newmis->s.origin);
	newmis->owner = self;
	newmis->nextthink = level.time + 1;
	newmis->think = G_FreeEdict;
    newmis->movetype = MOVETYPE_BOUNCE;
	newmis->solid = SOLID_BBOX;
	newmis->touch = shell_touch;
    newmis->classname = "shellcasing";
    newmis->s.modelindex = gi.modelindex("models/objects/shell/tris.md2");

	VectorClear (newmis->mins);
	VectorClear (newmis->maxs);

	gi.linkentity (newmis);

    flip = random();

    // Based on that number, pick a velocity
    if (flip < 0.2 )
     	VectorSet (newmis->velocity, 75, 20, 25);
	else if (flip < 0.4)
		VectorSet (newmis->velocity, 50, 50, 80);
    else if (flip < 0.6)
		VectorSet (newmis->velocity, 10, 25, 200);
    else if (flip < 0.8)
		VectorSet (newmis->velocity, 75, 50, 100);
    else
		VectorSet (newmis->velocity, 40, 10, 75);

    // pick a random number
    flip = random();

    // based on that rate, pick a rate at which to spin
    if (flip < 0.25)
		VectorSet (newmis->avelocity, 300, 300, 300);
    else if (flip < 0.5)
		VectorSet (newmis->avelocity, 150, 300, 100);
    else if (flip < 0.75)
		VectorSet (newmis->avelocity, 200, 100, 0);
    else
		VectorSet (newmis->avelocity, 400, 200, 100); 
}