#include "g_local.h"

static int sound_idle;
int MeanOfDeath;

void sentry_fire_inflictor (edict_t *self, vec3_t v, vec3_t targetdir);
void sentry_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point); 
void sentry_run (edict_t *sentry);
void sentry_attack (edict_t *sentry);
void sentry_noise (edict_t *ent);

void ShowGun (edict_t *nt);
qboolean FindTarget (edict_t *self);

mmove_t sentry_move_attack2;
mmove_t sentry_move_stand1;

#define W_CHAINGUN 1
#define W_ROCKETL  2
#define W_RAILGUN  3

qboolean CheckArea (edict_t *obj, edict_t *builder)
{
	vec3_t src, end;
	int pos;
	trace_t tr;

	// Check the origin
	pos = gi.pointcontents(obj->s.origin); 
	if (pos == 1 || pos == 2) 
		return false;

	// Check the surrounding area
	VectorSet (src, obj->s.origin[0] + obj->maxs[0] + 16, obj->s.origin[1] + obj->maxs[1] + 16, obj->s.origin[2] + obj->maxs[2] + 16);

	pos = gi.pointcontents(src); 

	if (pos == 1 || pos == 2) 
		return false;

	// Check the surrounding area
	VectorSet (end, obj->s.origin[0] + obj->mins[0] - 16, obj->s.origin[1] + obj->mins[1] - 16, obj->s.origin[2] + obj->mins[2] - 16);

	tr = gi.trace (src, NULL, NULL, end, obj, (MASK_SOLID | MASK_WATER | MASK_MONSTERSOLID | MASK_PLAYERSOLID));

	if (tr.fraction != 1)
		return false;

	pos = gi.pointcontents(end); 

	if (pos == 1 || pos == 2) 
		return false;

	// extend the size a little
	VectorSet (src, obj->s.origin[0] + obj->mins[0] - 16, obj->s.origin[1] + obj->maxs[1] + 16, obj->s.origin[2] + obj->maxs[2] + 16);

	pos = gi.pointcontents(src); 
	if (pos == 1 || pos == 2) 
		return false;

	VectorSet (end, obj->s.origin[0] + obj->maxs[0] + 16, obj->s.origin[1] + obj->mins[1] - 16, obj->s.origin[2] + obj->mins[2] - 16);

	tr = gi.trace (src, NULL, NULL, end, obj, (MASK_SOLID | MASK_WATER | MASK_MONSTERSOLID | MASK_PLAYERSOLID));

	if (tr.fraction != 1)
		return false;

	pos = gi.pointcontents(end); 
	if (pos == 1 || pos == 2) 
		return false;

	// Trace a line from the player to the object too
	tr = gi.trace (builder->s.origin, NULL, NULL, obj->s.origin, builder, (MASK_SOLID | MASK_WATER | MASK_MONSTERSOLID | MASK_PLAYERSOLID));

	if (tr.fraction != 1)
		return false;

	// may add in more checks later

	return true;
}

/*
=============================
Sentry attack functions
=============================
*/

void Sentry_ChangeWeapon (edict_t *self)
{
/*	if (self->slugs)
	{
		self->speed = W_RAILGUN;
		self->bounces = self->slugs;
		self->s.modelindex2 = gi.modelindex ("models/weapons/s_rail/tris.md2");
	}
	else */if (self->rockets && (self->playerclass == 3))
	{
		self->speed = W_RAILGUN;
		self->bounces = self->rockets;
		self->s.modelindex2 = gi.modelindex ("models/objects/sengun2/tris.md2");
	}
	else if (self->bullets)
	{
		if (self->playerclass == 1)
		{
			self->speed = W_CHAINGUN;
			self->s.modelindex2 = gi.modelindex ("models/objects/sengun/tris.md2");
		}
		else if (self->playerclass == 2)
		{
			self->speed = W_ROCKETL;
			self->s.modelindex2 = gi.modelindex ("models/objects/sengun1/tris.md2");
		}

		self->bounces = self->bullets;
	}
}

/*
====================================
sentry_fire_inflictor

Sentry shoots bullets, slugs or rockets
dependable on its class and ammo.
If it can't see enemy, it doesn't shoot.
Should add more weapons?
=====================================
*/

void sentry_fire_inflictor (edict_t *self, vec3_t v, vec3_t targetdir)
{
	if (!visible(self->enemy, self))
		return;

	if (self->bounces == 0)
	{
		Sentry_ChangeWeapon (self);
		return;
	}

	if (self->speed == W_CHAINGUN)
	{
		sentry_noise (self);
       	monster_fire_bullet (self, v, targetdir, 8, 4, DEFAULT_BULLET_HSPREAD/4, DEFAULT_BULLET_VSPREAD/4, MZ_BOOMERGUN);
		MeanOfDeath = 1;
		self->bullets--;
	}
    else if (self->speed == W_ROCKETL)
	{
		sentry_noise (self);
       	monster_fire_bullet (self, v, targetdir, 11, 4, DEFAULT_BULLET_HSPREAD/4, DEFAULT_BULLET_VSPREAD/4, MZ_BOOMERGUN);
//		monster_fire_rocket (self, v, targetdir, 120, 800, MZ_BOOMERGUN);
		MeanOfDeath = 2;
//		self->rockets--;
		self->bullets--;
	}
	else if (self->speed == W_RAILGUN)
	{
		monster_fire_rocket (self, v, targetdir, 120, 800, MZ_BOOMERGUN);
//		monster_fire_railgun (self, v, targetdir, 220, 10, MZ_BOOMERGUN);
		MeanOfDeath = 3;
		self->rockets--;
	}

    self->bounces--;
}

/*
===================================
sentry_attack2

Used for aiming. Code a-la monster.
===================================
*/

void sentry_attack2 (edict_t *self)
{
    vec3_t dir, start;

	if (!infront (self, self->enemy))
		return;

	VectorSet (start, self->s.origin[0], self->s.origin[1], self->s.origin[2] + 18);
	VectorSubtract (self->enemy->s.origin, start, dir);
	VectorNormalize (dir);

	self->s.angles[YAW] = vectoyaw (dir);

    sentry_fire_inflictor (self, start, dir);
}

/*
=================================
ClearSentryAmmo

Clears sentry's ammo. Only shells
are still remaining.
=================================
*/

void ClearSentryAmmo (edict_t *ent)
{
	ent->bullets = ent->creator->client->pers.inventory[ITEM_INDEX(FindItem("shells"))];
	ent->rockets = 0;
	ent->slugs = 0;
	ent->cells = 0;
}

/*
=================================
sentry_run

Hack. Imagine sentry running. Urghh...
Gimme fresh water.
Actually replaces monster running with
firing.
=================================
*/

void sentry_run (edict_t *sentry)
{
    if (sentry->enemy->deadflag == DEAD_DEAD)
	{
		sentry->monsterinfo.currentmove = &sentry_move_stand1;
		sentry->enemy = NULL;
        FindTarget (sentry);
		return;
	}

	if (sentry->enemy)
		if (sentry->enemy->client)
			if (sentry->enemy->client->resp.s_team == sentry->ripstate)
			{
				sentry->monsterinfo.currentmove = &sentry_move_stand1;
                FindTarget (sentry);
				return;
			}
	
	sentry->monsterinfo.attack(sentry);
}

/*
======================================
sentry_noise

Weapon noise.
======================================
*/

void sentry_noise (edict_t *ent)
{
	if (ent->s.modelindex2 == gi.modelindex ("models/objects/sengun/tris.md2"))
	    gi.sound (ent, CHAN_WEAPON, gi.soundindex("weapons/chngnl1a.wav"), 1, ATTN_NORM, 0);
}

// actually nothing
void sentry_noise_rotate (edict_t *ent)
{
	gi.sound (ent, CHAN_VOICE, gi.soundindex("float/fltsrch1.wav"), 1, ATTN_NORM, 0);
}

void sentry_stand (edict_t *sentry);

mframe_t sentry_stand_frames[]=
{
    ai_stand, 0, sentry_noise_rotate,
	ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, sentry_noise_rotate,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL,
    ai_stand, 0, NULL
};
mmove_t sentry_move_stand1 = {0, 15, sentry_stand_frames, sentry_stand};

void sentry_stand (edict_t *sentry)
{
	if (sentry->enemy != NULL || sentry->goalentity != NULL)
	{
		if (visible (sentry->enemy, sentry))
			sentry->monsterinfo.attack(sentry);
		return;
	}

	sentry->monsterinfo.currentmove = &sentry_move_stand1;
}

void sentry_attack (edict_t *sentry);

mframe_t sentry_attack2_frames[]=
{
    ai_charge, 0, NULL,
    ai_charge, 0, sentry_attack2
};
mmove_t sentry_move_attack2 = {16, 17, sentry_attack2_frames, sentry_run};

void sentry_expl (edict_t *self)
{
	edict_t *players;
	int i;

	for (i = 1; i <= maxclients->value; i++)
	{
		players = &g_edicts[i];

		if (!players->inuse)
			continue;
		if (!players->building)
			continue;

		if (players->building && players->building == self)
		{
			players->building = NULL;
			
			if (players->client->menu)
				PMenu_Close(players);
		}
	}

    G_Explosion (self);
	G_FreeEdict (self);
}

void Check_Owner (edict_t *ent)
{
	if (!ent->creator || !ent->creator->inuse || ent->creator->playerclass != PC_ENGINEER)
		sentry_expl (ent);
}

void sentry_attack (edict_t *self)
{
	if (self->enemy && self->enemy->client)
	{
		if (self->enemy->client->resp.s_team == self->ripstate)
		{
     		self->monsterinfo.currentmove = &sentry_move_stand1;
            FindTarget (self);
			return;
		}
	}

	if (!infront (self, self->enemy))
		return;
	if (self->monsterinfo.attack_finished > level.time)
		return;

   	self->monsterinfo.currentmove = &sentry_move_attack2;

	if (self->speed < W_RAILGUN)
		AttackFinished (self, .1);
	else
		AttackFinished (self, 1);
}

void sentry_pain (edict_t *sentry, edict_t *other, float kick, int damage);

mframe_t sentry_pain_frames[]=
{
    ai_move, 0, NULL,
	ai_move, 0, NULL,
	ai_move, 0, NULL,
	ai_move, 0, NULL
};
mmove_t sentry_move_pain1 = {18, 21, sentry_pain_frames, sentry_run};

void sentry_pain (edict_t *sentry, edict_t *other, float kick, int damage)
{
}

/*
==============
Cmd_Sentry_f

This creats new sentry, sets it activator, and gives it 
a playerclass that is used later at firing.
==============
*/

//  // SIGHT logic  //
void decoy_sight(edict_t *self, edict_t *other)
{
}

void Sentry_AddAmmo (edict_t *ent, int mod, int quantity)
{
	int add;

	if (mod > ent->building->playerclass)
		return;

	if (mod == 0)
	{
		quantity = (150 - ent->building->health) / 5;

		if (quantity > ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))])
			quantity = ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))];

		ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= quantity;

        if (ent->building->burnout)
        {
			if ((rand() % 100) < quantity)
			{
				quantity -= ent->building->burnout;
				ent->building->burnout = 0;
			}
            else
                ent->building->burnout -= quantity;
        }

		ent->building->health += quantity;

		if (quantity > 0)
			gi.cprintf (ent, PRINT_HIGH, "Sentry repaired.\n");
		return;
	}
/*	else if (mod == 3)
	{
		if (quantity > ent->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))])
			quantity = ent->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))];

		if (ent->building->slugs >= 20)
			return;

		if (ent->building->slugs + quantity > 20)
		{
			add = 20 - ent->building->slugs;

			if (quantity == ent->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))])
				if (quantity < add)
					add = quantity;
		}
		else
			add = quantity;

		ent->building->slugs += add;
		if (add)
		gi.cprintf (ent, PRINT_HIGH, "Slugs added.\n");
        ent->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))] -= add;
	} */
	else if (mod == 3)
	{
		if (quantity > ent->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))])
			quantity = ent->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))];

		if (ent->building->rockets >= 50)
			return;

		if (ent->building->rockets + quantity > 50)
		{
			add = 50 - ent->building->rockets;

			if (quantity == ent->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))])
				if (quantity < add)
					add = quantity;
		}
		else
			add = quantity;

		ent->building->rockets += add;
		if (add)
		gi.cprintf (ent, PRINT_HIGH, "Rockets added.\n");
        ent->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))] -= add;
	}
	else if (mod == 1)
	{
		if (quantity > ent->client->pers.inventory[ITEM_INDEX(FindItem("shells"))])
			quantity = ent->client->pers.inventory[ITEM_INDEX(FindItem("shells"))];

		if (ent->building->bullets >= 100)
			return;

		if (ent->building->bullets + quantity > 100)
		{
			add = 100 - ent->building->bullets;

			if (quantity == ent->client->pers.inventory[ITEM_INDEX(FindItem("shells"))])
				if (quantity < add)
					add = quantity;
		}
		else
			add = quantity;

		ent->building->bullets += add;
		if (add > 0)
		gi.cprintf (ent, PRINT_HIGH, "Shells added.\n");
        ent->client->pers.inventory[ITEM_INDEX(FindItem("shells"))] -= add;
	}
	Sentry_ChangeWeapon (ent->building);
}

void AddBullets (edict_t *ent, pmenu_t *menu)
{
    Sentry_AddAmmo (ent, 1, 20);
	PMenu_Close (ent);
}

void AddRockets (edict_t *ent, pmenu_t *menu)
{
    Sentry_AddAmmo (ent, 3, 4);
	PMenu_Close (ent);
}

void AddSlugs (edict_t *ent, pmenu_t *menu)
{
    Sentry_AddAmmo (ent, 3, 4);
	PMenu_Close (ent);
}

void Repair (edict_t *ent, pmenu_t *menu)
{
    Sentry_AddAmmo (ent, 0, 15);
	PMenu_Close (ent);
}

void Upgrade (edict_t *ent, pmenu_t *menu)
{
	if (ent->building->playerclass > 3)
		return;

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] < 70)
	{
		gi.cprintf (ent, PRINT_HIGH, "Not enough energy\n");
    	return;
	}

	gi.cprintf (ent, PRINT_HIGH, "Sentry upgraded.\n");
    ent->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] = 0;
	ent->building->playerclass++;

	ent->building->max_health = 100 * ent->building->playerclass;
	Sentry_ChangeWeapon (ent->building);
	PMenu_Close (ent);
}

void Rotate (edict_t *ent, pmenu_t *menu)
{
	ent->building->ideal_yaw = ent->building->s.angles[YAW] += 45;
	gi.cprintf (ent, PRINT_HIGH, "Rotated 45 degrees to the left.\n");
	PMenu_Close (ent);
}

void explode (edict_t *ent, pmenu_t *menu)
{
    sentry_expl (ent->building);
	PMenu_Close (ent);
}

pmenu_t sentry[] = 
{
	"*Sentry",			PMENU_ALIGN_CENTER, -1, NULL, NULL,
	NULL,				PMENU_ALIGN_CENTER, -1, NULL, NULL, 
	"1. Add Bullets",	PMENU_ALIGN_LEFT, 1, NULL, AddBullets,
	"2. Add Rockets",	PMENU_ALIGN_LEFT, 2, NULL, AddRockets,
//	NULL,				PMENU_ALIGN_CENTER, -1, NULL, NULL,
	"3. Repair",		PMENU_ALIGN_LEFT, 3, NULL, Repair,
	"4. Upgrade",		PMENU_ALIGN_LEFT, 4, NULL, Upgrade,
	"5. Rotate",		PMENU_ALIGN_LEFT, 5, NULL, Rotate,
	"6. Dismantle",		PMENU_ALIGN_LEFT, 6, NULL, explode,
};

void dists_check (edict_t *ent)
{
	if (!G_ClientExists(ent->owner) ||!ent->owner->client->menu)
	{
		G_FreeEdict(ent);
		return;
	}

	if (entdist(ent->owner, ent) > 300)
	{
		PMenu_Close(ent->owner);
		G_FreeEdict(ent);
		return;
	}

	ent->nextthink = level.time + 3;
}

void Cmd_SentryM_f (edict_t *ent)
{
	// Check to see if the menu is already open

   if (ent->client->showscores || ent->client->showinventory || 
        ent->client->menu)
        return;

	if (!G_ClientNotDead(ent))
		return;

   // Setup the User Selection Handler

	if (ent->building->bullets >= 100)
	{
		sentry[2].text = NULL;
		sentry[2].align = PMENU_ALIGN_CENTER;
		sentry[2].SelectFunc = NULL;
	}
	else
	{
		sentry[2].text = "Add shells";
		sentry[2].align = PMENU_ALIGN_LEFT;
		sentry[2].SelectFunc = AddBullets;
	}

	if (ent->building->rockets >= 50)
	{
		sentry[3].text = NULL;
		sentry[3].align = PMENU_ALIGN_CENTER;
		sentry[3].SelectFunc = NULL;
	}
	else
	{
		sentry[3].text = "Add rockets";
		sentry[3].align = PMENU_ALIGN_LEFT;
		sentry[3].SelectFunc = AddRockets;
	}
/*
	if (ent->building->slugs >= 20)
	{
		sentry[4].text = NULL;
		sentry[4].align = PMENU_ALIGN_CENTER;
		sentry[4].SelectFunc = NULL;
	}
	else
	{
		sentry[4].text = "Add slugs";
		sentry[4].align = PMENU_ALIGN_LEFT;
		sentry[4].SelectFunc = AddSlugs;
	}
*/
	if (ent->building->health >= 150)
	{
		sentry[4].text = NULL;
		sentry[4].align = PMENU_ALIGN_CENTER;
		sentry[4].SelectFunc = NULL;
	}
	else
	{
		sentry[4].text = "Repair";
		sentry[4].align = PMENU_ALIGN_LEFT;
		sentry[4].SelectFunc = Repair;
	}

	if (ent->building->playerclass >= 3)
	{
		sentry[5].text = NULL;
		sentry[5].align = PMENU_ALIGN_CENTER;
		sentry[5].SelectFunc = NULL;
	}
	else
	{
		sentry[5].text = "Upgrade";
		sentry[5].align = PMENU_ALIGN_LEFT;
		sentry[5].SelectFunc = Upgrade;
	}

    PMenu_Open(ent, sentry, -1, sizeof(sentry)/sizeof(pmenu_t));
}

void val (edict_t *ent, edict_t *other)
{
	edict_t *checker;

	if (!G_ClientExists(other))
		return;

	if (other->client->resp.s_team != ent->ripstate)
		return;

	if (other->playerclass != PC_ENGINEER)
		return;

	other->building = ent;
	Cmd_SentryM_f (other);

	checker = G_Spawn();
	checker->classname = "s_checker";
	checker->owner = other;
	checker->activator = ent;
	checker->think = dists_check;
	checker->nextthink = level.time + 3;
	VectorCopy (ent->s.origin, checker->s.origin);
	gi.linkentity (checker);
}

void Sentry_Menu (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	val (self, other);
}

void Sentry_Think (edict_t *self)
{
    ClearSentryAmmo (self);

    self->movetype = MOVETYPE_NONE;
    self->solid = SOLID_BBOX;
	self->takedamage = DAMAGE_AIM;
    self->s.effects = 0;
    self->s.frame = 0;
	self->touch = Sentry_Menu;
    self->model = "models/objects/senbase/tris.md2";
    self->classname = "sentry";
    self->max_health = 150;
	self->playerclass = 1;
    self->ripstate = self->creator->client->resp.s_team;
    self->mass = 200;
    self->pain = sentry_pain;
    self->die = sentry_die;
    self->fireflags = 18 | FIREFLAG_DOWN | FIREFLAG_DELTA_VIEW | FIREFLAG_IGNITE;
	self->style = 1;
	self->bullets = self->creator->client->pers.inventory[ITEM_INDEX(FindItem("shells"))];
	self->prethink = Check_Owner;
    self->s.modelindex2 = gi.modelindex ("models/objects/sengun1/tris.md2");

    self->monsterinfo.stand = sentry_stand;
    self->monsterinfo.walk = NULL;
    self->monsterinfo.run = sentry_run;
    self->monsterinfo.dodge = NULL;
    self->monsterinfo.attack = sentry_attack;
    self->monsterinfo.melee = NULL;
    self->monsterinfo.sight = decoy_sight;

    self->monsterinfo.aiflags |= AI_NOSTEP;

    self->health = 150;
    self->gib_health = -30;

    gi.linkentity (self);

	M_droptofloor (self);

    // First animation sequence
    self->monsterinfo.stand (self);

    //Let monster code control this decoy
    walkmonster_start (self);

    self->creator->client->pers.inventory[ITEM_INDEX(FindItem("shells"))] = 0;
	self->creator->ripstate &= ~STATE_BUILDING;
	if (!self->creator->client->chasetoggle)
   		self->creator->client->ps.gunindex = gi.modelindex(self->creator->client->pers.weapon->view_model);
	self->creator->movetype = MOVETYPE_WALK;
	gi.linkentity (self->creator);
	Sentry_ChangeWeapon (self);
}

void Sentry_health (edict_t *ent)
{
	if (ent->health == 150)
	{
		ent->nextthink = level.time + .1;
		ent->think = Sentry_Think;
		tprintf(ent->creator, ent->creator, MOD_NORMAL, PRINT_HIGH, "%s finished building a sentry gun\n", ent->creator->client->pers.netname);
		return;
	}

	if (rand() & 1)
	{
		if (rand() & 1)
		{
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_BLASTER);
			gi.WritePosition (ent->s.origin);
			gi.WriteDir (vec3_origin);
			gi.multicast (ent->s.origin, MULTICAST_PVS);
		}
	}

	ent->health += 3; // 5 seconds to build
	ent->nextthink = level.time + .1;
}

void Cmd_SBuild_f (edict_t *owner)
{
    edict_t *self;
    vec3_t forward;

	if (G_EntExists(owner->sentry))
	{
		gi.cprintf (owner, PRINT_HIGH, "You already have a sentrygun\n");
		return;
	}

	if (owner->playerclass != PC_ENGINEER)
	{
		gi.cprintf (owner, PRINT_HIGH, "Only engineers can build a sentry gun\n");
		return;
	}

	if (owner->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 130)
	{
		gi.cprintf (owner, PRINT_HIGH, "Not enough metal\n");
		return;
	}

    self = G_Spawn();

    // Place sentry 64 units forward of our position
    AngleVectors(owner->client->v_angle, forward, NULL, NULL);
    VectorMA(owner->s.origin, 64, forward, self->s.origin);

	VectorSet (self->mins, -16, -16, 0);
	VectorSet (self->maxs, 16, 16, 25);

	if (!CheckArea (self, owner))
	{
		gi.cprintf (owner, PRINT_HIGH, "Not enough space to build a sentry gun\n");
		G_FreeEdict (self);
		return;
	}

    // Link two entities together
    owner->sentry = self;	// for the owner, this is a pointer to the decoy
    self->creator = owner;	// for the decoy, this is a pointer to the owner
	owner->ripstate |= STATE_BUILDING;
	self->s.modelindex = gi.modelindex ("models/objects/senbase/tris.md2");
	self->nextthink = level.time + .1;
	self->takedamage = DAMAGE_AIM;
	self->die = sentry_die;
	self->think = Sentry_health;
	self->classname = "b_s";
	M_droptofloor (self);
	gi.linkentity (self);
	owner->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] -= 130;
}

void sentry_dead (edict_t *self)
{
	VectorSet (self->mins, -16, -16, -24);
	VectorSet (self->maxs, 16, 16, -8);
	self->movetype = MOVETYPE_TOSS;
	self->svflags |= SVF_DEADMONSTER;
	self->nextthink = 0;
	gi.linkentity (self);
}

mframe_t sentry_death_frames[]=
{
    ai_move, 0, NULL,
	ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL,
    ai_move, 0, NULL
};
mmove_t sentry_death_move = {32, 43, sentry_death_frames, sentry_dead};

void sentry_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	if (attacker->client && attacker != world && attacker != self->creator)
		gi.cprintf (self->creator, PRINT_HIGH, "Your sentry gun was destroyed by %s\n", attacker->client->pers.netname);
	else
		gi.cprintf (self->creator, PRINT_HIGH, "Your sentry gun was destroyed\n");

    if (self->creator->ripstate & STATE_BUILDING)
	{
    	self->creator->ripstate &= ~STATE_BUILDING;
		if (!self->creator->client->chasetoggle)
		 	self->creator->client->ps.gunindex = gi.modelindex(self->creator->client->pers.weapon->view_model);
    	self->creator->movetype = MOVETYPE_WALK; 
    	gi.linkentity (self->creator);
	}

	ThrowDebris(self, DEBRIS1_MODEL, 2.50, self->s.origin);
	ThrowDebris(self, DEBRIS1_MODEL, 3.50, self->s.origin);
	ThrowDebris(self, DEBRIS1_MODEL, 3.00, self->s.origin);
	ThrowDebris(self, DEBRIS2_MODEL, 1.50, self->s.origin);
	ThrowDebris(self, DEBRIS2_MODEL, 1.30, self->s.origin);

	sentry_expl (self);
}

//
// DISPENCER BEGIN
//

void PutAmmo (edict_t *self, pmenu_t *menu)
{
	int am;

	// shells
	am = 40;
	if (am > self->client->pers.max_shells)
		am = self->client->pers.max_shells; 
	if (am > (400 - self->building->bounces))
		am = 400 - self->building->bounces;
	self->client->pers.inventory[ITEM_INDEX(FindItem("Shells"))] -= am;
	self->building->bounces += am;

	// bullets
	am = 40;
	if (am > self->client->pers.max_bullets)
		am = self->client->pers.max_bullets; 
	if (am > (600 - self->building->bullets))
		am = 600 - self->building->bullets;
	self->client->pers.inventory[ITEM_INDEX(FindItem("Bullets"))] -= am;
	self->building->bullets += am;

	// rockets
	am = 20;
	if (am > self->client->pers.max_rockets)
		am = self->client->pers.max_rockets; 
	if (am > (300 - self->building->rockets))
		am = 300 - self->building->rockets;
	self->client->pers.inventory[ITEM_INDEX(FindItem("Rockets"))] -= am;
	self->building->rockets += am;

	// slugs
	am = 20;
	if (am > self->client->pers.max_slugs)
		am = self->client->pers.max_slugs; 
	if (am > (300 - self->building->slugs))
		am = 300 - self->building->slugs;
	self->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))] -= am;
	self->building->slugs += am;

	// cells
	am = 20;
	if (am > self->client->pers.max_cells)
		am = self->client->pers.max_cells; 
	if (am > (400 - self->building->cells))
		am = 400 - self->building->cells;
	self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= am;
	self->building->cells += am;

	// grenades
	am = 10;
	if (am > self->client->pers.max_grenades)
		am = self->client->pers.max_grenades; 
	if (am > (100 - self->building->leg_damage))
		am = 100 - self->building->leg_damage;
	self->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] -= am;
	self->building->leg_damage += am;
	PMenu_Close(self);
}

void PutArmor (edict_t *self, pmenu_t *menu)
{
	int am;

	if (!self->client->pers.inventory[ArmorIndex(self)])
		return;

	// cells
	am = 20;
	if (am > self->client->resp.arm)
		am = self->client->resp.arm; 
	if (am > (500 - self->building->count))
		am = 500 - self->building->count;
	self->client->pers.inventory[ArmorIndex(self)] -= am;
	self->building->count += am;
	PMenu_Close(self);
}

void RepairD (edict_t *ent, pmenu_t *menu)
{
	int metalcost;

	metalcost = (150 - ent->building->health) / 5;

	if (metalcost > ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))])
		metalcost = ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))];

	ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= metalcost;

    if (ent->building->burnout)
    {
		if ((rand() % 100) < metalcost)
		{
			metalcost -= ent->building->burnout;
			ent->building->burnout = 0;
		}
        else
			ent->building->burnout -= metalcost;
	}

	ent->building->health += metalcost;
	PMenu_Close(ent);
}

pmenu_t disp2[] = 
{
	"*Dispencer", PMENU_ALIGN_CENTER, -1, NULL, NULL,
	NULL, PMENU_ALIGN_CENTER, -1, NULL, NULL,
	"1. Put some ammo", PMENU_ALIGN_LEFT, 1, NULL, PutAmmo,
	"2. Put some armor", PMENU_ALIGN_LEFT, 2, NULL, PutArmor,
	"3. Repair", PMENU_ALIGN_LEFT, 3, NULL, RepairD,
	"4. Dismantle", PMENU_ALIGN_LEFT, 4, NULL, explode,
};

void WithdrawAmmo (edict_t *self, pmenu_t *menu)
{
	int am;

	// shells
	am = 400 - self->building->bounces;
	if (am > self->building->bounces)
		am = self->building->bounces;
	self->client->pers.inventory[ITEM_INDEX(FindItem("Shells"))] += am;
	self->building->bounces -= am;

	// bullets
	am = 500 - self->building->bullets;
	if (am > self->building->bullets)
		am = self->building->bullets;
	self->client->pers.inventory[ITEM_INDEX(FindItem("Bullets"))] += am;
	self->building->bullets -= am;

	// rockets
	am = 300 - self->building->bounces;
	if (am > self->building->bounces)
		am = self->building->bounces;
	self->client->pers.inventory[ITEM_INDEX(FindItem("Rockets"))] += am;
	self->building->rockets -= am;

	// slugs
	am = 300 - self->building->slugs;
	if (am > self->building->slugs)
		am = self->building->slugs;
	self->client->pers.inventory[ITEM_INDEX(FindItem("Slugs"))] += am;
	self->building->slugs -= am;

	// cells
	am = 400 - self->building->cells;
	if (am > self->building->cells)
		am = self->building->cells;
	self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] += am;
	self->building->cells -= am;

	// grenades
	am = 100 - self->building->leg_damage;
	if (am > self->building->leg_damage)
		am = self->building->leg_damage;
	self->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))] += am;
	self->building->leg_damage -= am;

	if (self->client->resp.s_team != self->building->ripstate)
		gi.cprintf (self->building->creator, PRINT_HIGH, "Enemy uses your dispencer!\n");

	PMenu_Close(self);
}

void WithdrawArmor (edict_t *self, pmenu_t *menu)
{
	int am;

	if (!self->building->count)
		return;

	// cells
	am = 500 - self->count;
	if (am > self->building->count)
		am = self->building->count;

	if (!ArmorIndex(self))
		self->client->pers.inventory[ITEM_INDEX(FindItem("Jacket Armor"))] += am;
	self->building->count -= am;

	if (self->client->resp.s_team != self->building->ripstate)
		gi.cprintf (self->building->creator, PRINT_HIGH, "Enemy uses your dispencer!\n");

	PMenu_Close(self);
}

pmenu_t disp1[] = 
{
	{ "*Dispencer", PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{ NULL, PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{ "1. Withdraw some ammo", PMENU_ALIGN_LEFT, 1, NULL, WithdrawAmmo },
	{ "2. Withdraw some armor", PMENU_ALIGN_LEFT, 2, NULL, WithdrawArmor}
};

void Cmd_DispM_f (edict_t *ent)
{
	// Check to see if the menu is already open

   if (ent->client->showscores || ent->client->showinventory || 
        ent->client->menu)
        return;

	if (!G_ClientNotDead(ent))
		return;

	PMenu_Open (ent, disp1, -1, sizeof(disp1)/sizeof(pmenu_t));
}

void val1 (edict_t *self, edict_t *other)
{
	edict_t *checker;

	if (!G_ClientNotDead(other))
		return;

	if (!G_ClientExists(other))
		return;

	Cmd_DispM_f (other);
	other->building = self;

	checker = G_Spawn();
	checker->classname = "s_checker";
	checker->owner = other;
	checker->think = dists_check;
	checker->nextthink = level.time + 3;
	VectorCopy (self->s.origin, checker->s.origin);
	gi.linkentity (checker);
}

void Cmd_DispM1_f (edict_t *ent)
{
	// Check to see if the menu is already open

   if (ent->client->showscores || ent->client->showinventory || 
        ent->client->menu)
        return;

	if (!G_ClientNotDead(ent))
		return;

	PMenu_Open (ent, disp2, -1, sizeof(disp2)/sizeof(pmenu_t));
}

void val3 (edict_t *self, edict_t *other)
{
	edict_t *checker;

	if (!G_ClientNotDead(other))
		return;

	if (!G_ClientExists(other))
		return;

	if (other->client->resp.s_team != self->ripstate)
		return;

	Cmd_DispM1_f (other);
	other->building = self;

	checker = G_Spawn();
	checker->classname = "s_checker";
	checker->owner = other;
	checker->think = dists_check;
	checker->nextthink = level.time + 3;
	VectorCopy (self->s.origin, checker->s.origin);
	gi.linkentity (checker);
}

void Disp_Menu (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (!G_ClientExists(other))
		return;

	val1 (self, other);
}

void Disp_Think (edict_t *self)
{
	// dispenser refilling itself 5%
	self->bounces += 20;
	self->cells += 20;
	self->bullets += 30;
	self->rockets += 15;
	self->leg_damage += 5;
	self->slugs += 15;
	self->count += 25;

	if (self->bounces > 400)
		self->bounces = 400;	
	if (self->cells > 400)
		self->cells = 400;	
	if (self->bullets > 600)
		self->bullets = 600;	
	if (self->rockets > 300)
		self->rockets = 300;	
	if (self->leg_damage > 100)
		self->leg_damage = 100;	
	if (self->slugs > 300)
		self->slugs = 300;	
	if (self->count > 500)
		self->count = 500;	
	
	self->nextthink = level.time + 10;
}

void disp_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	if (attacker->client && attacker != world && attacker != self->creator)
		gi.cprintf (self->creator, PRINT_HIGH, "Your dispencer was destroyed by %s\n", attacker->client->pers.netname);
	else
		gi.cprintf (self->creator, PRINT_HIGH, "Your dispencer was destroyed\n");

    if (self->creator->ripstate & STATE_BUILDING)
	{
    	self->creator->ripstate &= ~STATE_BUILDING;
		if (!self->creator->client->chasetoggle)
		  	self->creator->client->ps.gunindex = gi.modelindex(self->creator->client->pers.weapon->view_model);
    	self->creator->movetype = MOVETYPE_WALK; 
    	gi.linkentity (self->creator);
	}

	ThrowDebris(self, DEBRIS1_MODEL, 2.50, self->s.origin);
	ThrowDebris(self, DEBRIS1_MODEL, 3.50, self->s.origin);
	ThrowDebris(self, DEBRIS1_MODEL, 3.00, self->s.origin);
	ThrowDebris(self, DEBRIS2_MODEL, 1.50, self->s.origin);
	ThrowDebris(self, DEBRIS2_MODEL, 1.30, self->s.origin);

	sentry_expl (self);
}

void disp_pain (edict_t *sentry, edict_t *other, float kick, int damage)
{
}

void Dispencer_Think (edict_t *self)
{
    self->movetype = MOVETYPE_NONE;
    self->solid = SOLID_BBOX;
	self->takedamage = DAMAGE_AIM;
    self->s.effects = 0;
    self->s.frame = 0;
	self->touch = Disp_Menu;
    self->model = "models/weapons/s_base/tris.md2";
    self->classname = "dispencer";
    self->max_health = 150;
    self->ripstate = self->creator->client->resp.s_team;
    self->mass = 200;
    self->pain = disp_pain;
    self->die = disp_die;
    self->fireflags = 18 | FIREFLAG_DOWN | FIREFLAG_DELTA_VIEW | FIREFLAG_IGNITE;
	self->style = 1;
    self->health = 150;
    self->gib_health = -30;
	self->think = Disp_Think;
	self->nextthink = level.time + 10;
	self->prethink = Check_Owner;

	// Put some ammo in the Dispenser
	self->bounces = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("shells"))] * 0.25);
	self->bullets = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))] * 0.25);
	self->rockets = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))] * 0.25);
	self->cells = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] * 0.25);

	if (ArmorIndex (self->creator))
		self->count = ceil(self->creator->client->pers.inventory[ArmorIndex(self->creator)] * 0.25);
	else
		self->count = 0;

    self->leg_damage = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("grenades"))] * 0.25);
    self->slugs = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))] * 0.25);

	// Remove ours
	self->creator->client->pers.inventory[ITEM_INDEX(FindItem("shells"))] = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("shells"))] * 0.75);
	self->creator->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))] = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))] * 0.75);
	self->creator->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))] = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("rockets"))] * 0.75);
	self->creator->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] * 0.75);
	self->creator->client->pers.inventory[ITEM_INDEX(FindItem("grenades"))] = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("grenades"))] * 0.75);
	self->creator->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))] = ceil(self->creator->client->pers.inventory[ITEM_INDEX(FindItem("slugs"))] * 0.75);
    
	if (ArmorIndex(self->creator))
		self->creator->client->pers.inventory[ArmorIndex(self->creator)] = ceil(self->creator->client->pers.inventory[ArmorIndex(self->creator)] * 0.75);

    gi.linkentity (self);

	M_droptofloor (self);

	self->creator->ripstate &= ~STATE_BUILDING;
	if (!self->creator->client->chasetoggle)
		self->creator->client->ps.gunindex = gi.modelindex(self->creator->client->pers.weapon->view_model);
	self->creator->movetype = MOVETYPE_WALK;
	gi.linkentity (self->creator);
}

void Disp_health (edict_t *ent)
{
	if (ent->health >= 150)
	{
		ent->health = 150;
		ent->nextthink = level.time + .1;
		ent->think = Dispencer_Think;
		tprintf(ent->creator, ent->creator, MOD_NORMAL, PRINT_HIGH, "%s finished building a dispencer\n", ent->creator->client->pers.netname);
		return;
	}

	if (rand() & 1)
	{
		if (rand() & 1)
		{
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_BLASTER);
			gi.WritePosition (ent->s.origin);
			gi.WriteDir (vec3_origin);
			gi.multicast (ent->s.origin, MULTICAST_PVS);
		}
	}

	ent->health += 7.5; // 2 seconds to build
	ent->nextthink = level.time + .1;
}

void Cmd_DBuild_f (edict_t *owner)
{
    edict_t *self;
    vec3_t forward;

	if (G_EntExists(owner->disp))
	{
		gi.cprintf (owner, PRINT_HIGH, "You already have a dispencer.\nPlease report about this bug.\n");
		return;
	}

	if (owner->playerclass != PC_ENGINEER)
	{
		gi.cprintf (owner, PRINT_HIGH, "Only engineers can build a dispencer\n");
		return;
	}

	if (owner->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 100)
	{
		gi.cprintf (owner, PRINT_HIGH, "Not enough metal\n");
		return;
	}

    self = G_Spawn();

    // Place sentry 64 units forward of our position
    AngleVectors(owner->client->v_angle, forward, NULL, NULL);
    VectorMA(owner->s.origin, 64, forward, self->s.origin);

	VectorSet (self->mins, -16, -16, 0);
	VectorSet (self->maxs, 16, 16, 25);

	if (!CheckArea (self, owner))
	{
		gi.cprintf (owner, PRINT_HIGH, "Not enough space to build a dispencer\n");
		G_FreeEdict (self);
		return;
	}

    //Link two entities together
    owner->disp = self;	//for the owner, this is a pointer to the decoy
	owner->ripstate |= STATE_BUILDING;
    self->creator = owner;	//for the decoy, this is a pointer to the owner
	self->s.modelindex = gi.modelindex ("models/objects/disp/disp.md2");
	self->nextthink = level.time + .1;
	self->takedamage = DAMAGE_AIM;
    self->die = disp_die;
	self->think = Disp_health;
	self->classname = "b_d";
	M_droptofloor (self);
	gi.linkentity (self);
	owner->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] -= 100;
}

void Build_Sentry (edict_t *ent, pmenu_t *menu) 
{
	G_EntExists (ent->sentry) ? sentry_expl (ent->sentry) : Cmd_SBuild_f (ent);
	PMenu_Close(ent);
}

void Build_Disp (edict_t *ent, pmenu_t *menu)
{
	G_EntExists (ent->disp) ? sentry_expl (ent->disp) : Cmd_DBuild_f (ent);
	PMenu_Close(ent);
}

pmenu_t build[] = 
{
	{	"*Action", PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	NULL,     PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	"1. Build Sentry Gun", PMENU_ALIGN_LEFT, 1, NULL, Build_Sentry },
	{	"2. Build Dispencer", PMENU_ALIGN_LEFT, 2, NULL, Build_Disp }
};

void Cmd_Build_f (edict_t *ent)
{
    if (ent->client->showscores || ent->client->showinventory || 
        ent->client->menu)
        return;

	if (!G_ClientNotDead(ent))
		return;

	if (ent->playerclass != PC_ENGINEER)
		return;

	if (ent->waterlevel)
	{
		gi.cprintf (ent, PRINT_HIGH, "You can't build in water.\n");
		return;
	}

	if (!onground(ent))
	{
		gi.cprintf (ent, PRINT_HIGH, "You can't build in air.\n");
		return;
	}

	(!G_EntExists (ent->sentry)) ? (build[2].text = "Build Sentry Gun") : (build[2].text = "Detonate Sentry Gun");
	(!G_EntExists (ent->disp)) ? (build[3].text = "Build Dispencer") : (build[3].text = "Detonate Dispencer");

    PMenu_Open(ent, build, -1, sizeof(build)/sizeof(pmenu_t));
}

void Drop_Shells (edict_t *self, pmenu_t *menu)
{
	if (self->client->ammo_index == ITEM_INDEX(FindItem("Shells")))
	{
		gi.cprintf (self, PRINT_HIGH, "You can't drop your current ammo.\n");
		return;
	}

	// shells
	if (self->client->pers.inventory[ITEM_INDEX(FindItem("Shells"))] < 10)
	{
		// ENGINEER can make ammo
		if (self->playerclass == PC_ENGINEER)
		{
			if ((self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] / 3) > (10 - self->client->pers.inventory[ITEM_INDEX(FindItem("Shells"))]))
			{
				gi.cprintf (self, PRINT_HIGH, "You make some shells.\n");
				self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= ((10 - self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))]) * 3);
				self->client->pers.inventory[ITEM_INDEX(FindItem("Shells"))] = 10;
			}
		}

		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Shells"))] < 10)
			return;
	}

	stuffcmd (self, "drop shells\n");

	PMenu_Close(self);
}

void Drop_Bullets (edict_t *self, pmenu_t *menu)
{
	if (self->client->ammo_index == ITEM_INDEX(FindItem("Bullets")))
	{
		gi.cprintf (self, PRINT_HIGH, "You can't drop your current ammo.\n");
		return;
	}

	// bullets
	if (self->client->pers.inventory[ITEM_INDEX(FindItem("Bullets"))] < 50)
	{
		// ENGINEER can make ammo
		if (self->playerclass == PC_ENGINEER)
		{
			if ((self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] / 4) > (50 - self->client->pers.inventory[ITEM_INDEX(FindItem("Bullets"))]))
			{
				gi.cprintf (self, PRINT_HIGH, "You make some bullets.\n");
				self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= ((50 - self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))]) * 4);
				self->client->pers.inventory[ITEM_INDEX(FindItem("Bullets"))] = 50;
			}

			if (self->client->pers.inventory[ITEM_INDEX(FindItem("Bullets"))] < 50)
				return;
		}
	}

	stuffcmd (self, "drop bullets\n");

	PMenu_Close(self);
}

void Drop_Rockets (edict_t *self, pmenu_t *menu)
{
	if (self->client->ammo_index == ITEM_INDEX(FindItem("Rockets")))
	{
		gi.cprintf (self, PRINT_HIGH, "You can't drop your current ammo.\n");
		return;
	}

	// rockets
	if (self->client->pers.inventory[ITEM_INDEX(FindItem("Rockets"))] < 5)
	{
		// ENGINEER can make ammo
		if (self->playerclass == PC_ENGINEER)
		{
			if ((self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] / 5) > (5 - self->client->pers.inventory[ITEM_INDEX(FindItem("Rockets"))]))
			{
				gi.cprintf (self, PRINT_HIGH, "You make some rockets.\n");
				self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= ((50 - self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))]) * 5);
				self->client->pers.inventory[ITEM_INDEX(FindItem("Rockets"))] = 5;
			}
		}

		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Rockets"))] < 5)
			return;
	}

	stuffcmd (self, "drop rockets\n");
	PMenu_Close(self);
}

void Drop_Cells (edict_t *self, pmenu_t *menu)
{
	if (self->client->ammo_index == ITEM_INDEX(FindItem("Cells")))
	{
		gi.cprintf (self, PRINT_HIGH, "You can't drop your current ammo.\n");
		return;
	}

	// cells
	if (self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 50)
	{
		// ENGINEER can make ammo
		if (self->playerclass == PC_ENGINEER)
		{
			if ((self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] / 5) > (5 - self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))]))
			{
				gi.cprintf (self, PRINT_HIGH, "You make some cells.\n");
				self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= ((50 - self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))]) * 5);
				self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] = 50;
			}

			if (self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < 50)
				return;
		}
	}

	stuffcmd (self, "drop cells\n");
	PMenu_Close(self);
}

void Drop_Slugs (edict_t *self, pmenu_t *menu)
{
	if (self->client->ammo_index == ITEM_INDEX(FindItem("Slugs")))
	{
		gi.cprintf (self, PRINT_HIGH, "You can't drop your current ammo.\n");
		return;
	}

	// slugs
	if (self->client->pers.inventory[ITEM_INDEX(FindItem("Slugs"))] < 10)
	{
		// ENGINEER can make ammo
		if (self->playerclass == PC_ENGINEER)
		{
			if ((self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] / 3) > (10 - self->client->pers.inventory[ITEM_INDEX(FindItem("Slugs"))]))
			{
				gi.cprintf (self, PRINT_HIGH, "You make some slugs.\n");
				self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= ((10 - self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))]) * 3);
				self->client->pers.inventory[ITEM_INDEX(FindItem("Slugs"))] = 10;
			} 
		}

		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Slugs"))] < 10)
			return;
	}

	stuffcmd (self, "drop slugs\n");
	PMenu_Close(self);
}

pmenu_t discard[] = 
{
	{	"*Discard", PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	NULL,     PMENU_ALIGN_CENTER, -1, NULL, NULL },
	{	"1. Drop Shells", PMENU_ALIGN_LEFT, 1, NULL, Drop_Shells },
	{	"2. Drop Bullets", PMENU_ALIGN_LEFT, 2, NULL, Drop_Bullets },
	{	"3. Drop Rockets", PMENU_ALIGN_LEFT, 3, NULL, Drop_Rockets },
	{	"4. Drop Cells", PMENU_ALIGN_LEFT, 4, NULL, Drop_Cells },
	{	"5. Drop Slugs", PMENU_ALIGN_LEFT, 5, NULL, Drop_Slugs }
};

void Cmd_Discard_f (edict_t *ent)
{
    if (ent->client->showscores || ent->client->showinventory || 
        ent->client->menu)
        return;

	if (!G_ClientNotDead(ent))
		return;

    PMenu_Open(ent, discard, -1, sizeof(discard)/sizeof(pmenu_t));
}