// scout.c

#include "g_local.h"

//=========================================================================
// Handles the scanner function for Scouts
void TeamFortress_Scan (edict_t *self, int scanrange) 
{
	edict_t *list = NULL;
	int scen, scfr;

	if (self->playerclass != PC_SCOUT)
		return;

	if (scanrange < 5)
	{
		gi.cprintf(self, PRINT_HIGH, "You can't set the radius for less than 5 units.\n");
		return;
	}

	scanrange %= 255;

	scanrange *= 25;
	gi.cprintf (self, PRINT_HIGH, "Scanning...\n");

	// Base Defence scanning code here
	// Reset the entity counts
	scen = scfr = 0;

	// Walk the list
	// For now, just count the entities.
	// In the future, we'll display bearings :)
	// additions: the future is now!
	while ((list = findradius(list, self->s.origin, scanrange)) != NULL)
	{
		if (!list->takedamage)
			continue;
		if (!list->client)
			continue;
		if (!list->inuse)
			continue;
		if (list == self)
			continue;
		if (teamplay->value)
		{
			if ((list->client->resp.s_team == self->client->resp.s_team))
				scfr++;
			else
				scen++;
		}
		else
			scen++;
	}

	// Display the counts
	// For Base Defences, it will display the counts to all team members
	if ((!scen) && (!scfr))
		gi.cprintf (self, PRINT_HIGH, "No blips.\n");
	else
	{
		if (scen)
			gi.cprintf (self, PRINT_HIGH, "%i enemies.\n", scen);
		if (scfr)
			gi.cprintf (self, PRINT_HIGH, "%i friends.\n", scfr);
	}
}