// ipxsetup.c

#define DOOM2

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <process.h>
#include <stdarg.h>
#include <bios.h>

#include "ipxnet.h"
#include "ipxstr.h"
//#include "ipx_frch.h"	// FRENCH VERSION

int playerno=-1;
int gameid;
int numnetnodes;
int socketid = 0x869c;        // 0x869c is the official DOOM socket
int	myargc;
char **myargv;
char *doomenv = NULL;

setupdata_t    nodesetup[MAXNETNODES];

extern char names1[MAXPLAYERS][16]; //-jc-
extern char names2[MAXPLAYERS][16]; //-jc-
extern char pnames[MAXPLAYERS][16]; //-jc-

int ctf=0;                          //-jc-

/*
=================
=
= Error
=
= For abnormal program terminations
=
=================
*/

void Error (char *error, ...)
{
	 va_list argptr;

	 if (vectorishooked)
		  setvect (doomcom.intnum,olddoomvect);

	 va_start (argptr,error);
	 vprintf (error,argptr);
	 va_end (argptr);
	 printf ("\n");
	 ShutdownNetwork ();
	 exit (1);
}


/*
=================
=
= CheckParm
=
= Checks for the given parameter in the program's command line arguments
=
= Returns the argument number (1 to argc-1) or 0 if not present
=
=================
*/

int CheckParm(char *parm)
	 {
	 int i;

	 for(i = 1; i < myargc; i++)
		  if(stricmp(parm, myargv[i]) == 0)
			   return i;

	 return 0;
	 }


/*
=============
=
= NetISR
=
=============
*/

void interrupt NetISR (void)
{
	 if (doomcom.command == CMD_SEND)
	 {
		  localtime++;
		  SendPacket (doomcom.remotenode);
	 }
	 else if (doomcom.command == CMD_GET)
	 {
		  GetPacket ();
	 }
}



/*
===================
=
= LookForNodes
=
= Finds all the nodes for the game and works out player numbers among
them
=
= Exits with nodesetup[0..numnodes] and nodeadr[0..numnodes] filled in
===================
*/

void LookForNodes (void)
{
	 FILE *namesfile;

	 int            i,j,k;
	 int            netids[MAXNETNODES];
	 int            netplayer[MAXNETNODES];
	 struct time    time;
	 int            oldsec;
	 setupdata_t    *setup, *dest;
	 char           str[80];
	 int            total, console, othercon;

	 int 			spos      = 0;   // Spinner Pos & 3
	 char 			*spinner = "|/-\\";

//
// wait until we get [numnetnodes] packets, then start playing
// the playernumbers are assigned by netid
//
	 printf(STR_ATTEMPT, numnetnodes);

	 printf (STR_LOOKING);

	 oldsec = -1;
	 setup = (setupdata_t *)&doomcom.data;
	 localtime = -1;          // in setup time, not game time

//
// build local setup info
//
	 if (ctf) {
		 if (CheckParm("-name"))
			strcpy(nodesetup[0].name,myargv[CheckParm("-name")+1]);
		 else
			strcpy(nodesetup[0].name,"NONAME");

		 nodesetup[0].playernum=playerno-1;
	 }


	 nodesetup[0].nodesfound = 1;
	 nodesetup[0].nodeswanted = numnetnodes;
	 doomcom.numnodes = 1;

	 do
	 {
//
// check for aborting
//
		  while ( bioskey(1) )
		  {
			   if ( (bioskey (0) & 0xff) == 27)
					Error ("\n\n"STR_NETABORT);
		  }

//
// listen to the network
//
		  while (GetPacket ())
		  {
			   if (doomcom.remotenode == -1)
					dest = &nodesetup[doomcom.numnodes];
			   else
					dest = &nodesetup[doomcom.remotenode];

			   if (remotetime != -1)
			   {    // an early game packet, not a setup packet
					if (doomcom.remotenode == -1)
			 Error (STR_UNKNOWN);
			// if it allready started, it must have found all nodes
			dest->nodesfound = dest->nodeswanted;
			continue;
		   }

		   // update setup ingo
		   memcpy (dest, setup, sizeof(*dest) );

		   if (doomcom.remotenode != -1)
			continue;           // allready know that node address

		   //
		   // this is a new node
		   //
		   memcpy (&nodeadr[doomcom.numnodes], &remoteadr
			   , sizeof(nodeadr[doomcom.numnodes]) );

			   //
			   // if this node has a lower address, take all startup info
			   //
			   if ( memcmp (&remoteadr, &nodeadr[0], sizeof(&remoteadr) )< 0 )
			   {
			   }

			   doomcom.numnodes++;

			   if (ctf)
				   printf ("\n"STR_FOUND" [%s]\n",dest->name);  //-jc-
			   else
				   printf ("\n"STR_FOUND"\n");

			   if (doomcom.numnodes < numnetnodes)
					printf (STR_LOOKING); //
		  }
//
// we are done if all nodes have found all other nodes
//
		  for (i=0 ; i<doomcom.numnodes ; i++)
			   if (nodesetup[i].nodesfound != nodesetup[i].nodeswanted)
					break;

		  if (i == nodesetup[0].nodeswanted)
			   break;         // got them all

//
// send out a broadcast packet every second
//
		  gettime (&time);
		  if (time.ti_sec == oldsec)
			   continue;
		  oldsec = time.ti_sec;

		  printf ("%c%c",*(spinner+((spos++) & 3)),8);
		  doomcom.datalength = sizeof(*setup);

		  nodesetup[0].nodesfound = doomcom.numnodes;

		  memcpy (&doomcom.data, &nodesetup[0], sizeof(*setup));

		  SendPacket (MAXNETNODES);     // send to all

	 } while (1);

//
// count players
//


	 total = 0;
	 console = 0;

	 if (playerno==-1) {
		for (i=0 ; i<numnetnodes ; i++)
		{
			  if (nodesetup[i].drone)
				   continue;
			  total++;
			  if (total > MAXPLAYERS)
				   Error (STR_MORETHAN,MAXPLAYERS);
			  if (memcmp (&nodeadr[i], &nodeadr[0], sizeof(nodeadr[0])) < 0)
				   console++;


		}

	   if (ctf) {
		   nodesetup[0].playernum = console;

		   for (i=1;i<numnetnodes;i++) {
			  othercon=0;
			  for (j=0;j<numnetnodes;j++)
					if (memcmp (&nodeadr[j], &nodeadr[i], sizeof(nodeadr[i])) < 0)
						othercon++;

			  nodesetup[i].playernum = othercon;
	   }
	   }

	 }
	 else {
		total=numnetnodes;
		console=playerno-1; // Nodes numbers start at 0 so subtract 1.
	 }


	 if (!total)
		  Error (STR_NONESPEC);

	 doomcom.consoleplayer = console;
	 doomcom.numplayers = total;

	 printf (STR_CONSOLEIS"\n", console+1, total);


	 if (ctf) {
		 // Copy player names from the other machines.
		 for (i=0;i<numnetnodes;i++)
			 if (strcmp(nodesetup[i].name,"NONAME"))
			   strcpy(pnames[nodesetup[i].playernum],strupr(nodesetup[i].name));

		 // Dump the player names to a file, rather than adding extra parms,
		 // either through passing the array address of pnames or just passing
		 // all the names.
		 if ((namesfile=fopen("names.dat","w+"))!=NULL) {
			fprintf(namesfile,"%d\n",MAXPLAYERS);
			for (i=0;i<MAXPLAYERS;i++) fprintf(namesfile,"%s\n",pnames[i]);
			fclose(namesfile);
		 }
		 // If it fails, don't worry as ctfdoom will just resort to using
		 // the default names set.
	 }

}


//========================================================
//
//	Find a Response File
//
//========================================================
void FindResponseFile (void)
{
	int		i;
	#define	MAXARGVS	100

	for (i = 1;i < myargc;i++)
		if (myargv[i][0] == '@')
		{
			FILE *		handle;
			int		size;
			int		k;
			int		index;
			int		indexinfile;
			char	*infile;
			char	*file;
			char	*moreargs[20];
			char	*firstargv;

			// READ THE RESPONSE FILE INTO MEMORY
			handle = fopen (&myargv[i][1],"rb");
			if (!handle)
				Error (STR_NORESP);
			printf(STR_FOUNDRESP" \"%s\"!\n",strupr(&myargv[i][1]));
			fseek (handle,0,SEEK_END);
			size = ftell(handle);
			fseek (handle,0,SEEK_SET);
			file = malloc (size);
			fread (file,size,1,handle);
			fclose (handle);

			// KEEP ALL CMDLINE ARGS FOLLOWING @RESPONSEFILE ARG
			for (index = 0,k = i+1; k < myargc; k++)
				moreargs[index++] = myargv[k];

			firstargv = myargv[0];
			myargv = malloc(sizeof(char *)*MAXARGVS);
			memset(myargv,0,sizeof(char *)*MAXARGVS);
			myargv[0] = firstargv;

			infile = file;
			indexinfile = k = 0;
			indexinfile++;	// SKIP PAST ARGV[0] (KEEP IT)
			do
			{
				myargv[indexinfile++] = infile+k;
				while(k < size &&
					((*(infile+k)>= ' '+1) && (*(infile+k)<='z')))
					k++;
				*(infile+k) = 0;
				while(k < size &&
					((*(infile+k)<= ' ') || (*(infile+k)>'z')))
					k++;
			} while(k < size);

			for (k = 0;k < index;k++)
				myargv[indexinfile++] = moreargs[k];
			myargc = indexinfile;

			// DISPLAY ARGS
//			printf("%d command-line args:\n",myargc);
//			for (k=1;k<myargc;k++)
//				printf("%s\n",myargv[k]);

			break;
		}
}


/*
=============
=
= main
=
=============
*/

void main (void)
	 {
	 int  i;
	 unsigned char far *vector;

//
// determine game parameters
//

	 gameid = 0;
	 numnetnodes = 2;
	 doomcom.ticdup = 1;
	 doomcom.extratics = 1;
	 doomcom.episode = 1;
	 doomcom.map = 1;
	 doomcom.skill = 2;
	 doomcom.deathmatch = 0;

	 printf("\n"
			 "----------------------------------------------\n"
			 "DOOM 1 & 2 NETWORK DEVICE DRIVER - For CTFDoom\n"
			 "v2.00\n"
			 "----------------------------------------------\n");

	 if ((doomenv=getenv("DOOMENV"))!=NULL)
		printf ("DOOMENV set attempting to use %s\n",doomenv);


	 myargc = _argc;
	 myargv = _argv;
	 FindResponseFile();


	 if ((ctf=CheckParm("-ctf"))!=0) memcpy(pnames,names2,sizeof(pnames));

	 if ((i = CheckParm("-player"))!=0)
		playerno=atoi(myargv[i+1]);

	 if (playerno<1 || playerno>8) playerno=-1; // Invalid player ID.

	 if((i = CheckParm("-nodes")) != 0)
		  numnetnodes = atoi(myargv[i+1]);

	 if((i = CheckParm("-vector")) != 0)
		  {
		  doomcom.intnum = sscanf ("0x%x",myargv[i+1]);
		  vector = *(char far * far *)(doomcom.intnum*4);
		  if(vector != NULL && *vector != 0xcf)
			   {
		   printf(STR_VECTSPEC"\n", doomcom.intnum);
			   exit(-1);
			   }
		  }
	 else
		  {
		  for(doomcom.intnum = 0x60 ; doomcom.intnum <= 0x66 ;
doomcom.intnum++)
			   {
			   vector = *(char far * far *)(doomcom.intnum*4);
			   if(vector == NULL || *vector == 0xcf)
					break;
			   }
		  if(doomcom.intnum == 0x67)
			   {
		   printf(STR_NONULL"\n");
		   exit(-1);
		   }
	  }
	 printf(STR_COMMVECT"\n",doomcom.intnum);

	 if((i = CheckParm("-port")) != 0)
	  {
	  socketid = atoi (myargv[i+1]);
	  printf (STR_USEALT"\n", socketid);
		  }

	 InitNetwork ();

	 LookForNodes ();

	 localtime = 0;

	 LaunchDOOM (doomenv);

	 ShutdownNetwork ();

	 if (vectorishooked)
		  setvect (doomcom.intnum,olddoomvect);

	 exit(0);
	 }


