/* -- Anim.h --
Part of the Worminator 2D game engine
Copyright 1998 by Electroencephlogram Software

For function descriptions and explanations, see proto.h
For a detailed explanation of how the engine works, see
the documents that came with this source code package. */

// Red strobe light
#define RED_STROBE_LIGHT_ANIMATION_START 160
#define RED_STROBE_LIGHT_ANIMATION_LENGTH 2
#define RED_STROBE_LIGHT_GLARE_CENTER_ANIMATION_START 176
#define RED_STROBE_LIGHT_GLARE_CENTER_ANIMATION_LENGTH 2
#define RED_STROBE_LIGHT_GLARE_LEFT_ANIMATION_START 192
#define RED_STROBE_LIGHT_GLARE_LEFT_ANIMATION_LENGTH 2
#define RED_STROBE_LIGHT_GLARE_RIGHT_ANIMATION_START 208
#define RED_STROBE_LIGHT_GLARE_RIGHT_ANIMATION_LENGTH 2
#define RED_STROBE_LIGHT_ANIMATION_SPEED 32

// Blue particle beam
#define BLUE_PARTICLE_BEAM_ANIMATION_START 162
#define BLUE_PARTICLE_BEAM_ANIMATION_LENGTH 4
#define BLUE_PARTICLE_BEAM_ANIMATION_SPEED 4

// Conveyor belts
#define CONVEYOR_BELT_RIGHT_ANIMATION_START 224
#define CONVEYOR_BELT_RIGHT_ANIMATION_LENGTH 8
#define CONVEYOR_BELT_LEFT_ANIMATION_START 240
#define CONVEYOR_BELT_LEFT_ANIMATION_LENGTH 8
#define CONVEYOR_BELT_LEFT_END_LEFT_ANIMATION_START 200
#define CONVEYOR_BELT_LEFT_END_LEFT_ANIMATION_LENGTH 8
#define CONVEYOR_BELT_LEFT_END_RIGHT_ANIMATION_START 216
#define CONVEYOR_BELT_LEFT_END_RIGHT_ANIMATION_LENGTH 8
#define CONVEYOR_BELT_RIGHT_END_LEFT_ANIMATION_START 232
#define CONVEYOR_BELT_RIGHT_END_LEFT_ANIMATION_LENGTH 8
#define CONVEYOR_BELT_RIGHT_END_RIGHT_ANIMATION_START 248
#define CONVEYOR_BELT_RIGHT_END_RIGHT_ANIMATION_LENGTH 8

#define CONVEYOR_BELT_ANIMATION_SPEED 0

// Fire burning away
#define FIRE_ANIMATION_START 480
#define FIRE_ANIMATION_LENGTH 8
#define FIRE_LEFT_END_ANIMATION_START 496
#define FIRE_LEFT_END_ANIMATION_LENGTH 8
#define FIRE_RIGHT_END_ANIMATION_START 502
#define FIRE_RIGHT_END_ANIMATION_LENGTH 8

#define FIRE_ANIMATION_SPEED 2

// Water flowing left out of a sewer pipe
#define FLOWING_LEFT_SEWER_WATER_01_ANIMATION_START 3584
#define FLOWING_LEFT_SEWER_WATER_01_ANIMATION_LENGTH 4
#define FLOWING_LEFT_SEWER_WATER_02_ANIMATION_START 3600
#define FLOWING_LEFT_SEWER_WATER_02_ANIMATION_LENGTH 4
#define FLOWING_LEFT_SEWER_WATER_03_ANIMATION_START 3616
#define FLOWING_LEFT_SEWER_WATER_03_ANIMATION_LENGTH 4
#define FLOWING_LEFT_SEWER_WATER_04_ANIMATION_START 3632
#define FLOWING_LEFT_SEWER_WATER_04_ANIMATION_LENGTH 4
#define FLOWING_LEFT_SEWER_WATER_ANIMATION_SPEED 6

// Water flowing right out of a sewer pipe
#define FLOWING_RIGHT_SEWER_WATER_01_ANIMATION_START 3588
#define FLOWING_RIGHT_SEWER_WATER_01_ANIMATION_LENGTH 4
#define FLOWING_RIGHT_SEWER_WATER_02_ANIMATION_START 3604
#define FLOWING_RIGHT_SEWER_WATER_02_ANIMATION_LENGTH 4
#define FLOWING_RIGHT_SEWER_WATER_03_ANIMATION_START 3620
#define FLOWING_RIGHT_SEWER_WATER_03_ANIMATION_LENGTH 4
#define FLOWING_RIGHT_SEWER_WATER_04_ANIMATION_START 3636
#define FLOWING_RIGHT_SEWER_WATER_04_ANIMATION_LENGTH 4
#define FLOWING_RIGHT_SEWER_WATER_ANIMATION_SPEED 6

// Left half of water flowing down out of a sewer pipe
#define FLOWING_DOWN_WATER_LEFT_HALF_01_ANIMATION_START 3592
#define FLOWING_DOWN_WATER_LEFT_HALF_01_ANIMATION_LENGTH 4
#define FLOWING_DOWN_WATER_LEFT_HALF_02_ANIMATION_START 3608
#define FLOWING_DOWN_WATER_LEFT_HALF_02_ANIMATION_LENGTH 4
#define FLOWING_DOWN_WATER_LEFT_HALF_03_ANIMATION_START 3624
#define FLOWING_DOWN_WATER_LEFT_HALF_03_ANIMATION_LENGTH 4
#define FLOWING_DOWN_WATER_LEFT_HALF_04_ANIMATION_START 3640
#define FLOWING_DOWN_WATER_LEFT_HALF_04_ANIMATION_LENGTH 4
#define FLOWING_DOWN_WATER_LEFT_HALP_ANIMATION_SPEED 6

// Right half of water flowing down out of a sewer pipe
#define FLOWING_DOWN_WATER_RIGHT_HALF_01_ANIMATION_START 3596
#define FLOWING_DOWN_WATER_RIGHT_HALF_01_ANIMATION_LENGTH 4
#define FLOWING_DOWN_WATER_RIGHT_HALF_02_ANIMATION_START 3612
#define FLOWING_DOWN_WATER_RIGHT_HALF_02_ANIMATION_LENGTH 4
#define FLOWING_DOWN_WATER_RIGHT_HALF_03_ANIMATION_START 3628
#define FLOWING_DOWN_WATER_RIGHT_HALF_03_ANIMATION_LENGTH 4
#define FLOWING_DOWN_WATER_RIGHT_HALF_04_ANIMATION_START 3644
#define FLOWING_DOWN_WATER_RIGHT_HALF_04_ANIMATION_LENGTH 4
#define FLOWING_DOWN_WATER_RIGHT_HALP_ANIMATION_SPEED 6

// Icky Slime
#define ICKY_SLIME_SURFACE_ANIMATION_START 3568
#define ICKY_SLIME_SURFACE_ANIMATION_LENGTH 8
#define ICKY_SLIME_SUBMERGED_ANIMATION_START 3580
#define ICKY_SLIME_SUBMERGED_ANIMATION_LENGTH 4
#define ICKY_SLIME_ANIMATION_SPEED 6

// Standard blue water
#define WATER_SURFACE_ANIMATION_START 3648
#define WATER_SURFACE_ANIMATION_LENGTH 4
#define WATER_SUBMERGED_ANIMATION_START 3664
#define WATER_SUBMERGED_ANIMATION_LENGTH 4
#define WATER_ANIMATION_SPEED 10

// Kickass Lava
#define LAVA_SURFACE_ANIMATION_START 3652
#define LAVA_SURFACE_ANIMATION_LENGTH 4
#define LAVA_SUBMERGED_ANIMATION_START 3668
#define LAVA_SUBMERGED_ANIMATION_LENGTH 4
#define LAVA_ANIMATION_SPEED 8

// Nasty swamp water
#define SWAMP_WATER_SURFACE_ANIMATION_START 3656
#define SWAMP_WATER_SURFACE_ANIMATION_LENGTH 4
#define SWAMP_WATER_SUBMERGED_ANIMATION_START 3672
#define SWAMP_WATER_SUBMERGED_ANIMATION_LENGTH 4
#define SWAMP_WATER_ANIMATION_SPEED 8

/***************************\
|** BUILD ANIMATION TABLE **|
\***************************/
void build_animation_table()
{
short unsigned int x_tile_loop, y_tile_loop;
int number_of_animations = 0;
int bg_tile, fg_tile;
int animation_start, animation_length, animation_stop;

// Add all animated tiles to the list
for (x_tile_loop = 0; x_tile_loop < worminator_map.map_width; x_tile_loop++) {
	for (y_tile_loop = 0; y_tile_loop < worminator_map.map_height; y_tile_loop++) {
	bg_tile = worminator_map.background_tile_grid[x_tile_loop][y_tile_loop];
	fg_tile = worminator_map.foreground_tile_grid[x_tile_loop][y_tile_loop];

////////////// A red strobe light and its glare ///////////////////////////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, RED_STROBE_LIGHT_ANIMATION_START, RED_STROBE_LIGHT_ANIMATION_LENGTH, RED_STROBE_LIGHT_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, RED_STROBE_LIGHT_GLARE_CENTER_ANIMATION_START, RED_STROBE_LIGHT_GLARE_CENTER_ANIMATION_LENGTH, RED_STROBE_LIGHT_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, RED_STROBE_LIGHT_GLARE_LEFT_ANIMATION_START, RED_STROBE_LIGHT_GLARE_LEFT_ANIMATION_LENGTH, RED_STROBE_LIGHT_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, RED_STROBE_LIGHT_GLARE_RIGHT_ANIMATION_START, RED_STROBE_LIGHT_GLARE_RIGHT_ANIMATION_LENGTH, RED_STROBE_LIGHT_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

////////////// A blue particle beam ///////////////////////////////////////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, BLUE_PARTICLE_BEAM_ANIMATION_START, BLUE_PARTICLE_BEAM_ANIMATION_LENGTH, BLUE_PARTICLE_BEAM_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

////////////// A conveyor belt ////////////////////////////////////////////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, CONVEYOR_BELT_RIGHT_ANIMATION_START, CONVEYOR_BELT_RIGHT_ANIMATION_LENGTH, CONVEYOR_BELT_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, CONVEYOR_BELT_LEFT_ANIMATION_START, CONVEYOR_BELT_LEFT_ANIMATION_LENGTH, CONVEYOR_BELT_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

		if (check_tile_for_animation(x_tile_loop, y_tile_loop, CONVEYOR_BELT_LEFT_END_LEFT_ANIMATION_START, CONVEYOR_BELT_LEFT_END_LEFT_ANIMATION_LENGTH, CONVEYOR_BELT_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, CONVEYOR_BELT_LEFT_END_RIGHT_ANIMATION_START, CONVEYOR_BELT_LEFT_END_RIGHT_ANIMATION_LENGTH, CONVEYOR_BELT_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, CONVEYOR_BELT_RIGHT_END_LEFT_ANIMATION_START, CONVEYOR_BELT_RIGHT_END_LEFT_ANIMATION_LENGTH, CONVEYOR_BELT_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, CONVEYOR_BELT_RIGHT_END_RIGHT_ANIMATION_START, CONVEYOR_BELT_RIGHT_END_RIGHT_ANIMATION_LENGTH, CONVEYOR_BELT_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

////////////// A patch of fire burning ////////////////////////////////////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FIRE_ANIMATION_START, FIRE_ANIMATION_LENGTH, FIRE_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FIRE_LEFT_END_ANIMATION_START, FIRE_LEFT_END_ANIMATION_LENGTH, FIRE_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FIRE_RIGHT_END_ANIMATION_START, FIRE_RIGHT_END_ANIMATION_LENGTH, FIRE_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

////////////// Water flowing left out of a sewer pipe. ////////////////////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_LEFT_SEWER_WATER_01_ANIMATION_START, FLOWING_LEFT_SEWER_WATER_01_ANIMATION_LENGTH, FLOWING_LEFT_SEWER_WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_LEFT_SEWER_WATER_02_ANIMATION_START, FLOWING_LEFT_SEWER_WATER_02_ANIMATION_LENGTH, FLOWING_LEFT_SEWER_WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_LEFT_SEWER_WATER_03_ANIMATION_START, FLOWING_LEFT_SEWER_WATER_03_ANIMATION_LENGTH, FLOWING_LEFT_SEWER_WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_LEFT_SEWER_WATER_04_ANIMATION_START, FLOWING_LEFT_SEWER_WATER_04_ANIMATION_LENGTH, FLOWING_LEFT_SEWER_WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

////////////// Water flowing right out of a sewer pipe. ///////////////////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_RIGHT_SEWER_WATER_01_ANIMATION_START, FLOWING_RIGHT_SEWER_WATER_01_ANIMATION_LENGTH, FLOWING_RIGHT_SEWER_WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_RIGHT_SEWER_WATER_02_ANIMATION_START, FLOWING_RIGHT_SEWER_WATER_02_ANIMATION_LENGTH, FLOWING_RIGHT_SEWER_WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_RIGHT_SEWER_WATER_03_ANIMATION_START, FLOWING_RIGHT_SEWER_WATER_03_ANIMATION_LENGTH, FLOWING_RIGHT_SEWER_WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_RIGHT_SEWER_WATER_04_ANIMATION_START, FLOWING_RIGHT_SEWER_WATER_04_ANIMATION_LENGTH, FLOWING_RIGHT_SEWER_WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

////////////// Left half of water flowing down out of a sewer pipe. ///////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_DOWN_WATER_LEFT_HALF_01_ANIMATION_START, FLOWING_DOWN_WATER_LEFT_HALF_01_ANIMATION_LENGTH, FLOWING_DOWN_WATER_LEFT_HALP_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_DOWN_WATER_LEFT_HALF_02_ANIMATION_START, FLOWING_DOWN_WATER_LEFT_HALF_02_ANIMATION_LENGTH, FLOWING_DOWN_WATER_LEFT_HALP_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_DOWN_WATER_LEFT_HALF_03_ANIMATION_START, FLOWING_DOWN_WATER_LEFT_HALF_03_ANIMATION_LENGTH, FLOWING_DOWN_WATER_LEFT_HALP_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_DOWN_WATER_LEFT_HALF_04_ANIMATION_START, FLOWING_DOWN_WATER_LEFT_HALF_04_ANIMATION_LENGTH, FLOWING_DOWN_WATER_LEFT_HALP_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

////////////// Right half of water flowing down out of a sewer pipe. //////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_DOWN_WATER_RIGHT_HALF_01_ANIMATION_START, FLOWING_DOWN_WATER_RIGHT_HALF_01_ANIMATION_LENGTH, FLOWING_DOWN_WATER_RIGHT_HALP_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_DOWN_WATER_RIGHT_HALF_02_ANIMATION_START, FLOWING_DOWN_WATER_RIGHT_HALF_02_ANIMATION_LENGTH, FLOWING_DOWN_WATER_RIGHT_HALP_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_DOWN_WATER_RIGHT_HALF_03_ANIMATION_START, FLOWING_DOWN_WATER_RIGHT_HALF_03_ANIMATION_LENGTH, FLOWING_DOWN_WATER_RIGHT_HALP_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, FLOWING_DOWN_WATER_RIGHT_HALF_04_ANIMATION_START, FLOWING_DOWN_WATER_RIGHT_HALF_04_ANIMATION_LENGTH, FLOWING_DOWN_WATER_RIGHT_HALP_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

////////////// Icky Slime. ////////////////////////////////////////////////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, ICKY_SLIME_SURFACE_ANIMATION_START, ICKY_SLIME_SURFACE_ANIMATION_LENGTH, ICKY_SLIME_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, ICKY_SLIME_SUBMERGED_ANIMATION_START, ICKY_SLIME_SUBMERGED_ANIMATION_LENGTH, ICKY_SLIME_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

////////////// Standard blue water. ///////////////////////////////////////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, WATER_SURFACE_ANIMATION_START, WATER_SURFACE_ANIMATION_LENGTH, WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, WATER_SUBMERGED_ANIMATION_START, WATER_SUBMERGED_ANIMATION_LENGTH, WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

////////////// Kickass Lava. //////////////////////////////////////////////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, LAVA_SURFACE_ANIMATION_START, LAVA_SURFACE_ANIMATION_LENGTH, LAVA_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, LAVA_SUBMERGED_ANIMATION_START, LAVA_SUBMERGED_ANIMATION_LENGTH, LAVA_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;

////////////// Nasty swamp water. /////////////////////////////////////////////////////////////
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, SWAMP_WATER_SURFACE_ANIMATION_START, SWAMP_WATER_SURFACE_ANIMATION_LENGTH, SWAMP_WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		if (check_tile_for_animation(x_tile_loop, y_tile_loop, SWAMP_WATER_SUBMERGED_ANIMATION_START, SWAMP_WATER_SUBMERGED_ANIMATION_LENGTH, SWAMP_WATER_ANIMATION_SPEED, number_of_animations) == TRUE) number_of_animations++;
		}
	}

// Set the ending spot in the animation array
if (number_of_animations != 1023) tile_animations[number_of_animations][0] = 255;
}

/******************************\
|** CHECK TILE FOR ANIMATION **|
\******************************/
char check_tile_for_animation(unsigned char tile_x, unsigned char tile_y, int animation_start, int animation_length, char animation_speed, int number_of_animations)
{
int animation_stop = animation_start + animation_length - 1;
int bg_tile = worminator_map.background_tile_grid[tile_x][tile_y], fg_tile = worminator_map.foreground_tile_grid[tile_x][tile_y];

if ((bg_tile >= animation_start && bg_tile <= animation_stop) || (fg_tile >= animation_start && fg_tile <= animation_stop)) {
	if (bg_tile >= animation_start && bg_tile <= animation_stop) tile_animations[number_of_animations][0] = 0;
	else tile_animations[number_of_animations][0] = 1;
	tile_animations[number_of_animations][1] = tile_x;
	tile_animations[number_of_animations][2] = tile_y;
	tile_animations[number_of_animations][3] = animation_stop;
	tile_animations[number_of_animations][4] = animation_length;
	tile_animations[number_of_animations][5] = animation_speed;
	tile_animations[number_of_animations][6] = 0;
	return TRUE;
	}

return FALSE;
}


/***********************\
|** UPDATE ANIMATIONS **|
\***********************/
void update_animations()
{
volatile int animation_loop;
LOCK_VARIABLE(animation_loop);

// Don't do anything if the game is paused
if (game_is_running == FALSE) return;

// Pause the game speed timer
game_is_running = FALSE;

// Increase the global timer
global_timer++;
if (global_timer > 15) global_timer = 0;

// Update weather if nessicary
if (worminator_map.weather != 0) update_weather();

// Update all animated tiles
for (animation_loop = 0; animation_loop < 1024; animation_loop++) {
	if (tile_animations[animation_loop][0] == 255) {
		// Activate the game speed timer again
		game_is_running = TRUE;
		return;
		}
	if (tile_animations[animation_loop][6] == tile_animations[animation_loop][5]) {
		tile_animations[animation_loop][6] = 0;
		if (tile_animations[animation_loop][0] == 0) {
			worminator_map.background_tile_grid[tile_animations[animation_loop][1]][tile_animations[animation_loop][2]]++;
			if (worminator_map.background_tile_grid[tile_animations[animation_loop][1]][tile_animations[animation_loop][2]] > tile_animations[animation_loop][3]) {
				worminator_map.background_tile_grid[tile_animations[animation_loop][1]][tile_animations[animation_loop][2]] -= tile_animations[animation_loop][4];
				}
			}
		if (tile_animations[animation_loop][0] == 1) {
			worminator_map.foreground_tile_grid[tile_animations[animation_loop][1]][tile_animations[animation_loop][2]]++;
			if (worminator_map.foreground_tile_grid[tile_animations[animation_loop][1]][tile_animations[animation_loop][2]] > tile_animations[animation_loop][3]) {
				worminator_map.foreground_tile_grid[tile_animations[animation_loop][1]][tile_animations[animation_loop][2]] -= tile_animations[animation_loop][4];
				}
			}
		}
	else tile_animations[animation_loop][6]++;
	}
}

END_OF_FUNCTION(update_animations);
