/* -- Scripts.h --
Part of the Worminator 2D game engine
Copyright 1998 by Electroencephlogram Software

For function descriptions and explanations, see proto.h
For a detailed explanation of how the engine works, see
the documents that came with this source code package. */

void play_introduction()
{
int scroll_loop;

// Set the pallete to the worminator pallete
set_pallete(black_pallete);

// Fill the screen with black
rectfill(screen, 0, 0, 320, 200, 15);

// Draw, fade in, rest, and fade out the first frame
blit(worminator_data_file[INTRODUCTION_FRAME_01].dat, screen, 0, 0, 0, 0, 320, 200);
rest(1000);
fade_in(worminator_data_file[DEFAULT_WORMINATOR_PALLETE].dat, 8);
rest(2500);
fade_out(8);

// Draw, fade in, rest, and fade out the second frame
blit(worminator_data_file[INTRODUCTION_FRAME_02].dat, screen, 0, 0, 0, 0, 320, 200);
rest(1000);
fade_in(worminator_data_file[DEFAULT_WORMINATOR_PALLETE].dat, 8);
rest(2500);
fade_out(8);

// Fill the screen with black
rectfill(screen, 0, 0, 320, 200, 15);

// Reset the pallete to the worminator pallete
set_pallete(worminator_data_file[DEFAULT_WORMINATOR_PALLETE].dat);
}

/*****************\
|** RUN SCRIPTS **|
\*****************/
void run_scripts()
{
int script_loop;

// Check and run all scripts

// Level 1 (Worminator Factory) campaign scripts
if (current_level == 1) {
	// Secret passage message
	if (worminator_map.info_tile_grid[0][0] == NULL && player.x_position_in_pixels + 16 >= 2016 && player.x_position_in_pixels + 16 < 2048 && player.y_position_in_pixels + 16 >= 2624 && player.y_position_in_pixels + 16 < 2656) {
		worminator_map.info_tile_grid[0][0] = 164;
		add_text_message("A secret passage");
		}
	// Small gun turret ambush
	if (worminator_map.info_tile_grid[1][0] == NULL && player.x_position_in_pixels + 16 >= 1872 && player.x_position_in_pixels + 16 < 1904 && player.y_position_in_pixels + 16 >= 2656 && player.y_position_in_pixels + 16 < 2688) {
		worminator_map.info_tile_grid[1][0] = 164;
		worminator_map.foreground_tile_grid[123][167] = NULL;
		worminator_map.foreground_tile_grid[124][167] = NULL;
		spawn_sprite(SMALL_GUN_TURRET_ENEMY_SPRITE, 1968, 2672, NULL, NULL, 1);
		play_sample(worminator_data_file[ALARM_SOUND].dat, 255, 128, 1000, FALSE);
		add_text_message("Ambush");
		}
	// Bridge extention switch
	if (worminator_map.info_tile_grid[2][0] == NULL && player.x_position_in_pixels + 16 >= 1744 && player.x_position_in_pixels + 16 < 1760 && player.y_position_in_pixels + 16 >= 2832 && player.y_position_in_pixels + 16 < 2880) {
		worminator_map.info_tile_grid[2][0] = 164;
		worminator_map.background_tile_grid[110][178] = 57;
		for (script_loop = 0; script_loop < 7; script_loop++) {
			worminator_map.background_tile_grid[script_loop + 104][165] = 306;
			worminator_map.info_tile_grid[script_loop + 104][165] = solid_info_tile;
			}
		play_sample(worminator_data_file[GONG_SOUND].dat, 255, 128, 1000, FALSE);
		add_text_message("Bridge extended");
		}
	// Nuclear strike
	if (worminator_map.info_tile_grid[3][0] == NULL && player.x_position_in_pixels + 16 >= 2144 && player.x_position_in_pixels + 16 < 2167 && player.y_position_in_pixels + 16 >= 2672 && player.y_position_in_pixels + 16 < 2704) {
		worminator_map.info_tile_grid[3][0] = 164;
		spawn_sprite(BIG_NUCLEAR_BOMB_ENEMY_SPRITE, 2240, 1856, NULL, NULL, NULL);
		play_sample(worminator_data_file[ALARM_SOUND].dat, 255, 128, 1000, FALSE);
		add_text_message("Nuclear launch detected");
		}
	// Special bridge repair kit item
	if (worminator_map.info_tile_grid[4][0] == NULL && player.x_position_in_pixels + 16 >= 3184 && player.x_position_in_pixels + 16 < 3232 && player.y_position_in_pixels + 16 >= 3008 && player.y_position_in_pixels + 16 < 3056) {
		worminator_map.info_tile_grid[4][0] = 164;
		worminator_map.foreground_tile_grid[200][189] = NULL;
		worminator_map.graphical_properties_tile_grid[200][189] = masked_background_grph_tile;
		for (script_loop = 0; script_loop < 4; script_loop++) spawn_sprite(SMALL_GOLD_SPARK_SPRITE, 3208, 3032, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
		for (script_loop = 0; script_loop < 4; script_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, 3208, 3032, (float)((rand() % 40) - 20.00) / 20.00, (float)((rand() % 40) - 20.00) / 20.00, NULL);
		add_text_message("You got a bridge repair kit");
		}
	// Repair bridge event
	if (worminator_map.info_tile_grid[4][0] == 164 && worminator_map.info_tile_grid[5][0] == 0 && player.x_position_in_pixels + 16 >= 2336 && player.x_position_in_pixels + 16 < 2400 && player.y_position_in_pixels + 16 >= 2928 && player.y_position_in_pixels + 16 < 2992) {
		worminator_map.info_tile_grid[5][0] = 164;
		for (script_loop = 0; script_loop < 13; script_loop++) {
			worminator_map.foreground_tile_grid[script_loop + 135][186] = 2036;
			worminator_map.info_tile_grid[script_loop + 135][186] = solid_info_tile;
			}
		add_text_message("You repaired the lava bridge");
		}
	return;
	}

// Level 2 (Sewers) campaign scripts
else if (current_level == 2) {
	// Lift activation switch
	if (worminator_map.info_tile_grid[0][64] == NULL && player.x_position_in_pixels + 16 >= 1328 && player.x_position_in_pixels + 16 < 1344 && player.y_position_in_pixels + 16 >= 304 && player.y_position_in_pixels + 16 < 352) {
		worminator_map.info_tile_grid[0][64] = 164;
		worminator_map.background_tile_grid[84][20] = 56;
		worminator_map.info_tile_grid[36][32] = up_turning_point_info_tile;
		play_sample(worminator_data_file[GONG_SOUND].dat, 255, 128, 1000, FALSE);
		add_text_message("Lift activated");
		}
	// Turbo launch tube
	if (turbo_launch == FALSE && player.x_position_in_pixels + 16 >= 768 && player.x_position_in_pixels + 16 < 848 && player.y_position_in_pixels + 16 >= 864 && player.y_position_in_pixels + 16 < 896) {
		player.y_acceleration = -3.5;
		turbo_launch = TRUE;
		add_text_message("Turbo Launch");
		}

	return;
	}

// Level 3 (Cyberworm Building) campaign scripts
else if (current_level == 3) {
	// Drop red key if nessicary
	if (worminator_map.info_tile_grid[0][88] == NULL && player.x_position_in_pixels + 16 >= 48 && player.x_position_in_pixels + 16 < 80 && player.y_position_in_pixels + 16 >= 208 && player.y_position_in_pixels + 16 < 240) {
		worminator_map.info_tile_grid[0][88] = 164;
		if (player.has_red_keycard == TRUE) {
			player.has_red_keycard = FALSE;
			update_player_stats();
			add_text_message("You just dropped the red keycard back");
			add_text_message("down into the sewer");
			}
		}
	return;
	}

// Level 4 (Airship) campaign scripts
else if (current_level == 4) {
	// Nuclear strike halt switch
	if (worminator_map.info_tile_grid[0][0] == NULL && player.x_position_in_pixels + 16 >= 784 && player.x_position_in_pixels + 16 < 800 && player.y_position_in_pixels + 16 >= 1312 && player.y_position_in_pixels + 16 < 1360) {
		worminator_map.info_tile_grid[0][0] = 164;
		worminator_map.background_tile_grid[48][83] = 40;
		for (script_loop = 0; script_loop < 1024; script_loop++) {
			if (sprites[script_loop].sprite_type == NUCLEAR_BOMB_SPAWNER_SPRITE) {
				destroy_sprite(script_loop);
				script_loop--;
				}
			}
		play_sample(worminator_data_file[INITIATE_SHUTDOWN_SEQUENCE_SOUND].dat, 255, 128, 1000, FALSE);
		add_text_message("Nuclear strike halted");
		}
	// Dynamite blast lever
	if (worminator_map.info_tile_grid[1][0] == NULL && player.x_position_in_pixels + 16 >= 1744 && player.x_position_in_pixels + 16 < 1792 && player.y_position_in_pixels + 16 >= 1536 && player.y_position_in_pixels + 16 < 1600) {
		worminator_map.info_tile_grid[1][0] = 164;
		worminator_map.foreground_tile_grid[110][97] = 43;
		worminator_map.foreground_tile_grid[110][98] = 59;
		worminator_map.foreground_tile_grid[131][92] = NULL;
		worminator_map.foreground_tile_grid[133][92] = NULL;
		worminator_map.foreground_tile_grid[130][93] = NULL;
		worminator_map.foreground_tile_grid[131][93] = NULL;
		worminator_map.foreground_tile_grid[132][93] = NULL;
		worminator_map.foreground_tile_grid[133][93] = NULL;
		worminator_map.foreground_tile_grid[134][93] = NULL;
		worminator_map.foreground_tile_grid[131][94] = NULL;
		worminator_map.foreground_tile_grid[132][94] = NULL;
		worminator_map.foreground_tile_grid[133][94] = NULL;
		worminator_map.foreground_tile_grid[132][95] = NULL;
		worminator_map.foreground_tile_grid[133][95] = NULL;
		worminator_map.info_tile_grid[131][92] = NULL;
		worminator_map.info_tile_grid[133][92] = NULL;
		worminator_map.info_tile_grid[130][93] = NULL;
		worminator_map.info_tile_grid[131][93] = NULL;
		worminator_map.info_tile_grid[132][93] = NULL;
		worminator_map.info_tile_grid[133][93] = NULL;
		worminator_map.info_tile_grid[134][93] = NULL;
		worminator_map.info_tile_grid[131][94] = NULL;
		worminator_map.info_tile_grid[132][94] = NULL;
		worminator_map.info_tile_grid[133][94] = NULL;
		worminator_map.info_tile_grid[132][95] = NULL;
		worminator_map.info_tile_grid[133][95] = NULL;
		spawn_sprite(MEDIUM_EXPLOSION_SPRITE, 2112, 1488, NULL, NULL, NULL);
		spawn_shrapgibs(2112, 1488, 64, NULL);
		play_sample(worminator_data_file[GONG_SOUND].dat, 255, 128, 1000, FALSE);
		quake_timer = 256;
		add_text_message("Dynamite blast clears the passage");
		}
	return;
	}

// Level 6 (Don't Know) campaign scripts
else if (current_level == 6) {
	// Seal door and steal weapons
	if (worminator_map.info_tile_grid[0][0] == NULL && player.x_position_in_pixels + 16 >= 160 && player.x_position_in_pixels + 16 < 192 && player.y_position_in_pixels + 16 >= 1296 && player.y_position_in_pixels + 16 < 1328) {
		worminator_map.info_tile_grid[0][0] = 164;
		worminator_map.info_tile_grid[10][81] = NULL;
		player.current_weapon = NULL;
		player.has_red_keycard = FALSE, player.has_green_keycard = FALSE, player.has_blue_keycard = FALSE;
		player.bullets_left = -1, player.shells_left = -1, player.rockets_left = -1, player.cells_left = -1, player.gasoline_left = -1, player.mortars_left = -1, player.plasma_left = -1, player.mines_left = -1;
		desired_weapon = 0;
		update_player_stats();
		add_text_message("Something stole your weapons and then");
		add_text_message("locked the door behind you");
		}
	// Turbo launch tube
	if (turbo_launch == FALSE && player.x_position_in_pixels + 16 >= 1248 && player.x_position_in_pixels + 16 < 1280 && player.y_position_in_pixels + 16 >= 1760 && player.y_position_in_pixels + 16 < 1792) {
		player.y_acceleration = -5.5;
		turbo_launch = TRUE;
		add_text_message("Turbo Launch");
		}
	// Game ending
	if (player.x_position_in_pixels + 16 >= 1872 && player.x_position_in_pixels + 16 < 1904 && player.y_position_in_pixels + 16 >= 1648 && player.y_position_in_pixels + 16 < 1680) {
		game_is_running = FALSE;
		stop_midi();
		display_snapshot(12, FALSE);  // Worm scientist message

		// Full version movie ending
		if (version_size == FULL_VERSION) play_memory_fli(worminator_data_file[WORMY_FINALE_MOVIE].dat, screen, FALSE, NULL);  // Show the final cinematic

		// Alternate small-size ending
		else if (version_size == STRIPPED_VERSION) {
			set_pallete(black_pallete);
			blit(worminator_data_file[WORMY_FINALE_PAGE_01].dat, screen, 0, 0, 0, 0, 320, 200);
			fade_in(worminator_data_file[WORMY_FINALE_PAGE_01_PALLETE].dat, 2);
			rest(5000);
			fade_out(2);
			set_pallete(black_pallete);
			blit(worminator_data_file[WORMY_FINALE_PAGE_02].dat, screen, 0, 0, 0, 0, 320, 200);
			fade_in(worminator_data_file[WORMY_FINALE_PAGE_02_PALLETE].dat, 2);
			rest(5000);
			fade_out(2);
			set_pallete(black_pallete);
			blit(worminator_data_file[WORMY_FINALE_PAGE_03].dat, screen, 0, 0, 0, 0, 320, 200);
			fade_in(worminator_data_file[WORMY_FINALE_PAGE_03_PALLETE].dat, 2);
			rest(5000);
			fade_out(2);
			set_pallete(black_pallete);
			blit(worminator_data_file[WORMY_FINALE_PAGE_04].dat, screen, 0, 0, 0, 0, 320, 200);
			fade_in(worminator_data_file[WORMY_FINALE_PAGE_04_PALLETE].dat, 2);
			rest(5000);
			fade_out(2);
			}

		// These screens are common to both versions of the game
		set_pallete(worminator_data_file[DEFAULT_WORMINATOR_PALLETE].dat);
		display_snapshot(13, FALSE);  // Famous last words
		set_pallete(black_pallete);
		blit(worminator_data_file[WORMY_THE_END_OF_IT_ALL].dat, screen, 0, 0, 0, 0, 320, 200);
		fade_in(worminator_data_file[WORMY_THE_END_OF_IT_ALL_PALLETE].dat, 2);
		rest(10000);
		fade_out(2);

		// Restore the main menu again a really cheap way :)
		set_pallete(worminator_data_file[DEFAULT_WORMINATOR_PALLETE].dat);
		blit(worminator_data_file[MAIN_TITLE_SCREEN].dat, screen, 0, 0, 0, 0, 320, 200);
		current_level = -69;
		wormy_menu();
		}
	return;
	}
}
