/* -- Sprites.h --
Part of the Worminator 2D game engine
Copyright 1998 by Electroencephlogram Software

For function descriptions and explanations, see proto.h
For a detailed explanation of how the engine works, see
the documents that came with this source code package. */

// Projectiles
#define WORMINATOR_BULLET_SPRITE 1
#define WORMINATOR_ROCKET_SPRITE 2
#define WORMINATOR_MORTAR_SPRITE 3
#define WORMINATOR_BFG_PLASMA_BALL_SPRITE 4
#define WORMINATOR_MINE_SPRITE 5
#define ENEMY_PLASMA_BULLET_SPRITE 6
#define ENEMY_LASER_BOLT_SPRITE 7
#define SMALL_ENEMY_ROCKET_SPRITE 8
#define LARGE_ENEMY_ROCKET_SPRITE 9
#define ENEMY_MORTAR_SPRITE 10
#define ENEMY_TOXIN_SPRITE 11

// Particles and stuff that does basically nothing
#define BONUS_FLYUP_50_POINT_SPRITE 16
#define BONUS_FLYUP_100_POINT_SPRITE 17
#define BONUS_FLYUP_250_POINT_SPRITE 18
#define BONUS_FLYUP_500_POINT_SPRITE 19
#define SMALL_WHITE_SPARK_SPRITE 20
#define SMALL_BLUE_SPARK_SPRITE 21
#define SMALL_RED_SPARK_SPRITE 22
#define SMALL_GOLD_SPARK_SPRITE 23
#define WATER_BUBBLE_SPRITE 24
#define WATER_SPLASH_SPRITE 25
#define SHRAPNEL_SPRITE 26
#define GIB_SPRITE 27
#define SMALL_SPINNING_FAN_SPRITE 28
#define MEDIUM_SPINNING_FAN_SPRITE 29
#define LARGE_SPINNING_FAN_SPRITE 30

// Enemies
#define SMALL_BLUE_SLIME_BLOB_ENEMY_SPRITE 32
#define SMALL_RUNNER_ENEMY_SPRITE 33
#define ROBOTIC_DOG_ENEMY_SPRITE 34
#define SMALL_GUN_TURRET_ENEMY_SPRITE 35
#define MORTAR_GUN_TURRET_ENEMY_SPRITE 36
#define BIG_GUN_TURRET_ENEMY_SPRITE 37
#define FLYING_PROBE_ENEMY_SPRITE 38
#define DECIMATER_ENEMY_SPRITE 39
#define GIANT_ROBOT_ENEMY_SPRITE 40
#define MECHANICAL_CRUSHER_ENEMY_SPRITE 41
#define NUCLEAR_WORM_ENEMY_SPRITE 42
#define LASER_REBEL_WORM_ENEMY_SPRITE 43
#define ROCKET_REBEL_WORM_ENEMY_SPRITE 44
#define RIFLE_REBEL_WORM_ENEMY_SPRITE 45
#define BIG_GREEN_SLIME_BLOB_ENEMY_SPRITE 46
#define GUMDROP_ENEMY_SPRITE 47
#define BIG_NUCLEAR_BOMB_ENEMY_SPRITE 48
#define SMALL_NUCLEAR_BOMB_ENEMY_SPRITE 49
#define FIREWORM_SEGMENT_ENEMY_SPRITE 50
#define FLAME_JET_ENEMY_SPRITE 51

// Civilians
#define WORM_GIRL_SPRITE 64
#define WORM_BOY_SPRITE 65
#define WORM_COP_SPRITE 66
#define WORM_GENTLEMEN_SPRITE 67
#define WORM_BLONDE_DRESSED_SPRITE 68
#define WORM_STRIPPER_ONE_SPRITE 69
#define WORM_STRIPPER_TWO_SPRITE 70
#define WORM_BLONDE_NUDE_ONE_SPRITE 71
#define WORM_BLONDE_NUDE_TWO_SPRITE 72
#define WORM_BLONDE_IN_BED_SPRITE 73
#define WORM_BLONDE_DANCER_SPRITE 74

// Explosions
#define SMALL_EXPLOSION_SPRITE 80
#define MEDIUM_EXPLOSION_SPRITE 81
#define MUSHROOM_CLOUD_SPRITE 82
#define BFG_PLASMA_BALL_EXPLOSION_SPRITE 83

// Getable items
#define HEALTH_1_SPRITE 96
#define HEALTH_2_SPRITE 97
#define HEALTH_5_SPRITE 98
#define HEALTH_10_SPRITE 99
#define MINIGUN_SPRITE 100
#define BULLETS_SMALL_SPRITE 101
#define BULLETS_LARGE_SPRITE 102
#define SHOTGUN_SPRITE 103
#define SHELLS_SMALL_SPRITE 104
#define SHELLS_LARGE_SPRITE 105
#define ROCKET_LAUNCHER_SPRITE 106
#define ROCKETS_SMALL_SPRITE 107
#define ROCKETS_LARGE_SPRITE 108
#define LASER_GUN_SPRITE 109
#define CELLS_SMALL_SPRITE 110
#define CELLS_LARGE_SPRITE 111
#define FLAMETHROWER_SPRITE 112
#define GASOLINE_SMALL_SPRITE 113
#define GASOLINE_LARGE_SPRITE 114
#define MORTAR_CANNON_SPRITE 115
#define MORTARS_SMALL_SPRITE 116
#define MORTARS_LARGE_SPRITE 117
#define BFG_SPRITE 118
#define PLASMA_SMALL_SPRITE 119
#define PLASMA_LARGE_SPRITE 120
#define MINELAYER_SPRITE 121
#define MINES_SMALL_SPRITE 122
#define MINES_LARGE_SPRITE 123
#define RED_KEYCARD_SPRITE 124
#define GREEN_KEYCARD_SPRITE 125
#define BLUE_KEYCARD_SPRITE 126
#define LETTER_W_SPRITE 127
#define LETTER_O_SPRITE 128
#define LETTER_R_SPRITE 129
#define LETTER_M_SPRITE 130
#define SODA_SIXPACK_SPRITE 131
#define DOUGHNUTS_SPRITE 132
#define BOX_OF_DOUGHNUTS_SPRITE 133
#define MUD_BEER_SPRITE 134

// Misc stuff
#define FLOATING_PLATFORM_SPRITE 144
#define SMALL_EXPLOSIVE_BARREL_SPRITE 145
#define SMALL_EXPLOSIVE_NUCLEAR_CRATE_SPRITE 146
#define PUSHABLE_CRATE_SPRITE 147
#define PERVERT_MESSAGE_SPRITE 148
#define GREY_DOOR_SPRITE 149
#define RED_DOOR_SPRITE 150
#define RED_DOOR_TOP_SPRITE 151
#define RED_DOOR_BOTTOM_SPRITE 152
#define GREEN_DOOR_SPRITE 153
#define GREEN_DOOR_TOP_SPRITE 154
#define GREEN_DOOR_BOTTOM_SPRITE 155
#define BLUE_DOOR_SPRITE 156
#define SMALL_FLAME_SPRITE 157
#define WATER_DROP_SPRITE 158

// Spawners
#define BLUE_SPARK_SPAWNER_SPRITE 160
#define RED_SPARK_SPAWNER_SPRITE 161
#define WHITE_SPARK_SPAWNER_SPRITE 162
#define GOLD_SPARK_SPAWNER_SPRITE 163
#define WATER_DROP_SPAWNER_SPRITE 164
#define NUCLEAR_BOMB_SPAWNER_SPRITE 165
#define RANDOM_REBEL_WORM_SPAWNER_SPRITE 166

#include "projec~1.h"  // Ai for bullets, rockets, lasers, etc...
#include "partic~1.h"  // Ai for particle effects like sparks and shrapnel
#include "enemy ai.h"  // Ai for all the enemies in the game
#include "civili~1.h"  // Ai for all the civilian worms, like the cops
#include "item ai.h"   // Ai for powerups and other gettable krap
#include "misc ai.h"   // Ai for everything else, like platforms and crates
#include "spawn ai.h"  // Ai for spawning objects

/******************\
|** SPAWN SPRITE **|
\******************/
void spawn_sprite(int sprite_type, int x_position_in_pixels, int y_position_in_pixels, float x_acceleration, float y_acceleration, unsigned char direction)
{
int sprite_loop;

if (number_of_sprites >= 1023) return;

for (sprite_loop = 0; sprite_loop < 1024; sprite_loop++) {
	if (sprites[sprite_loop].sprite_active == 0) {
		number_of_sprites++;
		sprites[sprite_loop].sprite_active = 1;  // This applies to all sprites
		sprites[sprite_loop].sprite_type = sprite_type;  // This applies to all sprites

		// Scan all sprite types and pick one
		if (sprite_type == WORMINATOR_BULLET_SPRITE) {
			sprites[sprite_loop].timer = 128;
			sprites[sprite_loop].width = 4, sprites[sprite_loop].height = 1;
			sprites[sprite_loop].frame = WORMINATOR_BULLET_FLY;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == WORMINATOR_ROCKET_SPRITE) {
			sprites[sprite_loop].width = 15, sprites[sprite_loop].height = 9;
			sprites[sprite_loop].frame = WORMINATOR_ROCKET_FLY;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == WORMINATOR_MORTAR_SPRITE) {
			sprites[sprite_loop].timer = 512 + rand() % 256;
			sprites[sprite_loop].width = 13, sprites[sprite_loop].height = 13;
			sprites[sprite_loop].frame = WORMINATOR_MORTAR_FLY;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == WORMINATOR_BFG_PLASMA_BALL_SPRITE) {
			sprites[sprite_loop].timer = 8;
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = BFG_PLASMA_BALL_FLY_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == WORMINATOR_MINE_SPRITE) {
			sprites[sprite_loop].timer = 256;
			sprites[sprite_loop].width = 10, sprites[sprite_loop].height = 5;
			sprites[sprite_loop].frame = WORMINATOR_MINE_ARM;
			sprites[sprite_loop].hit_points_left = .25;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == ENEMY_PLASMA_BULLET_SPRITE) {
			sprites[sprite_loop].timer = 128;
			sprites[sprite_loop].width = 4, sprites[sprite_loop].height = 1;
			sprites[sprite_loop].frame = ENEMY_PLASMA_BULLET_FLY;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].direction = direction;
			play_relative_sound(PLASMA_BULLET_FIRE_SOUND, sprite_loop);
			}

		else if (sprite_type == ENEMY_LASER_BOLT_SPRITE) {
			sprites[sprite_loop].timer = 192;  // Lasers have a range limit of 12 squares
			sprites[sprite_loop].width = 8, sprites[sprite_loop].height = 3;
			sprites[sprite_loop].frame = ENEMY_LASER_BOLT_FLY;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			sprites[sprite_loop].direction = direction;
			play_relative_sound(LASER_BOLT_FIRE_SOUND, sprite_loop);
			}

		else if (sprite_type == SMALL_ENEMY_ROCKET_SPRITE) {
			sprites[sprite_loop].width = 14, sprites[sprite_loop].height = 7;
			sprites[sprite_loop].frame = SMALL_ENEMY_ROCKET_FLY;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == LARGE_ENEMY_ROCKET_SPRITE) {
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 8;
			sprites[sprite_loop].frame = LARGE_ENEMY_ROCKET_FLY_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == ENEMY_MORTAR_SPRITE) {
			sprites[sprite_loop].timer = 512 + rand() % 256;
			sprites[sprite_loop].width = 12, sprites[sprite_loop].height = 13;
			sprites[sprite_loop].frame = ENEMY_MORTAR_FLY;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == ENEMY_TOXIN_SPRITE) {
			sprites[sprite_loop].width = 15, sprites[sprite_loop].height = 3;
			sprites[sprite_loop].frame = ENEMY_TOXIN_FLY;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == BONUS_FLYUP_50_POINT_SPRITE || sprite_type == BONUS_FLYUP_100_POINT_SPRITE || sprite_type == BONUS_FLYUP_250_POINT_SPRITE || sprite_type == BONUS_FLYUP_500_POINT_SPRITE) {
			sprites[sprite_loop].timer = 256;  // Flyup sprites die after 256 frames
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 5;
			if (sprite_type == BONUS_FLYUP_50_POINT_SPRITE) sprites[sprite_loop].frame = BONUS_FLYUP_50_POINT;
			if (sprite_type == BONUS_FLYUP_100_POINT_SPRITE) sprites[sprite_loop].frame = BONUS_FLYUP_100_POINT;
			if (sprite_type == BONUS_FLYUP_250_POINT_SPRITE) sprites[sprite_loop].frame = BONUS_FLYUP_250_POINT;
			if (sprite_type == BONUS_FLYUP_500_POINT_SPRITE) sprites[sprite_loop].frame = BONUS_FLYUP_500_POINT;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == SMALL_WHITE_SPARK_SPRITE || sprite_type == SMALL_BLUE_SPARK_SPRITE || sprite_type == SMALL_RED_SPARK_SPRITE || sprite_type == SMALL_GOLD_SPARK_SPRITE) {
			sprites[sprite_loop].timer = 32;  // Sparks hang around for 32 * 3 frames
			sprites[sprite_loop].width = 3, sprites[sprite_loop].height = 3;
			if (sprite_type == SMALL_WHITE_SPARK_SPRITE) sprites[sprite_loop].frame = SMALL_WHITE_SPARK_01;
			if (sprite_type == SMALL_BLUE_SPARK_SPRITE) sprites[sprite_loop].frame = SMALL_BLUE_SPARK_01;
			if (sprite_type == SMALL_RED_SPARK_SPRITE) sprites[sprite_loop].frame = SMALL_RED_SPARK_01;
			if (sprite_type == SMALL_GOLD_SPARK_SPRITE) sprites[sprite_loop].frame = SMALL_GOLD_SPARK_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			}

		else if (sprite_type == WATER_BUBBLE_SPRITE) {
			sprites[sprite_loop].frame = WATER_BUBBLE_01 + (rand() % 4);
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			}

		else if (sprite_type == WATER_SPLASH_SPRITE) {
			sprites[sprite_loop].timer = 8;
			sprites[sprite_loop].frame = WATER_SPLASH_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			}

		else if (sprite_type == SHRAPNEL_SPRITE) {
			sprites[sprite_loop].timer = 256;
			sprites[sprite_loop].frame = SHRAPNEL_01 + (rand() % 8);
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			}

		else if (sprite_type == GIB_SPRITE) {
			sprites[sprite_loop].timer = 256;
			sprites[sprite_loop].frame = GIB_01 + (rand() % 10);
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].x_acceleration = x_acceleration;
			sprites[sprite_loop].y_acceleration = y_acceleration;
			}

		else if (sprite_type == FLOATING_PLATFORM_SPRITE) {
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 4;
			sprites[sprite_loop].frame = FLOATING_PLATFORM_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == SMALL_RUNNER_ENEMY_SPRITE) {
			sprites[sprite_loop].timer = 16;
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 24;
			sprites[sprite_loop].frame = SMALL_RUNNER_RUN_01;
			sprites[sprite_loop].hit_points_left = 2;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels + 8;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .8;
			else sprites[sprite_loop].x_acceleration = -.8;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == ROBOTIC_DOG_ENEMY_SPRITE) {
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 24;
			sprites[sprite_loop].frame = ROBOTIC_DOG_WALK_01;
			sprites[sprite_loop].hit_points_left = 4;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels + 8;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .75;
			else sprites[sprite_loop].x_acceleration = -.75;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == SMALL_GUN_TURRET_ENEMY_SPRITE) {
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = SMALL_GUN_TURRET_REST;
			sprites[sprite_loop].hit_points_left = 6;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == MORTAR_GUN_TURRET_ENEMY_SPRITE) {
			sprites[sprite_loop].width = 48, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = MORTAR_GUN_TURRET_REST;
			sprites[sprite_loop].hit_points_left = 12;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == BIG_GUN_TURRET_ENEMY_SPRITE) {
			sprites[sprite_loop].width = 48, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = BIG_GUN_TURRET_REST;
			sprites[sprite_loop].hit_points_left = 18;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == FLYING_PROBE_ENEMY_SPRITE) {
			sprites[sprite_loop].timer = (rand() % 512) + 256;
			sprites[sprite_loop].width = 24, sprites[sprite_loop].height = 24;
			sprites[sprite_loop].frame = FLYING_PROBE_FLY;
			sprites[sprite_loop].hit_points_left = 2;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels - 4;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels - 4;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .5;
			else sprites[sprite_loop].x_acceleration = -.5;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == DECIMATER_ENEMY_SPRITE) {
			sprites[sprite_loop].width = 48, sprites[sprite_loop].height = 48;
			sprites[sprite_loop].frame = DECIMATER_WALK_01;
			sprites[sprite_loop].hit_points_left = 15;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .75;
			else sprites[sprite_loop].x_acceleration = -.75;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == GIANT_ROBOT_ENEMY_SPRITE) {
			sprites[sprite_loop].width = 64, sprites[sprite_loop].height = 64;
			sprites[sprite_loop].frame = GIANT_ROBOT_WALK_03;
			sprites[sprite_loop].hit_points_left = 50;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .25;
			else sprites[sprite_loop].x_acceleration = -.25;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == MECHANICAL_CRUSHER_ENEMY_SPRITE) {
			sprites[sprite_loop].timer = 256;
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 96;
			sprites[sprite_loop].frame = MECHANICAL_CRUSHER;
			sprites[sprite_loop].hit_points_left = 666;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == NUCLEAR_WORM_ENEMY_SPRITE) {
			sprites[sprite_loop].timer = 24;
			sprites[sprite_loop].width = 24, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = NUCLEAR_WORM_WALK_01;
			sprites[sprite_loop].hit_points_left = 5;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .95;
			else sprites[sprite_loop].x_acceleration = -.95;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == LASER_REBEL_WORM_ENEMY_SPRITE) {
			sprites[sprite_loop].timer = (rand() % 256) + 128;
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = LASER_REBEL_WORM_WALK_02;
			sprites[sprite_loop].hit_points_left = 2;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .75;
			else sprites[sprite_loop].x_acceleration = -.75;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == ROCKET_REBEL_WORM_ENEMY_SPRITE) {
			sprites[sprite_loop].timer = (rand() % 256) + 128;
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = ROCKET_REBEL_WORM_WALK_02;
			sprites[sprite_loop].hit_points_left = 2;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .75;
			else sprites[sprite_loop].x_acceleration = -.75;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == RIFLE_REBEL_WORM_ENEMY_SPRITE) {
			sprites[sprite_loop].timer = 16;
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = RIFLE_REBEL_WORM_WALK_02;
			sprites[sprite_loop].hit_points_left = 2;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .75;
			else sprites[sprite_loop].x_acceleration = -.75;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == BIG_GREEN_SLIME_BLOB_ENEMY_SPRITE) {
			sprites[sprite_loop].timer = 16;
			sprites[sprite_loop].width = 96, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = BIG_GREEN_SLIME_BLOB_01;
			sprites[sprite_loop].hit_points_left = 666;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .1;
			else sprites[sprite_loop].x_acceleration = -.1;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == GUMDROP_ENEMY_SPRITE) {
			sprites[sprite_loop].timer = 16;
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = GUMDROP_MOVE_01;
			sprites[sprite_loop].hit_points_left = .25;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .4;
			else sprites[sprite_loop].x_acceleration = -.4;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == BIG_NUCLEAR_BOMB_ENEMY_SPRITE) {
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 48;
			sprites[sprite_loop].frame = BIG_NUCLEAR_BOMB;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].direction = direction;
			play_relative_sound(BOMB_FALLING_SOUND, sprite_loop);
			}

		else if (sprite_type == SMALL_NUCLEAR_BOMB_ENEMY_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = SMALL_NUCLEAR_BOMB;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].direction = direction;
			play_relative_sound(BOMB_FALLING_SOUND, sprite_loop);
			}

		else if (sprite_type == FIREWORM_SEGMENT_ENEMY_SPRITE) {
			sprites[sprite_loop].timer = 8;
			sprites[sprite_loop].width = 8, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = SMALL_FLAME_BURN_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels + 4;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (direction == 0) sprites[sprite_loop].x_acceleration = .5;
			else sprites[sprite_loop].x_acceleration = -.5;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == FLAME_JET_ENEMY_SPRITE) {
			sprites[sprite_loop].timer = 64 + (rand() % 64);
			sprites[sprite_loop].width = 96, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = NULL;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			sprites[sprite_loop].direction = direction;
			}

		else if (sprite_type == WORM_GIRL_SPRITE) {
			sprites[sprite_loop].timer = 64;
			sprites[sprite_loop].action_state = 0;
			sprites[sprite_loop].width = 24, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = WORM_GIRL_STAND;
			sprites[sprite_loop].hit_points_left = 2;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (worminator_map.info_tile_grid[x_position_in_pixels / 16][y_position_in_pixels / 16] == left_turning_point_info_tile) {
				sprites[sprite_loop].direction = 1;
				worminator_map.info_tile_grid[x_position_in_pixels / 16][y_position_in_pixels / 16] = 0;
				}
			else sprites[sprite_loop].direction = 0;
			}

		else if (sprite_type == WORM_BOY_SPRITE) {
			sprites[sprite_loop].timer = 64;
			sprites[sprite_loop].action_state = 0;
			sprites[sprite_loop].width = 24, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = WORM_BOY_STAND;
			sprites[sprite_loop].hit_points_left = 2;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (worminator_map.info_tile_grid[x_position_in_pixels / 16][y_position_in_pixels / 16] == left_turning_point_info_tile) {
				sprites[sprite_loop].direction = 1;
				worminator_map.info_tile_grid[x_position_in_pixels / 16][y_position_in_pixels / 16] = 0;
				}
			else sprites[sprite_loop].direction = 0;
			}

		else if (sprite_type == WORM_STRIPPER_ONE_SPRITE) {
			sprites[sprite_loop].timer = 8;
			sprites[sprite_loop].action_state = 0;
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = WORM_STRIPPER_ONE_REST;
			sprites[sprite_loop].hit_points_left = 2;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (worminator_map.info_tile_grid[x_position_in_pixels / 16][y_position_in_pixels / 16] == left_turning_point_info_tile) {
				sprites[sprite_loop].direction = 1;
				worminator_map.info_tile_grid[x_position_in_pixels / 16][y_position_in_pixels / 16] = 0;
				}
			else sprites[sprite_loop].direction = 0;
			}

		else if (sprite_type == WORM_BLONDE_NUDE_ONE_SPRITE) {
			sprites[sprite_loop].timer = 8;
			sprites[sprite_loop].action_state = 0;
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = WORM_BLONDE_NUDE_ONE_REST;
			sprites[sprite_loop].hit_points_left = 2;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			if (worminator_map.info_tile_grid[x_position_in_pixels / 16][y_position_in_pixels / 16] == left_turning_point_info_tile) {
				sprites[sprite_loop].direction = 1;
				worminator_map.info_tile_grid[x_position_in_pixels / 16][y_position_in_pixels / 16] = 0;
				}
			else sprites[sprite_loop].direction = 0;
			}

		else if (sprite_type == SMALL_EXPLOSION_SPRITE) {
			sprites[sprite_loop].timer = 4;
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = SMALL_EXPLOSION_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			do_damage(x_position_in_pixels - 4, y_position_in_pixels - 4, 24, 24, 1);
			}

		else if (sprite_type == MEDIUM_EXPLOSION_SPRITE) {
			sprites[sprite_loop].timer = 4;
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = MEDIUM_EXPLOSION_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			do_damage(x_position_in_pixels, y_position_in_pixels, 32, 32, 1);
			}

		else if (sprite_type == BFG_PLASMA_BALL_EXPLOSION_SPRITE) {
			sprites[sprite_loop].timer = 8;
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = BFG_PLASMA_BALL_EXPLODE_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels - 4;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels - 4;
			do_damage(x_position_in_pixels, y_position_in_pixels, 40, 40, 25);
			}

		else if (sprite_type == SMALL_EXPLOSIVE_BARREL_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = SMALL_EXPLOSIVE_BARREL;
			sprites[sprite_loop].hit_points_left = .5;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == SMALL_EXPLOSIVE_NUCLEAR_CRATE_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = SMALL_EXPLOSIVE_NUCLEAR_CRATE;
			sprites[sprite_loop].hit_points_left = 1.5;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == MUSHROOM_CLOUD_SPRITE) {
			sprites[sprite_loop].timer = 16;
			sprites[sprite_loop].width = 128, sprites[sprite_loop].height = 128;
			sprites[sprite_loop].frame = MUSHROOM_CLOUD_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			do_damage(x_position_in_pixels, y_position_in_pixels, 128, 128, 10);
			play_relative_sound(NUCLEAR_EXPLOSION_SOUND, sprite_loop);
			quake_timer = 512;
			}

		else if (sprite_type == HEALTH_1_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = ITEM_HEALTH_1;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == HEALTH_2_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = ITEM_HEALTH_2;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == HEALTH_5_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = ITEM_HEALTH_5;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == HEALTH_10_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = ITEM_HEALTH_10;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == MINIGUN_SPRITE) {
			sprites[sprite_loop].width = 21, sprites[sprite_loop].height = 15;
			sprites[sprite_loop].frame = WORMINATOR_MINIGUN;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels + 5;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels + 1;
			}

		else if (sprite_type == BULLETS_SMALL_SPRITE || sprite_type == BULLETS_LARGE_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			if (sprite_type == BULLETS_SMALL_SPRITE) sprites[sprite_loop].frame = ITEM_BULLETS_SMALL;
			else sprites[sprite_loop].frame = ITEM_BULLETS_LARGE;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == SHOTGUN_SPRITE) {
			sprites[sprite_loop].width = 24, sprites[sprite_loop].height = 9;
			sprites[sprite_loop].frame = WORMINATOR_SHOTGUN;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels + 4;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels + 7;
			}

		else if (sprite_type == SHELLS_SMALL_SPRITE || sprite_type == SHELLS_LARGE_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			if (sprite_type == SHELLS_SMALL_SPRITE) sprites[sprite_loop].frame = ITEM_SHELLS_SMALL;
			else sprites[sprite_loop].frame = ITEM_SHELLS_LARGE;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == ROCKET_LAUNCHER_SPRITE) {
			sprites[sprite_loop].width = 24, sprites[sprite_loop].height = 14;
			sprites[sprite_loop].frame = WORMINATOR_ROCKET_LAUNCHER;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels + 4;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels + 2;
			}

		else if (sprite_type == ROCKETS_SMALL_SPRITE || sprite_type == ROCKETS_LARGE_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			if (sprite_type == ROCKETS_SMALL_SPRITE) sprites[sprite_loop].frame = ITEM_ROCKETS_SMALL;
			else sprites[sprite_loop].frame = ITEM_ROCKETS_LARGE;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == LASER_GUN_SPRITE) {
			sprites[sprite_loop].width = 27, sprites[sprite_loop].height = 10;
			sprites[sprite_loop].frame = WORMINATOR_LASER_GUN;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels + 2;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels + 6;
			}

		else if (sprite_type == CELLS_SMALL_SPRITE || sprite_type == CELLS_LARGE_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			if (sprite_type == CELLS_SMALL_SPRITE) sprites[sprite_loop].frame = ITEM_CELLS_SMALL;
			else sprites[sprite_loop].frame = ITEM_CELLS_LARGE;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == FLAMETHROWER_SPRITE) {
			sprites[sprite_loop].width = 23, sprites[sprite_loop].height = 10;
			sprites[sprite_loop].frame = WORMINATOR_FLAMETHROWER;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels + 4;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels + 6;
			}

		else if (sprite_type == GASOLINE_SMALL_SPRITE || sprite_type == GASOLINE_LARGE_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			if (sprite_type == GASOLINE_SMALL_SPRITE) sprites[sprite_loop].frame = ITEM_GASOLINE_SMALL;
			else sprites[sprite_loop].frame = ITEM_GASOLINE_LARGE;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == MORTAR_CANNON_SPRITE) {
			sprites[sprite_loop].width = 18, sprites[sprite_loop].height = 19;
			sprites[sprite_loop].frame = WORMINATOR_MORTAR_CANNON;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels + 7;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels - 3;
			}

		else if (sprite_type == MORTARS_SMALL_SPRITE || sprite_type == MORTARS_LARGE_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			if (sprite_type == MORTARS_SMALL_SPRITE) sprites[sprite_loop].frame = ITEM_MORTARS_SMALL;
			else sprites[sprite_loop].frame = ITEM_MORTARS_LARGE;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == BFG_SPRITE) {
			sprites[sprite_loop].width = 29, sprites[sprite_loop].height = 20;
			sprites[sprite_loop].frame = WORMINATOR_BFG;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels + 2;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels - 4;
			}

		else if (sprite_type == PLASMA_SMALL_SPRITE || sprite_type == PLASMA_LARGE_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			if (sprite_type == PLASMA_SMALL_SPRITE) sprites[sprite_loop].frame = ITEM_PLASMA_SMALL;
			else sprites[sprite_loop].frame = ITEM_PLASMA_LARGE;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == MINELAYER_SPRITE) {
			sprites[sprite_loop].width = 21, sprites[sprite_loop].height = 17;
			sprites[sprite_loop].frame = WORMINATOR_MINE_LAYER;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels + 5;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels - 1;
			}

		else if (sprite_type == MINES_SMALL_SPRITE || sprite_type == MINES_LARGE_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			if (sprite_type == MINES_SMALL_SPRITE) sprites[sprite_loop].frame = ITEM_MINES_SMALL;
			else sprites[sprite_loop].frame = ITEM_MINES_LARGE;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == RED_KEYCARD_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = RED_KEYCARD;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == GREEN_KEYCARD_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = GREEN_KEYCARD;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == BLUE_KEYCARD_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = BLUE_KEYCARD;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == LETTER_W_SPRITE || sprite_type == LETTER_O_SPRITE || sprite_type == LETTER_R_SPRITE || sprite_type == LETTER_M_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			if (sprite_type == LETTER_W_SPRITE) sprites[sprite_loop].frame = ITEM_LETTER_W;
			else if (sprite_type == LETTER_O_SPRITE) sprites[sprite_loop].frame = ITEM_LETTER_O;
			else if (sprite_type == LETTER_R_SPRITE) sprites[sprite_loop].frame = ITEM_LETTER_R;
			else sprites[sprite_loop].frame = ITEM_LETTER_M;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == SODA_SIXPACK_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = ITEM_SODA_SIXPACK;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == DOUGHNUTS_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = ITEM_DOUGHNUTS;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == BOX_OF_DOUGHNUTS_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = ITEM_BOX_OF_DOUGHNUTS;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == MUD_BEER_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = ITEM_MUD_BEER;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == SMALL_SPINNING_FAN_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = SMALL_FAN;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == MEDIUM_SPINNING_FAN_SPRITE) {
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = MEDIUM_FAN;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == LARGE_SPINNING_FAN_SPRITE) {
			sprites[sprite_loop].width = 48, sprites[sprite_loop].height = 48;
			sprites[sprite_loop].frame = LARGE_FAN;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == PUSHABLE_CRATE_SPRITE) {
			sprites[sprite_loop].width = 32, sprites[sprite_loop].height = 32;
			sprites[sprite_loop].frame = PUSHABLE_CRATE;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == PERVERT_MESSAGE_SPRITE) {
			sprites[sprite_loop].timer = 512;
			sprites[sprite_loop].width = 174, sprites[sprite_loop].height = 45;
			sprites[sprite_loop].frame = PERVERT_MESSAGE;
			sprites[sprite_loop].x_position_in_pixels = screen_x_position + 41;
			sprites[sprite_loop].y_position_in_pixels = screen_y_position + 16;
			}

		else if (sprite_type == GREY_DOOR_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 48;
			sprites[sprite_loop].frame = GREY_DOOR_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == RED_DOOR_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 48;
			sprites[sprite_loop].frame = RED_DOOR_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == RED_DOOR_TOP_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 64;
			sprites[sprite_loop].frame = RED_DOOR_03_TOP;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == RED_DOOR_BOTTOM_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 64;
			sprites[sprite_loop].frame = RED_DOOR_03_BOTTOM;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == GREEN_DOOR_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 48;
			sprites[sprite_loop].frame = GREEN_DOOR_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == GREEN_DOOR_TOP_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 64;
			sprites[sprite_loop].frame = GREEN_DOOR_03_TOP;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == GREEN_DOOR_BOTTOM_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 64;
			sprites[sprite_loop].frame = GREEN_DOOR_03_BOTTOM;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == BLUE_DOOR_SPRITE) {
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 48;
			sprites[sprite_loop].frame = BLUE_DOOR_01;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == WATER_DROP_SPRITE) {
			sprites[sprite_loop].width = 4, sprites[sprite_loop].height = 8;
			sprites[sprite_loop].frame = WATER_DROP;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == BLUE_SPARK_SPAWNER_SPRITE || sprite_type == RED_SPARK_SPAWNER_SPRITE || sprite_type == WHITE_SPARK_SPAWNER_SPRITE || sprite_type == GOLD_SPARK_SPAWNER_SPRITE) {
			sprites[sprite_loop].timer = (rand() % 1024) + 128;
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = NULL;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == WATER_DROP_SPAWNER_SPRITE) {
			sprites[sprite_loop].timer = (rand() % 1024) + 128;
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = NULL;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		else if (sprite_type == NUCLEAR_BOMB_SPAWNER_SPRITE) {
			sprites[sprite_loop].timer = (rand() % 256) + 128;
			sprites[sprite_loop].width = 16, sprites[sprite_loop].height = 16;
			sprites[sprite_loop].frame = NULL;
			sprites[sprite_loop].x_position_in_pixels = x_position_in_pixels;
			sprites[sprite_loop].y_position_in_pixels = y_position_in_pixels;
			}

		return;
		}
	}
}

/********************\
|** DESTROY SPRITE **|
\********************/
void destroy_sprite(int sprite_number)
{
int sprite_loop;
for (sprite_loop = sprite_number; sprite_loop < number_of_sprites; sprite_loop++) {
	sprites[sprite_loop].sprite_active = sprites[sprite_loop + 1].sprite_active;
	sprites[sprite_loop].sprite_type = sprites[sprite_loop + 1].sprite_type;
	sprites[sprite_loop].in_range = sprites[sprite_loop + 1].in_range;
	sprites[sprite_loop].timer = sprites[sprite_loop + 1].timer;
	sprites[sprite_loop].animation_state = sprites[sprite_loop + 1].animation_state;
	sprites[sprite_loop].width = sprites[sprite_loop + 1].width; 
	sprites[sprite_loop].height = sprites[sprite_loop + 1].height;
	sprites[sprite_loop].action_state = sprites[sprite_loop + 1].action_state;
	sprites[sprite_loop].frame = sprites[sprite_loop + 1].frame;
	sprites[sprite_loop].hit_points_left = sprites[sprite_loop + 1].hit_points_left;
	sprites[sprite_loop].x_position_in_pixels = sprites[sprite_loop + 1].x_position_in_pixels;
	sprites[sprite_loop].y_position_in_pixels = sprites[sprite_loop + 1].y_position_in_pixels;
	sprites[sprite_loop].x_acceleration = sprites[sprite_loop + 1].x_acceleration;
	sprites[sprite_loop].y_acceleration = sprites[sprite_loop + 1].y_acceleration;
	sprites[sprite_loop].direction = sprites[sprite_loop + 1].direction;
	sprites[sprite_loop].rotate_factor = sprites[sprite_loop + 1].rotate_factor;
	}

number_of_sprites--;
}

/*******************\
|** CLEAR SPRITES **|
\*******************/
void clear_sprites()
{
int sprite_loop;
for (sprite_loop = 0; sprite_loop < 1024; sprite_loop++) {
	sprites[sprite_loop].sprite_active = NULL;
	sprites[sprite_loop].sprite_type = NULL;
	sprites[sprite_loop].in_range = TRUE;
	sprites[sprite_loop].timer = NULL;
	sprites[sprite_loop].animation_state = NULL;
	sprites[sprite_loop].width = NULL;
	sprites[sprite_loop].height = NULL;
	sprites[sprite_loop].action_state = NULL;
	sprites[sprite_loop].frame = NULL;
	sprites[sprite_loop].hit_points_left = NULL;
	sprites[sprite_loop].x_position_in_pixels = NULL;
	sprites[sprite_loop].y_position_in_pixels = NULL;
	sprites[sprite_loop].x_acceleration = NULL;
	sprites[sprite_loop].y_acceleration = NULL;
	sprites[sprite_loop].direction = NULL;
	sprites[sprite_loop].rotate_factor = NULL;
	}

number_of_sprites = 0;
}

/********************\
|** UPDATE SPRITES **|
\********************/
void update_sprites()
{
int sprite_loop;
int tile_hit;

for (sprite_loop = 0; sprite_loop < number_of_sprites; sprite_loop++) {

	// One of Worminator's bullets flying in the air.
	if (sprites[sprite_loop].sprite_type == WORMINATOR_BULLET_SPRITE) worminator_bullet_ai(sprite_loop);

	// One of Worminator's rockets flying in the air.
	else if (sprites[sprite_loop].sprite_type == WORMINATOR_ROCKET_SPRITE) worminator_rocket_ai(sprite_loop);

	// One of Worminator's mortars flying in the air.
	else if (sprites[sprite_loop].sprite_type == WORMINATOR_MORTAR_SPRITE) worminator_mortar_ai(sprite_loop);

	// One of Worminator's BFG plasma balls flying in the air.
	else if (sprites[sprite_loop].sprite_type == WORMINATOR_BFG_PLASMA_BALL_SPRITE) worminator_bfg_plasma_ball_ai(sprite_loop);

	// One of Worminator's mines.
	else if (sprites[sprite_loop].sprite_type == WORMINATOR_MINE_SPRITE) worminator_mine_ai(sprite_loop);

	// One of an enemies plasma bullets flying in the air.
	else if (sprites[sprite_loop].sprite_type == ENEMY_PLASMA_BULLET_SPRITE) enemy_plasma_bullet_ai(sprite_loop);

	// One of an enemies laser colts flying in the air.
	else if (sprites[sprite_loop].sprite_type == ENEMY_LASER_BOLT_SPRITE) enemy_laser_bolt_ai(sprite_loop);

	// One of an enemies small rockets flying in the air.
	else if (sprites[sprite_loop].sprite_type == SMALL_ENEMY_ROCKET_SPRITE) small_enemy_rocket_ai(sprite_loop);

	// One of an enemies large rockets flying in the air.
	else if (sprites[sprite_loop].sprite_type == LARGE_ENEMY_ROCKET_SPRITE) large_enemy_rocket_ai(sprite_loop);

	// One of a mortar gun turret's mortars flying in the air.
	else if (sprites[sprite_loop].sprite_type == ENEMY_MORTAR_SPRITE) enemy_mortar_ai(sprite_loop);

	// One of a deciamter's toxic bulltes flying in the air.
	else if (sprites[sprite_loop].sprite_type == ENEMY_TOXIN_SPRITE) enemy_toxin_ai(sprite_loop);
	
	// Any of the following flyup sprites
	else if (sprites[sprite_loop].sprite_type == BONUS_FLYUP_50_POINT_SPRITE || sprites[sprite_loop].sprite_type == BONUS_FLYUP_100_POINT_SPRITE || sprites[sprite_loop].sprite_type == BONUS_FLYUP_250_POINT_SPRITE || sprites[sprite_loop].sprite_type == BONUS_FLYUP_500_POINT_SPRITE) flyup_sprite_ai(sprite_loop);

	// A small spark.  Can be used for snow, bullet hits, blood, rain, water fountains, etc...
	else if (sprites[sprite_loop].sprite_type == SMALL_WHITE_SPARK_SPRITE || sprites[sprite_loop].sprite_type == SMALL_BLUE_SPARK_SPRITE || sprites[sprite_loop].sprite_type == SMALL_RED_SPARK_SPRITE || sprites[sprite_loop].sprite_type == SMALL_GOLD_SPARK_SPRITE) small_spark_ai(sprite_loop);

	// A bubble in the water
	else if (sprites[sprite_loop].sprite_type == WATER_BUBBLE_SPRITE) water_bubble_ai(sprite_loop);

	// A water_splash
	else if (sprites[sprite_loop].sprite_type == WATER_SPLASH_SPRITE) water_splash_ai(sprite_loop);

	// A chunk of shrapnel or a gib
	else if (sprites[sprite_loop].sprite_type == SHRAPNEL_SPRITE || sprites[sprite_loop].sprite_type == GIB_SPRITE) shrapgib_ai(sprite_loop);

	// A flying platform that carries the worminator
	else if (sprites[sprite_loop].sprite_type == FLOATING_PLATFORM_SPRITE) floating_platform_ai(sprite_loop);

	// A small running enemy that climbs hills and is pretty smart
	else if (sprites[sprite_loop].sprite_type == SMALL_RUNNER_ENEMY_SPRITE) running_enemy_ai(sprite_loop);

	// An awesome robotic dog that walks back and forth and bites the worminator
	else if (sprites[sprite_loop].sprite_type == ROBOTIC_DOG_ENEMY_SPRITE) robotic_dog_enemy_ai(sprite_loop);

	// A small gun turret
	else if (sprites[sprite_loop].sprite_type == SMALL_GUN_TURRET_ENEMY_SPRITE) small_gun_turret_ai(sprite_loop);

	// A mortar gun turret
	else if (sprites[sprite_loop].sprite_type == MORTAR_GUN_TURRET_ENEMY_SPRITE) mortar_gun_turret_ai(sprite_loop);

	// A big gun turret
	else if (sprites[sprite_loop].sprite_type == BIG_GUN_TURRET_ENEMY_SPRITE) big_gun_turret_ai(sprite_loop);

	// A flying probe
	else if (sprites[sprite_loop].sprite_type == FLYING_PROBE_ENEMY_SPRITE) flying_probe_enemy_ai(sprite_loop);

	// A decimater
	else if (sprites[sprite_loop].sprite_type == DECIMATER_ENEMY_SPRITE) decimater_enemy_ai(sprite_loop);

	// A giant robot
	else if (sprites[sprite_loop].sprite_type == GIANT_ROBOT_ENEMY_SPRITE) giant_robot_enemy_ai(sprite_loop);

	// A mechanical crusher
	else if (sprites[sprite_loop].sprite_type == MECHANICAL_CRUSHER_ENEMY_SPRITE) mechanical_crusher_enemy_ai(sprite_loop);

	// A nuclear worm
	else if (sprites[sprite_loop].sprite_type == NUCLEAR_WORM_ENEMY_SPRITE) nuclear_worm_enemy_ai(sprite_loop);

	// A rebel worm with a laser gun
	else if (sprites[sprite_loop].sprite_type == LASER_REBEL_WORM_ENEMY_SPRITE) laser_rebel_worm_enemy_ai(sprite_loop);

	// A rebel worm with a rocket launcher
	else if (sprites[sprite_loop].sprite_type == ROCKET_REBEL_WORM_ENEMY_SPRITE) rocket_rebel_worm_enemy_ai(sprite_loop);

	// A rebel worm with a rifle
	else if (sprites[sprite_loop].sprite_type == RIFLE_REBEL_WORM_ENEMY_SPRITE) rifle_rebel_worm_enemy_ai(sprite_loop);

	// A big ugly green slime blob that smooshes itself around
	else if (sprites[sprite_loop].sprite_type == BIG_GREEN_SLIME_BLOB_ENEMY_SPRITE) big_green_slime_blob_enemy_ai(sprite_loop);

	// A funny little red slime blob that smooshes itself around and looks like a gumdrop
	else if (sprites[sprite_loop].sprite_type == GUMDROP_ENEMY_SPRITE) gumdrop_enemy_ai(sprite_loop);

	// Either of the two nuclear bombs that can be dropped
	else if (sprites[sprite_loop].sprite_type == BIG_NUCLEAR_BOMB_ENEMY_SPRITE || sprites[sprite_loop].sprite_type == SMALL_NUCLEAR_BOMB_ENEMY_SPRITE) nuclear_bomb_enemy_ai(sprite_loop);

	// A segment of the all powerful fire worm!!!
	else if (sprites[sprite_loop].sprite_type == FIREWORM_SEGMENT_ENEMY_SPRITE) fireworm_segment_enemy_ai(sprite_loop);

	// A nasty flame jet
	else if (sprites[sprite_loop].sprite_type == FLAME_JET_ENEMY_SPRITE) flame_jet_enemy_ai(sprite_loop);

	// A worm girl
	else if (sprites[sprite_loop].sprite_type == WORM_GIRL_SPRITE) worm_girl_ai(sprite_loop);

	// A worm boy
	else if (sprites[sprite_loop].sprite_type == WORM_BOY_SPRITE) worm_boy_ai(sprite_loop);

	// A worm stripper!!!
	else if (sprites[sprite_loop].sprite_type == WORM_STRIPPER_ONE_SPRITE) worm_stripper_one_ai(sprite_loop);

	// A nude blonde worm slut!!!
	else if (sprites[sprite_loop].sprite_type == WORM_BLONDE_NUDE_ONE_SPRITE) worm_blonde_nude_one_ai(sprite_loop);

	// A small (16x16) explosion
	else if (sprites[sprite_loop].sprite_type == SMALL_EXPLOSION_SPRITE) small_explosion_ai(sprite_loop);

	// A medium (32x32) explosion
	else if (sprites[sprite_loop].sprite_type == MEDIUM_EXPLOSION_SPRITE) medium_explosion_ai(sprite_loop);

	// A small (16x32) explosive barrel
	else if (sprites[sprite_loop].sprite_type == SMALL_EXPLOSIVE_BARREL_SPRITE) small_explosive_barrel_ai(sprite_loop);

	// A small (16x32) explosive nuclear crate
	else if (sprites[sprite_loop].sprite_type == SMALL_EXPLOSIVE_NUCLEAR_CRATE_SPRITE) small_explosive_nuclear_crate_ai(sprite_loop);

	// A giant (128x128) mushroom cloud
	else if (sprites[sprite_loop].sprite_type == MUSHROOM_CLOUD_SPRITE) mushroom_cloud_ai(sprite_loop);

	// A BFG plasma ball explosion
	else if (sprites[sprite_loop].sprite_type == BFG_PLASMA_BALL_EXPLOSION_SPRITE) bfg_plasma_ball_explosion_ai(sprite_loop);

	// Any of the health packs that the worminator picks up
	else if (sprites[sprite_loop].sprite_type >= HEALTH_1_SPRITE && sprites[sprite_loop].sprite_type <= HEALTH_10_SPRITE) getable_health_ai(sprite_loop);

	// The minigun that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == MINIGUN_SPRITE) minigun_ai(sprite_loop);

	// The bullets used for ammo that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == BULLETS_SMALL_SPRITE || sprites[sprite_loop].sprite_type == BULLETS_LARGE_SPRITE) getable_bullets_ai(sprite_loop);

	// The shotgun that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == SHOTGUN_SPRITE) shotgun_ai(sprite_loop);

	// The shells used for ammo that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == SHELLS_SMALL_SPRITE || sprites[sprite_loop].sprite_type == SHELLS_LARGE_SPRITE) getable_shells_ai(sprite_loop);

	// The rocket launcher that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == ROCKET_LAUNCHER_SPRITE) rocket_launcher_ai(sprite_loop);

	// The rockets used for ammo that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == ROCKETS_SMALL_SPRITE || sprites[sprite_loop].sprite_type == ROCKETS_LARGE_SPRITE) getable_rockets_ai(sprite_loop);

	// The laser gun that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == LASER_GUN_SPRITE) laser_gun_ai(sprite_loop);

	// The cells used for ammo that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == CELLS_SMALL_SPRITE || sprites[sprite_loop].sprite_type == CELLS_LARGE_SPRITE) getable_cells_ai(sprite_loop);

	// The flamethrower that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == FLAMETHROWER_SPRITE) flamethrower_ai(sprite_loop);

	// The gas used for ammo that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == GASOLINE_SMALL_SPRITE || sprites[sprite_loop].sprite_type == GASOLINE_LARGE_SPRITE) getable_gasoline_ai(sprite_loop);

	// The mortar cannon that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == MORTAR_CANNON_SPRITE) mortar_cannon_ai(sprite_loop);

	// The mortars used for ammo that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == MORTARS_SMALL_SPRITE || sprites[sprite_loop].sprite_type == MORTARS_LARGE_SPRITE) getable_mortars_ai(sprite_loop);

	// The BFG that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == BFG_SPRITE) bfg_ai(sprite_loop);

	// The plasma used for ammo that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == PLASMA_SMALL_SPRITE || sprites[sprite_loop].sprite_type == PLASMA_LARGE_SPRITE) getable_plasma_ai(sprite_loop);

	// The minelayer that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == MINELAYER_SPRITE) minelayer_ai(sprite_loop);

	// The mines used for ammo that the worminator picks up
	else if (sprites[sprite_loop].sprite_type == MINES_SMALL_SPRITE || sprites[sprite_loop].sprite_type == MINES_LARGE_SPRITE) getable_mines_ai(sprite_loop);

	// A red keycard
	else if (sprites[sprite_loop].sprite_type == RED_KEYCARD_SPRITE) red_keycard_ai(sprite_loop);

	// A green keycard
	else if (sprites[sprite_loop].sprite_type == GREEN_KEYCARD_SPRITE) green_keycard_ai(sprite_loop);

	// A blue keycard
	else if (sprites[sprite_loop].sprite_type == BLUE_KEYCARD_SPRITE) blue_keycard_ai(sprite_loop);

	// A W, O, R, or M letter that the worminator can pick up
	else if (sprites[sprite_loop].sprite_type == LETTER_W_SPRITE || sprites[sprite_loop].sprite_type == LETTER_O_SPRITE || sprites[sprite_loop].sprite_type == LETTER_R_SPRITE || sprites[sprite_loop].sprite_type == LETTER_M_SPRITE) letter_ai(sprite_loop);

	// A soda sixpack
	else if (sprites[sprite_loop].sprite_type == SODA_SIXPACK_SPRITE) soda_sixpack_ai(sprite_loop);

	// Some doughnuts
	else if (sprites[sprite_loop].sprite_type == DOUGHNUTS_SPRITE) doughnuts_ai(sprite_loop);

	// A box of doughnuts
	else if (sprites[sprite_loop].sprite_type == BOX_OF_DOUGHNUTS_SPRITE) box_of_doughnuts_ai(sprite_loop);

	// A bottle of mud beer
	else if (sprites[sprite_loop].sprite_type == MUD_BEER_SPRITE) mud_beer_ai(sprite_loop);

	// Any of the spinning fans
	else if (sprites[sprite_loop].sprite_type == SMALL_SPINNING_FAN_SPRITE || sprites[sprite_loop].sprite_type == MEDIUM_SPINNING_FAN_SPRITE || sprites[sprite_loop].sprite_type == LARGE_SPINNING_FAN_SPRITE) basic_spinning_sprite_ai(sprite_loop);

	// A pushable crate that you can stand on
	else if (sprites[sprite_loop].sprite_type == PUSHABLE_CRATE_SPRITE) pushable_crate_ai(sprite_loop);

	// The pervert message
	else if (sprites[sprite_loop].sprite_type == PERVERT_MESSAGE_SPRITE) pervert_message_ai(sprite_loop);

	// A grey door
	else if (sprites[sprite_loop].sprite_type == GREY_DOOR_SPRITE) grey_door_ai(sprite_loop);

	// A red door
	else if (sprites[sprite_loop].sprite_type == RED_DOOR_SPRITE) red_door_ai(sprite_loop);

	// A top half of a two part red door
	else if (sprites[sprite_loop].sprite_type == RED_DOOR_TOP_SPRITE) red_door_top_ai(sprite_loop);

	// A bottom half of a two part red door
	else if (sprites[sprite_loop].sprite_type == RED_DOOR_BOTTOM_SPRITE) red_door_bottom_ai(sprite_loop);

	// A green door
	else if (sprites[sprite_loop].sprite_type == GREEN_DOOR_SPRITE) green_door_ai(sprite_loop);

	// A top half of a two part green door
	else if (sprites[sprite_loop].sprite_type == GREEN_DOOR_TOP_SPRITE) green_door_top_ai(sprite_loop);

	// A bottom half of a two part green door
	else if (sprites[sprite_loop].sprite_type == GREEN_DOOR_BOTTOM_SPRITE) green_door_bottom_ai(sprite_loop);

	// A blue door
	else if (sprites[sprite_loop].sprite_type == BLUE_DOOR_SPRITE) blue_door_ai(sprite_loop);

	// A water drop 
	else if (sprites[sprite_loop].sprite_type == WATER_DROP_SPRITE) water_drop_ai(sprite_loop);

	// A spark spawner of any color
	else if (sprites[sprite_loop].sprite_type == BLUE_SPARK_SPAWNER_SPRITE || sprites[sprite_loop].sprite_type == RED_SPARK_SPAWNER_SPRITE || sprites[sprite_loop].sprite_type == WHITE_SPARK_SPAWNER_SPRITE || sprites[sprite_loop].sprite_type == GOLD_SPARK_SPAWNER_SPRITE) spark_spawner_ai(sprite_loop);

	// A water drop spawner
	else if (sprites[sprite_loop].sprite_type == WATER_DROP_SPAWNER_SPRITE) water_drop_spawner_ai(sprite_loop);

	// A nuclear bomb spawner
	else if (sprites[sprite_loop].sprite_type == NUCLEAR_BOMB_SPAWNER_SPRITE) nuclear_bomb_spawner_ai(sprite_loop);
	}
}

/********************************\
|** SPRITE IS TOUCHING PLAYER? **|
\********************************/
int sprite_is_touching_player(int sprite_number)
{
int x_difference_one = 0, x_difference_two = 0;
int sx, sy, sw, sh, px, py;

if (player.health_bars_left < 1) return FALSE;

sx = (int)sprites[sprite_number].x_position_in_pixels;
sy = (int)sprites[sprite_number].y_position_in_pixels;
sw = sprites[sprite_number].width - 1;
sh = sprites[sprite_number].height - 1;

px = (int)player.x_position_in_pixels;
py = (int)player.y_position_in_pixels;

// Since most checks will fail, if we can drop most calls withough doing any compex checks,
// we should get a lot of speed gain.  This checks to see if the worm is near the sprite or not.
if (sx > px && sx - px >= 32) return FALSE;
else if (sx <= px && px - sx >= sw) return FALSE;
if (sy > py && sy - py >= 32) return FALSE;
else if (sy <= py && py - sy >= sh) return FALSE;

return TRUE;
}

/***************\
|** DO DAMAGE **|
\***************/
void do_damage(int x, int y, int w, int h, float damage_amount)
{
char do_damage;
int sprite_loop;
int sx, sy, sw, sh;
int px = player.x_position_in_pixels, py = player.y_position_in_pixels;

// Check player
if (damage_amount >= 1) {
	do_damage = TRUE;
	if (x > px && x - px >= 32) do_damage = FALSE;
	else if (x <= px && px - x >= w) do_damage = FALSE;
	if (y > py && y - py >= 32) do_damage = FALSE;
	else if (y <= py && py - y >= h) do_damage = FALSE;
	if (do_damage == TRUE) hurt_player(damage_amount * -1);
	}

// Check all sprites
for (sprite_loop = 0; sprite_loop < number_of_sprites; sprite_loop++) {
	if (sprites[sprite_loop].hit_points_left > 0) {
		do_damage = TRUE;

		sx = sprites[sprite_loop].x_position_in_pixels;
		sy = sprites[sprite_loop].y_position_in_pixels;
		sw = sprites[sprite_loop].width;
		sh = sprites[sprite_loop].height;

		// This is the actual collision detection
		if (x > sx && x - sx >= sw) do_damage = FALSE;
		else if (x <= sx && sx - x >= w) do_damage = FALSE;
		if (y > sy && y - sy >= sh) do_damage = FALSE;
		else if (y <= sy && sy - y >= h) do_damage = FALSE;

		if (do_damage == TRUE) sprites[sprite_loop].hit_points_left -= damage_amount;
		}
	}
}

/*******************************\
|** SPRITE IS TOUCHING SPRITE **|
\*******************************/
int sprite_is_touching_sprite(int sprite_number, char flag)
{
char sprite_hit;
int sprite_loop;
int msx, msy, msw, msh;
int sx, sy, sw, sh;

// Flag notes
// 0 = return all sprites
// 1 = return only damageable sprites

// These are the coordinates of the master sprite we are testing against
msx = sprites[sprite_number].x_position_in_pixels;
msy = sprites[sprite_number].y_position_in_pixels;
msw = sprites[sprite_number].width;
msh = sprites[sprite_number].height;

// Check all sprites
for (sprite_loop = 0; sprite_loop < number_of_sprites; sprite_loop++) {
	if (flag == 0 || sprites[sprite_loop].hit_points_left > 0) {
		sprite_hit = TRUE;
		sx = sprites[sprite_loop].x_position_in_pixels;
		sy = sprites[sprite_loop].y_position_in_pixels;
		sw = sprites[sprite_loop].width;
		sh = sprites[sprite_loop].height;

		// This is the actual collision detection
		if (msx > sx && msx - sx >= sw) sprite_hit = FALSE;
		else if (msx <= sx && sx - msx >= msw) sprite_hit = FALSE;
		if (msy > sy && msy - sy >= sh) sprite_hit = FALSE;
		else if (msy <= sy && sy - msy >= msh) sprite_hit = FALSE;

		if (sprite_hit == TRUE && sprite_loop != sprite_number) {
			if (flag == 0) return sprite_loop;
			else if (flag == 1 && sprites[sprite_loop].hit_points_left > 0) return sprite_loop;
			}
		}
	}

// No sprite was hit if we got here
return -1;
}

/*********************************\
|** CHECK SPRITE TURINIG ARROWS **|
\*********************************/
void check_sprite_turning_arrows(int sprite_number, char flag, float x_speed_to_set, float y_speed_to_set)
{
int tile_hit;
int sx, sy;

// Flag notes
// 0 = Check all arrow types
// 1 = Check all arrow types, but use special code on diagonal arrows that change x direction
// 2 = Check only diagonals and left and right arrows
// 3 = Check only cardnal direction arrows
// 4 = Check only diagonals
// 5 = Check only left and right arrows
// 6 = Check only up and down arrows

if (sprites[sprite_number].sprite_type == ROBOTIC_DOG_ENEMY_SPRITE) {
	sx = sprites[sprite_number].x_position_in_pixels;
	sy = sprites[sprite_number].y_position_in_pixels - 8;
	}
else if (sprites[sprite_number].sprite_type == FLYING_PROBE_ENEMY_SPRITE) {
	sx = sprites[sprite_number].x_position_in_pixels + 4;
	sy = sprites[sprite_number].y_position_in_pixels + 4;
	}
else if (sprites[sprite_number].sprite_type == FIREWORM_SEGMENT_ENEMY_SPRITE) {
	sx = sprites[sprite_number].x_position_in_pixels - 4;
	sy = sprites[sprite_number].y_position_in_pixels;
	}
else {
	sx = sprites[sprite_number].x_position_in_pixels;
	sy = sprites[sprite_number].y_position_in_pixels;
	}

tile_hit = worminator_map.info_tile_grid[(int)(sx / 16)][(int)(sy / 16)];
if (worminator_map.info_tile_grid[(int)((sx + 15) / 16)][(int)(sy / 16)] != tile_hit) return;
if (worminator_map.info_tile_grid[(int)(sx / 16)][(int)((sy + 15) / 16)] != tile_hit) return;

if (tile_hit < up_turning_point_info_tile || tile_hit > down_right_turning_point_info_tile) return;

if (flag == 0) {
	// Set these to zero for simpler code
	sprites[sprite_number].x_acceleration = 0;
	sprites[sprite_number].y_acceleration = 0;

	// Check the four cardinal direction arrows
	if (tile_hit == up_turning_point_info_tile) sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
	else if (tile_hit == down_turning_point_info_tile) sprites[sprite_number].y_acceleration = y_speed_to_set;
	else if (tile_hit == right_turning_point_info_tile) sprites[sprite_number].x_acceleration = x_speed_to_set, sprites[sprite_number].direction = 0;
	else if (tile_hit == left_turning_point_info_tile) sprites[sprite_number].x_acceleration = x_speed_to_set * -1, sprites[sprite_number].direction = 1;

	// Check the four multidirectional arrows
	else if (tile_hit == up_right_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
		sprites[sprite_number].x_acceleration = x_speed_to_set;
		sprites[sprite_number].direction = 0;
		}
	else if (tile_hit == down_left_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set;
		sprites[sprite_number].x_acceleration = x_speed_to_set * -1;
		sprites[sprite_number].direction = 1;
		}
	else if (tile_hit == up_left_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
		sprites[sprite_number].x_acceleration = x_speed_to_set * -1;
		sprites[sprite_number].direction = 1;
		}
	else if (tile_hit == down_right_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set;
		sprites[sprite_number].x_acceleration = x_speed_to_set;
		sprites[sprite_number].direction = 0;
		}

	// There is no need to continue on with this function and waste 6 ifs
	return;
	}

if (flag == 1) {
	// Set these to zero for simpler code
	sprites[sprite_number].x_acceleration = 0;
	sprites[sprite_number].y_acceleration = 0;

	// Check the four cardinal direction arrows
	if (tile_hit == up_turning_point_info_tile) sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
	else if (tile_hit == down_turning_point_info_tile) sprites[sprite_number].y_acceleration = y_speed_to_set;
	else if (tile_hit == right_turning_point_info_tile) sprites[sprite_number].x_acceleration = x_speed_to_set, sprites[sprite_number].direction = 0;
	else if (tile_hit == left_turning_point_info_tile) sprites[sprite_number].x_acceleration = x_speed_to_set * -1, sprites[sprite_number].direction = 1;

	// Check the four multidirectional arrows
	if (sprites[sprite_number].direction == 0) {
		if (tile_hit == up_right_turning_point_info_tile) {
			sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
			sprites[sprite_number].x_acceleration = x_speed_to_set;
			}
		else if (tile_hit == down_left_turning_point_info_tile) {
			sprites[sprite_number].x_acceleration = x_speed_to_set;
			sprites[sprite_number].y_acceleration = 0;
			}
		else if (tile_hit == up_left_turning_point_info_tile) {
			sprites[sprite_number].x_acceleration = x_speed_to_set;
			sprites[sprite_number].y_acceleration = 0;
			}
		else if (tile_hit == down_right_turning_point_info_tile) {
			sprites[sprite_number].y_acceleration = y_speed_to_set;
			sprites[sprite_number].x_acceleration = x_speed_to_set;
			}

		}
	if (sprites[sprite_number].direction == 1) {
		if (tile_hit == up_right_turning_point_info_tile) {
			sprites[sprite_number].x_acceleration = x_speed_to_set * -1;
			sprites[sprite_number].y_acceleration = 0;
			}
		else if (tile_hit == down_left_turning_point_info_tile) {
			sprites[sprite_number].y_acceleration = y_speed_to_set;
			sprites[sprite_number].x_acceleration = x_speed_to_set * -1;
			}
		else if (tile_hit == up_left_turning_point_info_tile) {
			sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
			sprites[sprite_number].x_acceleration = x_speed_to_set * -1;
			}
		else if (tile_hit == down_right_turning_point_info_tile) {
			sprites[sprite_number].x_acceleration = x_speed_to_set * -1;
			sprites[sprite_number].y_acceleration = y_speed_to_set;
			}
		}

	// There is no need to continue on with this function and waste 5 ifs
	return;
	}

if (flag == 2) {
	// Set these to zero for simpler code
	sprites[sprite_number].x_acceleration = 0;
	sprites[sprite_number].y_acceleration = 0;

	// Check the four cardinal direction arrows
	if (tile_hit == right_turning_point_info_tile) sprites[sprite_number].x_acceleration = x_speed_to_set, sprites[sprite_number].direction = 0;
	else if (tile_hit == left_turning_point_info_tile) sprites[sprite_number].x_acceleration = x_speed_to_set * -1, sprites[sprite_number].direction = 1;

	// Check the four multidirectional arrows
	else if (tile_hit == up_right_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
		sprites[sprite_number].x_acceleration = x_speed_to_set;
		sprites[sprite_number].direction = 0;
		}
	else if (tile_hit == down_left_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set;
		sprites[sprite_number].x_acceleration = x_speed_to_set * -1;
		sprites[sprite_number].direction = 1;
		}
	else if (tile_hit == up_left_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
		sprites[sprite_number].x_acceleration = x_speed_to_set * -1;
		sprites[sprite_number].direction = 1;
		}
	else if (tile_hit == down_right_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set;
		sprites[sprite_number].x_acceleration = x_speed_to_set;
		sprites[sprite_number].direction = 0;
		}

	// There is no need to continue on with this function and waste 4 ifs
	return;
	}

if (flag == 3) {
	// Set these to zero for simpler code
	sprites[sprite_number].x_acceleration = 0;
	sprites[sprite_number].y_acceleration = 0;

	// Check the four cardinal direction arrows
	if (tile_hit == up_turning_point_info_tile) sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
	else if (tile_hit == down_turning_point_info_tile) sprites[sprite_number].y_acceleration = y_speed_to_set;
	else if (tile_hit == right_turning_point_info_tile) sprites[sprite_number].x_acceleration = x_speed_to_set, sprites[sprite_number].direction = 0;
	else if (tile_hit == left_turning_point_info_tile) sprites[sprite_number].x_acceleration = x_speed_to_set * -1, sprites[sprite_number].direction = 1;

	// There is no need to continue on with this function and waste 3 ifs
	return;
	}

if (flag == 4) {
	// Check the four multidirectional arrows
	if (tile_hit == up_right_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
		sprites[sprite_number].x_acceleration = x_speed_to_set;
		sprites[sprite_number].direction = 0;
		}
	else if (tile_hit == down_left_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set;
		sprites[sprite_number].x_acceleration = x_speed_to_set * -1;
		sprites[sprite_number].direction = 1;
		}
	else if (tile_hit == up_left_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
		sprites[sprite_number].x_acceleration = x_speed_to_set * -1;
		sprites[sprite_number].direction = 1;
		}
	else if (tile_hit == down_right_turning_point_info_tile) {
		sprites[sprite_number].y_acceleration = y_speed_to_set;
		sprites[sprite_number].x_acceleration = x_speed_to_set;
		sprites[sprite_number].direction = 0;
		}

	// There is no need to continue on with this function and waste 2 ifs
	return;
	}

if (flag == 5) {
	// Set these to zero for simpler code
	sprites[sprite_number].x_acceleration = 0;
	sprites[sprite_number].y_acceleration = 0;

	// Check the four cardinal direction arrows
	if (tile_hit == right_turning_point_info_tile) sprites[sprite_number].x_acceleration = x_speed_to_set, sprites[sprite_number].direction = 0;
	else if (tile_hit == left_turning_point_info_tile) sprites[sprite_number].x_acceleration = x_speed_to_set * -1, sprites[sprite_number].direction = 1;

	// There is no need to continue on with this function and waste an if
	return;
	}

if (flag == 6) {
	// Set these to zero for simpler code
	sprites[sprite_number].x_acceleration = 0;
	sprites[sprite_number].y_acceleration = 0;

	// Check the four cardinal direction arrows
	if (tile_hit == up_turning_point_info_tile) sprites[sprite_number].y_acceleration = y_speed_to_set * -1;
	else if (tile_hit == down_turning_point_info_tile) sprites[sprite_number].y_acceleration = y_speed_to_set;
	}

}

/*********************************\
|** CHECK POINT COLLISIONS GRID **|
\*********************************/
int check_point_collisions_grid(int sprite_number, int x, int y, char type_flag)
{
char spawn_loop;
int tile_hit;

// Type flag notes:
// 0 = object counts as an enemy (block enemy tiles work)
// 1 = object counts as a projectile (breaks breakable walls)
// 2 = object counts as a projectile, but won't break breakable walls
// 3 = object has advanced ai (return true for solid or the value of the tile)
// 4 = object is "other" (does none of the above)

tile_hit = worminator_map.info_tile_grid[x / 16][y / 16];

if (tile_hit == blank_info_tile) return FALSE;

if (tile_hit == solid_info_tile) return TRUE;

if (sprites[sprite_number].x_acceleration < 0) {
	if (tile_hit == solid_from_right_no_ammo_info_tile) return TRUE;
	if (tile_hit == solid_from_right_allow_ammo_info_tile && type_flag != 1 && type_flag != 2) return TRUE;
	}
else if (sprites[sprite_number].x_acceleration > 0) {
	if (tile_hit == solid_from_left_no_ammo_info_tile) return TRUE;
	if (tile_hit == solid_from_left_allow_ammo_info_tile && type_flag != 1 && type_flag != 2) return TRUE;
	}

if (sprites[sprite_number].y_acceleration < 0) {
	if (tile_hit == solid_from_bottom_no_ammo_info_tile) return TRUE;
	if (tile_hit == solid_from_bottom_allow_ammo_info_tile && type_flag != 1 && type_flag != 2) return TRUE;
	}
else if (sprites[sprite_number].y_acceleration > 0) {
	if (tile_hit == solid_from_top_no_ammo_info_tile || tile_hit == solid_from_top_no_drop_info_tile) return TRUE;
	if (tile_hit == solid_from_top_allow_ammo_info_tile && type_flag != 1 && type_flag != 2) return TRUE;
	}

if (tile_hit == painful_from_top_info_tile) return TRUE;
if (tile_hit == painful_from_bottom_info_tile) return TRUE;
if (type_flag != 3 && type_flag != 0) {
	if (tile_hit == slope_up_left_to_right_45_info_tile) return TRUE;
	if (tile_hit == slope_up_left_to_right_225_left_info_tile) return FALSE;
	if (tile_hit == slope_up_left_to_right_225_right_info_tile) return TRUE;
	if (tile_hit == slope_up_right_to_left_45_info_tile) return TRUE;
	if (tile_hit == slope_up_right_to_left_225_left_info_tile) return TRUE;
	if (tile_hit == slope_up_right_to_left_225_right_info_tile) return FALSE;
	if (tile_hit == slope_filler_info_tile) return TRUE;
	}
else if (type_flag == 3) {
	if (tile_hit == slope_up_left_to_right_45_info_tile) return slope_up_left_to_right_45_info_tile;
	if (tile_hit == slope_up_left_to_right_225_left_info_tile) return slope_up_left_to_right_225_left_info_tile;
	if (tile_hit == slope_up_left_to_right_225_right_info_tile) return slope_up_left_to_right_225_right_info_tile;
	if (tile_hit == slope_up_right_to_left_45_info_tile) return slope_up_right_to_left_45_info_tile;
	if (tile_hit == slope_up_right_to_left_225_left_info_tile) return slope_up_right_to_left_225_left_info_tile;
	if (tile_hit == slope_up_right_to_left_225_right_info_tile) return slope_up_right_to_left_225_right_info_tile;
	if (tile_hit == slope_filler_info_tile) return slope_filler_info_tile;
	}
if (tile_hit == breakable_wall_info_tile && type_flag == 1) {
	for (spawn_loop = 0; spawn_loop < 16; spawn_loop++) spawn_sprite(SMALL_WHITE_SPARK_SPRITE, ((x / 16) * 16) + 8,  ((y / 16) * 16) + 8, (float)((rand() % 20) - 10.00) / 10.00, (float)((rand() % 20) - 10.00) / 10.00, NULL);
	worminator_map.foreground_tile_grid[x / 16][y / 16] = 0;
	worminator_map.info_tile_grid[x / 16][y / 16] = blank_info_tile;
	return TRUE;
	}
else if (tile_hit == breakable_wall_info_tile && type_flag != 1) return TRUE;
if (tile_hit == block_enemy_info_tile && (type_flag == 0 || type_flag == 3)) return TRUE;

else if (tile_hit == conveyor_belt_right_info_tile) return TRUE;
else if (tile_hit == conveyor_belt_left_info_tile) return TRUE;

else if (tile_hit == half_slippery_info_tile) return TRUE;
else if (tile_hit == mostly_slippery_info_tile) return TRUE;

// If we GOT to here, there was no collision with anything.
return FALSE;
}

/*********************\
|** SPAWN SHRAPGIBS **|
\*********************/
void spawn_shrapgibs(int x, int y, unsigned char number_of_shraps, unsigned char number_of_gibs)
{
unsigned char spawn_loop;

for (spawn_loop = 0; spawn_loop < number_of_shraps; spawn_loop++) {
	spawn_sprite(SHRAPNEL_SPRITE, x, y, (float)((rand() % 20) - 10) / 10.00 * 1.5, (float)((rand() % 20) - 10) / 10.00 * 1.5, NULL);
	}

for (spawn_loop = 0; spawn_loop < number_of_gibs; spawn_loop++) {
	spawn_sprite(GIB_SPRITE, x, y, (float)((rand() % 20) - 10) / 10.00 * 1.5, (float)((rand() % 20) - 10) / 10.00 * 1.5, NULL);
	}
}
