/* -- Text.h --
Part of the Worminator 2D game engine
Copyright 1998 by Electroencephlogram Software

For function descriptions and explanations, see proto.h
For a detailed explanation of how the engine works, see
the documents that came with this source code package. */

/**********************\
|** ADD TEXT MESSAGE **|
\**********************/
void add_text_message(unsigned char *message)
{
char empty_finder;

for (empty_finder = 0; empty_finder < 4; empty_finder++) {
	if (text_messages[empty_finder].timer == -1) {
		text_messages[empty_finder].timer = 512;
		text_messages[empty_finder].message = message;
		return;
		}
	}

// No slots were free, so kill the weakest message and add the new one at the end
slide_messages(0);
text_messages[3].timer = 512;
text_messages[3].message = message;

}

/**************************\
|** UPDATE TEXT MESSAGES **|
\**************************/
void update_text_messages()
{
char message_loop;

for (message_loop = 0; message_loop < 4; message_loop++) {
	if (text_messages[message_loop].timer != -1) {
		if (text_messages[message_loop].timer == 0) slide_messages(message_loop);
		else text_messages[message_loop].timer--;
		}
	}
}

/********************\
|** SLIDE MESSAGES **|
\********************/
void slide_messages(char message_number)
{
char message_loop;

if (message_number == 3) {
	text_messages[3].timer = -1;
	text_messages[3].message = NULL;
	return;
	}

for (message_loop = message_number; message_loop < 3; message_loop++) {
	text_messages[message_loop].timer = text_messages[message_loop + 1].timer;
	text_messages[message_loop].message = text_messages[message_loop + 1].message;
	}

text_messages[3].timer = -1;
text_messages[3].message = NULL;
}
