#
# Default Compiler settings
#
# $Id$
#

# Platform = linux
# Compiler = gcc

CC=gcc
BASE_CFLAGS=-Dstricmp=strcasecmp

CFLAGS=$(BASE_CFLAGS) -m486 -O6 -ffast-math -funroll-loops \
        -fomit-frame-pointer -fexpensive-optimizations -malign-loops=2 \
        -malign-jumps=2 -malign-functions=2 -pedantic -D_DEBUG

LDFLAGS=-ldl -lm

SHLIBEXT=so
SHLIBCFLAGS=-fPIC
SHLIBLDFLAGS=-shared

LIBEXT=lib
LIBLDFLAGS=-static


OBJEXT=o

LIBDIR=$(BASEDIR)/lib/$(RELEASE)/$(COMPILER)/$(PLATFORM)/$(MODULE)
OBJDIR=$(BASEDIR)/obj/$(RELEASE)/$(COMPILER)/$(PLATFORM)/$(MODULE)
SODIR=$(BASEDIR)/so/$(RELEASE)/$(COMPILER)/$(PLATFORM)/$(MODULE)

DO_CC=$(CC) $(CFLAGS) $(SHLIBCFLAGS) -o $@ -c $<

OPTIONS  = BASEDIR=$(BASEDIR) PLATFORM=$(PLATFORM) COMPILER=$(COMPILER) RELEASE=$(RELEASE)

.c.o:
	$(DO_CC)

# Settings for cleaning
CLEAN_FILES = $(OBJS) $(TARGET)

clean:
	rm -f $(CLEAN_FILES)

test:
	@echo OPTIONS = \"$(OPTIONS)\"
	@echo LIBDIR  = \"$(LIBDIR)\"
	@echo OBJDIR  = \"$(OBJDIR)\"
	@echo SODIR   = \"$(SODIR)\"

# end of file
