#include "q3la.h"

char* diverse::timestr_h(int sec)
{
	static char str[16];
	str[0] = 0;
	sprintf (str, "%02i:%02i:%02i h", time_h(sec), time_m(sec), time_s(sec));
	return str;
}

char* diverse::timestr_hm(int sec)
{
	static char str[16];
	str[0] = 0;
	sprintf (str, "%02i:%02i h", time_h(sec), time_m(sec));
	return str;
}

char* diverse::timestr_m(int sec)
{
	static char str[16];
	str[0] = 0;
	sprintf (str, "%i:%02i min", time_h(sec)*60 + time_m(sec), time_s(sec));
	return str;
}

int diverse::time_h(int seconds)
{
	return (seconds/3600);
}

int diverse::time_m(int seconds)
{
	return ((seconds%3600)/60);
}

int diverse::time_s(int seconds)
{
	return ((seconds%3600)%60);
}

char* diverse::funname_to_html(char *name) // check for completeness!!!
{
	char color_str[8][8] = { "", "black", "red", "green", "yellow", "blue", "cyan", "purple" };
	static char new_name[512];
	new_name[0] = 0;
	bool active = false;
	bool printed = false;
	for (unsigned int i = 0; i < strlen (name); i++) {
		char tempstr[2];
		if (name[i] == '^') {
			if ((name[i+1] > '0') && (name[i+1] < '8')) {
				tempstr[0] = name[++i];
				tempstr[1] = 0;
				active = true;
			} else {
				f2a_copy_char (new_name, name+i);
			}
		} else {
			if (active == true) {
				if (printed == true) {
					strcat (new_name, "</font>");
				}
				printed = true;
				strcat (new_name, "<font color=\"");
				strcat (new_name, color_str[atoi(tempstr)]);
				strcat (new_name, "\">");
				active = false;
			}
			f2a_copy_char (new_name, name+i);
		}
	}
	if (printed == true) {
		strcat (new_name, "</font>");
	}
	return new_name;
}

char* diverse::funname_to_ascii(char *name) // check for completeness!!!
{
	static char new_name[64];
	new_name[0] = 0;
	for (unsigned int i = 0; i < strlen (name); i++) {
		if (name[i] == '^') {
			if ((name[i+1] >= '0') && (name[i+1] <= '9')) {
				i++;
			} else {
				f2a_copy_char (new_name, name+i);
			}
		} else {
			f2a_copy_char (new_name, name+i);
		}
	}
	return new_name;
}

void diverse::f2a_copy_char (char* dest_str, char* copy_char) 
{
	if (*copy_char == '<') {
		strcat (dest_str, "&lt;");
	} 
	else if (*copy_char == '>') {
		strcat (dest_str, "&gt;");
	}
	else if (*copy_char == '&') {
		strcat (dest_str, "&amp;");
	}
	int len = strlen (dest_str);
	dest_str[len] = *copy_char;
	dest_str[len+1] = 0;
}

void diverse::deltree (char* pathstr) {
#ifndef __LINUX_PLATFORM__
	_finddata_t result;
	long handle;
	long done;
	static int i = 0;
	handle = _findfirst (pathstr, &result);
	done = handle;
	while (done != -1) {
		if ((result.attrib == _A_SUBDIR) && (result.name[0] != '.')) {
			i++; 
			if (_chdir (result.name) != 0) {
				error::msg_and_exit ("diverse::deltree - couldn't change to lower level directory");
			}
			deltree ("*.*");
			i--;
			if ((i != 0) || (strcmp (pathstr, ".") != 0)) _chdir ("..");
			_rmdir (result.name);
		}
		else {
			remove (result.name);
		}
		done = _findnext (handle, &result);
	}
#else
	char system_str[256];
	sprintf (system_str, "rm -r %s", pathstr);
	system (system_str);
#endif
}