#include "q3la.h"

player_t::player_t()
{
	init();
}

void player_t::init()
{
	for (int i = 0; i < MAX_WEAPONS; i++) {
		kills[i]	= 0;
		killed[i]	= 0;
		suicides[i]	= 0;
		memberkills[i]	= 0;
	}
	game_count	= 0;
	ping_count	= 0;
	ping_sum	= 0;
	deaths		= 0;
	mkiol		= 0;
	mkiol_time	= 0;
	next		= 0;
	playtime	= 0;
	ratio		= 0;
	eff			= 0;
	skill		= 0;
	name[0]		= 0;
	botskill	= -1;
	team		= -1;
	listed		= false;
}

player_t::~player_t()
{
	if (next != 0) {
		delete[] next;
	}
	next = 0;
}

player_t* player_t::build_next()
{
	next = new player_t[1];
	return next;
}

player_t player_t::operator= (player_t &other)
{
	for (int i = 0; i < MAX_WEAPONS; i++) {
		kills[i] = other.kills[i];
		killed[i] = other.killed[i];
		suicides[i] = other.suicides[i];
		memberkills[i] = other.memberkills[i];
	}
	ping_count = other.ping_count;
	ping_sum = other.ping_sum;
	botskill = other.botskill;
	team = other.team;
	deaths = other.deaths;
	mkiol = other.mkiol;
	mkiol_time = other.mkiol_time;
	ratio = other.ratio;
	eff = other.eff;
	skill = other.skill;
	strcpy (name, other.name);
	next = other.next;
	playtime = other.playtime;
	return other;
}

void player_t::set_name (char* in_name) {
	if (strlen (in_name) > MAX_NAME_LEN) {
		error::msg_and_exit ("player_t::set_name - overflow");
	}
	strcpy (name, in_name);
}

char* player_t::get_name () {
	return name;
}

unsigned int player_t::get_kills(int weapon)
{
	return kills[weapon];
}

unsigned int player_t::get_memberkills(int weapon)
{
	return memberkills[weapon];
}

unsigned int player_t::get_killed(int weapon)
{
	return killed[weapon];
}

unsigned int player_t::get_suicides(int weapon)
{
	return suicides[weapon];
}

unsigned int player_t::get_kills()
{
	return kills[0];
}

unsigned int player_t::get_memberkills()
{
	return memberkills[0];
}

unsigned int player_t::get_killed()
{
	return killed[0];
}

unsigned int player_t::get_suicides()
{
	return suicides[0];
}

int player_t::get_frags()
{
	return (get_kills() - deaths - get_suicides());
}

double player_t::get_skill()
{
	if (skill == 0) {
		skill = (double) get_kills() / (double) (get_killed() + deaths + get_suicides() + 1);
	}
	return skill;
}

double player_t::get_eff()
{
	if (eff == 0) {
		if (get_kills() + (get_killed() + deaths + get_suicides()) == 0) {
			eff = 0;
		} else {
			eff = 100.0 * (double) get_kills() / (double) (get_kills() + (get_killed() + deaths + get_suicides()));
		}
	}
	return eff;
}

double player_t::get_ratio()
{
	if (ratio == 0) {
		if (playtime == 0) { // prevent divide by zero
			ratio = -9999; // error, playtime == 0!
		} else {
			ratio = (double) (get_frags() * 60.0 / playtime) - (double) ((get_killed() + deaths + get_suicides()) * 60.0 / playtime);
		}
	}
	return ratio;
}

void player_t::add_ping(int ping)
{
	ping_count++;
	ping_sum += ping;
}
