#include "q3la.h"

analyzedemo::analyzedemo(FILE* in_logfile, resultdata* in_result, configdata* in_config)
{
	logfile = in_logfile;
	result = in_result;
	config = in_config;
}

analyzedemo::~analyzedemo()
{
}

int analyzedemo::parse()
{	
	char line[256];
	for (;;) {
		if (fgets(line, 255, logfile) == 0) {
			if (feof(logfile)) {
				result->event_endofgame(last_time); // if log ends during the game
				return 0;
			}
			else if (ferror(logfile)) {
				error::msg_and_exit ("analyzedemo::parse - logfile read error");
			}
			else error::msg_and_exit ("analyzedemo::parse - unknown error");
		}
		if (checkline (line) == 1) {
			return 1;
		}
	}
}

int analyzedemo::checkline(char *line)
{
//	printf ("%s", line); // DEBUG

	char temp_str[256] = "";
	
	char time[256] = "";
	char event[256] = "";
	get_word (line, time, ' ');

	if (strlen (time) <= 8) {
		get_word (event, ' ');
	} 
	else  { // log format bug if time > 1000 mins, overflow in Q3's com_sprintf()
		int endposn = strlen (time);
		if (time[endposn-1] == ':') {
			strcpy (event, strstr (time, ":") + 3);
			time[endposn-strlen(event)] = 0;
		}
	}
	
	// Item
	
	if (strcmp (event, "Item:") == 0) { 
		return 0;
	}
	
	// Kill
	
	if (strcmp (event, "Kill:") == 0) { 
		
		get_word (temp_str, ' ');
		int killer = atoi (temp_str);
		
		get_word (temp_str, ' ');
		int victim = atoi (temp_str);
		
		get_word (temp_str, ' ');
		int weapon = atoi (temp_str);
		
		result->add_kill (killer, victim, weapon, get_time(time));
		return 0;
	}
	
	// ----
	
	if (strstr (event, "----") == event) { 
		return 0;
	}

	// Chat
	
	if (strcmp (event, "say:") == 0) { 
		return 0;
	}
	
	// Teamchat
	
	if (strcmp (event, "sayteam:") == 0) { 
		return 0;
	}
	
	// ClientBegin
	
	if (strcmp (event, "ClientBegin:") == 0) {
/*
		get_word (temp_str, ' ');
		int id = atoi (temp_str);
		result->client_connect (id, get_time(time));
*/
		return 0;
	}

	// ClientConnect
	
	if (strcmp (event, "ClientConnect:") == 0) {
		get_word (temp_str, ' ');
		int id = atoi (temp_str);
		result->client_connect (id, get_time(time));
		return 0;
	}
	
	// ClientDisconnect
	
	if (strcmp (event, "ClientDisconnect:") == 0) {
		get_word (temp_str, ' ');
		int id = atoi (temp_str);
		result->client_disconnect (id, get_time(time));
		return 0;
	}
	
	// ClientUserinfoChanged
	
	if (strcmp (event, "ClientUserinfoChanged:") == 0) {
		
		char name[64] = "";
		char botskill_str[4] = "";
		char team_str[4] = "";
		int botskill = -1;
		int team = -1;
		
		get_word (temp_str, ' '); // get client id
		int id = atoi (temp_str);
		
		get_word (temp_str, '\\');
		while (temp_str[0] != 0) {
			if (strcmp (temp_str, "n") == 0) { // get name
				get_word (name, '\\');
			} else if (strcmp (temp_str, "skill") == 0) { // get skill
				get_word (botskill_str, '\\');
			} else if (strcmp (temp_str, "t") == 0) { // get team
				get_word (team_str, '\\');
			} else { // different stuff
				get_word (temp_str, '\\');
			}
			get_word (temp_str, '\\'); // check next
		}

		if (team_str[0] != 0) { // teamplay?
			team = atoi(team_str);
		}
		
		if (botskill_str[0] != 0) { // bot?
			botskill = atoi(botskill_str);
		}

		result->client_info(id, name, botskill, team);

		return 0;
	}
	
	// Ping

	if (strcmp (event, "score:") == 0) {

		int ping;
		int client_id;

		get_word (temp_str, ' '); // score

		get_word (temp_str, ' '); // string "ping:"
		get_word (temp_str, ' '); // ping
		ping = atoi (temp_str);

		get_word (temp_str, ' '); // string "client:"
		get_word (temp_str, ' '); // client
		client_id = atoi (temp_str);

		result->add_ping (client_id, ping);
		
		return 0;
	}

	// Init game
	
	if (strcmp (event, "InitGame:") == 0) {

		char mapname[256];
		char gamename[256];
		int fraglimit = 0;
		int timelimit = 0;

		result->event_startofgame(get_time(time));

		get_word (temp_str, '\\');
		while (temp_str[0] != 0) {
			if (strcmp (temp_str, "mapname") == 0) { // get mapname
				get_word (mapname, '\\');
				strcpy (result->mapname, _strlwr (mapname));
			} else if (strcmp (temp_str, "gamename") == 0) { // get gamename (i. e. "baseq3")
				get_word (gamename, '\\');
			} else if (strcmp (temp_str, "fraglimit") == 0) { // get fraglimit
				get_word (temp_str, '\\');
				fraglimit = atoi (temp_str);
				result->fraglimit = fraglimit;
			} else if (strcmp (temp_str, "timelimit") == 0) { // get timelimit
				get_word (temp_str, '\\');
				timelimit = atoi (temp_str);
				result->timelimit = timelimit;
			}
			get_word (temp_str, '\\'); // check next
		}

		return 0;
	}

	// Exit - end of game
	
	if (strcmp (event, "Exit:") == 0) {
		return 0;
	}
	
	// Server shutdown
	
	if (strcmp (event, "ShutdownGame:") == 0) {
		result->event_endofgame(get_time(time));
		return 1;
	}

//	static int unaccounted = 0; // DEBUG
//	printf ("\nunaccounted: %i - \"%s\"", ++unaccounted, line); // DEBUG

	return 0;
}

int analyzedemo::get_time(char* time_str)
{
	int min = 0;
	int sec = 0;
	sscanf(time_str,"%d:%d",&min,&sec);
	last_time = 60 * min + sec;
	return last_time;
}

void analyzedemo::get_word(char *line, char *word, char delimiter)
{
	strcpy (current_line, line);
	current_word = current_line;
	get_word (word, delimiter);
}

void analyzedemo::get_word(char *word, char delimiter)
{
	// cut leading delimiters and spaces
	
	while ((current_word[0] != 0) && ((current_word[0] == delimiter) || (current_word[0] == ' '))) { 
		current_word++;
	}

	// copy chars until next delimiter is reached
	
	char* next_word = current_word;
	while ((next_word[0] != 0) && (next_word[0] != delimiter) && (next_word[0] != '\r') && (next_word[0] != '\n')) {
		next_word++;
	}
	strncpy (word, current_word, next_word - current_word);
	word[next_word-current_word] = 0;
	current_word = next_word;
}
