#include "q3la.h"

configdata::configdata()
{
	strcpy (output_directory, "");
	strcpy (homepage_address, "");
	strcpy (homepage_string, "Back");
	strcpy (configfile, "q3la.cfg");
	strcpy (font_size_title, "12");
	strcpy (font_size_text, "10");
	min_kills			= 0;
	min_games			= 0;
	min_playtime		= 0;
	max_players			= 0;
	limits_used			= false;
	no_bots				= false;
	q3ladata			= false;
	open_after			= false;
	q3la_css			= false;
	in_subdir			= false;
	sortorder_players	= so_ratio;
}

configdata::~configdata()
{
}

void configdata::read_options(int argc, char **argv)
{
    int i;  
	char tempstr[256];
    for (i = 2; i < argc; i++) { 
	strcpy (tempstr, argv[i]);
	_strupr (tempstr);
        if ((tempstr[0] == '-') || (tempstr[0] == '/')) {
			switch (tempstr[1]) {
			case 'M': // no_bots in results
				if (strstr (tempstr, "MIN_KILLS:") != 0) {
					min_kills = atoi (strstr (tempstr, ":") + 1);
					limits_used = true;
				}
				if (strstr (tempstr, "MIN_GAMES:") != 0) {
					min_games = atoi (strstr (tempstr, ":") + 1);
					limits_used = true;
				}
				if (strstr (tempstr, "MIN_PLAYTIME:") != 0) {
					min_playtime = atoi (strstr (tempstr, ":") + 1);
					limits_used = true;
				}
				if (strstr (tempstr, "MAX_PLAYERS:") != 0) {
					max_players = atoi (strstr (tempstr, ":") + 1);
					limits_used = true;
				}
				break;
			case 'C': // no_bots in results
				if (strstr (tempstr, "CFG:") != 0) {
					strcpy (configfile, strstr (argv[i], ":") + 1);					
				}
				break;
			case 'B': // no_bots in results
				no_bots = true;
				break;
			case 'D': // write q3ladata.txt
				q3ladata = true;
				break;
			case 'A': // open after analysis
				open_after = true;
				break;
			case 'O': // sortorder, extend!!!
				switch (tempstr[2]) {
				case 'P':
					sortorder_players = so_playtime;
					break;
				case 'R':
					sortorder_players = so_ratio;
					break;
				case 'E':
					sortorder_players = so_eff;
					break;
				case 'S':
					sortorder_players = so_skill;
					break;
				case 'N':
					sortorder_players = so_name;
					break;
				case 'F':
					sortorder_players = so_frags;
					break;
				case 'K':
					sortorder_players = so_kills;
					break;
				default:
					break;
				}
				break;
			default:
				break;
			}
        }
    }
}

void configdata::read_cfg(char* cfg_str)
{
	FILE* configfile = fopen (cfg_str, "r");
	if (configfile == 0) {
		printf ("\nNo CFG found, using default values\n");
		return;
	} 
	char line[256];
	for (;;) {
		if (fgets(line, 255, configfile) == 0) {
			if (ferror(configfile)) {
				error::msg_and_exit ("analyzedemo::parse - configfile read error");
			}
			return;
		}
		parse_cfg_line (line);
	}
}

void configdata::parse_cfg_line(char *line)
{

	// ignore comment lines
	if (line[0] == ';') {
		return;
	}

	// output directory
	get_option (line, "output_directory", output_directory); 

	// homepage address
	get_option (line, "homepage_address", homepage_address);

	// homepage string
	get_option (line, "homepage_string", homepage_string);

	// font size title
	get_option (line, "font_size_title", font_size_title);

	// font size text
	get_option (line, "font_size_text", font_size_text);

}

void configdata::get_option(char* line, char* search_str, char* cfg_str) 
{
	char* pos;
	char str[256];
	strcpy (str, search_str);
	pos = strstr (line, str) + strlen (str);
	if (pos > line) {
		get_word (pos, cfg_str);
		printf ("\n- %-20s \"%s\"", search_str, cfg_str);
	}
}

void configdata::get_word(char* pos, char *str)
{
	char* first = pos;
	while ((*first != '\r') && (*first != '\n') && *first != '\"') first++;
	char* second = first+1;
	while ((*second != '\r') && (*second != '\n') && *second != '\"') second++;
	strncpy (str, first+1, second-first-1);
	str[second-first-1] = 0;
}
