#include "q3la.h"

q3la_main::q3la_main()
{
}

q3la_main::~q3la_main()
{
}

void q3la_main::run (int argc, char** argv) 
{
#ifdef TEST
	_chdir ("e:\\Games\\Quake III Arena\\baseq3");
	//	_chdir ("c:\\");
	argc = 2;
	argv[1] = "games.log";
#endif
	
	if (argc < 2) {
		help();
	}
	
	version_info();
	
	// Get start time
	
	clock_t start, finish;   
	start = clock();
	
	config.read_options (argc, argv); // read command line options - needed for read_cfg
	printf ("\nReading CFG: %s", config.configfile);
	config.read_cfg (config.configfile); // read CFG
	printf ("\n");
	config.read_options (argc, argv); // read command line options again to override CFG
	
#ifdef TEST
	//	config.no_bots = true;
	//	config.limits_used = true;
	//	config.max_players = 10;
	//	config.sortorder_players = so_playtime;
	strcpy (config.output_directory, "c:\\results\\");
#endif
	
	if (config.q3ladata == true) { // delete q3ladata.txt
		outputfile deldata; 
		deldata.open("q3ladata.txt");
		deldata.close();
	}
	
	analyze (argv[1]);
	
	// Get finish time, output
	
	finish = clock();
	printf( "\n%.2f seconds elapsed", ((double) (finish - start) / CLOCKS_PER_SEC));
	
	if (config.open_after == true) { // NT / 9x check!!!
		system ("start players.htm"); //9x
		system ("players.htm"); // NT
	}
}

//
// ANALYZE
//

void q3la_main::analyze (char* pathstr) 
{
	
	// Backup start directory
			
			char start_directory[256];
#ifndef __LINUX_PLATFORM__
			_getcwd (start_directory, 256);
#else
			getcwd (start_directory, 256);
#endif	

	// Try to read CSS file if output directory not == current directory
	
	int css_in = 0;
	int css_size = 0;
	char* css_buf = 0;
	
	if ((config.output_directory[0] != 0) && (strcmp (config.output_directory, ".") != 0)) {
#ifndef __LINUX_PLATFORM__
		css_in = _open ("q3la.css", _O_BINARY);
#else
		css_in = open ("q3la.css", O_RDONLY);
#endif
		if (css_in != -1) {
			config.q3la_css = true;
		}
		css_size = _filelength (css_in);
		css_buf = new char[css_size+1];
		printf ("\nReading q3la.css\n");
		_read (css_in, css_buf, css_size);
		_close (css_in);
	}
	
	// Create and change to output directory

	_mkdir (config.output_directory);
	_chdir (config.output_directory);
	
	// Delete directory "q3la_games"

	diverse::deltree ("q3la_games");
	diverse::deltree ("q3la_players");

	// Write CSS file (if it was read and not already exists in results folder)
	
	if (config.q3la_css == true) { // CSS file was read
		FILE* css_out = fopen ("q3la.css", "r");
		if (css_out == 0) {  // CSS doesn't yet exist
			FILE* css_out = fopen ("q3la.css", "wb");
			if (css_out == 0) { // failed to copy
				printf ("\nCouldn't write q3la.css, using default stylesheets");
				config.q3la_css = false;
			} else { // copy successful
				printf ("\nCopied stylesheet file q3la.css to results folder");
				fwrite (css_buf, sizeof(char), css_size, css_out);
				fclose (css_out);
			}
		} else { // CSS already exists
			printf ("\nUsing existing stylesheet file q3la.css");
			fclose (css_out);
		}
	} else { // no CSS file read
		FILE* css_out = fopen ("q3la.css", "r");
		if (css_out != 0) { // CSS exists
			printf ("\nUsing existing stylesheet file q3la.css");
			fclose (css_out);
			config.q3la_css = true;
		} else { // CSS doesn't exist
			printf ("\nNo q3la.css found, using default stylesheets");
		}
	}
	printf ("\n");
	
	delete[] css_buf;

	// Open games.htm
	
	outputfile out_games_total;
	out_games_total.open ("games.htm");
	html::html_header (&out_games_total, &config);
	if (config.homepage_address[0] != 0) {
		out_games_total.write ("<p class=\"title\"><a href=\"%s\"><font color=red>%s</font></a></p>", 
			config.homepage_address, config.homepage_string);
	}
	out_games_total.write ("<p class=\"title\"><a href=\"players.htm\"><font color=red>Player list</font></a></p>");
	html::line (&out_games_total, 
		"Games with less than two players are not listed\r\n<br>Players without kills or deaths are ignored");
	
	resultdata_total results_total;
	int	gamecount = 0;
	
	// Change back to start directory to find logs

	_chdir (start_directory);
	
	// Start parsing logs

#ifndef __LINUX_PLATFORM__
	_finddata_t finddata;
	int handle = _findfirst (pathstr, &finddata);
	int done = handle;
	while (done != -1) {
		if ((finddata.attrib != _A_SUBDIR) && (finddata.name[0] != '.')) {
			
			FILE* logfile = fopen (finddata.name, "rb");
			if (logfile == 0) {
				error::msg_and_exit ("q3la_main::analyze - can't open %s", finddata.name);
			}
#else 
			FILE* logfile = fopen (pathstr, "rb");
			if (logfile == 0) {
				error::msg_and_exit ("q3la_main::analyze - can't open %s", pathstr);
			}
#endif
			
			fseek (logfile, 0, SEEK_END);
			int logfilesize = ftell (logfile);
			fseek (logfile, 0, SEEK_SET);

#ifndef __LINUX_PLATFORM__
			printf ("\nParsing %s [%i byte]", finddata.name, logfilesize); 
#else
			printf ("\nParsing %s [%i byte]", pathstr, logfilesize); 
#endif
			
			// Change to output directory
			
			_chdir (config.output_directory);
			
			// Write stats
			
			printf ("\n- Writing game stats to \"games.htm\"        ");
			
			resultdata result(&config);
			analyzedemo analyze (logfile, &result, &config);
			for (;;) {
				result.init();
				if (analyze.parse() == 0) { // parse next game
					break;
				}
				result.sort_players(config.sortorder_players); // sort players for each game
				gamecount++;
				
				int rel_pos = 100 * ftell(logfile) / logfilesize;
				printf ("\b\b\b\b\b\b\b(%3i %%)", rel_pos); // progress indication
				
				if (output_game(gamecount, &result, &out_games_total) == 0) {
					results_total.add_results (&result); // add to total results 
				}
			}
			printf ("\b\b\b\b\b\b\b(100 %%)"); // progress indication
			
			if (config.q3ladata == true) { 
				printf ("\nWriting q3ladata.txt"); // output of this is delayed to actual writing
			}

#ifndef __LINUX_PLATFORM__

			// Close logfile
			
			fclose (logfile);
		}

		// Change back to start directory for reading next logfile (necesssary???)
		
		_chdir (start_directory);

		// Get next logfile 
		
		done = _findnext (handle, &finddata);
	}

#else
	fclose (logfile);
#endif

	// Close games.htm

	html::html_footer(&out_games_total, true);
	out_games_total.close();

	printf ("\n");
	
	// Change to output directory for writing total results
	
	_chdir (config.output_directory);
	
	// Output total player results
	
	outputfile outfile;
	outfile.open ("players.htm");
	printf ("\nWriting player stats to \"players.htm\"");
	
	results_total.sort_players (config.sortorder_players); // sort all players
	output out_total (&results_total, &outfile, &config, gamecount);
	out_total.list_players_total_html();
	
	outfile.close ();

	// Output per player results
	
#ifndef __LINUX_PLATFORM__
	_mkdir ("q3la_players");
#else
	mkdir ("q3la_players", S_IRWXU);
#endif
	_chdir ("q3la_players");
	config.in_subdir = true;
	
	printf ("\n\nWriting per player stats        ");
	output_per_player_stats(&results_total);
	printf ("\n");
	
	// Go back to start directory
	
	_chdir (start_directory);
}

//
// PER PLAYER STATS
//

void q3la_main::output_per_player_stats(resultdata_total* results_total)
{
	player_t* player = results_total->get_player_first()->next;
	int count = 0;
	while (player != 0) {
		count++;
		if (player->listed == false) {
			player = player->next;
			continue;
		}
		int rel_pos = 100 * count / results_total->get_player_count();
		printf ("\b\b\b\b\b\b\b(%3i %%)", rel_pos); // progress indication
		outputfile out_player;
		char filename[256];
		sprintf (filename, "player_%i.htm", count);
		out_player.open (filename);
		html::html_header (&out_player, &config);
		out_player.write ("<p class=\"title\"><a href=\"../players.htm\"><font color=red>Player list</font></a></p>");
		out_player.write ("<p class=\"title\"><span style=\"background-color: #808080\">%s</span></p>", 
			diverse::funname_to_html(player->get_name()));
		output out (results_total, &out_player, &config, 0);
		out.player_weapon_stats(player);
		html::html_footer (&out_player, false);
		out_player.close();
		player = player->next;
	}
	printf ("\b\b\b\b\b\b\b(100 %%)"); // progress indication
}

//
// PER GAME STATS
//

int q3la_main::output_game(int gamecount, resultdata* result, outputfile* out_games_total)
{
	// delete bots
	if (config.no_bots == true) {
		result->delete_bots();
	}
	
	// delete nullplayers
	result->delete_nullplayers();
	
	// only output games with more than one player
	if (result->get_player_count() < 2) {
		return 1;
	}
	
	// Output to "games.htm"
	output out_total (result, out_games_total, &config);
	html::line_header(out_games_total);
	out_games_total->write ("<b><font size=\"3\"><a href=\"q3la_games/game_%i.htm\"><font color=\"#FF0000\">Game %i</font></a><br>(%s)</font></b>", gamecount, gamecount, result->mapname);
	html::line_footer(out_games_total);
//	out_total.list_teams_html();
	out_total.list_players_html();
	
	// Open output file for current game
	
#ifndef __LINUX_PLATFORM__
	_mkdir ("q3la_games");
#else
	mkdir ("q3la_games", S_IRWXU);
#endif
	_chdir ("q3la_games");
	config.in_subdir = true;
	
	char gamefile[16];
	sprintf (gamefile, "game_%i.htm", gamecount);
	outputfile out_game_current;
	out_game_current.open (gamefile);
	html::html_header(&out_game_current, &config);
	
	// Output to "game_<x>.htm"
	output out_current (result, &(out_game_current), &config);
	if (config.homepage_address[0] != 0) {
		out_game_current.write ("<p class=\"title\"><a href=\"%s\"><font color=red>%s</font></a></p>", 
			config.homepage_address, config.homepage_string);
	}
	out_game_current.write ("<p class=\"title\"><a href=\"../players.htm\"><font color=red>Player list</font></a></p>");
	out_game_current.write ("<p class=\"title\"><a href=\"../games.htm\"><font color=red>Game list</font></a></p>");
	out_game_current.write ("<p class=\"title\">Game %i</p>", gamecount);
	out_current.game_info();
	out_current.list_teams_html();
	out_current.list_players_html();
	html::line (&out_game_current, "<b>Killcharts</b>");
	for (int i = 0; i < MAX_WEAPONS; i++) {
		out_current.table_kills_html(i);
	}
	if (config.q3ladata == true) {
		out_current.game_data(gamecount);
	}
	
	// Close current game file
	html::html_footer(&out_game_current, true);
	out_game_current.close();
	_chdir ("..");
	config.in_subdir = false;
	
	return 0;
}

void q3la_main::help () 
{
	version_info();
    printf ("\nUsage: q3la <logfile> [OPTIONS]\n");
#ifdef __LINUX_PLATFORM__
	printf ("\nNo wildcards allowed!\n");
#else 
	printf ("\nWildcards allowed!\n");
#endif
    printf ("\nOptions:\n");
	printf ("\n/a                 open results after analysis");
	printf ("\n/b                 don't include bots in results");
	printf ("\n/d                 write data file (q3ladata.txt)");
	printf ("\n/o<x>              sortorder (<x> can be N,R,E,S,F,K,N,P - see readme)");
	printf ("\n/cfg:<filespec>    use custom CFG - no spaces in <filespec> allowed");
	printf ("\n/min_kills:<x>     exclude players with less than <x> kills from player stats");
	printf ("\n/min_games:<x>     exclude players with less than <x> games from player stats");
	printf ("\n/min_playtime:<x>  exclude players with less than <x> seconds playtime");
	printf ("\n/max_players:<x>   no more than <x> players in player stats");
	printf ("\n\nOptions can be specified in upper or lower case with the prefix '/' or '-'");
	printf ("\n");
	exit (1);
}

void q3la_main::version_info()
{
    printf ("\n%s %s, %s\n%s\n", helpstr1, version, date, helpstr2);
	printf ("\n*** ONLY WORKS WITH Q3A'S GAMES.LOG! ***\n");
}
