#include "q3la.h"

resultdata::resultdata(configdata* in_config)
{
	config = in_config;
}	

resultdata::~resultdata()
{
}

void resultdata::init() {
	player_count = 0;
	game_starttime = 0;
	mapname[0] = 0;
	timelimit = 0;
	fraglimit = 0;
	for (int i = 0; i < MAX_CLIENTS; i++) {
		for (int j = 0; j < MAX_CLIENTS; j++) {
			for (int k = 0; k < MAX_WEAPONS; k++) {
				kills[i][j][k] = 0;
			}
		}
		mkiol_temp[i] = 0;
		mkiol_time[i] = 0;
		players[i].init();
	}
	for (int t = 1; t <= MAX_TEAMS; t++) {
		teams[t].init();
	}
}

void resultdata::add_ping(int client_id, int ping)
{
	players[client[client_id].player_id].add_ping (ping);
}

int resultdata::add_kill(int killer, int victim, int weapon, int time)
{
	// return 1 - no kill added because of option no_bots
	// return 2 - victim or killer id > player_count

	if (config->no_bots == true) {
		if (players[client[killer].player_id].botskill > -1) return 1;
		if (players[client[victim].player_id].botskill > -1) return 1;
	}

	if ((client[victim].player_id > player_count-1) || (client[killer].player_id > player_count-1)) {
		return 2;
	}
	
	// Translate splash to weapon itself
	
	switch (weapon) {
	case 5:
	case 7:
	case 9:
	case 13:
		weapon--;
		break;
	default:
		break;
	}

	// Check for MAX_WEAPONS overflow

	if (weapon >= MAX_WEAPONS) {
		error::msg_and_exit ("resultdata::add_kill - weapon id > MAX_WEAPONS");
	}

	// Check for valid team IDs

	int kteam = players[client[killer].player_id].team;
	int vteam = players[client[victim].player_id].team;
	bool killer_team, victim_team = false;

	if ((kteam > 0) && (kteam <= MAX_TEAMS)) {
		killer_team = true;
	}

	if ((vteam > 0) && (vteam <= MAX_TEAMS)) {
		victim_team = true;
	}
	
	// Kill

	if ((victim <= player_count) && (killer <= player_count)) {
		
		if (killer != victim) {

			// Normal kill

			// killer			
			players[client[victim].player_id].killed[weapon]++;
			players[client[victim].player_id].killed[0]++; // add to "kills by all weapons"

			// victim
			players[client[killer].player_id].kills[weapon]++;
			players[client[killer].player_id].kills[0]++; // add to "kills by all weapons"

			if (kteam != vteam) { // kill vs other team
				if (killer_team) { // killer team
					teams[kteam].kills[weapon]++;
					teams[kteam].kills[0]++;
				}
				if (victim_team) { // victim team
					teams[vteam].killed[weapon]++;
					teams[vteam].killed[0]++;
				}
			} else { // teammember kill
				if (killer_team) {
					teams[kteam].memberkills[weapon]++;
					teams[kteam].memberkills[0]++;
					players[client[killer].player_id].memberkills[0]++; 				
				}
			}
			
			mkiol_temp[killer]++;

		} else {
			
			// Suicide
			
			players[client[victim].player_id].suicides[weapon]++;
			players[client[victim].player_id].suicides[0]++; // add to "kills by all weapons"

			if (victim_team) {
				teams[vteam].suicides[weapon]++;
				teams[vteam].suicides[0]++;
			}
		}
	}

	// Death

	if ((victim <= player_count) && (killer > player_count)) {
		players[client[victim].player_id].deaths++;
		if (victim_team) {
			teams[vteam].deaths++;
		}
	}

	// Log MKIOL if necessary

	if (mkiol_temp[victim] > players[client[victim].player_id].mkiol) {
		players[client[victim].player_id].mkiol = mkiol_temp[victim];
		players[client[victim].player_id].mkiol_time = time - mkiol_time[victim];
	}
	mkiol_temp[victim] = 0;
	mkiol_time[victim] = time;
	
	// Log kills in matrix (static method)

	if ((killer <= player_count) && (victim <= player_count)) {
		kills[client[killer].player_id][client[victim].player_id][weapon]++;
		kills[client[killer].player_id][client[victim].player_id][0]++; // add to "kills by all weapons"
	}

	return 0;
}

int resultdata::client_connect(int client_id, int connect_time)
{
	client[client_id].connect_time = connect_time;
	mkiol_time[client_id] = connect_time;
	mkiol_temp[client_id] = 0;
	return 0;	
}

int resultdata::client_info(int client_id, char *name, int botskill, int team)
{

	// new connect

	if (client[client_id].status == never_connected) { 
		client[client_id].player_id = add_player ();
		client[client_id].status = connected;
		players[client[client_id].player_id].set_name(name);
		players[client[client_id].player_id].botskill = botskill;
		players[client[client_id].player_id].team = team;
	} 
	
	// reconnect
	
	else if (client[client_id].status == disconnected) {
		int player_id = -1;
		if (botskill == -1) {
			player_id = get_player_id (name);
		}
		if (player_id == -1) {
			client[client_id].player_id = add_player ();
			players[client[client_id].player_id].set_name(name);
			players[client[client_id].player_id].botskill = botskill;
			players[client[client_id].player_id].team = team;
		} else {
			client[client_id].player_id = player_id;
			players[client[client_id].player_id].set_name(name);
			players[client[client_id].player_id].botskill = botskill;
			players[client[client_id].player_id].team = team;
		}
		client[client_id].status = connected;
	}
	
	// already connected

	else if (client[client_id].status == connected) {
		players[client[client_id].player_id].set_name(name);
		players[client[client_id].player_id].botskill = botskill;
		players[client[client_id].player_id].team = team;
	}

	return 0;
}

int resultdata::get_player_id(char* name)
{
	for (int i = 0; i < get_player_count(); i++) {
		if (strcmp (name, get_player(i)->get_name()) == 0) {
			return i;
		}
	}
	return -1;
}

int resultdata::add_player()
{
	if (player_count >= MAX_CLIENTS-1) {
		error::msg_and_exit ("resultdata::add_player - too many clients in game (%i)", player_count);
	}
	players[player_count].init();
	player_count++;
	return (player_count-1);
}

int resultdata::client_disconnect(int client_id, int disconnect_time)
{
	if (client[client_id].player_id == -1) {
		return 1;
	}
	int pt = disconnect_time - client[client_id].connect_time;
	if (pt > 0) { // check it playtime positive
		players[client[client_id].player_id].playtime += pt;
	}
	if (mkiol_temp[client_id] > players[client[client_id].player_id].mkiol) {
		players[client[client_id].player_id].mkiol = mkiol_temp[client_id];
		players[client[client_id].player_id].mkiol_time = disconnect_time - mkiol_time[client_id];
	}
	mkiol_temp[client_id] = 0;
	client[client_id].status = disconnected;
	return 0;	
}

int resultdata::get_player_count()
{
	return player_count;
}

player_t* resultdata::get_player(int player_id)
{
	return &players[player_id];
}

player_t* resultdata::get_team(int team_id)
{
	return &teams[team_id];
}

int resultdata::event_startofgame(int time)
{
	for (int i = 0; i < MAX_CLIENTS; i++) {
		client[i].player_id = -1;
		client[i].status = never_connected;
		mkiol_temp[i] = 0;
		mkiol_time[i] = time;
	}
	game_starttime = time;
	return 0;
}

int resultdata::event_endofgame(int time)
{
	for (int i = 0; i < MAX_CLIENTS; i++) {
		if (client[i].status == connected) {
			if (i > get_player_count()) break; // shouldn't happen
			int pt = time - client[i].connect_time;
			if (pt > 0) { // check it playtime positive
				players[client[i].player_id].playtime += pt;
			}
			if (mkiol_temp[i] > players[client[i].player_id].mkiol) {
				players[client[i].player_id].mkiol = mkiol_temp[i];
				players[client[i].player_id].mkiol_time = time - mkiol_time[i];
			}
		}
	}
	return 0;
}

unsigned short resultdata::get_kills(int player, int victim)
{
	return kills[player][victim][0];
}

unsigned short resultdata::get_kills(int player, int victim, int weapon)
{
	return kills[player][victim][weapon];
}

int resultdata::sort_players(sort_t order)
{
	for (int p1 = 0; p1 < get_player_count()-1; p1++) {
		for (int p2 = p1+1; p2 < get_player_count(); p2++) {
			double val1 = 0;
			double val2 = 0;
			char str1[256] = "";
			char str2[256] = "";
			player_t player1 = *(get_player(p1));
			player_t player2 = *(get_player(p2));

			switch (order) {
			case so_name:
				strcpy (str1, diverse::funname_to_ascii(player1.get_name()));
				strcpy (str2, diverse::funname_to_ascii(player2.get_name()));
				_strlwr (str1);
				_strlwr (str2);
				break;
			case so_kills:
				val1 = player1.get_kills();
				val2 = player2.get_kills();
				break;
			case so_frags:
				val1 = player1.get_frags();
				val2 = player2.get_frags();
				break;
			case so_ratio: 
				val1 = player1.get_ratio();
				val2 = player2.get_ratio();
				break;
			case so_eff: 
				val1 = player1.get_eff();
				val2 = player2.get_eff();
				break;
			case so_skill: 
				val1 = player1.get_skill();
				val2 = player2.get_skill();
				break;
			case so_playtime: 
				val1 = player1.playtime;
				val2 = player2.playtime;
				break;
			}
			switch (order) {
			case so_name:
				if (strcmp (str1, str2) > 0) {
					make_sort(p1, p2);
				}
				break;
			case so_kills:
			case so_frags:
			case so_ratio:
			case so_eff:
			case so_skill:
			case so_playtime:
				if (val1 < val2) {
					make_sort(p1, p2);
				}
				break;
			}
		}
	}
	return 0;
}

int resultdata::make_sort(int p1, int p2)
{
	player_t temp_player = players[p1];
	players[p1] = players[p2];
	players[p2] = temp_player;
	int i;
	// sort kill matrix
	for (i = 0; i < get_player_count(); i++) {
		// vertical swap
		for (int j = 0; j < MAX_WEAPONS; j++) {
			unsigned short temp = kills[i][p1][j];
			kills[i][p1][j] = kills[i][p2][j];
			kills[i][p2][j] = temp;
		}
	}
	for (i = 0; i < get_player_count(); i++) {
		// horizontal swap
		for (int j = 0; j < MAX_WEAPONS; j++) {
			unsigned short temp = kills[p1][i][j];
			kills[p1][i][j] = kills[p2][i][j];
			kills[p2][i][j] = temp;
		}
	}
	return 0;
}

unsigned int resultdata::get_player_kills(int player)
{
	return players[player].kills[0];
}

unsigned int resultdata::get_player_kills(int player, int weapon)
{
	return players[player].kills[weapon];
}

unsigned int resultdata::get_player_killed(int player)
{
	return players[player].killed[0];
}

unsigned int resultdata::get_player_killed(int player, int weapon)
{
	return players[player].killed[weapon];
}

unsigned int resultdata::get_player_suicides(int player)
{
	return players[player].suicides[0];
}

unsigned int resultdata::get_player_suicides(int player, int weapon)
{
	return players[player].suicides[weapon];
}

unsigned int resultdata::get_team_kills(int team)
{
	return teams[team].kills[0];
}

unsigned int resultdata::get_team_kills(int team, int weapon)
{
	return teams[team].kills[weapon];
}

unsigned int resultdata::get_team_killed(int team)
{
	return teams[team].killed[0];
}

unsigned int resultdata::get_team_killed(int team, int weapon)
{
	return teams[team].killed[weapon];
}

unsigned int resultdata::get_team_suicides(int team)
{
	return teams[team].suicides[0];
}

unsigned int resultdata::get_team_suicides(int team, int weapon)
{
	return teams[team].suicides[weapon];
}

unsigned int resultdata::get_total_kills()
{
	unsigned int total = 0;
	for (int i = 0; i < player_count; i++) {
		total += get_player_kills(i);
	}
	return total;
}

unsigned int resultdata::get_total_kills(int weapon)
{
	unsigned int total = 0;
	for (int i = 0; i < player_count; i++) {
		total += get_player_kills(i, weapon);
	}
	return total;
}

void resultdata::delete_bots()
{
	if (config->no_bots == false) { // only delete bots if no_bots option set
		return;
	}

	int new_count = 0;
	for (int i = 0; i < player_count; i++) {
		if (players[i].botskill == -1) {
			players[new_count] = players[i];
			for (int j = 0; j < player_count; j++) {
				for (int w = 0; w < MAX_WEAPONS; w++) {
					kills[new_count][j][w] = kills[i][j][w];
					kills[j][new_count][w] = kills[j][i][w];
				}
			}
			new_count++;
		}
	}
	player_count = new_count;
}

void resultdata::delete_nullplayers()
{
	int new_count = 0;
	for (int i = 0; i < player_count; i++) {
		if ((players[i].get_frags() > 0) || (players[i].get_killed() > 0) 
			|| (players[i].deaths > 0) || (players[i].get_suicides() > 0)){
			players[new_count] = players[i];
			for (int j = 0; j < player_count; j++) {
				for (int w = 0; w < MAX_WEAPONS; w++) {
					kills[new_count][j][w] = kills[i][j][w];
					kills[j][new_count][w] = kills[j][i][w];
				}
			}
			new_count++;
		}
	}
	player_count = new_count;
}
