/**********************************************************
Quake2 Cluster Project
An addition and modification of iD Software's Quake2 shared 
library sources which enable Quake2 servers running this 
library to interconnect other servers which speak the 
protocol developed under the Quake2 Cluster Project.
Copyright (c) 1998 Justin Randall and Todd Bliss

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be 
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more 
details. You should have received a copy of the GNU General 
Public License along with this program; if not, write to 
the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, 
Boston, MA  02111-1307, USA.
**********************************************************/

/**********************************************************
ClusterGameExtentions.h

  Structure definitions and functions which extend id's
  shared library, and must be included before declarations
  in g_local.h
**********************************************************/

/**********************************************************
	$Log: ClusterGameExtentions.h,v $
	Revision 1.2  1998/02/01 15:07:18  logic
	Release 0.3

	Revision 1.1  1998/01/31 09:53:55  logic
	Added RULES_ClientUserInfoChanged for access to client variables.
	Fixed the password bug
	Fixed the looping respawn/telefrag bug
	Added Invincibility functions to RULES
	Added ClientThink2 to RULES
	Added RULES_ClientCmd
	Added cmd invincible to RULES
	Added ()'s around player names on broadcast messages
	Added MOTD motd-mapname.txt
	Changed invincibility fx

**********************************************************/

typedef struct {
	long		RespawnInvTimeOut;	// How long is player invincible? -1 = infinet, 0 = not at all.
	long		motd_time;	// How long to display motd? motd = ltime + lengh to display
	char		motd_msg[1024]; // message to display for the MOTD
	long		motd_lasttime;	// last time motd msg was sent to client
	long		killtime;		// RULES_Cmd_Kill_f anti-spam variable
	int			killcount;		// Keep track of how many times this guy suicides over a given time period
	long		last_cluster_say;	// When was the last broadcast message sent?
} RULES_EdictExt;
