/**********************************************************
Quake2 Cluster Project
An addition and modification of iD Software's Quake2 shared 
library sources which enable Quake2 servers running this 
library to interconnect other servers which speak the 
protocol developed under the Quake2 Cluster Project.
Copyright (c) 1998 Justin Randall and Todd Bliss

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be 
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more 
details. You should have received a copy of the GNU General 
Public License along with this program; if not, write to 
the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, 
Boston, MA  02111-1307, USA.
**********************************************************/
#include "rules.h"

#define CLUSTER_KEEPALIVE 3000
#define GAME_CLUSTER	1
// Respawn Invincibility time
#define		RULE_RESPAWN_INVINC_TIME	10

typedef struct {
	edict_t *exit;
	edict_t *client;
} ClientExit;



// Cluster.c
void DEBUG_PrintBytes(unsigned char *bytes, long len);
void ClusterCopying(void);
void ChangeServer(edict_t *exit, edict_t *e);
void stuffcmd(edict_t *e, char *s);
long ClientExitThread(ClientExit *ExitData);
// void RegisterServer(void);
// void ExitNoDamage(edict_t *ent);
// void GetClusterMaster(char *cm);
// void GetServerAddrPort(char *ThisServer);
// void GetServerPort(char *ThisPort);
// void GetServerAddr(char *ThisServer);
void ClusterKillE(edict_t *admin);
void ClusterExit_think(edict_t *self);
void StuffDefault(edict_t *ent);
int SaveClusterLinksToDisk(void);
int ClusterLoadLinks(void);
edict_t *PopulateExit(FILE *in);
int ValidateAdmin(edict_t *admin);
void StringToNull(char *buf);
void ClusterInit(void);
int ClusterCommand(char *cmd, edict_t *ent);
int ClusterRegisterLink(edict_t *exit, char pkt_id);
void SP_LinkEntity(edict_t *admin, char *named, char link_type);
int ClusterCmdSpawn(edict_t *ent);
void ClusterListLinks(edict_t *ent);
int ClusterCmdList(edict_t *ent);
int ClusterCmdLink(edict_t *ent);
void ClusterLinkTo(edict_t *ent, char *name, char *dest);

// cluster_protocol.c

unsigned long ClusterChecksum(unsigned char *data, long dataLen);
long thread_ClusterListen(void);
unsigned short ClusterCharToUS(unsigned char *bytes);
unsigned char ClusterByteSignData(unsigned char *data, long dataLen, unsigned char *key);
void ClusterSpinNetServer(void);
void ClusterRegServer(void);
int ClusterCheckSig(unsigned char *data, unsigned char *key, long dataLen);
void ClusterSendMSG(char *dest, unsigned short iPort, unsigned char *msg, long Len, unsigned char *key);
void ClusterIntToBytes(int i, unsigned char *bytes);
void ClusterSelectSpawnPoint(vec3_t spawn_origin, vec3_t spawn_angles, char *ExitName);
// cluster_links.c


