/**********************************************************
	Cluster Protocol Packet Headers
	These are used when creating packet headers
	such as SP_LinkEntity registration. Also used
	in decoding packets in the low-level protocol 
	functions.
**********************************************************/
#define		PKT_EXIT_SET			10	// Spawned an exit, registring with DB
#define		PKT_EXIT_GET			11	// Request from DB for exit info
#define		PKT_CLIENT_SET			20	// Client data being sent
#define		PKT_CLIENT_GET			21	// Request for client data
#define		PKT_SERVER_KEEPALIVE	30	// Server heartbeat
#define		PKT_EXIT_KEEPALIVE		31	// Exit heartbeat
#define		PKT_ENTER_KEEPALIVE		32	// Entrance heartbeat
#define		PKT_SEC_CHALLENGE		40	// Challenge
#define		PKT_SEC_RESPONSE		41	// Response
#define		PKT_SERVER_REG			50	// Server registration
#define		PKT_SERVER_REQ			51	// Request for server information
#define		PKT_ENTER_SET			60  // Entrance entity registration
#define		PKT_ENTER_GET			61	// Entrance entity request
#define		PKT_ENTER_GET_NACK		62	// Failed to find an entrance
#define		PKT_ENTER_REQ_HB		63	// Request for new link.. send heartbeat
#define		PKT_EDICT_SET			70	// Edict Data
#define		PKT_ITEM_SEND			80	// For sending items to players from one level to the next
#define		PKT_SERVER_LIST_REQ		90	// Request a list of servers in the cluster
#define		PKT_SERVER_LIST_RESP	91	// Response to a list request
#define		PKT_LC_REMOVE			92	// LinkChange update for server list
#define		PKT_LC_ADD				93	// LinkChange addition --a server may be available			
#define		PKT_BPRINTF				100	// Packet contains a message to be fed to gi.bprintf
/**********************************************************
	Cluster Link Entity Identifiers
	These are used when a cmd spawn exit or 
	cmd spawn entrance are called.
**********************************************************/
#define		LINK_EXIT				1
#define		LINK_ENTRANCE			2

// For transferring inventory
#define		XFER_INV			35

// Build Number
#define		G_ClusterBuild			"0309"

// Queue Index Max
#define		CLUSTER_MAX_REQ_QUEUE	512
#define		CLUSTER_MAX_SERVERS		256


/**********************************************************
	Cluster Structures
**********************************************************/
typedef struct {
	// Cluster Link Registration Packet
	// Used when links are spawned to transfer
	unsigned char			packetid;
	unsigned char			ms_port[2];
	unsigned char			q2_port[2];
	unsigned char			name[16];
} ClusterLinkRegPacket;


typedef struct {
	// Populated on a machine's coordination
	// server when a link registration packet
	// is received.
	int				status;
	char			myaddr[64];	// Dotted decimal IP address
	unsigned short	my_ms_port;	// miniserver port
	unsigned short	my_q2_port;	// q2 port
	char			remoteaddr[17];	// Remote address (for exits)
	unsigned short	remote_ms_port;	// Remote miniserver port
	unsigned short	remote_q2_port;	// Remote q2 port
	char			name[16];		// Link name, must be same between exits and enter
	unsigned long	timeout;		// Used for database, no heartbeat, no record allocation
} LinkRecord;

typedef struct {
	// Server Record, each q2 instance
	// sends a registration to the 
	// machine db master
	char			status;		// record status  0=invalid 1=valid
	char			addr[64];	// dotted ip addr --change this to 4 byte addr!
	unsigned short	comport;
	unsigned short	port;		// server port
	unsigned char			max_clients;	// maximum clients this server allows
	unsigned char			clients;	// current number of clients
	char			name[16];	// server name
} ServerRecord;

typedef struct {
	// Server Req packet
	unsigned char	packetid;		// PKT_SERVER_REQ
	unsigned char	ms_port[2];		// My local miniserver
	char			link_dest[16];	// Link Destination
} ServerReqPacket;

typedef struct {
	unsigned char	packet_id;		// PKT_SERVER_REG
	unsigned char	comport[2];		// local listen process
	unsigned char	port[2];
	unsigned char	max_clients;
	unsigned char	clients;
} ServerRegPacket;

typedef struct {
	unsigned char	packet_id;
	unsigned char	remote_ms_port[2];
	unsigned char	addr[4];		// FIX ME: Change to char[4] and pack/unpack!
	char			name[16];
} ReqLinkHeartbeatPacket;

typedef struct {
	unsigned char	packet_id;
	unsigned char	accept_players;
	unsigned char	entrance_ms_port[2];
	unsigned char	entrance_q2_port[2];
	char			name[16];
} EntranceKeepAlive;

typedef struct {
	// We will start with this, build as we debug
	unsigned char	packet_id;
	unsigned char	ms_port[2];
	// Client Persistant vars
	// char			userinfo[MAX_INFO_STRING];
	char			netname[16];
	unsigned char	health[2];
	unsigned char	max_health[2];
	unsigned char	score[2];
	char			weapon[32];		// current weapn
} ClusterSendPlayerPacket;

typedef struct {
	unsigned char	packet_id;
	unsigned char	inv_index;
	unsigned char	inv_value;
	char			player_name[16];
} ClusterSendItemPacket;

typedef struct {
	unsigned char	addr[4];	// Packed IP Address
	unsigned char	q2_port[2];	// Quake2 Port
	unsigned char	ms_port[2];	// MiniServer Port
} ClusterPackedAddr;

typedef struct {
	unsigned char	packet_id;	// Request ServerList
	unsigned char	request_id;	// which request is this (to prevent looping)
	unsigned char	addr[4];	// address
	unsigned char	q2_port[2];	// Quake2 Server port
	unsigned char	ms_port[2];	// MiniServer Port
} ClusterServerListReqPacket;

typedef struct {
	unsigned char	packet_id;	// Response do ServerList request
	unsigned char	request_id;	// Responding to request #
	unsigned char	addr[4];	// Responding server's address
	unsigned char	q2_port[2];	// Responding server's q2 port
	unsigned char	ms_port[2];	// Responding server's miniserver port
	unsigned char	clients;	// # of clients on the server
} ClusterServerListRespPacket;

typedef struct {
	unsigned char	addr[4];
	unsigned char	q2_port[2];
	unsigned char	ms_port[2];
	unsigned char	clients;
} ClusterServerListRecord;

typedef struct {
	unsigned char	packet_id;	// PKT_BPRINTF
	char			message[80];
} ClusterBPrintfPacket;
typedef struct {
	char			ThreadName[64];
	HANDLE			threadhandle;
} ClusterThreads;

ClientExit G_et;	// For passing two pointers to the client exit thread

RecvMSG	G_ExitMSG;

struct in_addr	G_ServerAddr;	// My IP address
unsigned short	G_ServerPort;	// The port of the q2 server running here
unsigned short	G_ReferalPort;	// This machine's DB server port
char			*G_ClusterId;
char			*G_ClusterKey;
unsigned short	G_LocalComPort;	// The port that this instance listens to for communications
char			*G_HostName;	// The name of the q2 server as set by "hostname" cvar
unsigned char	G_LastRequestID;	// For cycling through request identifiers
ClusterServerListReqPacket	G_ServerListHistory[CLUSTER_MAX_REQ_QUEUE];	// Keep a list of requests
int				G_QueueIndex;		// Keep a cycling queue index for requests
ClusterServerListRecord	G_ServerList[CLUSTER_MAX_SERVERS];	// Max DB Size for server listing
int				G_ActiveThreads;
ClusterThreads	ThreadList[256];
ClusterPackedAddr	G_LocalQRL;	// Packed address of this servers resource locator (addr/msport/q2port)

void SpinDBThread(void);
void ClusterEnterHeartBeat(RecvMSG *request);
void ClusterReceiveEnterKeepAlive(RecvMSG *Packet);
void ClusterReLink(edict_t *ent);
void ClusterSendPlayer(edict_t *player, edict_t *exit);
void ClusterRecvPlayer(RecvMSG *ParentData);
void ClusterSendPlayerItem(char *dest_addr, unsigned short dest_msport, char *playername, int inv_index, int value);
void ClusterRecvPlayerItem(RecvMSG *ParentData);
void ClusterBytesToDDIP(unsigned char *bytes, char *addr);
void ClusterPackAddr(char *addr, unsigned short ms_port, unsigned short q2_port, ClusterPackedAddr *qaddr);
void ClusterDDIPToBytes(char *addr, unsigned char *bytes);
void ClusterRemoveLink(char *name);
int ClusterCmdDelete(edict_t *ent);
int ClusterCharToINT(unsigned char *bytes);
int ClusterCmdHelp(edict_t *ent);
void ClusterServerListRequest(void);
void ClusterServerListResponse(RecvMSG *Packet);
void ClusterRecvListResponse(RecvMSG *Packet);
void ClusterCMDListServers(edict_t *ent);
int ClusterCmdBPrintf(edict_t *ent);
void ClusterRecvBPrintf(RecvMSG *Packet);
void ClusterSendBPrintf(char *message);
int ClusterCmdVersion(edict_t *ent);

