/**********************************************************
Quake2 Cluster Project
An addition and modification of iD Software's Quake2 shared 
library sources which enable Quake2 servers running this 
library to interconnect other servers which speak the 
protocol developed under the Quake2 Cluster Project.
Copyright (c) 1998 Justin Randall and Todd Bliss

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be 
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more 
details. You should have received a copy of the GNU General 
Public License along with this program; if not, write to 
the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, 
Boston, MA  02111-1307, USA.
**********************************************************/

#define MAX_SERVERS 1000
#define MAX_LINKS 1000

typedef struct {
	int		status;	// 0 Open Slot, 1 In Use, used when searching to see if an element is not intialized
	char	ServerAddr[255];
	char	ServerMap[255];
	long	timeout;
	int		clients;
	int		maxclients;
} ServerInfo;

typedef struct {
	int		status; // 0 open slot, 1 in use
	char	Name[24];
	char	Map[24];
	char	SourceAddr[64];
	char	SourceMap[24];
} ClusterExitInfo;


void dbthread(void);
int GetServer(char *s, ServerInfo *Servers);
int DelServer(char *addr, ServerInfo *Servers);
// int SetServer(char *addr, char *map, ServerInfo *Servers);
int DBKeepAlive(ServerInfo Packet, ServerInfo *Servers);
int SetClusterExit(char *name, char *map, char *sourceaddr, char *sourcemap, ClusterExitInfo *ClusterExits);
int DBRegServer(RecvMSG Packet, ServerRecord *Servers);
void DBServerReq(RecvMSG Packet);
void DBEnterReq(RecvMSG Packet, LinkRecord *Enters);
int DBEnterReg(RecvMSG Packet, LinkRecord *Enters);
// int DBLinkExitSpawn(RecvMSG Packet, LinkRecord *Exits);

/**********************************************************
	v0.2 - v0.3 conversion
	MAJOR protocol changes
**********************************************************/



