Program TATool;
Uses DOS,Utils,VGAGraf,STMR_STR,ASMUtils;
{
 Info only. Won't compile without my units (which suck to much to release :-)
}

{
 To-Do:
  Add -optimize to allow optimizing tile-references by removing unreferenced
   tiles and recalculating all references. Saves space on the harddrive, and
   could even save memory?!
  Dump more GAF data.
  RIX_Show_Interactive:
   bug; Tall but narrow maps wraps. Write new slowblt.
  Speedup/recode 'SaveHeightMap' (be-gone, blockread-of-4-bytes)
}

CONST
 version             :String[8]='0.0.4.2';

 FIXUP               = 6; { HEIGHT-FIXUP - why needed?! }

TYPE
 TA_GAFHeader = Record
  IDversion          :LongInt;       { $00- }
  Entries            :LongInt;       { $04- }
  Unknown            :LongInt;       { $08- }
 end;

 TA_GAFentry = Record
  frames       :Word;                { $00- }
  unknown1     :Word;                { $02- }
  unknown2     :LongInt;             { $04- }
  name         :Array[0..31] of char;{ $08- }
  { ptrs to frame graphics * frames }{ $28- }
 end;

 TA_TNTHeader = Record
  IDversion          :LongInt;       { $00- }
  Width              :LongInt;       { $04- }
  Height             :LongInt;       { $08- }
  PTRmapdata         :LongInt;       { $0C- }
  PTRmapattr         :LongInt;       { $10- }
  PTRtilegfx         :LongInt;       { $14- }
  tiles              :LongInt;       { $18- }
  tileanims          :LongInt;       { $1C- }
  PTRtileanim        :LongInt;       { $20- }
  sealevel           :LongInt;       { $24- }
  PTRminimap         :LongInt;       { $28- }
  unknown1           :LongInt;       { $2C- }
  pad1,pad2,pad3,pad4:LongInt;
 end;

VAR
 SavedExitProc       :Pointer;
 F                   :File;
 fn                  :PathStr;
 S                   :String;

 GAF                 :TA_GAFHeader;
 TNT                 :TA_TNTHeader;

 Palette             :Array[1..256*3] of byte;

 BytesRead           :Word;
 w1,w2               :Word;
 Loop                :Word;
 MiniMapW,MiniMapH   :LongInt;

 PaletteBINloaded    :Boolean;


Procedure CustomExit; FAR;
var
 Err:    String[80];
begin
  If ErrorAddr<>Nil then
    begin
      Err:='Sorry, this error is unknown. ('+st(ExitCode)+')';
     Case ExitCode of
       1: Err:='Invalid function number';
       2: Err:='File not found';
       3: Err:='Path not found';
       4: Err:='Too many open files';
       5: Err:='File access denied';
       6: Err:='Invalid file handle';
      12: Err:='Invalid file access code';
      15: Err:='Invalid drive number';
      18: Err:='No more files';
     100: Err:='Disk read error';
     101: Err:='Disk write error';
     102: Err:='File not assigned';
     103: Err:='File not open';
     104: Err:='File not open for input';
     105: Err:='File not open for output';
     106: Err:='Invalid numeric format';
     150: Err:='Disk is write-protected';
     151: Err:='Bad drive request struct length';
     152: Err:='Drive not ready';
     154: Err:='CRC error in data';
     156: Err:='Disk seek error';
     157: Err:='Unknown media type';
     158: Err:='Sector Not Found';
     159: Err:='Printer out of paper';
     160: Err:='Device write fault';
     161: Err:='Device read fault';
     162: Err:='Hardware failure (Network Failure)';
     200: Err:='Division by zero';
     201: Err:='Range check error';
     202: Err:='Stack overflow error';
     203: Err:='Heap overflow error';
     204: Err:='Invalid pointer operation';
     205: Err:='Floating point overflow';
     206: Err:='Floating point underflow';
     207: Err:='Invalid floating point operation';
     211: Err:='Call to abstract method';
     215: Err:='Arithmetic overflow error';
     216: Err:='General Protection fault';
     end;
      WriteLn(#10#13,'ERROR: ',Err);
      ErrorAddr:=Nil;
     { ExitCode:=1;}
    end;
  ExitProc:=SavedExitProc;
end;

Procedure DumpTNTInfo;
begin
 WriteLn('-- header -- (',SizeOf(TA_TNTHEader),' bytes)');
 Write('$00: Header ID: $',HexL(TNT.IDversion));
 if TNT.IDversion<>8192 then Write(' -- header identification failed?!') else Write(' -- header OK!');
 WriteLn;
 WriteLn('$04: Map width           : ',SpaceB(KiloComma(TNT.Width),12),HexL(TNT.Width),
  '  (actual: ',KiloComma((TNT.Width-FIXUP) div 2),' tiles)');
 WriteLn('$08: Map height          : ',SpaceB(KiloComma(TNT.Height),12),HexL(TNT.Height),
  '  (actual: ',KiloComma((TNT.Height-FIXUP) div 2),' tiles)');
 WriteLn('$0C: PTR to map data     : ',SpaceB(KiloComma(TNT.PTRmapdata),12),HexL(TNT.PTRmapdata));
 WriteLn('$10: PTR to map attribs  : ',SpaceB(KiloComma(TNT.PTRmapattr),12),HexL(TNT.PTRmapattr));
 WriteLn('$14: PTR to tilegfx      : ',SpaceB(KiloComma(TNT.PTRtilegfx),12),HexL(TNT.PTRtilegfx));
 WriteLn('$18: tiles               : ',SpaceB(KiloComma(TNT.tiles),12),HexL(TNT.tiles));
 WriteLn('$1C: # of tile anims     : ',SpaceB(KiloComma(TNT.tileanims),12),HexL(TNT.tileanims));
 WriteLn('$20: PTR to tile anims   : ',SpaceB(KiloComma(TNT.PTRtileanim),12),HexL(TNT.PTRtileanim));
 WriteLn('$24: sealevel            : ',SpaceB(KiloComma(TNT.sealevel),12),HexL(TNT.sealevel));
 WriteLn('$28: PTR to minimap      : ',SpaceB(KiloComma(TNT.PTRminimap),12),HexL(TNT.PTRminimap));
 WriteLn('$2C: unknown1            : ',SpaceB(KiloComma(TNT.unknown1),12),HexL(TNT.unknown1));
 WriteLn('       minimap w,h       : ',
  SpaceB(KiloComma(minimapW)+', '+KiloComma(minimapH),12),HexL(minimapW),', ',HexL(minimapH));
 WriteLn('-- computed --');
 WriteLn(' # of tiles used for map: ',KiloComma((TNT.Width div 2)*((TNT.Height-FIXUP) div 2)));
end;

Function ZTS2String(VAR ZS;const len: byte): String; Assembler;
{ Should really scan for a '\0' too }
asm
 push ds
 xor  ch,ch
 mov  cl,len
 les  di,@result
 lds  si,ZS
 mov  al,cl
 stosb
 rep  movsb
 pop  ds
end;

Procedure DumpGAFentryInfo(entry: LongInt);
var
 PTRentry         :LongInt;
 GAFentry         :TA_GAFentry;
 PTRframe         :LongInt;
 loop             :Word;
begin
 Seek(F,SizeOf(TA_GAFHeader)+(entry*4));
 BlockRead(F,PTRentry,4);
 Write(HexL(PTRentry),': "');
 Seek(F,PTRentry);
 BlockRead(F,GAFentry,SizeOf(GAFentry));
 WriteLn(SpaceB(ZTS2String(GAFentry.name,32),32)+'" (',GAFentry.frames,' frames)');
  for loop:=0 to GAFentry.frames-1 do
   begin
    BlockRead(F,PTRframe,4);
    Write(' frame #',loop,' table @ ',HexL(PTRframe));
    BlockRead(F,PTRframe,4);
    WriteLn(' (param = ',HexL(PTRframe),')');
   end;
end;

Procedure DumpGAFInfo;
begin
 WriteLn('-- header -- (',SizeOf(TA_GAFHeader),' bytes)');
 Write('$00: Header ID: $',HexL(GAF.IDversion));
 if GAF.IDversion<>$010100 then Write(' -- header identification failed?!') else Write(' -- header OK!');
 WriteLn;
 WriteLn('$04: entries             : ',SpaceB(KiloComma(GAF.Entries),12),HexL(GAF.Entries));
 WriteLn('$08: unknown             : ',SpaceB(KiloComma(GAF.unknown),12),HexL(GAF.unknown));
 WriteLn('-- table of contents --');
 for loop:=0 to GAF.entries-1 do
  begin
   DumpGAFentryInfo(loop);
  end;
end;

Procedure Check_TileReferences;
var
 Tile                   :Word;
 NotUsed                :Word;
 Loop                   :LongInt;
 TileChart              :Pointer;
begin
 WriteLn('  Analyzing tile references');
 if TNT.tiles>32767 then begin
  WriteLn('  Too many tiles -- out of memory');
  Exit;
 end;
 GetMem(TileChart,65534);
 FillChar(TileChart^,65534,0);
 Seek(F,TNT.PTRmapdata);
 WriteLn('  Scanning thru ',(TNT.Width*(TNT.Height+FIXUP)) div 4,' locations.');
 for loop:=0 to ((TNT.Width*(TNT.Height+FIXUP)) div 4)-1 do
  begin
   BlockRead(F,Tile,2,bytesread);
{   WriteLn(HexL(loop*2),' = ',hexW(tile));}
   if tile>TNT.tiles then WriteLn('  ERROR: Referencing non-existant tile #',tile,' @ ',HexL(Loop*2))
  else
   Inc(MemW[Seg(TileChart^):Ofs(TileChart^)+(LongInt(tile)*2)]);
  end;

 NotUsed:=0;
 for loop:=0 to TNT.tiles-1 do
  begin
   if MemW[Seg(TileChart^):Ofs(TileChart^)+(LongInt(loop)*2)]=0 then
    begin
     Inc(NotUsed);
     if NotUsed=1 then Write('  Unreferenced:') else
     if NotUsed mod 12=1 then Write(#10#13,'               :');
     Write(' ',HexW(loop));
    end;
  end;
 if NotUsed>0 then WriteLn;
 WriteLn('  of ',TNT.tiles,' tiles - ',NotUsed,' are unreferenced.');
 FreeMem(TileChart,65534);
end;

Procedure SaveTile(nr: LongInt;const Filename: PathStr);
var
 gfx           :Pointer;
begin
 if nr>TNT.Tiles-1 then
  begin
   WriteLn(' ! adressing non-existant tile #',nr);
   exit;
  end;
 WriteLn('  Writing tile #',nr,' as "',filename,'"');
 GetMem(gfx,1024);
 Seek(F,TNT.PTRtilegfx+(nr*1024));
 BlockRead(F,gfx^,1024,BytesRead);
 RIX_Save(Filename,gfx,palette,32,32);
 FreeMem(gfx,1024);
end;

Procedure SaveTileMap(nr: Word;const Filename: PathStr);
var
 VScreen                :Pointer;
 loop                   :LongInt;
 gfx                    :Pointer;
 X,Y                    :Word;
begin
 GetMem(VScreen,320*200);
 GetMem(gfx,1024);
 FilLChar(VScreen^,320*200,0);
 X:=0;
 Y:=0;
{ Write('  Processing tile# xxxx');}
 for loop:=nr to Min(nr+59,TNT.Tiles-1) do
  begin
{   Write(#8#8#8#8);
   Write(Lz(loop,4));}
   Seek(F,TNT.PTRtilegfx+(loop*1024));
   BlockRead(F,gfx^,1024,BytesRead);
   PutGFX(X*32,Y*32,32,32,Seg(gfx^),Ofs(gfx^),Seg(Vscreen^));
   Inc(X,1);
   if X>9 then
    begin
     X:=0;
     Inc(Y,1);
    end;
  end;
{ WriteLn;}
 WriteLn('  Writing tile #',nr,'-',Min(nr+59,TNT.Tiles-1),' as "',filename,'"');
 RIX_Save(filename,VScreen,palette,320,200);
 FreeMem(gfx,1024);
 FreeMem(VScreen,320*200);
end;

Procedure SaveMiniMap(const Filename: PathStr);
var
 data           :Pointer;
begin
 if (MiniMapW*MiniMapH<65535) then
 begin
  WriteLn('Writing minimap as "',filename,'"');
  GetMem(data,65535);
  Seek(F,TNT.PTRminimap+8);
  BlockRead(F,data^,MiniMapW*MiniMapH,BytesRead);
  RIX_Save(Filename,data,palette,MiniMapW,MiniMapH);
  FreeMem(data,65535);
 end else WriteLn('Minimap too large :-(');
end;

Procedure SaveMap(const Filename: Pathstr);
var
 Tile                   :LongInt;
 tilegfx                :Pointer;
 tiledata               :Pointer;
 F2                     :File;
 loop2                  :LongInt;
begin
 GetMem(tilegfx,1024);
 GetMem(tiledata,65535);
 FillChar(tiledata^,65535,0);

 Write('  Writing RIX header ...');
 RIX_WriteHeader(filename,Palette,(TNT.width div 2)*32,(TNT.height div 2)*32);
 Assign(F2,filename);
 Reset(F2,1);
 Seek(F2,FileSize(F2));
 WriteLn('OK!');
 loop2:=(TNT.width div 2)*(TNT.height div 2)*32*32;
 Write('  Preparing file of ',KiloComma(loop2+778),' bytes ...');

 While loop2>0 do
  begin
   if loop2>65535 then loop:=65535 else loop:=loop2;
   BlockWrite(F2,tiledata^,loop,bytesread);
   Dec(Loop2,loop);
  end;
 WriteLn('OK!');

 WriteLn('  Processing ',TNT.height div 2,' maplines.');
 Write('  Progress: ');
 for loop:=0 to (TNT.height div 2)-1 do
  begin
   Seek(F,TNT.PTRmapdata+(loop*TNT.width));
   { Read a whole scanline of map tile data }
   BlockRead(F,tiledata^,TNT.width,BytesRead);
   for loop2:=0 to (TNT.width div 2)-1 do
    begin
     tile:=MemW[Seg(tiledata^):Ofs(tiledata^)+(loop2*2)];
     Seek(F,TNT.PTRtilegfx+(tile*1024));
     BlockRead(F,tilegfx^,1024,bytesread);
     FileBlockWrite(F2,778,loop2*32,loop*32,32,32,(TNT.width div 2)*32,(TNT.height div 2)*32,tilegfx);
    end;
   Write('');
  end;
 Close(F2);
 WriteLn;
 WriteLn('  Completed!');
 FreeMem(tiledata,65535);
 FreeMem(tilegfx,1024);
end;

Procedure LoadPaletteBIN;
var
 F              :File;
begin
 if PaletteBINloaded then Exit;
 Write('  Loading ',ProgramPath(ParamStr(0)),'PALETTE.BIN');
 if Exist(ProgramPath(ParamStr(0))+'PALETTE.BIN') then
 begin
  Assign(F,ProgramPath(ParamStr(0))+'PALETTE.BIN');
  Reset(F,1);
  BlockRead(F,Palette,256*3,BytesRead);
  Close(F);
  PaletteBINloaded:=True;
 end else Write(' - file not found');
 WriteLn;
end;

Procedure SaveHeightMap(filename: PathStr);
var
 F2                     :File;
 data                   :Array[1..4] of byte;
 Loop,
 cnt                    :LongInt;
 Palette                :Array[1..256*3] of byte;

begin
 Write('  Loading ',ProgramPath(ParamStr(0)),'HEIGHT.BIN');
 Assign(F2,ProgramPath(ParamStr(0))+'HEIGHT.BIN');
 Reset(F2,1);
 BlockRead(F2,Palette,256*3,BytesRead);
 Close(F2);
 WriteLn;

 Write('  Writing RIX header ...');
 RIX_WriteHeader(Filename,Palette,TNT.width,TNT.height);
 WriteLn;

 Assign(F2,filename);
 Reset(F2,1);
 Seek(F2,FileSize(F2));

 Seek(F,TNT.PTRmapattr);
 cnt:=(TNT.height)*(TNT.width);
 Write('  Writing ',cnt,' pixels...');
 for loop:=1 to cnt do
  begin
   BlockRead(F,data[1],4,BytesRead);
   BlockWrite(F2,data[1],1,BytesRead);
  end;
 Close(F2);
 WriteLn;
end;

Procedure SplitTNT(filename: PathStr);
var
 T              :Text;
 F2             :File;
 loop           :LongInt;
 data           :Pointer;
 doread         :Word;

begin
 GetMem(data,65535);
 WriteLn('  TNT Splitting in progress ...');

 Assign(T,filename+'.!IN');
 Rewrite(T);

 WriteLn(T,'; Total Annihilation Map Resources extracted using TATool ',version);
 WriteLn(T,'; (C)1997 Saruman / DFR Research & Engineering. -- FREEWARE');
 WriteLn(T,'');
 WriteLn(T,'[TNT]');
 WriteLn(T,' file = ',filename,'.TNT');
 WriteLn(T,' size = ',FileSize(F));
 WriteLn(T,'');

 WriteLn(T,'[HEADER]');
 WriteLn(T,' IDversion = ',TNT.IDversion);
 WriteLn(T,' width = ',TNT.Width);
 WriteLn(T,' height = ',TNT.Height+FIXUP);
 WriteLn(T,' tiles = ',TNT.tiles);
 WriteLn(T,' tileanims = ',TNT.tileanims);
 WriteLn(T,' sealevel = ',TNT.sealevel);
 WriteLn(T,' PTRmapdata = ',TNT.PTRmapdata);
 WriteLn(T,' PTRmapattr = ',TNT.PTRmapattr);
 WriteLn(T,' PTRtilegfx = ',TNT.PTRtilegfx);
 WriteLn(T,' PTRtileanim = ',TNT.PTRtileanim);
 WriteLn(T,' PTRminimap = ',TNT.PTRminimap);
 WriteLn(T,' unknown1 = ',TNT.unknown1);
 WriteLn(T,' pad1 = ',TNT.pad1);
 WriteLn(T,' pad2 = ',TNT.pad2);
 WriteLn(T,' pad3 = ',TNT.pad3);
 WriteLn(T,' pad4 = ',TNT.pad4);
 WriteLn(T,'');

 WriteLn(T,'[EXTRACTED]');

 { MAP DATA }
 loop:=(TNT.Width div 2)*((TNT.Height+FIXUP) div 2)*2;
 Write('  Extracting ',KiloComma(loop),' bytes of map data to '+filename+'.!MD');
 WriteLn(T,' Mapdata = ',filename+'.!MD');
 WriteLn(T,' Mapdatasize = ',Loop);
 WriteLn(T,'');
 Assign(F2,filename+'.!MD');
 ReWrite(F2,1);
 Seek(F,TNT.PTRmapdata);
 While loop>0 do
  begin
   if loop>65355 then doread:=65535 else doread:=loop;
   BlockRead(F,data^,doread,bytesread);
   Dec(Loop,doread);
   BlockWrite(F2,data^,doread,bytesread);
  end;
 Close(F2);
 WriteLn(' [ok]');

 { MAP DATA ATTRIBUTES }
 loop:=(TNT.Width)*((TNT.Height+FIXUP))*4;
 Write('  Extracting ',KiloComma(loop),' bytes of map data attributes to '+filename+'.!MA');
 WriteLn(T,' Mapdataattributes = ',filename+'.!MA');
 WriteLn(T,' Mapdataattributessize = ',Loop);
 WriteLn(T,'');
 Assign(F2,filename+'.!MA');
 ReWrite(F2,1);
 Seek(F,TNT.PTRmapattr);
 While loop>0 do
  begin
   if loop>65355 then doread:=65535 else doread:=loop;
   BlockRead(F,data^,doread,bytesread);
   Dec(Loop,doread);
   BlockWrite(F2,data^,doread,bytesread);
  end;
 Close(F2);
 WriteLn(' [ok]');

 { TILE GRAPHICS }
 Write('  Extracting graphics for ',KiloComma(TNT.tiles),' tiles to '+filename+'.!TG');
 WriteLn(T,' tilegraphics = ',filename+'.!TG');
 WriteLn(T,' tilegraphicssize = ',TNT.tiles);
 WriteLn(T,'');
 Assign(F2,filename+'.!TG');
 ReWrite(F2,1);
 Seek(F,TNT.PTRtilegfx);
 for loop:=0 to TNT.tiles-1 do
  begin
   BlockRead(F,data^,1024,bytesread);
   BlockWrite(F2,data^,1024,bytesread);
  end;
 Close(F2);
 WriteLn(' [ok]');

 { ANIMATED TILES/SCENERY }
 loop:=TNT.PTRminimap-TNT.PTRtileanim;
 Write('  Extracting ',KiloComma(TNT.tileanims),' tileanim entries to '+filename+'.!TA');
 WriteLn(T,' tileanim = ',filename+'.!TA');
 WriteLn(T,' tileanimsize = ',loop);
 WriteLn(T,'');
 Assign(F2,filename+'.!TA');
 ReWrite(F2,1);
 Seek(F,TNT.PTRtileanim);
  While loop>0 do
  begin
   if loop>65355 then doread:=65535 else doread:=loop;
   BlockRead(F,data^,doread,bytesread);
   Dec(Loop,doread);
   BlockWrite(F2,data^,doread,bytesread);
  end;
 Close(F2);
 WriteLn(' [ok]');

 { MINIMAP }
 Loop:=(minimapW*minimapH)+8;
 Write('  Extracting minimap to '+filename+'.!MM');
 WriteLn(T,' minimap = ',filename+'.!MM');
 WriteLn(T,' minimapsize = ',loop);
 WriteLn(T,'');
 Assign(F2,filename+'.!MM');
 ReWrite(F2,1);
 Seek(F,TNT.PTRminimap);
  While loop>0 do
  begin
   if loop>65355 then doread:=65535 else doread:=loop;
   BlockRead(F,data^,doread,bytesread);
   Dec(Loop,doread);
   BlockWrite(F2,data^,doread,bytesread);
  end;
 Close(F2);
 WriteLn(' [ok]');
 WriteLn('  TNT Split completed.');
 Close(T);
 FreeMem(Data,65535);
end;

Procedure JoinTNT(filename: PathStr);
var
 T              :Text;
 F2             :File;
 loop           :LongInt;
 data           :Pointer;

 outfile        :PathStr;
 origsize       :LongInt;

 Mapdata,
 Mapdataattributes,
 tilegraphics,
 tileanim,
 minimap        :String;

 new_tiles,
 new_tileanims,
 pos_mapdata,
 pos_mapdataattributes,
 pos_tilegraphics,
 pos_tileanim,
 pos_minimap    :LongInt;

begin
 Assign(T,filename);
 Reset(T);
 GetINI2(T,'[TNT]','file',S);
 if S='' then begin
  WriteLn('  [TNT] "file=" empty? - cannot proceed.');
  Close(T);
  Exit;
  end;
 Outfile:=S;

 if (exist(outfile)) and (not paramexist('-o')) then begin
  WriteLn('  Outfile already exists - cannot proceed. (use -o to override)');
  Close(T);
  Exit;
 end;

 mapdata:='';
 mapdataattributes:='';
 tilegraphics:='';
 tileanim:='';
 minimap:='';
 { load all resource files }
 GetINI2(T,'[EXTRACTED]','mapdata',mapdata);
 GetINI2(T,'[EXTRACTED]','mapdataattributes',mapdataattributes);
 GetINI2(T,'[EXTRACTED]','tilegraphics',tilegraphics);
 GetINI2(T,'[EXTRACTED]','tileanim',tileanim);
 GetINI2(T,'[EXTRACTED]','minimap',minimap);

 WriteLn('  Checking existance of MAPDATA resource: ',mapdata);
 if NOT Exist(mapdata) then begin WriteLn('  file not found - cannot proceed.'); Close(T); Exit; end;

 WriteLn('  Checking existance of MAPDATAATTRIBUTES resource: ',mapdata);
 if NOT Exist(mapdataattributes) then begin WriteLn('  file not found - cannot proceed.'); Close(T); Exit; end;

 WriteLn('  Checking existance of TILEGRAPHICS resource: ',tilegraphics);
 if NOT Exist(tilegraphics) then begin WriteLn('  file not found - cannot proceed.'); Close(T); Exit; end;

 WriteLn('  Checking existance of TILEANIM resource: ',tileanim);
 if NOT Exist(tileanim) then begin WriteLn('  file not found - cannot proceed.'); Close(T); Exit; end;

 WriteLn('  Checking existance of MINIMAP resource: ',minimap);
 if NOT Exist(minimap) then begin WriteLn('  file not found - cannot proceed.'); Close(T); Exit; end;

 Assign(F,outfile);
 ReWrite(F,1);

 GetMem(Data,65535);

 GetINI2(T,'[TNT]','size',S);
 Origsize:=Va(S);
 WriteLn('  Joining into ',outfile,' (original size: ',KiloComma(origsize),')');

 { Read header entries }
 WriteLn('  Reading old header entries');
 GetINI2(T,'[HEADER]','IDversion',S);     TNT.IDversion:=Va(S);
 GetINI2(T,'[HEADER]','width',S);         TNT.width:=Va(S);
 GetINI2(T,'[HEADER]','height',S);        TNT.height:=Va(S);
 GetINI2(T,'[HEADER]','tiles',S);         TNT.tiles:=Va(S);
 GetINI2(T,'[HEADER]','tileanims',S);     TNT.tileanims:=Va(S);
 GetINI2(T,'[HEADER]','sealevel',S);      TNT.sealevel:=Va(S);
 GetINI2(T,'[HEADER]','PTRmapdata',S);    TNT.PTRmapdata:=Va(S);
 GetINI2(T,'[HEADER]','PTRmapattr',S);    TNT.PTRmapattr:=Va(S);
 GetINI2(T,'[HEADER]','PTRtilegfx',S);    TNT.PTRtilegfx:=Va(S);
 GetINI2(T,'[HEADER]','PTRtileanim',S);   TNT.PTRtileanim:=Va(S);
 GetINI2(T,'[HEADER]','PTRminimap',S);    TNT.PTRminimap:=Va(S);
 GetINI2(T,'[HEADER]','unknown1',S);      TNT.unknown1:=Va(S);
 GetINI2(T,'[HEADER]','pad1',S);          TNT.pad1:=Va(S);
 GetINI2(T,'[HEADER]','pad2',S);          TNT.pad2:=Va(S);
 GetINI2(T,'[HEADER]','pad3',S);          TNT.pad3:=Va(S);
 GetINI2(T,'[HEADER]','pad4',S);          TNT.pad4:=Va(S);

 WriteLn('  Stamping old header on output file');
 BlockWrite(F,TNT,SizeOf(TA_TNTHeader),bytesread);

 Write('  Appending MAPDATA resource ...');
 pos_mapdata:=FilePos(F);
 Assign(F2,mapdata);
 Reset(F2,1);
 While NOT EoF(F2) do
  begin
   BlockRead(F2,data^,65535,bytesread);
   BlockWrite(F,data^,bytesread,bytesread);
  end;
 Close(F2);
 WriteLn(' [ok]');

 Write('  Appending MAPDATAATTRIBUTES resource ...');
 pos_mapdataattributes:=FilePos(F);
 Assign(F2,mapdataattributes);
 Reset(F2,1);
 While NOT EoF(F2) do
  begin
   BlockRead(F2,data^,65535,bytesread);
   BlockWrite(F,data^,bytesread,bytesread);
  end;
 Close(F2);
 WriteLn(' [ok]');

 Write('  Appending TILEGRAPHICS resource ...');
 pos_tilegraphics:=FilePos(F);
 Assign(F2,tilegraphics);
 Reset(F2,1);
 new_tiles:=FileSize(F2) div 1024;
 While NOT EoF(F2) do
  begin
   BlockRead(F2,data^,65535,bytesread);
   BlockWrite(F,data^,bytesread,bytesread);
  end;
 Close(F2);
 WriteLn(' [ok]');

 Write('  Appending TILEANIM resource ...');
 pos_tileanim:=FilePos(F);
 Assign(F2,tileanim);
 Reset(F2,1);
 new_tileanims:=FileSize(F2) div 132;    { *** }
 While NOT EoF(F2) do
  begin
   BlockRead(F2,data^,65535,bytesread);
   BlockWrite(F,data^,bytesread,bytesread);
  end;
 Close(F2);
 WriteLn(' [ok]');

 Write('  Appending MINIMAP resource ...');
 pos_minimap:=FilePos(F);
 Assign(F2,minimap);
 Reset(F2,1);
 While NOT EoF(F2) do
  begin
   BlockRead(F2,data^,65535,bytesread);
   BlockWrite(F,data^,bytesread,bytesread);
  end;
 Close(F2);
 WriteLn(' [ok]');

 Seek(F,0);
 WriteLn('  Stamping recalculated header');

 TNT.PTRmapdata:=pos_mapdata;
 TNT.PTRmapattr:=pos_mapdataattributes;
 TNT.tiles:=new_tiles;
 TNT.PTRtilegfx:=pos_tilegraphics;
 TNT.tileanims:=new_tileanims;
 TNT.PTRtileanim:=pos_tileanim;
 TNT.PTRminimap:=pos_minimap;
 BlockWrite(F,TNT,SizeOf(TA_TNTHeader),Bytesread);

 WriteLn('  Join complete. (file size=',KiloComma(FileSize(F)),')');
 FreeMem(Data,65535);
 Close(F);
 Close(T);
end;

Procedure Rix2MM(fn,s: PathStr);
var
 F,F2            :File;
 buf             :Pointer;
 w,h             :LongInt;
begin
 WriteLn('  Creating minimap "',s,'" from "',fn,'"');
 RIX_ReadHeader(fn,Palette,w1,w2);
 w:=w1; h:=w2;
 if (w1<>$FC) or (w1<>$FC) then begin
  WriteLn('  Error: Image width/height not $FC (252)');
  exit;
 end;
 Assign(F,fn); Reset(F,1);
 Seek(F,778);
 Assign(F2,s); ReWrite(F2,1);
 BlockWrite(F2,w,4,bytesread);
 BlockWrite(F2,h,4,bytesread);
 GetMem(Buf,65535);
 BlockRead(F,Buf^,65535,BytesRead);
 BlockWrite(F2,Buf^,BytesRead,BytesRead);
 FreeMem(Buf,65535);
 WriteLn('  Done');
end;

Procedure ProcessGAF;
begin
 BlockRead(F,GAF,SizeOf(TA_GAFHeader));
 DumpGAFInfo;

end;

Procedure Info;
begin
 WriteLn('TATOOL <filename> [options]');
 WriteLn;
 WriteLn(' filename:                        ; .TNT, .GAF, .RIX/.SCX or .!IN');
 WriteLn;
 WriteLn(' options:');
 WriteLn('  -saveminimap                    ; Extract the minimap');
 WriteLn('  -showminimap                    ; View the minimap');
 WriteLn('  -savemap                        ; Extract complete map as picture');
 WriteLn('  -savetile  [tile#] [lasttile#]  ; Extract the tiles');
 WriteLn('  -tilemap [tile#]                ; Creates one map of a set of tiles');
 WriteLn('  -tilemaps                       ; Create maps of all tiles');
 WriteLn('  -heightmap                      ; Create heightmap');
 WriteLn('  -viewheightmap                  ; View heightmap');
 WriteLn('  -split                          ; Split map into it''s components');
 WriteLn('  -join [-o]                      ; Join components to create map');
 WriteLn('  -rix2mm                         ; RIX to Minimap (*.!MM');
 WriteLn('  -analyze                        ; Deeper analyzis of TNT.');
 WriteLn;
 WriteLn(' All graphics extracted in RIX/SCX format.');
 Halt(0);
end;

BEGIN
 SavedExitProc:=ExitProc;
 ExitProc:=@CustomExit;

 Assign(Output,'');
 ReWrite(Output);

 WriteLn('Total Annihilation Tool v',Version,' - (C)1997 Saruman / DFR Research & Engineering');
 WriteLn('File Format Research by Saruman & Bobban, 1997-10-22. (use -h for help)');

 WriteLn;
 PaletteBINloaded:=False;

 if ParamExist('-h') or (ParamExist('-?')) then Info;

 fn:=Upper_F(ParamStr(1));
 if fn='' then Info;

 if NOT Exist(fn) then begin
   WriteLn('  Error: File "',fn,'" not found.');
   Halt(1);
  end;

 if (FileExt(fn)='SCX') or (FileExt(fn)='RIX') then
  begin

   if ParamExist('-extrpal') then
    begin
     S:=ParamStr(ParamNr('-extrpal')+1);
     if S='' then WriteLn('  Must supply filename for output file (-extrpal)')
      else begin
       WriteLn('  Extracting palette from ',FN,' to ',S);
       SavePaletteFromRix(fn,s);
      end;
      halt;
     end;

     if ParamExist('-rix2mm') then
     begin
      S:=ParamStr(ParamNr('-rix2mm')+1);
      if S='' then S:=FileBase(fn)+'.!MM';
      Rix2MM(fn,s);
      halt;
     end;

   RIX_Show_Interactive(fn);
   SetScreen($3);
   Halt;
  end;

 if (FileExt(fn)='!IN') or (ParamExist('-join')) then
  begin
   WriteLn('  Merging resources using ',FN,' to create new .TNT file');
   JoinTNT(fn);
   halt;
  end;

 WriteLn('  Reading header from '+fn);
 Assign(F,fn);
 Reset(F,1);

 if (FileExt(fn)='GAF') then
  begin
   ProcessGAF;
   Close(F);
   Halt;
  end;

 BlockRead(F,TNT,SizeOf(TA_TNTHeader),BytesRead);
 Seek(F,TNT.PTRMinimap);
 Blockread(F,MinimapW,4,BytesRead);
 Blockread(F,MinimapH,4,BytesRead);

 DumpTNTInfo;

 if Fixup<>0 then
 begin
{  WriteLn('  Internal Map Height fixup executed!');}
  Dec(TNT.height,FIXUP);
 end;

 if ParamExist('-savemap') then
  begin
   LoadPaletteBIN;
   WriteLn('  Writing poster to "',FileBase(FN)+'.SCX','"');
   SaveMap(FileBase(FN)+'.SCX');
  end;

 if ParamExist('-savetile') then
  begin
   LoadPaletteBIN;
   w1:=Va(ParamStr(ParamNr('-savetile')+1));
   w2:=Va(ParamStr(ParamNr('-savetile')+2));
   if w2<w1 then w2:=w1;
   if w2>TNT.tiles-1 then w2:=TNT.tiles-1;
   WriteLn('  Extracting tiles #',w1,' thru ',w2);
   for loop:=w1 to w2 do
    SaveTile(loop,'TILE'+Lz(Loop,4)+'.SCX');
  end;

 if ParamExist('-tilemap') then
  begin
   LoadPaletteBIN;
   loop:=Va(ParamStr(ParamNr('-tilemap')+1));
   WriteLn('  Creating tilemap of tiles #',loop,' thru ',Min(loop+60,TNT.tiles));
   SaveTileMap(loop,'TMAP'+Lz(loop,4)+'.SCX');
  end;

 if ParamExist('-tilemaps') then
  begin
   LoadPaletteBIN;
   WriteLn('  Creating tilemaps - ',Trunc(TNT.tiles div 60)+1,' files needed.');
   loop:=0;
   While (loop<TNT.tiles-1) do
   begin
    SaveTileMap(loop,'TMAP'+Lz(Loop,4)+'.SCX');
    Inc(Loop,60);
   end;
  end;

 if ParamExist('-heightmap') then
  begin
   WriteLn('  Creating heightmap as "',FileBase(FN)+'.SCX','"');
   SaveHeightMap(FileBase(FN)+'.SCX');
  end;

 if ParamExist('-viewheightmap') then
  begin
   WriteLn('  Creating heightmap...');
   SaveHeightMap('TEMP.$$$');
   SetScreen($13);
   RIX_Show_Interactive('TEMP.$$$');
   SetScreen($3);
   Kill('TEMP.$$$');
  end;

 if ParamExist('-saveminimap') then
  begin
   LoadPaletteBIN;
   SaveMiniMap(FileBase(fn)+'.SCX');
  end;

 if ParamExist('-showminimap') then
  begin
   LoadPaletteBIN;
   SaveMiniMap('TEMP.$$$');
   SetScreen($13);
   RIX_Show_Interactive('TEMP.$$$');
   SetScreen($3);
   Kill('TEMP.$$$');
  end;

 if ParamExist('-split') then
  begin
   SplitTNT(FileBase(fn));
  end;

 if ParamExist('-analyze') then
  begin
   Check_TileReferences;
   WriteLn('  Analyzis complete.');
  end;

 Close(F);
END.
