// Soul.cpp: implementation of the CSoul class.
//
//////////////////////////////////////////////////////////////////////



#include "extdll.h" 
#include "decals.h" 
#include "util.h" 
#include "cbase.h" 
#include "monsters.h" 
#include "weapons.h" 
#include "nodes.h" 
#include "player.h" 
#include "soundent.h" 
#include "shake.h" 
#include "gamerules.h"
#include "Soul.h"
#include "animation.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//extern void CopyToBodyQue(entvars_t *pev);
//extern edict_t				*g_pBodyQueueHead;
//

//CSoul Functions
//Spawn
/***************************
* CSoul::Spawn
* 
* In: none
* Mod: this
* ret: none
*
* Generate a generic soul, no owner yet
****************************/

void CSoul::Spawn()
	{ 
		pev->classname = MAKE_STRING("soul");
		pev->movetype = MOVETYPE_TOSS;
		pev->solid = SOLID_TRIGGER;
		pev->effects |= (EF_BRIGHTFIELD | EF_LIGHT);
		pev->absmin = pev->origin + Vector(-16, -16, 0);
		pev->absmax = pev->origin + Vector(16, 16, 16); 
//		SET_MODEL(ENT(pev), SOUL_MODEL);
		SetTouch(ItemTouch);

	}

//Precache
/***************************
* CSoul::Precache
* 
* In: none
* Mod: none
* ret: none
*
* originally, souls were freaked-out Xen models
* that needed to be precached before use.
* Player models are already cached, so nothing is done here.
****************************/

void CSoul::Precache( void )
	{
//		PRECACHE_MODEL (SOUL_MODEL);
	}

void CSoul::Kill( void )
	{
	 UTIL_Remove(this);
	}


//MyTouch
/***************************
* CSoul::MyTouch
* 
* In: CBasePlayer
* Mod: this
* ret: Bool
*
* Function to handle the soul being touched (picked up)
* by something. Return true if player, false otherwise
****************************/


BOOL CSoul::MyTouch( CBasePlayer *pPlayer )
	{
		if (!pPlayer->IsAlive()) //touched by a corpse
			{
			 return FALSE;
			}
		if (!pPlayer->IsPlayer())//touched by non-player
			{
			 return FALSE;
			};     
int ms = (int) CVAR_GET_FLOAT("sv_soullimit"); //grab server variable
		if ((++pPlayer->m_souls)%ms==0) // each time a player gets x souls, give them an effect
			{
			 if (RANDOM_LONG(0,1)) //randomize pick-up sound
			 EMIT_SOUND( pPlayer->edict(), CHAN_ITEM, "garg/gar_step1.wav", 1, ATTN_NORM );
			 else
			 EMIT_SOUND( pPlayer->edict(), CHAN_ITEM, "garg/gar_step2.wav", 1, ATTN_NORM );
					//NEW: souls retain appearance of ORIGINAL owner
			 int i;
			 int j=ENTINDEX(ENT(pPlayer->pev)); 
			 for (i=0;i<10;i++)
			 pPlayer->soulEnt[i]=j; //all souls "consumed" for blessing.. reset
									//array so all dropped souls look like this player

			 TriggerEffect(pPlayer); //give the blessing
			}
		else //no blessing, just another soul
			{
			 int curSoul =(pPlayer->m_souls)%ms; 
			 pPlayer->soulEnt[curSoul]=pev->renderamt; //make sure this soul looks like it's former
														//owner when dropped 
			 if (RANDOM_LONG(0,1))//randomize pick-up sound
			 EMIT_SOUND (pPlayer->edict(), CHAN_ITEM, "zombie/claw_miss1.wav", 1, ATTN_NORM);

			 else
			 EMIT_SOUND( pPlayer->edict(), CHAN_ITEM, "zombie/claw_miss2.wav", 1, ATTN_NORM);
			}

			 SetTouch(NULL); //soul picked-up.. get rid of it
			 ALERT(at_console,"Removed soul\n");
			 UTIL_Remove(this);
		 return TRUE;

	}

/***************************
* CSoul::TriggerEffect
* 
* In: CBasePlayer
* Mod: owner
* ret: none
*
* turn "soul" into clone based on CBasePlayer
****************************/

int CSoul::TriggerEffect(CBasePlayer *pPlayer )
	{
		hudtextparms_t textparms;
		char text[1024];
		char mEffect[128];
		int madness;
		int min = (int) CVAR_GET_FLOAT("_blessingmin");
		int max = (int) CVAR_GET_FLOAT("_blessingmax");
//		float msgx = CVAR_GET_FLOAT("_hudx");
//		float msgy = CVAR_GET_FLOAT("_hudy");


		if (min==max) //testing condition: set min to max to test 1 blessing
			{
			 madness = min;
			 if (pPlayer->m_effectTime)
				{
				 pPlayer->m_effectTime = -1.0;
				 pPlayer->CheckTimeBasedEffect();
				}
			}
		else if (pPlayer->m_effectTime) //if player has a time-based blessing...
			{
			 madness = RANDOM_LONG (1,SOUL_CLONE);//give them a non-t-b blessing

			}
		else  //no time-based blessing...
			{
			 madness = RANDOM_LONG (min,max);//give them any blessing
			}
		switch (madness) //what blessing?
			{
				case 1: sprintf(mEffect,"longevity"); //extra life
						textparms.r1=0; //perdy colors
						textparms.g1=255;
						textparms.b1=0;
						pPlayer->pev->health=200; break;//set player health to 200

				case 2: sprintf(mEffect,"durability");
						textparms.r1=0;
						textparms.g1=0;
						textparms.b1=255;
						pPlayer->pev->armorvalue=200; break;//set player armor=200

				case 3: sprintf(mEffect,"bounty");
						textparms.r1=255;
						textparms.g1=0;
						textparms.b1=255; //give player too much crap :P
						pPlayer->GiveNamedItem( "weapon_shotgun" );
						pPlayer->GiveNamedItem( "ammo_buckshot" );
						pPlayer->GiveNamedItem( "weapon_9mmAR" );
						pPlayer->GiveNamedItem( "ammo_9mmAR" );
						pPlayer->GiveNamedItem( "ammo_ARgrenades" );
						pPlayer->GiveNamedItem( "weapon_handgrenade" );
						pPlayer->GiveNamedItem( "weapon_tripmine" );
						#ifndef OEM_BUILD //(cut-and-paste job)
						pPlayer->GiveNamedItem( "weapon_357" );
						pPlayer->GiveNamedItem( "ammo_357" );
						pPlayer->GiveNamedItem( "weapon_crossbow" );
						pPlayer->GiveNamedItem( "ammo_crossbow" );
						pPlayer->GiveNamedItem( "weapon_egon" );
						pPlayer->GiveNamedItem( "weapon_gauss" );
						pPlayer->GiveNamedItem( "ammo_gaussclip" );
						pPlayer->GiveNamedItem( "weapon_rpg" );
						pPlayer->GiveNamedItem( "ammo_rpgclip" );
						pPlayer->GiveNamedItem( "weapon_satchel" );
						pPlayer->GiveNamedItem( "weapon_snark" );
						pPlayer->GiveNamedItem( "weapon_hornetgun" );
						#endif
						break;

				case SOUL_CLONE:
						textparms.r1=255;
						textparms.g1=0;
						textparms.b1=128;
						sprintf(mEffect, "a divine clone"); 
						MakeClone(pPlayer);//make da clone
						break;		

				case SOUL_CLOAK:
						textparms.r1=128;
						textparms.g1=0;
						textparms.b1=255;
						sprintf(mEffect,"cloak of deception"); 
						break;

				case SOUL_ALLIANCE:	
						textparms.r1=255;
						textparms.g1=0;
						textparms.b1=0;
						pPlayer->pev->flags |= FL_GODMODE; //eenveenceeble!!
						pPlayer->pev->renderamt = 128; 
						pPlayer->pev->rendercolor.x = 128;
						pPlayer->pev->rendercolor.y = 0;
						pPlayer->pev->rendercolor.z = 255; //color o' shell
						pPlayer->pev->renderfx = 	kRenderFxGlowShell;//shell!
						sprintf(mEffect, "unholy armor");
						break;

				case SOUL_FLY: //a.k.a. 15 bean soup blessing
						textparms.r1=64;
						textparms.g1=64;
						textparms.b1=255;
						//crap to generate trail (see rocket code)
						MESSAGE_BEGIN( MSG_BROADCAST, SVC_TEMPENTITY );
						WRITE_BYTE( TE_BEAMFOLLOW );
						WRITE_SHORT(pPlayer->entindex());	// entity
						WRITE_SHORT(PRECACHE_MODEL("sprites/smoke.spr") );	// model
						WRITE_BYTE( 40 ); // life
						WRITE_BYTE( 5 );  // width
						WRITE_BYTE( 204 );   // r, g, b
						WRITE_BYTE( 204 );   // r, g, b
						WRITE_BYTE( 255 );   // r, g, b
						WRITE_BYTE( 255 );	// brightness
						MESSAGE_END();  // move PHS/PVS data sending into here (SEND_ALL, SEND_PVS, SEND_PHS)

						pPlayer->pev->gravity = 0.01; //"flight" by less gravity
						sprintf(mEffect,"wings of destruction"); 
						break;
//NEW: blessing to show enemy stats (health/armor)
				case SOUL_PERCEPTION:
						textparms.r1=128;
						textparms.g1=128;
						textparms.b1=0;
						sprintf(mEffect,"perception"); 
						break;

//NEW: blessing that reduces gravity to player
				case SOUL_GRAVITY:
						textparms.r1=0;
						textparms.g1=128;
						textparms.b1=64;
					    pPlayer->pev->gravity=0.2;//wow
						sprintf(mEffect,"anti-gravity boots"); 
						break;

//NEW: blessing to increase max speed to player
				case SOUL_SPEED:
						textparms.r1=64;
						textparms.g1=155;
						textparms.b1=64;
						sprintf(mEffect,"boots of mercury"); 
						break;

				default: ALERT(at_console, "called effect default\n");
						 sprintf(mEffect, "unknown %d",madness); //eek!

			}

//setup for time-based blessings
		//every blessing who's number is greater than SOUL_CLONE is considered time-based
		//If this changes, be sure to adjust this if necesssary
		if (madness > SOUL_CLONE) //don't do this unless its time based
			{    
			 pPlayer->m_effect = madness; //set blessing to player
			 pPlayer->m_effectTime= 30.0; // allow 30 sec effect
			 pPlayer->m_effectPrev=gpGlobals->time;//initialize comparitor time
			 //HUD stuff.. keep msg up 'til blessing is gone
			 textparms.y = 1;
			 textparms.holdTime=28.0; //28 s
			 textparms.fadeinTime=1.0; // 1 s
			 textparms.fadeoutTime=1.0;// 1 s
			 textparms.channel=CHAN_ITEM;
			}
		else //not time based
			{
			//HUD stuff again
			 textparms.y = .93;
			 textparms.holdTime=6.5; //6.5 s
			 textparms.fadeinTime=1.0; // 1.0 s
			 textparms.fadeoutTime=2.5; //2.5 s
			 textparms.channel=CHAN_STATIC;
			}
 sprintf(text, "%s was blessed with %s!\n",  STRING( pPlayer->pev->netname ), mEffect);
 UTIL_ClientPrintAll( HUD_PRINTNOTIFY,text); //msg to all players
 textparms.x = .5-(float)(strlen(mEffect)*.005);

 textparms.effect=0;
//textparms.x = msgx;
//textparms.y = msgy;


//post a message to the user HUD that they have a blessing
 UTIL_HudMessage( (CBaseEntity *)pPlayer, textparms, mEffect);//msg to blessed player


 return madness;
}
/***************************
* CSoul::Clone
* 
* In: CBasePlayer
* Mod: this
* ret: none
*
* turn "soul" into clone based on CBasePlayer
****************************/
void CSoul::Clone(CBasePlayer *pPlayer)
{


	owner = pPlayer->pev; //set who we are cloning

	SetThink(CloneThink); //give the clone something to do
	pev->nextthink=gpGlobals->time + 0.1; //update clone often

	if (pev->effects & EF_NODRAW) 
		return;

	pev->movetype = MOVETYPE_TOSS; //toss!
	pev->solid = SOLID_TRIGGER; //not really "solid"
	pev->netname = owner->netname; //i don't know why I left this in
	pev->model = owner->model; //I'm sure some of these lines can go
	pev->modelindex = owner->modelindex;
	pev->colormap = owner->colormap;
	pev->skin = owner->skin;
	pev->body = owner->body;
	pev->framerate = 1.0;

	UTIL_SetOrigin(pev, owner->origin); //give it "feet"
	UTIL_SetSize(pev, owner->mins, owner->maxs);
	pev->renderfx	= kRenderFxDeadPlayer; //looks like the dead player
	pev->renderamt	= ENTINDEX( ENT( owner ) );


}
/************************
* CSoul::CloneThink
*
* Update function for clone:
* Copy owner's relative position,
* remove on owner death
*************************/
void CSoul::CloneThink( void )
{
		if ((owner->deadflag == DEAD_DYING) || (owner->deadflag == DEAD_DEAD))
			{	//if the owner is dead, kill clone
			 SetTouch(NULL);
			 ALERT(at_console,"Removed clone\n");
			 UTIL_Remove(this);
			}

	if ( FBitSet(owner->flags, FL_DUCKING) && !FBitSet(pev->flags,FL_DUCKING)) 
		{//owner ducking & clone not ducking, clone must duck

		//BUG: this doesn't work for all models for some reason
		 UTIL_SetSize(pev, VEC_DUCK_HULL_MIN, VEC_DUCK_HULL_MAX);
//		 pev->origin = pev->origin - (VEC_DUCK_HULL_MIN - VEC_HULL_MIN);
		 SetBits(pev->flags, FL_DUCKING);
		}
	else if (!FBitSet(owner->flags, FL_DUCKING) && FBitSet(pev->flags,FL_DUCKING))
		{//owner standing & clone ducking, clone must stand!
		 ClearBits(pev->flags,FL_DUCKING);
//		 pev->origin = pev->origin + (VEC_DUCK_HULL_MIN - VEC_HULL_MIN);
		 UTIL_SetSize(pev, VEC_HULL_MIN, VEC_HULL_MAX);
		}

	pev->angles = owner->angles; //copy details of owner position
	pev->frame = owner->frame;
	pev->weaponmodel = owner->weaponmodel;
	pev->viewmodel = owner->viewmodel;
	pev->sequence = owner->sequence;
	pev->animtime = owner->animtime;
	pev->gaitsequence = owner->gaitsequence;
	void *pmodel = GET_MODEL_PTR( ENT(pev) );
	SetController( pmodel, pev, 0, owner->controller[0] );
	SetController( pmodel, pev, 1, owner->controller[1] );
	SetController( pmodel, pev, 2, owner->controller[2] );
	SetController( pmodel, pev, 3, owner->controller[3] );
	::SetBlending( pmodel, pev, 0, owner->blending[0] );
	::SetBlending( pmodel, pev, 1, owner->blending[1] );

	pev->nextthink=gpGlobals->time + 0.1; //next think time!
	

}
/***********************
* SoulSpawn
* In:  CBasePlayer, int
* Mod: add entities to world
* ret: none
* pevVictim is the newly deceased player
* who must depart with his souls.
* Number of souls determined by in cGibs
* (function look familiar?)
*************************/

void  SoulSpawn( CBasePlayer *pevVictim, int cGibs)
{
	int cSplat;

	for ( cSplat = 0 ; cSplat < cGibs ; cSplat++ )
	{
		CSoul *pGib = GetClassPtr( (CSoul *)NULL );
		ALERT(at_console,"Created soul\n");
		pGib->pev->angles.y = RANDOM_LONG(0,359);
		pGib->SetThink( CSoul::Kill );
		pGib->pev->nextthink = gpGlobals->time + 120;//remove soul after 2(?) min
		pGib->pev->controller[0]=128;//center body
		pGib->pev->controller[1]=128;
		pGib->pev->controller[2]=128;
		pGib->pev->controller[3]=128;
		pGib->owner = pevVictim->pev;
		pGib->Spawn( );
		pGib->pev->renderfx	= kRenderFxDeadPlayer;
		pGib->pev->renderamt = pevVictim->soulEnt[cSplat];
//		pGib->pev->renderamt = ENTINDEX( ENT( pevVictim ) );
//		pGib->pev->netname = MAKE_STRING
		//pGib->pev->renderfx = kRenderFxPulseSlowWide;
		//pGib->pev->renderamt = 128;
		//pGib->pev->rendermode = kRenderTransTexture;
		pGib->pev->sequence = 11;
		pGib->pev->animtime = gpGlobals->time;
		pGib->pev->framerate = 1.0;
		UTIL_SetSize(pGib->pev, VEC_HULL_MIN, VEC_HULL_MAX);


		if ( pevVictim )
		{
			// spawn the soul somewhere in the dead guy's bounding volume
			pGib->pev->origin.x = pevVictim->pev->absmin.x + pevVictim->pev->size.x * (RANDOM_FLOAT ( 0 , 1 ) );
			pGib->pev->origin.y = pevVictim->pev->absmin.y + pevVictim->pev->size.y * (RANDOM_FLOAT ( 0 , 1 ) );
			pGib->pev->origin.z = pevVictim->pev->absmin.z + 64;
			// make the soul fly away from the attack vector
			pGib->pev->velocity = g_vecAttackDir * -1;
			pGib->pev->model = pevVictim->pev->model;
			pGib->pev->modelindex = pevVictim->pev->modelindex;
			pGib->pev->colormap = pevVictim->pev->colormap;
			pGib->pev->skin = pevVictim->pev->skin;
			pGib->pev->gravity = 0.5;

			// mix in some noise
			pGib->pev->velocity.x += RANDOM_FLOAT ( -0.5, 0.5 );
			pGib->pev->velocity.y += RANDOM_FLOAT ( -0.5, 0.5 );
			if ((pGib->pev->velocity.z += RANDOM_FLOAT ( 0.1, 0.5 ))<0)
			pGib->pev->velocity.z=0;

			pGib->pev->velocity = pGib->pev->velocity * RANDOM_FLOAT ( 300, 400 );

			
			if ( pevVictim->pev->health > -50)
			{
				pGib->pev->velocity = pGib->pev->velocity * 0.7;
			}
			else if ( pevVictim->pev->health > -200)
			{
				pGib->pev->velocity = pGib->pev->velocity * 2;
			}
			else
			{
				pGib->pev->velocity = pGib->pev->velocity * 4;
			}

		}
	}
}

/**************************************
* MakeClone
* In: CBasePlayer
* mod: +entity
* ret: none
*
* This function used by blessing routine 
* to generate clone based on given CBasePlayer
*****************************************/
void MakeClone(CBasePlayer *pPlayer)
{
				
 CSoul *clone = GetClassPtr( (CSoul *)NULL );
 clone->Clone(pPlayer);
}

/***********************************
* RadiusDamageSafe
* In: lots.. see RadiusDamage
* Mod: entities' damage, world
* ret: none
* Equivalent to RadiusDamage, but doesn't damage attacker
* Not used anymore, so whatever.
************************************/

void RadiusDamageSafe( Vector vecSrc, entvars_t *pevInflictor, entvars_t *pevAttacker, float flDamage, float flRadius, int iClassIgnore, int bitsDamageType )
{
	CBaseEntity *pEntity = NULL;
	TraceResult	tr;
	float		flAdjustedDamage, falloff;
	Vector		vecSpot;

	if ( flRadius )
		falloff = flDamage / flRadius;
	else
		falloff = 1.0;

	int bInWater = (UTIL_PointContents ( vecSrc ) == CONTENTS_WATER);

	vecSrc.z += 1;// in case grenade is lying on the ground

	if ( !pevAttacker )
		pevAttacker = pevInflictor;

	// iterate on all entities in the vicinity.
	while ((pEntity = UTIL_FindEntityInSphere( pEntity, vecSrc, flRadius )) != NULL)
	{
		if ( pEntity->pev->takedamage != DAMAGE_NO )
		{
			// UNDONE: this should check a damage mask, not an ignore
			if ( iClassIgnore != CLASS_NONE && pEntity->Classify() == iClassIgnore )
			{// houndeyes don't hurt other houndeyes with their attack
				continue;
			}

			// blast's don't tavel into or out of water
			if (bInWater && pEntity->pev->waterlevel == 0)
				continue;
			if (!bInWater && pEntity->pev->waterlevel == 3)
				continue;
			if (pevAttacker == pEntity->pev) //don't harm attacker
				continue;
			vecSpot = pEntity->BodyTarget( vecSrc );
			
			UTIL_TraceLine ( vecSrc, vecSpot, dont_ignore_monsters, ENT(pevInflictor), &tr );

			if ( tr.flFraction == 1.0 || tr.pHit == pEntity->edict() )
			{// the explosion can 'see' this entity, so hurt them!
				if (tr.fStartSolid)
				{
					// if we're stuck inside them, fixup the position and distance
					tr.vecEndPos = vecSrc;
					tr.flFraction = 0.0;
				}
				
				// decrease damage for an ent that's farther from the bomb.
				flAdjustedDamage = ( vecSrc - tr.vecEndPos ).Length() * falloff;
				flAdjustedDamage = flDamage - flAdjustedDamage;
			
				if ( flAdjustedDamage < 0 )
				{
					flAdjustedDamage = 0;
				}
			
				// ALERT( at_console, "hit %s\n", STRING( pEntity->pev->classname ) );
				if (tr.flFraction != 1.0)
				{
					ClearMultiDamage( );
					pEntity->TraceAttack( pevInflictor, flAdjustedDamage, (tr.vecEndPos - vecSrc).Normalize( ), &tr, bitsDamageType );
					ApplyMultiDamage( pevInflictor, pevAttacker );
				}
				else
				{
					pEntity->TakeDamage ( pevInflictor, pevAttacker, flAdjustedDamage, bitsDamageType );
				}
			}
		}
	}
}
////////////EOF