// Soul.h: interface for the CSoul class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(CSOUL_H)
#define CSOUL_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "items.h"

#define SOUL_MODEL "models/player.mdl" //not used
//#define MIN_EFFECTS "1"				//test only MIN-MAX effects
//#define MAX_EFFECTS 8				//# of effects WITH CODE
#define JUMP_HEIGHT (192.0) //Ummm.. sure

extern void RadiusDamage( Vector vecSrc, entvars_t *pevInflictor, entvars_t *pevAttacker, float flDamage, float flRadius, int iClassIgnore, int bitsDamageType );

void MakeClone(CBasePlayer *pPlayer);
void SoulSpawn(CBasePlayer *pPlayer, int soulCount);
void RadiusDamageSafe( Vector vecSrc, entvars_t *pevInflictor, entvars_t *pevAttacker, float flDamage, float flRadius, int iClassIgnore, int bitsDamageType );

//Define your blessings here... be sure to give them a unique number!
//this could probably be put into an enum
#define SOUL_NONE 0

#define SOUL_LIFE 1

#define SOUL_ARMOR 2

#define SOUL_BOUNTY 3

#define SOUL_CLONE 4
//every blessing who's number is greater than SOUL_CLONE is considered time-based
#define SOUL_CLOAK 5

#define SOUL_ALLIANCE 6	

#define SOUL_FLY 7

#define SOUL_PERCEPTION 8

#define SOUL_GRAVITY 9

#define SOUL_SPEED 10

#define SOUL_SNARK 600	//undone

//CSoul Class
class CSoul : public CItem
{
public:
	void Spawn ();
	void Precache ( void );
	void EXPORT Kill ( void );
//	void EXPORT Touch( CBaseEntity *pOther );
	BOOL MyTouch( CBasePlayer *pPlayer);
	void CloneThink( void );
	void Clone(CBasePlayer *pPlayer);
	int TriggerEffect(CBasePlayer *pPlayer );
	entvars_t *owner;
};
#endif // !defined(CSOUL_H)
