#ifndef __CLIENTINFOMGR_H
#define __CLIENTINFOMGR_H

#include "basedefs_de.h"
#include "ClientUtilities.h"

class CClientDE;

struct CLIENT_INFO
{
	CLIENT_INFO()	{ r = g = b = 0; m_Ping = 0.0f; nID = 0; hstrName = DNULL; nFrags = 0; hName = DNULL; szName.cx = szName.cy = 0; hFragCount = DNULL; szFragCount.cx = szFragCount.cy = 0; pPrev = DNULL; pNext = DNULL;}

	float			m_Ping;
	DDWORD			nID;
	HSTRING			hstrName;
	int				nFrags;

	HSURFACE		hName;
	CSize			szName;
	
	HSURFACE		hFragCount;
	CSize			szFragCount;

	// Player color.
	DBYTE			r, g, b, padding;

	CLIENT_INFO*	pPrev;
	CLIENT_INFO*	pNext;
};

class CClientInfoMgr
{
public:

	CClientInfoMgr();
	~CClientInfoMgr();

	void	Init (CClientDE* pClientDE);

	void	AddClient (HSTRING hstrName, DDWORD nID, int nFragCount, DBYTE r, DBYTE g, DBYTE b);
	void	RemoveClient (DDWORD nID);
	void	RemoveAllClients();
	
	void	AddFrag (DDWORD nLocalID, DDWORD nID);
	void	RemoveFrag (DDWORD nLocalID, DDWORD nID);

	CLIENT_INFO* GetClientByID(DDWORD nID);
	
	DDWORD	GetNumClients();
	char*	GetPlayerName (DDWORD nID);

	void	UpdateFragDisplay (int nFrags);

	void	UpdateAllFragSurfaces();
	void	ClearAllFragSurfaces();
	void	UpdateSingleFragSurface (CLIENT_INFO* pClient);
	void	ClearUpToDate() {m_bFragSurfacesUpToDate = DFALSE;}

	void	Draw (DBOOL bDrawSingleFragCount, DBOOL bDrawAllFragCounts);

//JSP add
	void	TA_Init();
	
	void	TA_DrawCountdownTimer();
	void	TA_UpdateFight();
	void	TA_UpdateCounter(int);
	DBOOL	TA_ShouldDrawCountDownTimer();
	void	TA_SetShouldDrawCountDownTimer(DBOOL);
	void	TA_SetShouldDrawNewCountDownTimer(DBOOL);
	
	void	TA_PlayVictorySound();
	void	TA_PlayDefeatSound();
	void	TA_PlaySuicideSound();
	void	TA_PlayCountdownSound();
	DBOOL	TA_CountdownSoundAlreadyPlayed();
	void	TA_SetCountdownSoundAlreadyPlayed(DBOOL blah) {m_bTA_CountdownSoundAlreadyPlayed=blah;}
	
	void	TA_Victory();
	void	TA_Defeat();
	void	TA_Suicide();
	
	void	TA_DrawHealthArmor();
	void	TA_UpdateHealthArmor();//Not used in new.
	void	TA_UpdateName1();
	void	TA_UpdateHealth1(DBYTE IsMechaMode);
	void	TA_UpdateArmor1(DBYTE IsMechaMode);
	void	TA_UpdateName2();
	void	TA_UpdateHealth2(DBYTE IsMechaMode);
	void	TA_UpdateArmor2(DBYTE IsMechaMode);
	void	TA_UpdatePlayer1Color();
	void	TA_UpdatePlayer2Color();
///

protected:

	CClientDE*			m_pClientDE;
	CLIENT_INFO*		m_pClients;

	DDWORD				m_nLastFontSize;
	DBOOL				m_bFragSurfacesUpToDate;

	HSURFACE			m_hFragDisplay;
	DDWORD				m_cxFragDisplay;
	DDWORD				m_cyFragDisplay;

	//JSP add /////////

	HDECOLOR hTransColor;
	
	HSURFACE			m_hTowArenaIDDisplay;
	DDWORD				m_cxTowArenaIDDisplay;
	DDWORD				m_cyTowArenaIDDisplay;

	HSURFACE			m_hTA_VS;
	DDWORD				m_cxTA_VS;
	DDWORD				m_cyTA_VS;

	DBOOL				ShouldDrawCountDownTimer;
	DBOOL				ShouldDrawNewCountDownTimer;

	DBOOL				m_bTA_CountdownSoundAlreadyPlayed;
		
	HSURFACE			m_hTA_Victory;
	DDWORD				m_cxTA_Victory;
	DDWORD				m_cyTA_Victory;

	HSURFACE			m_hTA_Defeat;
	DDWORD				m_cxTA_Defeat;
	DDWORD				m_cyTA_Defeat;

	HSURFACE			m_hTA_Suicide;
	DDWORD				m_cxTA_Suicide;
	DDWORD				m_cyTA_Suicide;
	
	HSURFACE			m_hTA_Name1;
	DDWORD				m_cxTA_Name1;
	DDWORD				m_cyTA_Name1;

	HSURFACE			m_hTA_Health1;
	DDWORD				m_cxTA_Health1;
	DDWORD				m_cyTA_Health1;

	HSURFACE			m_hTA_Armor1;
	DDWORD				m_cxTA_Armor1;
	DDWORD				m_cyTA_Armor1;

	HSURFACE			m_hTA_Name2;
	DDWORD				m_cxTA_Name2;
	DDWORD				m_cyTA_Name2;
	
	HSURFACE			m_hTA_Health2;
	DDWORD				m_cxTA_Health2;
	DDWORD				m_cyTA_Health2;
	
	HSURFACE			m_hTA_Armor2;
	DDWORD				m_cxTA_Armor2;
	DDWORD				m_cyTA_Armor2;
	
	HSURFACE			m_hTA_HealthBar1;
	DDWORD				m_cxTA_HealthBar1;
	DDWORD				m_cyTA_HealthBar1;
	
	HSURFACE			m_hTA_ArmorBar1;
	DDWORD				m_cxTA_ArmorBar1;
	DDWORD				m_cyTA_ArmorBar1;
	
	HSURFACE			m_hTA_HealthBar2;
	DDWORD				m_cxTA_HealthBar2;
	DDWORD				m_cyTA_HealthBar2;
	
	HSURFACE			m_hTA_ArmorBar2;
	DDWORD				m_cxTA_ArmorBar2;
	DDWORD				m_cyTA_ArmorBar2;

	HSURFACE			m_hPlayer1Color;
	DDWORD				m_cxPlayer1Color;
	DDWORD				m_cyPlayer1Color;
	
	HSURFACE			m_hPlayer2Color;
	DDWORD				m_cxPlayer2Color;
	DDWORD				m_cyPlayer2Color;

	HSURFACE temp1;
	HSURFACE temp2;
	HSURFACE temp3;
	HSURFACE temp4;
///////
};

#endif