#include "StdAfx.h"
#include "StringEx.h"
#include "TimeHUD.h"
#include "TimeHUDDlg.h"
#include "Threads.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

class CStringEx;

IMPLEMENT_DYNCREATE(CExampleThread, CWinThread)

CExampleThread::CExampleThread()
{
	m_bDone = FALSE;
	m_pOwner = NULL;
	m_bAutoDelete = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// CUpdateThread

IMPLEMENT_DYNCREATE(CUpdateThread, CExampleThread)

CUpdateThread::CUpdateThread()
{
}

CUpdateThread::~CUpdateThread()
{
}

BOOL CUpdateThread::InitInstance()
{
	// TODO:  perform and per-thread initialization here
	return TRUE;
}

int CUpdateThread::Run()
{
	FILE *stream;

    time_t ltime;
	time_t starttime;

	long elapsedsecs;

    struct tm *today;

	char ampm[] = "AM";
	char cCurrMonth[4];

	int iCurrHour12;
	int iCurrHour24;
	int iCurrMin;
	int iPlayHours;
	int iPlayMinutes;
	int iNextUpdate = 0;


	ASSERT(m_pOwner != NULL);
	if (m_pOwner == NULL)
		return -1;

	iNextUpdate = -1;
	time( &starttime );

	while (!m_bDone)
	{
		//Update time_t structure
		time( &ltime );

	    //Convert to time structure
		today = localtime( &ltime );

		//Get the current minute
		iCurrMin = today->tm_min;

		//If this is either the first update or we are ready to update the next minute
		if( iNextUpdate == -1 || iCurrMin == iNextUpdate )
		{
			//Get the current 24 hour
			iCurrHour24 = today->tm_hour;

			//Get the current month(abbreviated month)
			strftime(cCurrMonth, 4, "%b", today);

			/*
			If the time is greater then 12, make it normal time
			and change the AMPM string to PM
			*/
			if( today->tm_hour > 12 )
			{
				strcpy( ampm, "PM" );
				today->tm_hour -= 12;
			}
			else //The time is AM
			{
				strcpy(ampm, "AM");
			}

			//Adjust if midnight hour.
			if( today->tm_hour == 0 )
				today->tm_hour = 12;

			//Get the current 12 hour
			iCurrHour12 = today->tm_hour;

			if( ( stream  = fopen( "config\\time.cs", "w" ) ) == NULL )
			{
				m_bDone = TRUE;
				return 0;
			}
			else
			{
				elapsedsecs = ltime - starttime;
				if(elapsedsecs)
				{
					iPlayHours = elapsedsecs / 3600;
					iPlayMinutes = elapsedsecs / 60 - (iPlayHours * 60);
				}
				else
				{
					iPlayHours = 0;
					iPlayMinutes = 0;
				}

				fprintf( stream, "$CurrentTime[12] = \"%d:%.2d %s\";\n", iCurrHour12, iCurrMin, ampm );
				fprintf( stream, "$CurrentTime[24] = \"%d:%.2d\";\n", iCurrHour24, iCurrMin);
				fprintf( stream, "$CurrentDate = \"%s %d, %d\";\n", cCurrMonth, today->tm_mday, today->tm_year + 1900);
				fprintf( stream, "$PlayTime = \"%dh %dm\";\n", iPlayHours, iPlayMinutes);
				fclose( stream );

				//Set the next update to the next minute.
				if( iCurrMin == 59 )
					iNextUpdate = 0;
				else
					iNextUpdate = iCurrMin + 1;
			}
		}
		//Sleep a little so the processor can do other work.
		Sleep( 100 );
	}

	m_pOwner->PostMessage(WM_CLOSE, 0, 0L);
	return 0;
}

BEGIN_MESSAGE_MAP(CUpdateThread, CWinThread)
	//{{AFX_MSG_MAP(CUpdateThread)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUpdateThread message handlers
/////////////////////////////////////////////////////////////////////////////
// CLaunchThread

IMPLEMENT_DYNCREATE(CLaunchThread, CExampleThread)

CLaunchThread::CLaunchThread()
{

}

CLaunchThread::~CLaunchThread()
{
}

BOOL CLaunchThread::InitInstance()
{
	// TODO:  perform and per-thread initialization here
	return TRUE;
}

BOOL CLaunchThread::LaunchApplication(LPCTSTR pCmdLine, PROCESS_INFORMATION *pProcessInfo)
{
	STARTUPINFO stStartUpInfo;
	
	memset(&stStartUpInfo, 0, sizeof(STARTUPINFO));
	
	stStartUpInfo.cb = sizeof(STARTUPINFO);
	
	stStartUpInfo.dwFlags = STARTF_USESHOWWINDOW;
	stStartUpInfo.wShowWindow = SW_SHOWDEFAULT;
	
	return CreateProcess(NULL, (LPTSTR)pCmdLine, NULL, NULL, FALSE,
		NORMAL_PRIORITY_CLASS, NULL, 
		NULL, &stStartUpInfo, pProcessInfo);
}

int CLaunchThread::Run()
{
	PROCESS_INFORMATION stProcessInfo;
	CStringEx szCmdLine;
	int iRetVal;
	DWORD dwStatus;

	ASSERT(m_pOwner != NULL);
	if (m_pOwner == NULL)
		return -1;

	CSingleLock sLock(&(m_pOwner->m_mutex));

	szCmdLine = cCmdLine;
	iRetVal = szCmdLine.FindReplaceNoCase("timehud.exe", "tribes.exe", FALSE);

	if(iRetVal)
	{
		if(LaunchApplication(szCmdLine, &stProcessInfo))
		{
			//Check for state of thread
			while (!m_bDone)
			{
				VERIFY(::GetExitCodeThread(stProcessInfo.hThread, &dwStatus));

				if (dwStatus == STILL_ACTIVE)
					Sleep( 100 );
				else //Sleep a little so the processor can do other work.
					m_bDone = TRUE;
			}

			CloseHandle(stProcessInfo.hThread);
			CloseHandle(stProcessInfo.hProcess);
		}
	}

	m_pOwner->PostMessage(WM_CLOSE, 0, 0L);
	return 0;
}

BEGIN_MESSAGE_MAP(CLaunchThread, CWinThread)
	//{{AFX_MSG_MAP(CLaunchThread)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLaunchThread message handlers
/////////////////////////////////////////////////////////////////////////////
