//=============================================================================
// GibProjectile.
//=============================================================================
class GibProjectile expands Projectile;

var float MagnitudeVel,Count,SmokeRate;
var vector InitialDir;

// Auto state means this state is automatically entered when the
// object begins play.

auto state Flying
{

simulated function Tick(float DeltaTime)
{
	// Define a variable to represent the trail of blood behind the
	// GibProjectile.
	
	local BloodTrail b;
	
	// Spawn the bloodtrail; the routine below is a modified version
	// of the rocket's smoke trail.
	
	Count += DeltaTime;
	if ( (Count>(FRand()*0.035)) && (Level.NetMode!=NM_DedicatedServer) ) 
	{
		b = Spawn(class'VomitTrail');
		b.RemoteRole = ROLE_None;		
		Count=0.0;
	}
}


	// If the GibProjectile hits someone, and it's not yourself,
	// explode!
	function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ((Other != instigator) && (GibProjectile(Other) == none)) 
			Explode(HitLocation,Normal(HitLocation-Other.Location));
	}

	function Explode(vector HitLocation, vector HitNormal)
	{
		local BloodSpurt P;
	
		// Hurt anything in the radius.

		HurtRadius(Damage,100.0, 'exploded', MomentumTransfer, HitLocation );

 		// Spawn a bloodspurt

 		P=spawn(class'BloodSpurt',,,HitLocation + HitNormal*16);	
 		P.DrawScale+=1;
 		Destroy();
	}

	// Setup the initial variables here, like Velocity and
	// Acceleration.
	
	function BeginState()
	{
		initialDir = vector(Rotation);	
		Velocity = speed*initialDir;
		Acceleration = initialDir*50;
		PlaySound(SpawnSound, SLOT_None, 2.3);	
	}
}

defaultproperties
{
     speed=500.000000
     MaxSpeed=750.000000
     Damage=65.000000
     MomentumTransfer=2500
     ImpactSound=Sound'UnrealI.Blob.BlobHit'
     RemoteRole=ROLE_SimulatedProxy
     Mesh=Mesh'UnrealI.LiverM'
     DrawScale=2.300000
     AmbientSound=Sound'UnrealI.Blob.BlobDeath'
     bBounce=True
}
