(**************************************************************************
QuArK -- Quake Army Knife -- 3D game editor
Copyright (C) 1996-99 Armin Rigo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author Armin Rigo by e-mail: arigo@planetquake.com
or by mail: Armin Rigo, La Cure, 1854 Leysin, Switzerland.
See also http://www.planetquake.com/quark
**************************************************************************)

unit QkGroup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, QkObjects, QkFileObjects, Menus, TB97,
  QkForm, StdCtrls, Buttons, Python;

type
 QExplorerGroup = class(QFileObject)
                  protected
                    function OuvrirFenetre(nOwner: TComponent) : TQForm1; override;
                  public
                    class function TypeInfo: String; override;
                    procedure EtatObjet(var E: TEtatObjet); override;
                    class procedure FileObjectClassInfo(var Info: TFileObjectClassInfo); override;
                    procedure CopierObjets(Complet: Boolean);
                    procedure ReadObjectStream(F: TStream);
                    procedure WriteObjectStream(F: TStream);
                    function IsExplorerItem(Q: QObject) : TIsExplorerItem; override;
                    function AccepteDestination(Q: QObject) : Boolean;
                    procedure GO(Method: Integer);
                    procedure Go1(maplist, extracted: PyObject; var FirstMap: String; QCList: TQList); override;
                    procedure RenderAsText;
                  end;

type
  TFQGroup = class(TQForm1)
    Panel1: TPanel;
    Label1: TLabel;
    GoPanel: TPanel;
    GoBtn: TBitBtn;
    Panel2: TPanel;
    ListBox1: TListBox;
    procedure GoBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    procedure wmMessageInterne(var Msg: TMessage); message wm_MessageInterne;
  protected
    function AssignObject(Q: QFileObject; State: TFileObjectWndState) : Boolean; override;
  public
  end;

{type
 TBasicSibling = class(TInfoEnreg1)
                 public
                   Target: QFileObject;
                   procedure WriteSibling(const Path: String; Obj: QObject); override;
                 end;}

 {------------------------}

var
 DelayedClipboardGroup : QExplorerGroup = Nil;
 LargeDataInClipboard : Boolean = False;

function ClipboardGroup : QExplorerGroup;
function CopyToOutside(Gr: QExplorerGroup) : QExplorerGroup;
procedure InitGamesMenu(L: TStrings);

 {------------------------}

implementation

uses Qk1, QkMapPoly, Setup, QkInclude, QkMacro, Quarkx, Travail, QkQuakeC;

{$R *.DFM}

 {------------------------}

var
 Chain1: TClipboardHandler;

function ClipboardGroup : QExplorerGroup;
begin
 Result:=QExplorerGroup.Create(LoadStr1(5122), Nil);
end;

function CopyToOutside(Gr: QExplorerGroup) : QExplorerGroup;
{var
 I: Integer;}
begin
 Gr.Acces;
 Result:=Gr.Clone(Nil, False) as QExplorerGroup;
{for I:=0 to Result.SousElements.Count-1 do
  ProcessMacros(Result.SousElements[I], Gr.SousElements[I]);}
 ProcessMacros(Result, Gr);
end;

function CollerObjets(PasteNow: QObject) : Boolean;
var
 Source: TMemoryStream;
 H: THandle;
 P: PChar;
 SourceTaille: Integer;
begin
 Result:=IsClipboardFormatAvailable(CF_QObjects);
 if Result and Assigned(PasteNow) then
  begin
   Source:=Nil; try
   OpenClipboard(Form1.Handle); try
   H:=GetClipboardData(CF_QObjects);
   if H=0 then
    Result:=False
   else
    begin
     SourceTaille:=GlobalSize(H);
     Source:=TMemoryStream.Create;
     Source.SetSize(SourceTaille);
     Move(GlobalLock(H)^, Source.Memory^, SourceTaille);
     GlobalUnlock(H);
    end;
   finally CloseClipboard; end;
   if Result then
    (PasteNow as QExplorerGroup).ReadObjectStream(Source);
   finally Source.Free; end;
  end
 else
  if not Result and IsClipboardFormatAvailable(CF_Text) and OpenClipboard(0) then
   begin
    H:=GetClipboardData(CF_Text);
    if H<>0 then
     begin
      P:=GlobalLock(H);
      if P<>Nil then
       begin
        Result:=EnteteObjTexte(P);
        if Result and Assigned(PasteNow) then
         ChargerObjTexte(PasteNow, P, StrLen(P));
       end;
      GlobalUnlock(H);
     end;
    CloseClipboard;
   end;
 Result:=Result or Chain1(PasteNow);
end;

procedure InitGamesMenu(L: TStrings);
var
 list, obj: PyObject;
 I, Count: Integer;
 P: PChar;
begin
 try
  list:=GetQuarkxAttr('buildmodes');
  if list<>Nil then
   begin
    Count:=PyObject_Length(list);
    if Count<0 then Exit;
    for I:=0 to Count-1 do
     begin
      obj:=PyList_GetItem(list, I);
      if obj=Nil then Exit;
      P:=PyString_AsString(obj);
      if P=Nil then Exit;
      L.Add(P);
     end;
   end;
 finally
  PythonCodeEnd;
 end;
end;

(*procedure TBasicSibling.WriteSibling(const Path: String; Obj: QObject);
var
 Q1: QObject;
begin
 Target.Acces;
 Obj.Name:=Path;
 Q1:=Target.SousElements.FindName(Path);
 if Q1=Nil then
  Target.SousElements.Add(Obj)
 else
  Target.SousElements[Target.SousElements.IndexOf(Q1)]:=Obj;
end;*)

 {------------------------}

class function QExplorerGroup.TypeInfo;
begin
 Result:='.qrk';
end;

function QExplorerGroup.OuvrirFenetre;
begin
 Result:=TFQGroup.Create(nOwner);
end;

procedure QExplorerGroup.EtatObjet(var E: TEtatObjet);
begin
 inherited;
 E.IndexImage:=iiExplorerGroup;
 E.MarsColor:=clBlue;
end;

class procedure QExplorerGroup.FileObjectClassInfo(var Info: TFileObjectClassInfo);
begin
 inherited;
 Info.NomClasseEnClair:=LoadStr1(5120);
{Info.FileExtCount:=1;}
 Info.FileExt{[0]}:=772;
{Info.DefaultExt[0]:='qrk';}
 Info.WndInfo:=[wiForm1];
 Info.QuArKFileObject:=True;
end;

procedure QExplorerGroup.CopierObjets(Complet: Boolean);
var
 H: THandle;
 M: TMemoryStream;
 HasText: Boolean;
begin
 M:=TMemoryStream.Create; try
 WriteObjectStream(M);
 H:=GlobalAlloc(gmem_Moveable or gmem_DDEShare, M.Size);
 Move(M.Memory^, GlobalLock(H)^, M.Size);
 GlobalUnlock(H);
 finally M.Free; end;
 OpenClipboard(Form1.Handle); try
 EmptyClipboard;
 SetClipboardData(CF_QObjects, H);
 HasText:=False;
 if SousElements.Count=1 then
  SousElements[0].CopyExtraData(HasText);
 if not HasText then
  if Complet or (GetObjectSize(Nil, False) < 16*1024) then
   RenderAsText
  else
   begin
    SetClipboardData(CF_TEXT, 0);
    AddRef(+1);
    DelayedClipboardGroup:=Self;
    LargeDataInClipboard:=True;
   end;
 finally CloseClipboard; end;
end;

procedure QExplorerGroup.RenderAsText;
var
 L: TStringList;
 Data: String;
 P: PChar;
 H: THandle;
begin
 DelayedClipboardGroup.AddRef(-1);
 DelayedClipboardGroup:=Nil;
 L:=TStringList.Create; try
 EcrireObjTexte(Self, L, False);
 Data:=L.Text;
 finally L.Free; end;
 H:=GlobalAlloc(gmem_Moveable or gmem_DDEShare, Length(Data)+1);
 if H<>0 then
  begin
   P:=GlobalLock(H);
   Move(Data[1], P^, Length(Data)+1);
   GlobalUnlock(H);
   SetClipboardData(CF_TEXT, H);
  end;
end;

procedure QExplorerGroup.ReadObjectStream(F: TStream);
var
 OldReadFormat: Integer;
begin
 OldReadFormat:=ReadFormat;
 try
  ReadFormat:=rf_Default;
  LoadFromStream(F);
 finally
  ReadFormat:=OldReadFormat;
 end;
end;

procedure QExplorerGroup.WriteObjectStream(F: TStream);
var
 I: Integer;
 Links, Modif: TQList;
 Info1: {TBasicSibling;}TInfoEnreg1;
begin
 Acces;
{Info1:=TBasicSibling.Create; try
 Info1.Target:=Self;
 WriteSiblingsTo(Info1);}
 try
  Links:=Nil;
  Modif:=Nil;
  try
   for I:=0 to SousElements.Count-1 do
    with SousElements[I] do
     begin
      Acces;
      if Flags and ofFileLink <> 0 then
       begin
        if Links=Nil then
         Links:=TQList.Create;
        Links.Add(Self.SousElements[I]);
        Flags:=Flags and not ofFileLink;
       end;
      if Flags and ofModified <> 0 then
       begin
        if Modif=Nil then
         Modif:=TQList.Create;
        Modif.Add(Self.SousElements[I]);
       end;
     end;
   Info1:=TInfoEnreg1.Create; try
   Info1.Format:=rf_Default;
   Info1.F:=F;
   Enregistrer1(Info1);
   finally Info1.Free; end;
  finally
   if Links<>Nil then
    begin
     for I:=Links.Count-1 downto 0 do
      with Links[I] do
       Flags:=Flags or ofFileLink;
     Links.Free;
    end;
   if Modif<>Nil then
    begin
     for I:=Modif.Count-1 downto 0 do
      with Modif[I] do
       Flags:=Flags or ofModified;
     Modif.Free;
    end;
  end;
 finally
  FixupAllReferences;
 end;
{finally Info1.Free; end;}
end;

function QExplorerGroup.IsExplorerItem(Q: QObject) : TIsExplorerItem;
begin
 Result:=ieResult[Q is QFileObject];
end;

function QExplorerGroup.AccepteDestination(Q: QObject) : Boolean;
var
 I: Integer;
begin
 Result:=False;
 if Q=Nil then
  Exit;
 for I:=0 to SousElements.Count-1 do
  if ieCanDrop in Q.IsExplorerItem(SousElements[I]) then
   begin
    Result:=True;
    Exit;
   end;
end;

 {------------------------}

procedure QExplorerGroup.GO;
var
 maplist, extracted: PyObject;
 FirstMap, CfgFile: String;
 QCList: TQList;
 args: PyObject;
begin
 extracted:=PyList_New(0);
 maplist:=PyList_New(0);
 try
  FirstMap:='';
  QCList:=TQList.Create; try
  Go1(maplist, extracted, FirstMap, QCList);
  CfgFile:='';
  CompilerPatches(QCList, CfgFile);
  finally QCList.Free; end;
  if (FirstMap='') or (FirstMap='*') then
   args:=Py_BuildValueX('OiOs', [maplist, Method, extracted, PChar(CfgFile)])
  else
   args:=Py_BuildValueX('OiOss', [maplist, Method, extracted, PChar(CfgFile), PChar(FirstMap)]);
  Py_XDECREF(CallMacroEx(args, 'buildmaps'));
 finally
  Py_DECREF(maplist);
  Py_DECREF(extracted);
  PythonCodeEnd;
 end;
end;

procedure QExplorerGroup.Go1(maplist, extracted: PyObject; var FirstMap: String; QCList: TQList);
var
 I: Integer;
begin
 Acces;
 DebutTravail(175, SousElements.Count); try
 for I:=0 to SousElements.Count-1 do
  begin
   if SousElements[I] is QFileObject then
    QFileObject(SousElements[I]).Go1(maplist, extracted, FirstMap, QCList);
   ProgresTravail;
  end;
 finally FinTravail; end;
end;

 {------------------------}

procedure TFQGroup.wmMessageInterne(var Msg: TMessage);
var
 Q: QObject;
 I, HiddenCount, HiddenSize: Integer;
begin
 case Msg.wParam of
  wp_AfficherObjet:
    if FileObject<>Nil then
     begin
      Panel2.Caption:=FmtLoadStr1(5401, [FileObject.Name]);
      HiddenCount:=0;
      HiddenSize:=0;
      for I:=0 to FileObject.SousElements.Count-1 do
       begin
        Q:=FileObject.SousElements[I];
        if not (Q is QFileObject) then
         begin
          Inc(HiddenCount);
          Inc(HiddenSize, Q.GetObjectSize(Nil, False));
         end;
       end;
      Label1.Visible:=HiddenCount>0;
      if HiddenCount>0 then
       Label1.Caption:=FmtLoadStr1(5402, [(HiddenSize+512) div 1024, HiddenCount]);
     end;
 end;
 inherited;
end;

function TFQGroup.AssignObject(Q: QFileObject; State: TFileObjectWndState) : Boolean;
begin
 Result:=(Q is QExplorerGroup) and inherited AssignObject(Q, State);
end;

procedure TFQGroup.GoBtnClick(Sender: TObject);
begin
 if FileObject is QExplorerGroup then
  QExplorerGroup(FileObject).GO(ListBox1.ItemIndex);
end;

procedure TFQGroup.FormCreate(Sender: TObject);
begin
 inherited;
 InitGamesMenu(ListBox1.Items);
 ListBox1.ItemIndex:=0;
end;

initialization
  RegisterQObject(QExplorerGroup, 'z');
  Chain1:=ClipboardChain;
  ClipboardChain:=CollerObjets;
end.
