unit QkQme;

interface

uses Objects, QmObj, QkUI;

type
 TProcessEntryEvent = procedure(const FileName: String; var Entree: TEntreeRepQM);

var
 RepertoireQM   : PRepertoireQM;
 NbEntrees      : INTEGER;
 SourceFileName : String;
 DestBatch      : ^Text;

procedure ProcessQuArKFiles(OnProcess: TProcessEntryEvent; Msg: Boolean);
procedure Empty(const Rep: String);
function QkDosRtPath: String;
procedure RecallBatch(const Cmd: String; ShortFileName: String);
function FileExists(const FileName: String) : Boolean;

implementation

uses QmPak;

function OpenQuArKFile(const FileName: String; var Rep : PRepertoireQM; var Nb : INTEGER) : Boolean;
var
 Intro : TIntroQM;
begin
 SourceFile:=New(PBufStream, Init(FileName, stOpenRead, 1024));
 SourceFile^.Read(Intro, SizeOf(Intro));
 IF SourceFile^.Status<>stOk THEN
  BEGIN
   OpenQuArKFile:=False;
   Dispose(SourceFile, Done);
   Writeln('WARNING: couldn''t open file ', FileName);
  END
 ELSE
  BEGIN
   IF Intro.Signature<>SignatureQM THEN
    Error('File '+FileName+' is not a QuArK file');
   SourceFile^.Seek(Intro.PositionRep);
   GetMem(Rep, Intro.TailleRep);
   SourceFile^.Read(Rep^, Intro.TailleRep);
   IF SourceFile^.Status<>stOk THEN
    Error('File format error : '+FileName);
   Nb:=Intro.TailleRep DIV SizeOf(TEntreeRepQM);
   OpenQuArKFile:=True;
  END;
end;

procedure CloseQuArKFile(Rep : PRepertoireQM; Nb : INTEGER);
begin
 FreeMem(Rep, Nb*SizeOf(TEntreeRepQM));
 Dispose(SourceFile, Done);
end;

procedure Process(var Fichiers: TStringCollection; const FileName: String; Repertoire: PRepertoireQM; Count: Integer;
                  OnProcess: TProcessEntryEvent); forward;

procedure ProcessFile(var Fichiers: TStringCollection; const FileName: String; OnProcess: TProcessEntryEvent);
var
 Repertoire2: PRepertoireQM;
 Count: Integer;
 OldFile: PStream;
begin
 OldFile:=SourceFile;
 Fichiers.Insert(NewStr(FileName));
 if OpenQuArKFile(FileName, Repertoire2, Count) then
  begin
   Process(Fichiers, FileName, Repertoire2, Count, OnProcess);
   CloseQuArKFile(Repertoire2, Count);
  end;
 SourceFile:=OldFile;
end;

procedure Process(var Fichiers: TStringCollection; const FileName: String; Repertoire: PRepertoireQM; Count: Integer;
                  OnProcess: TProcessEntryEvent);
var
 I, J: Integer;
 Entree: PEntreeRepQM;
 NomF: String;
begin
 Entree:=PEntreeRepQM(Repertoire);
 for I:=0 to Count-1 do
  begin
   if Entree^.Version<VersionNXF then
    Error('QuakeMap-style files not supported, convert it to QuArK');
   if Entree^.Version>VersionNXF then
    begin
     Writeln('WARNING: unsupported version number');
     Writeln('This file may have been created with a too recent version of QuArK');
    end;
   OnProcess(FileName, Entree^);
   if Entree^.InfoType=qmFileLnk then
    begin
     NomF:=NXFString(Entree^, 'FileName');
     if NomF<>'' then
      begin
       LowerCase(NomF);
       NomF:=Copy(SourceFileName,1,ExtractPath(SourceFileName))+NomF+'.qme';
       if not Fichiers.Search(@NomF, J) then
        begin
         Fichiers.AtInsert(J, NewStr(NomF));
         ProcessFile(Fichiers, NomF, OnProcess);
        end;
      end;
    end;
   Inc(Entree);
  end;
end;

procedure ProcessCurrentFile(OnProcess: TProcessEntryEvent);
var
 Fichiers: TStringCollection;
begin
 Fichiers.Init(4,4);
 Fichiers.Insert(NewStr(SourceFileName));
 Process(Fichiers, SourceFileName, RepertoireQM, NbEntrees, OnProcess);
 Fichiers.Done;
end;

 {----------------------------}

CONST
 Directory = $10;
 AnyFile   = $3F;

TYPE
    { Search record used by FindFirst and FindNext }
  SearchRec = RECORD
    Fill: ARRAY[1..21] OF Byte;
    Attr: Byte;
    Time: Longint;
    Size: Longint;
    Name: string [12];
  END;

var
 DosError: Integer;

PROCEDURE FindFirst(const F : STRING; Attr : WORD; var S : SearchRec);
ASSEMBLER;

VAR
 Tampon : ARRAY[0..79] OF BYTE;

ASM
 LDS DX,[S]
 MOV AH,$1A
 INT $21

 CLD
 LDS SI,[F]
 MOV DI,SP
 MOV DX,DI
 MOV BX,SS
 MOV ES,BX
 LODSB
 MOV CL,AL
 MOV CH,0
 REP MOVSB
 MOV AL,0
 STOSB
 MOV DS,BX

 MOV CX,[Attr]
 MOV AH,$4E
 INT $21
 MOV AX,18
 JC @Erreur

 LES DI,[S]
 ADD DI,30
 MOV CX,13
 MOV AL,0
 REPNE SCASB
 SUB CX,12
 NEG CX
 MOV AL,CL
 STD
 DEC DI
 MOV SI,DI
 DEC SI
 REP SEGES MOVSB
 STOSB

 XOR AX,AX
 @Erreur:

 MOV BX,SEG @DATA
 MOV DS,BX

 MOV [DosError],AX
END;

PROCEDURE FindNext(var S : SearchRec);
ASSEMBLER;

ASM
 MOV AH,$4F
 INT $21
 MOV AX,18
 JC @Erreur

 LES DI,[S]
 ADD DI,30
 MOV CX,13
 MOV AL,0
 REPNE SCASB
 SUB CX,12
 NEG CX
 MOV AL,CL
 STD
 DEC DI
 MOV SI,DI
 DEC SI
 REP SEGES MOVSB
 STOSB

 XOR AX,AX
 @Erreur:

 MOV [DosError],AX
END;

function FileExists(const FileName: String) : Boolean;
var
 S: SearchRec;
begin
 FindFirst(FileName, AnyFile, S);
 FileExists:=DosError=0;
end;
(*var
 f: file;
begin
 assign(f, FileName);
 {$I-} reset(f,1); {$I+}
 if IOResult=0 then
  begin
   close(f);
   FileExists:=True;
  end
 else
  FileExists:=False;
end;*)

procedure Empty(const Rep: String);
var
 SubDir: TStringCollection;
 I: Integer;
 F: File;
 S: SearchRec;
begin
 SubDir.Init(4,4);
 FindFirst(Rep+'*.*', AnyFile, S);
 while DosError=0 do
  begin
   if S.Attr and Directory = 0 then
    begin
     Assign(F, Rep+S.Name);
     {$I-}
     Erase(F);
     {$I+}
     I:=IOResult;
    end
   else
    if (S.Name<>'.') and (S.Name<>'..') then
     SubDir.Insert(NewStr(S.Name));
   FindNext(S);
  end;
 for I:=0 to SubDir.Count-1 do
  Empty(Rep+PString(SubDir.At(I))^+'\');
 SubDir.Done;
 {$I-}
 RmDir(Copy(Rep, 1, Length(Rep)-1));
 {$I+}
 I:=IOResult;
end;

procedure ProcessQuArKFiles(OnProcess: TProcessEntryEvent; Msg: Boolean);
var
 I,J,K: Integer;
 ProcessedFiles: TStringCollection;
begin
 ProcessedFiles.Init(4,4);
 K:=3;
 repeat
  J:=CmdLineText(K);
  if J<0 then Break;
  SourceFileName:=ParamStr(J);
  LowerCase(SourceFileName);
  if Pos('.',SourceFileName)=0 then
   if FileExists(SourceFileName+'.map') and not FileExists(SourceFileName+'.qme') then
    SourceFileName:=SourceFileName+'.map'
   else
    SourceFileName:=SourceFileName+'.qme';
  if not ProcessedFiles.Search(@SourceFileName,I) then
   begin
    ProcessedFiles.Insert(NewStr(SourceFileName));
    if OpenQuArKFile(SourceFileName, RepertoireQM, NbEntrees) then
     begin
      if Msg then
       Writeln('Processing ', SourceFileName, '...');
      Process(ProcessedFiles, SourceFileName, RepertoireQM, NbEntrees, OnProcess);
      CloseQuArKFile(RepertoireQM, NbEntrees);
     end;
   end;
  Inc(K);
 until False;
 ProcessedFiles.Done;
end;

function QkDosRtPath: String;
var
 S: String;
begin
 S:=ParamStr(0);
 QkDosRtPath:=Copy(S, 1, ExtractPath(S)-1);
end;

procedure RecallBatch(const Cmd: String; ShortFileName: String);
begin
 if ShortFileName='' then
  ShortFileName:='-';
 Writeln(DestBatch^, 'call ', QkDosRtPath, '\QK.BAT /', Cmd, ' ', QkDosRtPath, ' ',
  QuakeDir, ' ', ShortFileName, ' ', PackFile);
end;

end.