unit QkUI;

interface

uses Strings, Objects;

procedure Error(const S: String);
function EditKeys(var Keys: TStringCollection; const Caption: String; Mode: Integer) : Boolean;
function Prompt(const L1,L2: String; var S: String) : Boolean;
function CmdLineText(I: Integer) : Integer;
function CmdLineText1(I: Integer) : String;
function CmdLineOption(C: Char) : Boolean;
function CompareText(const T1,T2: String) : Integer;
function IntToStr(I: Integer) : String;
procedure LowerCase(var S);

implementation

{$I SCANCODE.INC}

const
 Prompt1 = #255'         ';
 PromptLine = 12;

function ReadKey: Word; assembler;
asm
 mov ah, $10
 int $16
end;

function KeyPressed: Boolean; assembler;
asm
 mov ah, $11
 int $16
 mov al, 0
 jz @Fin
 inc ax
@Fin:
end;

function EditKeys(var Keys: TStringCollection; const Caption: String; Mode: Integer) : Boolean;
const
 WinX1 = 12;
 WinY1 = 8;
 WinX2 = 66;
 WinY2 = 16;
type
 TScreen = array[0..24,0..79] of Word;
var
 Screen: TScreen absolute $B800:0000;
 Background: array[WinY1..WinY2, WinX1..WinX2] of Word;
 I, J, TopLine, CurLine: Integer;
 S: String[127];
 P: PString;
 Writing: Boolean;

  procedure WriteLine(X,Y: Integer; const S: String; Attr: Word);
  var
   I: Integer;
  begin
   for I:=1 to Length(S) do
    begin
     Screen[Y,X+I-1]:=Ord(S[I]) or Attr;
     if X+I=WinX2 then Exit;
    end;
  end;

  procedure WriteThisLine(Attr: Word);
  begin
   while Length(S)<WinX2-WinX1 do
    S:=S+'  ';
   WriteLine(WinX1+1, J, S, Attr);
   Inc(J);
  end;

  function MoveCurLine(Delta: Integer) : Boolean;
  var
   Dist, NPos: Integer;
   P: PString;
  begin
   MoveCurLine:=False;
   Writing:=False;
   if Mode=2 then Exit;
   NPos:=CurLine;
   Dist:=Abs(Delta);
   while Dist>0 do
    begin
     if Delta>0 then
      begin
       Inc(NPos);
       if NPos>=Keys.Count then Exit;
      end
     else
      begin
       Dec(NPos);
       if NPos<0 then Exit;
      end;
     P:=PString(Keys.At(NPos));
     if (P<>Nil) and (Copy(P^, 1,1) = #255) then
      begin
       CurLine:=NPos;
       Dec(Dist);
      end;
    end;
   MoveCurLine:=True;
  end;

begin
 EditKeys:=False;
 Writing:=False;
 if Mode=2 then
  CurLine:=PromptLine
 else
  begin
   CurLine:=-1;
   if not MoveCurLine(+1) then Exit;
  end;
 for J:=WinY1 to WinY2 do
  Move(Screen[J,WinX1], Background[J], 2*(WinX2-WinX1+1));
 Screen[WinY1,WinX1]:=$1AC9;
 Screen[WinY1,WinX2]:=$1ABB;
 Screen[WinY2,WinX1]:=$1AC8;
 Screen[WinY2,WinX2]:=$1ABC;
 for I:=WinX1+1 to WinX2-1 do
  begin
   Screen[WinY1,I]:=$1ACD;
   Screen[WinY2,I]:=$1ACD;
  end;
 for J:=WinY1+1 to WinY2-1 do
  begin
   Screen[J,WinX1]:=$1ABA;
   Screen[J,WinX2]:=$1ABA;
  {for I:=WinX1+1 to WinX2-1 do
    Screen[J,I]:=$1F20;}
  end;
 WriteLine((WinX1+WinX2-Length(Caption)) div 2, WinY1, Caption, $1A00);
 case Mode of
  0: WriteLine(20,WinY2, ' Enter: change key  Esc: continue ', $1A00);
  2: WriteLine(24,WinY2, ' Enter: continue  Esc: quit ', $1A00);
 end;
 TopLine:=0;
 repeat
  if TopLine>CurLine then
   TopLine:=CurLine;
  I:=TopLine;
  J:=WinY1+1;
  while (J<WinY2) and (I<Keys.Count) do
   begin
    P:=PString(Keys.At(I));
    if (P<>Nil) and (Length(P^)>=1) and (P^[1]=#255) then
     begin
      S:=Copy(P^, 2, 255);
      while Length(S)<10 do
       S:=' '+S;
      P:=PString(Keys.At(I+1));
      if P<>Nil then
       S:=S+'  '+P^;
      if I=CurLine then
       if Writing then
        WriteThisLine($0E00)
       else
        WriteThisLine($0F00)
      else
       WriteThisLine($1F00);
      Inc(I,2);
     end;
    Inc(I);
   end;
  S:='';
  while J<WinY2 do
   WriteThisLine($1100);
  if CurLine>=I then
   Inc(TopLine)
  else
   begin
    I:=ReadKey;
    case Chr(Lo(I)) of
     #27: Break;
     #13: if Mode=0 then
           begin
            Writing:=False;
            WriteLine(28,11, 'Ŀ', $4E00);
            WriteLine(28,12, '  Press the new key  ', $4E00);
            WriteLine(28,13, '', $4E00);
            while Port[$60]<128 do
             if KeyPressed and (Lo(ReadKey)=27) then
              Break;
            repeat
             I:=PORT[$60];
             if KeyPressed and (Lo(ReadKey)=27) then
              Break;
            until I<128;
            if (I>1) and (I<128) and (ScanCodes[I]^<>#0) then
             begin
              DisposeStr(PString(Keys.At(CurLine)));
              Keys.AtPut(CurLine, NewStr(#255+StrPas(ScanCodes[I])));
             end;
            while KeyPressed do
             ReadKey;
           end
          else
           begin
            EditKeys:=True;
            Break;
           end;
     #8, ' '..'~':
      begin
       S:=PString(Keys.At(CurLine))^;
       if Lo(I)<>8 then
        begin
         if not Writing then
          if Mode<>2 then
           S:=#255
          else
           S:=Prompt1;
         S:=S+Chr(Lo(I));
        end
       else
        if (Length(S)>1) and ((Mode<>2) or (Length(S)>Length(Prompt1))) then
         Delete(S, Length(S), 1);
       DisposeStr(PString(Keys.At(CurLine)));
       Keys.AtPut(CurLine, NewStr(S));
       Writing:=True;
      end;
    else case Chr(Hi(I)) of
     'G': MoveCurLine(-9999);
     'H': MoveCurLine(-1);
     'I': MoveCurLine(-6);
     'K','M': Writing:=not Writing;
     'O': MoveCurLine(+9999);
     'P': MoveCurLine(+1);
     'Q': MoveCurLine(+6);
    end; end;
   end;
 until False;
 for J:=WinY1 to WinY2 do
  Move(Background[J], Screen[J,WinX1], 2*(WinX2-WinX1+1));
end;

procedure Error(const S: String);
begin
 Writeln('Sorry, an error occured.');
 Writeln('ERROR: ', S);
 Halt(1);
end;

function Prompt(const L1,L2: String; var S: String) : Boolean;
var
 Temp: TStringCollection;
begin
 Temp.Init(12,1);
 Temp.AtInsert(0, NewStr(#255));
 Temp.AtInsert(1, Nil);
 Temp.AtInsert(2, Nil);
 Temp.AtInsert(3, NewStr(#255+L1));
 Temp.AtInsert(4, Nil);
 Temp.AtInsert(5, Nil);
 Temp.AtInsert(6, NewStr(#255+L2));
 Temp.AtInsert(7, Nil);
 Temp.AtInsert(8, Nil);
 Temp.AtInsert(9, NewStr(#255));
 Temp.AtInsert(10, Nil);
 Temp.AtInsert(11, Nil);
 Temp.AtInsert(12, NewStr(Prompt1+S));
 Temp.AtInsert(13, Nil);
 Temp.AtInsert(14, Nil);
 Prompt:=EditKeys(Temp, ' Quake Army Knife ', 2);
 S:=Copy(PString(Temp.At(PromptLine))^, Length(Prompt1)+1, 255);
 Temp.Done;
end;

function CmdLineText(I: Integer) : Integer;
var
 Result: Integer;
begin
 Result:=2;
 while Result<=ParamCount do
  begin
   if Copy(ParamStr(Result),1,1)<>'-' then
    begin
     Dec(I);
     if I=1 then
      begin
       CmdLineText:=Result;
       Exit;
      end;
    end
   else
    if CompareText(ParamStr(Result), '-game') = 0 then
     Inc(Result);
   Inc(Result);
  end;
 CmdLineText:=-1;
end;

function CmdLineText1(I: Integer) : String;
begin
 I:=CmdLineText(I);
 if I<0 then Error('Too few arguments on command line');
 CmdLineText1:=ParamStr(I);
end;

function CmdLineOption(C: Char) : Boolean;
var
 I: Integer;
 S: String[3];
begin
 for I:=2 to ParamCount do
  begin
   S:=ParamStr(I);
   if (Length(S)=2) and (S[1]='-') and (Upcase(S[2])=Upcase(C)) then
    begin
     CmdLineOption:=True;
     Exit;
    end;
  end;
 CmdLineOption:=False;
end;

FUNCTION CompareText(const T1,T2: String) : INTEGER;

VAR
 I : INTEGER;

BEGIN
 CompareText:=1;
 IF Length(T1)<>Length(T2) THEN Exit;
 FOR I:=1 TO Length(T1) DO
  IF UPCASE(T1[I])<>UPCASE(T2[I]) THEN
   Exit;
 CompareText:=0;
END;

procedure LowerCase(var S);
assembler;
asm
 xor cx, cx
 les di, [S]
 mov cl, [es:di]
 inc cx
@Boucle:
 dec cx
 jz @Fin
 inc di
 mov al, [es:di]
 cmp al, 'A'
 jb @Boucle
 cmp al, 'Z'
 ja @Boucle
 add al, 32
 mov [es:di], al
 jmp @Boucle
@Fin:
end;

function IntToStr(I: Integer) : String;
var
 Result: String[15];
begin
 Str(I, Result);
 IntToStr:=Result;
end;

end.