unit QPAcc;
{$N+}

interface

uses Objects, Strings, QkUI;

type
 TType   = (tInconnu, tStr, tReel, tVecteur, tPtr, tObjData, tFrPtr);
 TSymbole = (symInconnu, symType, symIdent, symVariable, symObjVar,
  symDeuxPoints, symPointVirgule, symPoint, symAffecte, symVirgule,
  symPlus, symMoins, symFois, symDivise, symAnd, symOr, symNot, symLogOr, symLogAnd,
  symEgal, symDifferent, symPlusPetit, symPlusGrand, symPlusPetitOuEgal, symPlusGrandOuEgal,
  symAccolade1, symAccolade2, symParenthese1, symParenthese2, symLOCAL, symBIND, symAUTOEXEC,
  symIF, symELSE, symWHILE, symDO, symRETURN, symReel, symChaine, symVecteur, symEOF,
  symDollar, symCrochet1, symCrochet2);

const
 MotsClefs: array[symLOCAL..symRETURN] of PChar =
  ('LOCAL', 'BIND', 'AUTOEXEC', 'IF', 'ELSE', 'WHILE', 'DO', 'RETURN');
 NomsTypes: array[tInconnu..tPtr] of PChar =
  ('VOID', 'STRING', 'FLOAT', 'VECTOR', 'ENTITY');
 Impulse0Def = 100;
 NomPatchImpulse = 'qkdosrt~.qc';

procedure Compiler(Patch: PStringCollection; Source: PStream; const NomCible: String;
                    var Touches: TStringCollection; Impulse0: Integer);

implementation

uses QmObj;

const
 FacteurT : ARRAY[1..6] OF LONGINT = (8, 8, 8, 36, 1, 4);

type
 TEntree = Packed RECORD
            Pos, Nb : LONGINT;
           END;
 TEntete = Packed RECORD
            Version : LONGINT;
            CodeSys : LONGINT;
            Entrees : ARRAY[1..6] OF TEntree;
            TailleLocData : LONGINT;
           END;
 PVarStruct = ^TVarStruct;
 TVarStruct = Packed RECORD
               InfoType : TType;
               Sys      : BYTE;
               Pos      : WORD;
               Nom      : LONGINT;
              END;
 PTableauVar = ^TTableauVar;
 TTableauVar = array[0..0] of TVarStruct;
 PFrame = ^TFrame;
 TFrame = Packed RECORD
           Code, LocData, LocSize, Reserve : LONGINT;
           NomFrame, NomFich    : LONGINT;
           NbArguments          : LONGINT;
           Args                 : ARRAY[1..8] OF BYTE;
          END;
 PVarCollection = ^TVarCollection;
 TVarCollection = object(TSortedCollection)
                   procedure Add(nNom: PChar; const St: TVarStruct);
                   procedure FreeItem(Item: Pointer); virtual;
                   function KeyOf(Item: Pointer) : Pointer; virtual;
                   function Compare(Key1, Key2: Pointer) : Integer; virtual;
                  end;

procedure Compiler(Patch: PStringCollection; Source: PStream; const NomCible: String;
                    var Touches: TStringCollection; Impulse0: Integer);
type
 Vecteur = ARRAY[1..3] OF Single;
 TTypeEtendu = record
                T: TType;
                NbArg: Integer;
                Arg: array[1..8] of record
                                     T: TType;
                                     Nom: array[0..63] of Char;
                                    end;
               end;
 TSymboleMot = array[0..1023] of Char;
const
 TailleType : ARRAY[TType] OF WORD = (1,1,1,3,1,1,1);
var
 Zero: Vecteur;
 Entete: TEntete;
 Origine: LongInt;
 CurrentLine: TSymboleMot;
 CurrentFile: Text;
 CurrentFileIndex: Integer;
 SymboleMot: TSymboleMot;
 SymboleReel: Single;
 SymboleVecteur: Vecteur;
 VarLocales: PVarCollection;
 VarGlobales, VarObjet: TVarCollection;
 Symbole: TSymbole;
 SymboleVar: TVarStruct;
 SymboleType: TType;
 NDatas: Word;
 NoFrame, NQCode, NStrings: LongInt;
 NoImpulse: Integer;
 Immediate, NomPatch: LongInt;
 Files: Array[1..6] of File;
 Vars: PTableauVar;
 VariableEstLocale, VariableObjet: Boolean;
 PL: PChar;
 PIPos: LongInt;
 NomVariable: Array[0..63] of Char;
 MdlFrames: PCollection;

  procedure ToutFermer;
  var
   I: Integer;
   F: File;
  begin
   for I:=6 downto 1 do
    begin
     Close(Files[I]);
     Erase(Files[I]);
    end;
   if PIPos>0 then
    begin
     Assign(F, NomPatchImpulse);
     Erase(F);
    end;
  end;

  procedure Erreur(Numero: Integer);
  var
   S: String[5];
  begin
   ToutFermer;
   Str(Numero, S);
   Error('Compile error #'+S);
  end;

  procedure LibererMdlFrames;
  var
   I: Integer;
  begin
   if MdlFrames<>Nil then
    begin
     for I:=MdlFrames^.Count-1 downto 0 do
      StrDispose(PChar(MdlFrames^.At(I)));
     MdlFrames^.DeleteAll;
     Dispose(MdlFrames, Done);
     MdlFrames:=Nil;
    end;
  end;

  function LireChaine(No: LongInt) : PChar;
  var
   Lu: Word;
  begin
   Seek(Files[5], No);
   BlockRead(Files[5], NomVariable, SizeOf(NomVariable), Lu);
   LireChaine:=NomVariable;
  end;

  function ChercheVar(Nom: PChar) : Boolean;
  var
   Min, Max, Test, Resultat: LongInt;
   St: TVarStruct;
  {P: PTableauVar;}
  begin
  {P:=PTableauVar(NDataDef.Memory);
   for Test:=NDataDef.Size div SizeOf(TVarStruct) - 1 downto 0 do
    if StrIComp(PChar(@Chaines[P^[Test].Nom+1]), PChar(Nom)) = 0 then
     begin
      SymboleVar:=P^[Test];
      ChercheVar:=True;
      Exit;
     end;}
   Min:=0;
   Max:=Entete.Entrees[2].Nb-1;
   while Min < Max do
    begin
     Test:=(Min+Max) shr 1;
     Resultat:=StrIComp(LireChaine(Vars^[Test].Nom), Nom);
     if Resultat<0 then
      Min:=Test+1
     else
      if Resultat>0 then
       Max:=Test
      else
       begin
        while (Test>0) and (StrIComp(LireChaine(Vars^[Test-1].Nom), Nom) = 0) do
         Dec(Test);
        Max:=Entete.Entrees[2].Nb-1;
        while ((Vars^[Test].InfoType=tObjData) xor VariableObjet)
        and (Test<Max) and (StrIComp(LireChaine(Vars^[Test+1].Nom), Nom) = 0) do
         Inc(Test);
        SymboleVar:=Vars^[Test];
        ChercheVar:=True;
        Exit;
       end;
    end;
   ChercheVar:=False;
  end;

  function EcrireChaine : LongInt;
  var
   L: Integer;
  begin
   Seek(Files[5], NStrings);
   L:=StrLen(SymboleMot)+1;
   BlockWrite(Files[5], SymboleMot, L);
   EcrireChaine:=NStrings;
   Inc(NStrings, L);
  end;

  function EcrireReel(R: Single) : LongInt;
  begin
   EcrireReel:=NDatas;
   Inc(NDatas);
   BlockWrite(Files[6], R, 4);
  end;

  function EcrireVecteur(var V: Vecteur) : LongInt;
  begin
   EcrireVecteur:=NDatas;
   Inc(NDatas, 3);
   BlockWrite(Files[6], V, 4*3);
  end;

  PROCEDURE Trim;
  BEGIN
   repeat
    case PL^ of
     #0: begin
          if EOF(CurrentFile) then Exit;
          ReadLn(CurrentFile, CurrentLine);
          PL:=CurrentLine;
         end;
     #8, #9, ' ': Inc(PL);
     '/': case PL[1] of
           '/': repeat
                 Inc(PL);
                until PL^=#0;
           '*': begin
                 Inc(PL, 2);
                 repeat
                  while (PL^<>#0) and ((PL^<>'*') or (PL[1]<>'/')) do
                   Inc(PL);
                  if PL^<>#0 then
                   begin
                    Inc(PL, 2);
                    Trim;
                    Exit;
                   end;
                  if EOF(CurrentFile) then Exit;
                  ReadLn(CurrentFile, CurrentLine);
                  PL:=CurrentLine;
                 until False;
                end;
           else Exit;
          end;
     else Exit;
    end;
   until False;
  END;

  PROCEDURE Lire(Attendu : TSymbole);

    PROCEDURE Lu(nSymbole : TSymbole);

    BEGIN
     Symbole:=nSymbole;
     Inc(PL);
    END;

    PROCEDURE Lu2(Sym1, Sym2 : TSymbole);

    BEGIN
     Inc(PL);
     IF PL^='=' THEN
      BEGIN
       Symbole:=Sym2;
       Inc(PL)
      END
     ELSE
      Symbole:=Sym1;
    END;

    FUNCTION LireReel : Single;

    VAR
     Echelle, Result : Single;
     Neg             : BOOLEAN;

    BEGIN
     Neg:=PL^='-';
     IF Neg THEN
      Inc(PL);
     IF NOT (PL^ IN ['0'..'9']) THEN
      Erreur(4096);
     Result:=0;
     REPEAT
      Result:=Result*10 + (ORD(PL^)-48);
      Inc(PL);
     UNTIL NOT (PL^ IN ['0'..'9']);
     IF PL^='.' THEN
      BEGIN
       Echelle:=1;
       Inc(PL);
       WHILE PL^ IN ['0'..'9'] DO
        BEGIN
         Echelle:=Echelle*0.1;
         Result:=Result + Echelle*(ORD(PL^)-48);
         Inc(PL);
        END;
      END;
     IF Neg THEN
      LireReel:=-Result
     else
      LireReel:=Result;
    END;

  var
   I,J: Integer;
   VarL: PVarCollection;
   Normal, Surbrillance: Boolean;

  BEGIN
   IF (Symbole<>Attendu) AND (Attendu<>symInconnu) THEN
    Erreur(4097);
   while (PL=Nil) or (PL^=#0) do
    begin
     LibererMdlFrames;
     if PL<>Nil then
      begin
       Close(CurrentFile);
       Inc(CurrentFileIndex);
      end;
     Write('.');
     if CurrentFileIndex>=Patch^.Count then
      begin
       PL:=Nil;
       Symbole:=symEOF;
       Exit;
      end;
     StrPCopy(SymboleMot, PString(Patch^.At(CurrentFileIndex))^);
     NomPatch:=EcrireChaine;
     Assign(CurrentFile, StrPas(SymboleMot));
     {$I-} Reset(CurrentFile); {$I+}
     if IOResult<>0 then
      Error('Could not open QuakeC file '+PString(Patch^.At(CurrentFileIndex))^);
     CurrentLine[0]:=#0;
     PL:=CurrentLine;
     Trim;
    end;
   CASE PL^ OF
    'a'..'z','A'..'Z' : BEGIN
                         I:=0;
                         REPEAT
                          SymboleMot[I]:=PL^;
                          Inc(PL);
                          Inc(I);
                         UNTIL NOT (PL^ IN ['a'..'z','A'..'Z','0'..'9','_']);
                         SymboleMot[I]:=#0;
                         Symbole:=Low(MotsClefs);
                         while (Symbole<=High(MotsClefs)) and (StrIComp(SymboleMot, MotsClefs[Symbole])<>0) do
                          Inc(Symbole);
                         if Symbole>High(MotsClefs) then
                          begin
                           SymboleType:=Low(NomsTypes);
                           while (SymboleType<=High(NomsTypes)) and (StrIComp(SymboleMot, NomsTypes[SymboleType])<>0) do
                            Inc(SymboleType);
                           if SymboleType<=High(NomsTypes) then
                            Symbole:=symType
                           else
                            begin
                             Symbole:=symVariable;
                             VariableEstLocale:=(VarLocales<>Nil) and VarLocales^.Search(@SymboleMot, I);
                             if VariableEstLocale then
                              SymboleVar:=PVarStruct(VarLocales^.At(I))^
                             else
                              begin
                               if VariableObjet then
                                VarL:=@VarObjet
                               else
                                VarL:=@VarGlobales;
                               if VarL^.Search(@SymboleMot, I) then
                                SymboleVar:=PVarStruct(VarL^.At(I))^
                               else
                                if not ChercheVar(SymboleMot) then
                                 begin
                                  if VariableObjet then
                                   VarL:=@VarGlobales
                                  else
                                   VarL:=@VarObjet;
                                  if VarL^.Search(@SymboleMot, I) then
                                   SymboleVar:=PVarStruct(VarL^.At(I))^
                                  else
                                   begin
                                    Symbole:=symIdent;
                                    SymboleVar.InfoType:=tInconnu;
                                   end;
                                 end;
                               if SymboleVar.InfoType=tObjData then
                                Symbole:=symObjVar;
                              end;
                            end;
                          end;
                        END;
    '0'..'9' : BEGIN
                Symbole:=symReel;
                SymboleReel:=LireReel;
               END;
    ';' : Lu(symPointVirgule);
    '{' : Lu(symAccolade1);
    '}' : Lu(symAccolade2);
    ':' : Lu(symDeuxPoints);
    '=' : Lu2(symAffecte, symEgal);
    '+' : Lu(symPlus);
    '-' : begin
           Inc(PL);
           IF PL^ IN ['0'..'9'] THEN
            BEGIN
             Symbole:=symReel;
             SymboleReel:=-LireReel;
            END
           ELSE
            Symbole:=symMoins;
          end;
    '*' : Lu(symFois);
    '/' : Lu(symDivise);
    '&' : BEGIN
           Lu(symAnd);
           IF PL^='&' THEN
            Lu(symLogAnd);
          END;
    '|' : BEGIN
           Lu(symOr);
           IF PL^='|' THEN
            Lu(symLogOr);
          END;
    '!' : Lu2(symNot, symDifferent);
    '<' : Lu2(symPlusPetit, symPlusPetitOuEgal);
    '>' : Lu2(symPlusGrand, symPlusGrandOuEgal);
    '(' : Lu(symParenthese1);
    ')' : Lu(symParenthese2);
    '.' : Lu(symPoint);
    ',' : Lu(symVirgule);
    '''': BEGIN
           Inc(PL);
           Trim;
           FOR I:=1 TO 3 DO
            BEGIN
             SymboleVecteur[I]:=LireReel;
             Trim;
            END;
           IF PL^<>'''' THEN
            Erreur(4098);
           Lu(symVecteur);
          END;
    '"' : BEGIN
           Inc(PL);
           J:=0;
           Surbrillance:=False;
           WHILE PL^<>'"' DO
            BEGIN
             Normal:=True;
             CASE PL^ OF
              #0  : Erreur(4099);
              '\' : begin
                     Inc(PL);
                     case UPCASE(PL^) of
                      'N': begin
                            SymboleMot[J]:=#10; Inc(J);
                            Normal:=False;
                           end;
                      'Q': begin
                            SymboleMot[J]:='"'; Inc(J);
                            Normal:=False;
                           end;
                      '0'..'9','A'..'F':
                       if Upcase(PL[1]) in ['0'..'9','A'..'F'] then
                        begin
                         if PL^<='9' then
                          I:=Ord(PL^)-Ord('0')
                         else
                          I:=Ord(Upcase(PL^))-(Ord('A')-10);
                         Inc(PL);
                         I:=I*16;
                         if PL^<='9' then
                          Inc(I, Ord(PL^)-Ord('0'))
                         else
                          Inc(I, Ord(Upcase(PL^))-(Ord('A')-10));
                         SymboleMot[J]:=Chr(I); Inc(J);
                         Normal:=False;
                        end;
                      'H': begin
                            Surbrillance:=True;
                            Normal:=False;
                           end;
                      'L': begin
                            Surbrillance:=False;
                            Normal:=False;
                           end;
                     end;
                    end;
             END;
             if Normal then
              begin
               if Surbrillance then
                SymboleMot[J]:=Chr(Ord(PL^) or 128)
               else
                SymboleMot[J]:=PL^;
               Inc(J);
              end;
             Inc(PL);
            END;
           SymboleMot[J]:=#0;
           Lu(symChaine);
          END;
    '$': Lu(symDollar);
    '[': Lu(symCrochet1);
    ']': Lu(symCrochet2);
    ELSE Erreur(4100);
   END;
   Trim;
  END;

  procedure TypeEtendu(var Result: TTypeEtendu);
  begin
   Result.T:=SymboleType;
   Result.NbArg:=-1;
   Lire(symType);
   if Symbole=symParenthese1 then
    begin
     Lire(symParenthese1);
     Result.NbArg:=0;
     if Symbole<>symParenthese2 then
      repeat
       Inc(Result.NbArg);
       with Result.Arg[Result.NbArg] do
        begin
         T:=SymboleType;
         Lire(symType);
         if (T=tInconnu) and (Symbole=symParenthese1) then
          begin
           Lire(symParenthese1);
           Lire(symParenthese2);
           T:=tFrPtr;
          end;
         StrLCopy(Nom, SymboleMot, SizeOf(Nom));
        end;
       if Symbole in [symVariable, symObjVar] then
        Lire(symInconnu)
       else
        Lire(symIdent);
       if Symbole=symParenthese2 then Break;
       Lire(symVirgule);
      until False;
     Lire(symParenthese2);
    end;
  end;

  procedure ChargerFrame(Pos: LongInt; var Result: TFrame);
  var
   L: LongInt;
  begin
   Seek(Files[6], 4*Pos);
   BlockRead(Files[6], L, 4);
   Seek(Files[6], LongInt(NDatas)*4);
   Seek(Files[4], L*SizeOf(TFrame));
   BlockRead(Files[4], Result, SizeOf(TFrame));
  end;

  function DefVar(var L: TVarCollection; const T: TTypeEtendu) : Integer;
  forward;

TYPE
 TExprFlags = (fInstr, fPeutAffecter);
 PExpr = ^TExpr;
 TExpr = RECORD
          P, P2, Instr : WORD;
          T            : TType;
          Flags        : SET OF TExprFlags;
         END;

VAR
 ResultatAppel : PExpr;

  PROCEDURE Coder(Instr, Arg1, Arg2, Arg3 : WORD);
  VAR
   Tampon : ARRAY[1..4] OF WORD;
  BEGIN
   Tampon[1]:=Instr;
   Tampon[2]:=Arg1;
   Tampon[3]:=Arg2;
   Tampon[4]:=Arg3;
   BlockWrite(Files[1], Tampon, SizeOf(Tampon));
   INC(NQCode);
  END;

  PROCEDURE Transm(const De : TExpr; A : PExpr);

  BEGIN
   IF @De=ResultatAppel THEN
    ResultatAppel:=A;
  END;

  FUNCTION Immediat(const E : TExpr) : WORD;

  BEGIN
   IF fInstr IN E.Flags THEN
    BEGIN
     Coder(E.Instr, E.P, E.P2, NDatas);
     Immediat:=NDatas;
     BlockWrite(Files[6], Zero, 4*TailleType[E.T]);
     INC(NDatas, TailleType[E.T]);
    END
   ELSE
    Immediat:=E.P;
  END;

  PROCEDURE Expression(var Result : TExpr); FORWARD;

  PROCEDURE CoderAppel(PosAppel : WORD);

  VAR
   NbArg,I : INTEGER;
   Args    : ARRAY[1..8] OF TExpr;

  BEGIN
   Lire(symParenthese1);
   NbArg:=0;
   IF Symbole<>symParenthese2 THEN
    REPEAT
     INC(NbArg);
     IF Symbole=symObjVar THEN
      WITH Args[NbArg] DO
       BEGIN
        P:=SymboleVar.Pos;
        Flags:=[];
        T:=tObjData;
        Lire(symObjVar);
       END
     ELSE
      Expression(Args[NbArg]);
     IF Symbole=symParenthese2 THEN Break;
     Lire(symVirgule);
    UNTIL False;
   FOR I:=1 TO NbArg DO
    BEGIN
     WITH Args[I] DO
      IF fInstr IN Flags THEN
       Coder(Instr, P, P2, I*3+1)
      ELSE
       Coder($20, P, I*3+1, 0);
     Transm(Args[I], Nil);
    END;
   Coder($33+NbArg, PosAppel, 0, 0);
   Lire(symParenthese2);
  END;

  PROCEDURE chk(const E : TExpr; T : TType);

  BEGIN
  {IF (E.T<>tInconnu) and (T<>tInconnu) and (E.T<>T) THEN
    Erreur(4101);}
  END;
  
  CONST
   Affecte : ARRAY[Boolean, TType] OF WORD =
    (($1F, $21, $1F, $20, $22, $23, $24),
     ($25, $27, $25, $26, $28, $29, $2A));

  PROCEDURE Expression(var Result : TExpr);

   PROCEDURE ExprEtOu(var Result : TExpr);

    PROCEDURE ExprComparaison(var Result : TExpr);

     PROCEDURE ExprPlusMoins(var Result : TExpr);

      PROCEDURE ExprFoisDivise(var Result : TExpr);

       PROCEDURE ExprNot(var Result : TExpr);

        PROCEDURE ExprFinal(var Result : TExpr);

         PROCEDURE Appel;

         VAR
          F : TVarStruct;
         {R : TResApp;}

         BEGIN
          F:=SymboleVar;
          Lire(symVariable);
          IF Symbole=symParenthese1 THEN
           BEGIN
            IF Assigned(ResultatAppel) AND
             ((ResultatAppel^.P=1)
              OR ((fInstr IN ResultatAppel^.Flags) AND (ResultatAppel^.P2=1))) THEN
             BEGIN
              Coder(Affecte[False, ResultatAppel^.T], 1, NDatas, 0);
              IF ResultatAppel^.P=1 THEN
               ResultatAppel^.P:=NDatas
              ELSE
               ResultatAppel^.P2:=NDatas;
              BlockWrite(Files[6], Zero, 4*TailleType[ResultatAppel^.T]);
              INC(NDatas, TailleType[ResultatAppel^.T]);
             END;
            CoderAppel(F.Pos);
            ResultatAppel:=@Result;
            Result.P:=1;
            Result.T:=tInconnu;
           {Result.Flags:=[];
            Coder(Affecte[False, F^.TypeExpr], 1, NDatas, 0);
            Result.P:=NDatas;
            Result.T:=F^.TypeExpr;
            Datas.Write(Zero, 4*TailleType[F^.TypeExpr]);
            INC(NDatas, TailleType[F^.TypeExpr]);}
           {Result.P:=ResultatAppels.Count;
            IF Result.P>0 THEN
             BEGIN
              R.P:=ResultatAppels.At(Result.P-1);
              IF R.Pos=1 THEN
               BEGIN
                Coder(Affecte[False, R.TypeRetour], 1, NDatas, 0);
                R.Pos:=NDatas;
                Datas.Write(Zero, 4*TailleType[R.TypeRetour]);
                INC(NDatas, TailleType[R.TypeRetour]);
                ResultatAppels.AtPut(Result.P-1, R.P);
               END;
             END;
            Result.T:=F^.TypeExpr;
            Result.Flags:=[fResultatAppel];
            R.Pos:=1;
            R.TypeRetour:=Result.T;
            ResultatAppels.Insert(R.P);}
           END
          ELSE
           BEGIN
            Result.P:=F.Pos;
            Result.T:=tFrPtr;
           END;
          Result.Flags:=[];
         END;

        VAR
         St : TVarStruct;
         I  : Integer;

        BEGIN
         CASE Symbole OF
          symVariable    : if SymboleVar.InfoType=tFrPtr then
                            Appel
                           else
                            BEGIN
                             Result.P:=SymboleVar.Pos;
                             Result.T:=SymboleVar.InfoType;
                             Result.Flags:=[fPeutAffecter];
                             Lire(symVariable);
                            END;
          symReel        : BEGIN
                            St.InfoType:=tReel;
                            St.Sys:=0;
                            St.Pos:=EcrireReel(SymboleReel);
                            St.Nom:=Immediate;
                            BlockWrite(Files[2], St, SizeOf(St));
                            Result.P:=St.Pos;
                            Result.T:=tReel;
                            Result.Flags:=[];
                            Lire(symReel);
                           END;
          symChaine      : BEGIN
                            LongInt(SymboleReel):=EcrireChaine;
                           {IF ObjChaine^.Immediat=0 THEN
                             BEGIN
                              ObjChaine^.Immediat:=NDatas;
                              Datas.Write(SymboleReel, 4);
                              INC(NDatas);
                             END;}
                            St.InfoType:=tStr;
                            St.Sys:=0;
                            St.Pos:={ObjChaine^.Immediat} EcrireReel(SymboleReel);
                            St.Nom:=Immediate;
                            BlockWrite(Files[2], St, SizeOf(St));
                            Result.P:=St.Pos;
                            Result.T:=tStr;
                            Result.Flags:=[];
                            Lire(symChaine);
                           END;
          symVecteur     : BEGIN
                            St.InfoType:=tVecteur;
                            St.Sys:=0;
                            St.Pos:=EcrireVecteur(SymboleVecteur);
                            St.Nom:=Immediate;
                            BlockWrite(Files[2], St, SizeOf(St));
                            Result.P:=St.Pos;
                            Result.T:=tVecteur;
                            Result.Flags:=[];
                            Lire(symVecteur);
                           END;
          symParenthese1 : BEGIN
                            Lire(symParenthese1);
                            Expression(Result);
                            Lire(symParenthese2);
                           END;
          symDollar : BEGIN
                       Lire(symDollar);
                       if not (Symbole in [symIdent, symVariable, symObjVar]) then
                        Erreur(4113);
                       I:=0;
                       while (I<MdlFrames^.Count)
                         and (StrIComp(PChar(MdlFrames^.At(I)), SymboleMot)<>0) do
                        Inc(I);
                       if I>=MdlFrames^.Count then
                        Erreur(4113);
                       SymboleReel:=I;
                       Symbole:=symReel;
                       ExprFinal(Result);
                      END;
          ELSE
           Erreur(4102);
         END;
        END;

       var
        St: TVarStruct;
        Lu: Word;

       BEGIN
        ExprFinal(Result);
        WHILE Symbole=symPoint DO
         BEGIN
          IF Result.T<>tPtr THEN
           Erreur(4103);
          Result.P:=Immediat(Result);
          VariableObjet:=True;
          Lire(symPoint);
          VariableObjet:=False;
          Result.P2:=SymboleVar.Pos;
         {Seek(Files[6], 4*LongInt(Result.P2));
          BlockRead(Files[6], St.Nom, 4);
          Seek(Files[6], 4*LongInt(NDatas));
          Seek(Files[3], SizeOf(St));
          Cherche:=St.Nom;
          repeat
           BlockRead(Files[3], St, SizeOf(St), Lu);
           if Lu<SizeOf(St) then
            begin
             St.InfoType:=tInconnu;
             Break;
            end;
          until (St.Pos = Cherche);}
          Seek(Files[3], SizeOf(St));
          repeat
           BlockRead(Files[3], St, SizeOf(St), Lu);
           if Lu<SizeOf(St) then
            begin
             St.InfoType:=tInconnu;
             Break;
            end;
          until StrIComp(LireChaine(St.Nom), SymboleMot)=0;
          Lire(symObjVar);
          Result.T:=St.InfoType;
          CASE Result.T OF
           tVecteur : Result.Instr:=$19;
           tStr     : Result.Instr:=$1A;
           tPtr     : Result.Instr:=$1B;
           tFrPtr   : Result.Instr:=$1D;
           ELSE       Result.Instr:=$18;
          END;
          Result.Flags:=[fInstr, fPeutAffecter];
         END;
       END;

      BEGIN
       IF Symbole=symNot THEN
        BEGIN
         Lire(symNot);
         ExprNot(Result);
         Result.P:=Immediat(Result);
         CASE Result.T OF
          tStr   : Result.Instr:=$2E;
          tPtr   : Result.Instr:=$2F;
          tFrPtr : Result.Instr:=$30;
          ELSE     Result.Instr:=$2C;
         END;
         Result.P2:=0;
         Result.T:=tReel;
         Result.Flags:=[fInstr];
        END
       ELSE
        ExprNot(Result);
      END;

     VAR
      E : TExpr;
      Divise : BOOLEAN;

     BEGIN
      ExprFoisDivise(Result);
      WHILE Symbole IN [symFois, symDivise] DO
       BEGIN
        Result.P:=Immediat(Result);
        Divise:=Symbole=symDivise;
        Lire(symInconnu);
        ExprFoisDivise(E);
        IF Divise THEN
         BEGIN
          chk(E,tReel);
          chk(Result,tReel);
          Result.Instr:=$05;
         END
        ELSE
         IF Result.T=tVecteur THEN
          IF E.T=tVecteur THEN
           BEGIN
            Result.Instr:=$02;
            Result.T:=tReel;
           END
          ELSE
           BEGIN
            chk(E,tReel);
            Result.Instr:=$04;
           END
         ELSE
          BEGIN
           chk(Result,tReel);
           IF E.T=tVecteur THEN
            BEGIN
             Result.Instr:=$03;
             Result.T:=tVecteur;
            END
           ELSE
            BEGIN
             chk(E,tReel);
             Result.Instr:=$01;
             Result.T:=tReel;
            END;
          END;
        Result.P2:=Immediat(E);
        Transm(E, @Result);
        Result.Flags:=[fInstr];
       END;
     END;

    VAR
     E : TExpr;

    BEGIN
     ExprPlusMoins(Result);
     WHILE (Symbole IN [symPlus, symMoins])
      or ((Symbole = symReel) and (SymboleReel<0)) DO
      BEGIN
       Result.P:=Immediat(Result);
       if Symbole <> symMoins then
        IF Result.T=tVecteur THEN
         Result.Instr:=$07
        ELSE
         BEGIN
          chk(Result,tReel);
          Result.Instr:=$06;
         END
       else
        IF Result.T=tVecteur THEN
         Result.Instr:=$09
        ELSE
         BEGIN
          chk(Result,tReel);
          Result.Instr:=$08;
         END;
       if Symbole<>symReel then
        Lire(symInconnu);
       ExprPlusMoins(E);
       chk(E, Result.T);
       Result.P2:=Immediat(E);
       Transm(E, @Result);
       Result.Flags:=[fInstr];
      END;
    END;

   VAR
    E : TExpr;

   BEGIN
    ExprComparaison(Result);
    WHILE Symbole IN [symEgal, symDifferent, symPlusPetit, symPlusPetitOuEgal,
    symPlusGrand, symPlusGrandOuEgal] DO
     BEGIN
      Result.P:=Immediat(Result);
      WITH Result DO
       CASE Symbole OF
        symEgal : CASE T OF
                   tVecteur : Instr:=$0B;
                   tStr     : Instr:=$0C;
                   tPtr     : Instr:=$0D;
                   tFrPtr   : Instr:=$0E;
                   ELSE Instr:=$0A;
                  END;
        symDifferent : CASE T OF
                        tVecteur : Instr:=$10;
                        tStr     : Instr:=$11;
                        tPtr     : Instr:=$12;
                        tFrPtr   : Instr:=$13;
                        ELSE Instr:=$0F;
                       END;
        symPlusPetit : Instr:=$16;
        symPlusGrand : Instr:=$17;
        symPlusPetitOuEgal : Instr:=$14;
        symPlusGrandOuEgal : Instr:=$15;
       END;
      IF Result.Instr>=$14 THEN
       chk(Result,tReel);
      Lire(symInconnu);
      ExprComparaison(E);
      chk(E, Result.T);
      Result.P2:=Immediat(E);
      Transm(E, @Result);
      Result.Flags:=[fInstr];
      Result.T:=tReel;
     END;
   END;

  VAR
   E, Cible : TExpr;

  BEGIN
   ExprEtOu(Cible);
   WHILE Symbole IN [symOr, symAnd, symLogOr, symLogAnd] DO
    BEGIN
    {chk(Cible,tReel);}
     Cible.P:=Immediat(Cible);
     WITH Cible DO
      CASE Symbole OF
       symOr     : Instr:=$41;
       symAnd    : Instr:=$40;
       symLogOr  : Instr:=$3F;
       symLogAnd : Instr:=$3E;
      END;
     Lire(symInconnu);
     ExprEtOu(E);
    {chk(E,tReel);}
     Cible.P2:=Immediat(E);
     Transm(E, @Cible);
     Cible.Flags:=[fInstr];
    END;
   IF Symbole=symAffecte THEN
    BEGIN
     IF NOT (fPeutAffecter IN Cible.Flags) THEN
      Erreur(4104);
     Lire(symAffecte);
     Expression(E);
     chk(E, Cible.T);
     IF fInstr IN Cible.Flags THEN
      BEGIN
       Coder($1E, Cible.P, Cible.P2, NDatas);
       Cible.P:=NDatas;
       BlockWrite(Files[6], Zero, 4);
       INC(NDatas);
      END;
     IF (fInstr IN E.Flags) AND NOT (fInstr IN Cible.Flags) THEN
      BEGIN
       Coder(E.Instr, E.P, E.P2, Cible.P);
       Transm(E, Nil);
       Result.P:=Cible.P;
      END
     ELSE
      BEGIN
       Result.P:=Immediat(E);
       Transm(E, @Result);
       Coder(Affecte[fInstr IN Cible.Flags, Cible.T], Result.P, Cible.P, 0);
      END;
     Result.T:=Cible.T;
     Result.Flags:=[];
    END
   ELSE
    BEGIN
     Result:=Cible;
     Transm(Cible, @Result);
    END;
  END;

  procedure QCodeSeek(Pos1: LongInt; Delta: LongInt);
  begin
   Seek(Files[1], Pos1*8+Delta);
  end;

  function CompilerBloc : Integer;  { result = taille var. locales }

  VAR
   E    : TExpr;
   Pos1 : LONGINT;
   Pos2 : LONGINT;
   VL0  : PVarCollection;
   T    : TTypeEtendu;
   Ouvert, PVirg:Boolean;
   Result: Integer;

  BEGIN
   Result:=0;
   VL0:=Nil;
   Ouvert:=Symbole=symAccolade1;
   if Ouvert then
    Lire(symAccolade1);
   REPEAT
    PVirg:=True;
    CASE Symbole OF
     symPointVirgule : ;
     symAccolade2 : if Ouvert then Break;
    {symDiese : BEGIN
                 Lire(symDiese);
                 R:=SymboleReel;
                 Lire(symReel);
                 F:=SymboleFunc;
                 Lire(symAppel);
                 St.InfoType:=tReel;
                 St.Sys:=0;
                 St.Pos:=EcrireReel(R);
                 St.Nom:=Immediate;
                 DSDesc.Write(St, SizeOf(St));
                 Coder($3C, St.Pos, F^.Pos, 0);
                END;}
     symIF    : BEGIN
                 Lire(symIF);
                 Lire(symParenthese1);
                 Expression(E);
                 Lire(symParenthese2);
                 E.P:=Immediat(E);
                 ResultatAppel:=Nil;
                 Pos1:=NQCode;
                 Coder($32, E.P, 0, 0);
                 Inc(Result, CompilerBloc);
                 QCodeSeek(Pos1, +4);
                 Pos1:=NQCode-Pos1;
                 if Symbole=symPointVirgule then
                  Lire(symPointVirgule);
                 IF Symbole=symELSE THEN
                  INC(Pos1);
                 BlockWrite(Files[1], Pos1, 2);
                 QCodeSeek(NQCode, 0);
                 IF Symbole=symELSE THEN
                  BEGIN
                   Pos1:=NQCode;
                   Coder($3D, 0, 0, 0);
                   Lire(symELSE);
                   Inc(Result, CompilerBloc);
                   QCodeSeek(Pos1, +2);
                   Pos1:=NQCode-Pos1;
                   BlockWrite(Files[1], Pos1, 2);
                   QCodeSeek(NQCode, 0);
                  END;
                 PVirg:=False;
                END;
     symWHILE : BEGIN
                 Lire(symWHILE);
                 Pos1:=NQCode;
                 Lire(symParenthese1);
                 Expression(E);
                 Lire(symParenthese2);
                 E.P:=Immediat(E);
                 ResultatAppel:=Nil;
                 Pos2:=NQCode;
                 Coder($32, E.P, 0, 0);
                 Inc(Result, CompilerBloc);
                 Coder($3D, Pos1-NQCode, 0, 0);
                 QCodeSeek(Pos2, +4);
                 Pos1:=NQCode-Pos2;
                 BlockWrite(Files[1], Pos1, 2);
                 QCodeSeek(NQCode, 0);
                 PVirg:=False;
                END;
     symDO    : BEGIN
                 Lire(symDO);
                 Pos1:=NQCode;
                 Inc(Result, CompilerBloc);
                 Lire(symWHILE);
                 Lire(symParenthese1);
                 Expression(E);
                 Lire(symParenthese2);
                 E.P:=Immediat(E);
                 ResultatAppel:=Nil;
                 Coder($31, E.P, Pos1-NQCode, 0);
                END;
     symRETURN: BEGIN
                 Lire(symRETURN);
                 if Symbole<>symPointVirgule then
                  begin
                   Expression(E);
                   Coder($2B, Immediat(E), 0, 0);
                   ResultatAppel:=Nil;
                  end
                 else
                  Coder($2B, 0, 0, 0);
                END;
     symAccolade1: begin
                    Inc(Result, CompilerBloc);
                    ResultatAppel:=Nil;
                    PVirg:=False;
                   end;
     symLOCAL: begin
                if VL0=Nil then
                 begin
                  VL0:=New(PVarCollection, Init(VarLocales^.Count,1));
                  for Pos1:=0 to VarLocales^.Count-1 do
                   VL0^.Insert(VarLocales^.At(Pos1));
                 end;
                Lire(symLocal);
                TypeEtendu(T);
                Inc(Result, DefVar(VarLocales^, T));
               end;
    ELSE BEGIN
          Expression(E);
          E.P:=Immediat(E);
          IF (Symbole=symParenthese1) AND (E.T=tFrPtr) THEN
           CoderAppel(E.P);
          ResultatAppel:=Nil;
         END;
    END;
    if not Ouvert then begin CompilerBloc:=Result; Exit; end;
    if PVirg then
     Lire(symPointVirgule);
   {ResultatAppels.DeleteAll;}
   UNTIL False;
   if VL0<>Nil then
    begin
     for Pos1:=VarLocales^.Count-1 downto 0 do
      if VL0^.IndexOf(VarLocales^.At(Pos1))<0 then
       VarLocales^.AtFree(Pos1);
     VL0^.DeleteAll;
     Dispose(VL0, Done);
    end;
   Lire(symAccolade2);
   CompilerBloc:=Result;
  END;

  function DefVar(var L: TVarCollection; const T: TTypeEtendu) : Integer;
  var
   Taille, I: Integer;
   Variable: TVarStruct;
   F: TFrame;
   V: Vecteur;
   S: PChar;

    procedure Definir;
    begin
     Variable.Pos:=NDatas;
     Variable.Sys:=0;
     Variable.Nom:=EcrireChaine;
     L.Add(SymboleMot, Variable);
     BlockWrite(Files[2], Variable, SizeOf(Variable));
    end;

  begin
   if T.NbArg<0 then
    begin
     Variable.InfoType:=T.T;
     Taille:=TailleType[T.T];
    end
   else
    begin
     Variable.InfoType:=tFrPtr;
     Taille:=1;
    end;
   if (Symbole=symVariable)
   and (VariableEstLocale xor (@L=@VarGlobales)) then
    begin
    {if Variable.InfoType <> SymboleVar.InfoType then
      Erreur(4105);
     if Variable.InfoType=tFrPtr then
      begin
       ChargerFrame(SymboleVar.Pos, F);
       if F.Code<0 then
        Erreur(4106);
       if F.NbArguments <> T.NbArg then
        Erreur(4107);
       for I:=1 to T.NbArg do
        if TailleType[T.Arg[I].T] <> F.Args[I] then
         Erreur(4108);
      end;}
     Variable:=SymboleVar;
     Lire(symVariable);
     Variable.Nom:=0;
    end
   else
    begin
     Definir;
     if Symbole in [symVariable, symObjVar] then
      Lire(symInconnu)
     else
      Lire(symIdent);
     Seek(Files[6], 4*LongInt(NDatas));
     BlockWrite(Files[6], Zero, 4*Taille);
     if Variable.InfoType = tVecteur then
      begin
       Variable.InfoType:=tReel;
       GetMem(S, SizeOf(SymboleMot));
       StrCopy(S, SymboleMot);
       StrCat(SymboleMot, '_x');
       Definir;
       Inc(NDatas);
       StrCat(StrCopy(SymboleMot, S), '_y');
       Definir;
       Inc(NDatas);
       StrCat(StrCopy(SymboleMot, S), '_z');
       Definir;
       Inc(NDatas);
       FreeMem(S, SizeOf(SymboleMot));
      end
     else
      Inc(NDatas, Taille);
    end;
   DefVar:=Taille;
   if Symbole = symAffecte then
    begin
     Lire(symAffecte);
     if T.NbArg<0 then
      case T.T of
       tStr: begin
              LongInt(V[1]):=EcrireChaine;
              Lire(symChaine);
             end;
       tReel: begin
               V[1]:=SymboleReel;
               Lire(symReel);
              end;
       tVecteur: begin
                  V:=SymboleVecteur;
                  Lire(symVecteur);
                 end;
       else Erreur(4109);
      end
     else
      begin
       VarLocales:=New(PVarCollection, Init(16,16));
       Seek(Files[6], 4*LongInt(Variable.Pos));
       BlockRead(Files[6], V, 4);
       Seek(Files[6], LongInt(NDatas)*4);
       if Variable.Nom=0 then
        Variable.Nom:=EcrireChaine;
       if LongInt(V[1])<>0 then
        begin
         Seek(Files[4], LongInt(V[1])*SizeOf(TFrame));
         BlockRead(Files[4], F, SizeOf(TFrame));
         SymboleVar.Pos:=NDatas;
         Inc(NDatas);
         BlockWrite(Files[6], V, 4);
         SymboleVar.InfoType:=tFrPtr;
         VarLocales^.Add('INHERITED', SymboleVar);
         Move(SymboleMot, SymboleMot[10], SizeOf(SymboleMot)-11);
         SymboleMot[High(SymboleMot)]:=#0;
         StrMove(SymboleMot, 'inherited_', 10);
         SymboleVar.Nom:=EcrireChaine;
         BlockWrite(Files[2], SymboleVar, SizeOf(SymboleVar));
         F.NomFrame:=SymboleVar.Nom;
         Seek(Files[4], LongInt(V[1])*SizeOf(TFrame));
         BlockWrite(Files[4], F, SizeOf(TFrame));
        end;
       FillChar(F, SizeOf(F), 0);
       F.Code:=NQCode;
       F.LocData:=NDatas;
       F.LocSize:=0;
       F.NbArguments:=T.NbArg;
      {if Variable.Nom=0 then
        Variable.Nom:=EcrireChaine;}
       F.NomFrame:=Variable.Nom;
       F.NomFich:=NomPatch;
       for I:=1 to T.NbArg do
        begin
         Taille:=TailleType[T.Arg[I].T];
         F.Args[I]:=Taille;
         Inc(F.LocSize, Taille);
         SymboleVar.Pos:=NDatas;
         Inc(NDatas, Taille);
         BlockWrite(Files[6], Zero, 4*Taille);
         SymboleVar.InfoType:=T.Arg[I].T;
         SymboleVar.Sys:=0;
         VarLocales^.Add(PChar(@T.Arg[I].Nom[0]), SymboleVar);
         S:=StrECopy(SymboleMot, T.Arg[I].Nom);
         SymboleVar.Nom:=EcrireChaine;
         BlockWrite(Files[2], SymboleVar, SizeOf(SymboleVar));
         if SymboleVar.InfoType = tVecteur then
          begin
           SymboleVar.InfoType:=tReel;
           StrCopy(S, '_x');
           VarLocales^.Add(SymboleMot, SymboleVar);
           SymboleVar.Nom:=EcrireChaine;
           BlockWrite(Files[2], SymboleVar, SizeOf(SymboleVar));
           Inc(SymboleVar.Pos);
           S[1]:='y';
           VarLocales^.Add(SymboleMot, SymboleVar);
           SymboleVar.Nom:=EcrireChaine;
           BlockWrite(Files[2], SymboleVar, SizeOf(SymboleVar));
           Inc(SymboleVar.Pos);
           S[1]:='z';
           VarLocales^.Add(SymboleMot, SymboleVar);
           SymboleVar.Nom:=EcrireChaine;
           BlockWrite(Files[2], SymboleVar, SizeOf(SymboleVar));
          end;
        end;

       if (Symbole=symCrochet1) and (F.NbArguments=0) then
        begin
         Lire(symCrochet1);
         if Symbole=symReel then
          begin
           V[2]:=SymboleReel;
           Lire(symReel);
          end
         else
          begin
           Lire(symDollar);
           if not (Symbole in [symIdent, symVariable, symObjVar]) then
            Erreur(4113);
           I:=0;
           while (I<MdlFrames^.Count)
            and (StrIComp(PChar(MdlFrames^.At(I)), SymboleMot)<>0) do
             Inc(I);
           if I>=MdlFrames^.Count then
            Erreur(4113);
           V[2]:=I;
           Lire(symInconnu);
          end;
         I:=NDatas;
         Inc(NDatas);
         BlockWrite(Files[6], V[2], 4);
         Lire(symVirgule);
         if Symbole=symVariable then
          begin
           if SymboleVar.InfoType<>tFrPtr then
            Erreur(4111);
           Coder($3C, I, SymboleVar.Pos, 0);
           Lire(symVariable);
          end
         else
          begin
           SymboleVar.Pos:=Variable.Pos;
           Definir;
           Inc(NDatas);
           BlockWrite(Files[6], Zero, 4);
           Coder($3C, I, Variable.Pos, 0);
           Variable.Pos:=SymboleVar.Pos;
           if Symbole=symObjVar then
            Lire(symObjVar)
           else
            Lire(symIdent);
          end;
         Lire(symCrochet2);
        end;

       ResultatAppel:=Nil;
       Inc(F.LocSize, CompilerBloc);
       Coder(0, 0, 0, 0);

       Dispose(VarLocales, Done);
       VarLocales:=Nil;
       Taille:=1;

       LongInt(V[1]):=NoFrame;
       Seek(Files[4], SizeOf(F)*NoFrame);
       BlockWrite(Files[4], F, SizeOf(F));
       Inc(NoFrame);
      end;
     Seek(Files[6], 4*LongInt(Variable.Pos));
     BlockWrite(Files[6], V, 4*Taille);
    end
   else
    if Symbole=symVirgule then
     begin
      Lire(symVirgule);
      DefVar:=Taille + DefVar(L, T);
     end;
  end;

  procedure DefObjVar;
  var
   T: TType;
   L: LongInt;
   C: Char;
   P: PChar;
  begin
   Lire(symPoint);
   T:=SymboleType;
   Lire(symType);
   if Symbole=symParenthese1 then
    begin
     Lire(symParenthese1);
     if Symbole<>symParenthese2 then
      repeat
       Lire(symType);
       Lire(symInconnu);
       if Symbole=symParenthese2 then Break;
       Lire(symVirgule);
      until False;
     Lire(symParenthese2);
     T:=tFrPtr;
    end;
   repeat
    SymboleVar.InfoType:=T;
    SymboleVar.Sys:=0;
    SymboleVar.Pos:=NDatas;
    Seek(Files[6], 4*LongInt(NDatas));
    Seek(Files[3], FileSize(Files[3]));
    L:=Entete.TailleLocData;
    SymboleVar.Pos:=L;
    SymboleVar.InfoType:=T;
    SymboleVar.Nom:=EcrireChaine;
    BlockWrite(Files[3], SymboleVar, 8);
    Entete.TailleLocData:=L+TailleType[T];
    SymboleVar.InfoType:=tObjData;
    SymboleVar.Pos:=NDatas;
    BlockWrite(Files[2], SymboleVar, 8);
    VarObjet.Add(SymboleMot, SymboleVar);
    Inc(NDatas);
    BlockWrite(Files[6], L, 4);
    if T=tVecteur then
     begin
      P:=StrEnd(SymboleMot);
      P[0]:='_';
      P[2]:=#0;
      for C:='x' to 'z' do
       begin
        P[1]:=C;
        SymboleVar.InfoType:=tReel;
        SymboleVar.Pos:=L;
        SymboleVar.Nom:=EcrireChaine;
        BlockWrite(Files[3], SymboleVar, 8);
        SymboleVar.InfoType:=tObjData;
        SymboleVar.Pos:=NDatas;
        BlockWrite(Files[2], SymboleVar, 8);
        VarObjet.Add(SymboleMot, SymboleVar);
        Inc(NDatas);
        BlockWrite(Files[6], L, 4);
        Inc(L);
       end;
     end;
    Lire(symInconnu);
    if Symbole<>symVirgule then Break;
    Lire(symVirgule);
   until False;
  end;

  procedure DefCodeAuto(Double: Boolean);
  var
   nCode: String[143];
   Temp: TDosStream;
  begin
   if PIPos=0 then
    begin
     Patch^.AtInsert(Patch^.Count, NewStr(NomPatchImpulse));
     Temp.Init(NomPatchImpulse, stCreate);
     nCode:='Void() W_WeaponFrame = {'#13#10;
     Temp.Write(nCode[1], Length(nCode));
    end
   else
    begin
     Temp.Init(NomPatchImpulse, stOpen);
     Temp.Seek(PIPos);
    end;
   Str(NoImpulse, nCode);
   nCode:='if (self.impulse == '+nCode+') { ';
   Temp.Write(nCode[1], Length(nCode));
   Temp.Write(SymboleMot, StrLen(SymboleMot));
   if not Double then
    nCode:='(); self.impulse=0; };'#13#10
   else
    begin
     Inc(NoImpulse);
     Str(NoImpulse, nCode);
     nCode:='(1); self.impulse=0; }'#13#10'else if (self.impulse == '+nCode
      +') { ';
     Temp.Write(nCode[1], Length(nCode));
     Temp.Write(SymboleMot, StrLen(SymboleMot));
     nCode:='(0); self.impulse=0; };'#13#10;
    end;
   Temp.Write(nCode[1], Length(nCode));
   PIPos:=Temp.GetPos;
   nCode:='inherited(); };';
   Temp.Write(nCode[1], Length(nCode));
   Temp.Done;
   Inc(NoImpulse);
  end;

  procedure DefCodeImpulse;
  var
   F: TFrame;
   S, S2: String[5];
   Pos: LongInt;
  begin
   Lire(symBIND);
   Touches.AtInsert(Touches.Count, NewStr(#255 + StrPas(SymboleMot)));
   Lire(symChaine);
   Lire(symVirgule);
   Touches.AtInsert(Touches.Count, NewStr(StrPas(SymboleMot)));
   Lire(symChaine);
   Lire(symVirgule);
   if Symbole<>symVariable then
    begin
     Touches.AtInsert(Touches.Count, NewStr(StrPas(SymboleMot)));
     Lire(symChaine);
    end
   else
    begin
     if SymboleVar.InfoType<>tFrPtr then
      Erreur(4111);
     ChargerFrame(SymboleVar.Pos, F);
     if (F.Code<0) or (F.NbArguments>1) then
      Erreur(4111);
     if (F.NbArguments=1) and (F.Args[1]<>1) then
      Erreur(4111);
     Str(NoImpulse, S);
     if F.NbArguments=0 then
      Touches.AtInsert(Touches.Count, NewStr('impulse ' + S))
     else
      begin
       Str(NoImpulse+1, S2);
       Touches.AtInsert(Touches.Count, NewStr('+impulse' + S));
       Touches.AtInsert(Touches.Count, NewStr('alias +impulse' + S + ' "impulse ' + S + '"'));
       Touches.AtInsert(Touches.Count, NewStr('alias -impulse' + S + ' "impulse ' + S2 + '"'));
      end;
     DefCodeAuto(F.NbArguments=1);
     Lire(symVariable);
    end;
  end;

  procedure DefCodeAutoexec;
  var
   Chaine: String;
   S: String[5];
   F: TFrame;
  begin
   Lire(symAUTOEXEC);
   Chaine:='';
   repeat
    if Symbole<>symVariable then
     begin
      Chaine:=Chaine+StrPas(SymboleMot);
      Lire(symChaine);
     end
    else
     begin
      if SymboleVar.InfoType<>tFrPtr then
       Erreur(4111);
      ChargerFrame(SymboleVar.Pos, F);
      if (F.Code<0) or (F.NbArguments>0) then
       Erreur(4111);
      Str(NoImpulse, S);
      DefCodeAuto(False);
      Lire(symVariable);
      Chaine:=Chaine+'impulse '+S;
     end;
    if Symbole<>symVirgule then Break;
    Lire(symVirgule);
   until False;
   Touches.AtInsert(Touches.Count, NewStr(Chaine));
  end;

  procedure DefMdlFrames;
  var
   S: String;
   Espace: Integer;
  begin
   Lire(symDollar);
   S:='';
   while PL^<>#0 do
    begin
     Inc(S[0]);
     S[Length(S)]:=PL^;
     Inc(PL);
    end;
   Trim;
   if (Symbole in [symIdent, symVariable, symObjVar])
   and (StrIComp(SymboleMot, 'frame')=0) then
    repeat
     while (S<>'') and (S[1] in [' ', #8, #9]) do
      Delete(S, 1, 1);
     if S='' then Break;
     Espace:=Pos(' ', S);
     if Espace=0 then
      Espace:=Length(S)+1;
     S[Espace]:=#0;
    {if MdlFrames.IndexOf(Nouveau)>=0 then
      Erreur(....);}
     if MdlFrames=Nil then
      MdlFrames:=New(PCollection, Init(8,8));
     MdlFrames^.Insert(StrNew(@S[1]));
     Delete(S, 1, Espace);
    until False;
   Symbole:=symPointVirgule;
  end;

  procedure EcrireResultat;
  const
   TailleTampon = 4096;
  var
   Dest: File;
   nEntete: TEntete;
   I: Integer;
   Tampon: Pointer;
   Reste: LongInt;
  begin
   Assign(Dest, NomCible);
   Rewrite(Dest, 1);
   GetMem(Tampon, TailleTampon);
   FillChar(nEntete, SizeOf(nEntete), 0);
   BlockWrite(Dest, nEntete, SizeOf(nEntete));
   nEntete:=Entete;
   for I:=1 to 6 do
    begin
     Reste:=FileSize(Files[I]);
     nEntete.Entrees[I].Pos:=FilePos(Dest);
     nEntete.Entrees[I].Nb:=Reste div FacteurT[I];
     Seek(Files[I], 0);
     while Reste>TailleTampon do
      begin
       BlockRead(Files[I], Tampon^, TailleTampon);
       BlockWrite(Dest, Tampon^, TailleTampon);
       Dec(Reste, TailleTampon);
      end;
     BlockRead(Files[I], Tampon^, Reste);
     BlockWrite(Dest, Tampon^, Reste);
     if Reste and 3 <> 0 then  { align to 4-byte boundary }
      BlockWrite(Dest, Zero, 3 - ((Reste-1) and 3));
    end;
   FreeMem(Tampon, TailleTampon);
   Seek(Dest, 0);
   BlockWrite(Dest, nEntete, SizeOf(nEntete));
   Close(Dest);
  end;

  procedure ChargerChaines;
  var
   P{, HeapEnd0}: Pointer;
   Lire: Word;
   PosChaines: LongInt;
   SegChaines: Word;
   S: String[5];

    procedure TrieVariables(L, R: LongInt);
    var
      I, J, Resultat: LongInt;
      P, T: TVarStruct;
      NomVar2: PChar;
    begin
      repeat
        I := L;
        J := R;
        P := Vars^[(L + R) shr 1];
        NomVar2:=Ptr(SegChaines + P.Nom shr 4, P.Nom and $F);
        repeat
          repeat
           with Vars^[I] do
            Resultat:=StrIComp(Ptr(SegChaines+Nom shr 4, Nom and $F), NomVar2);
           if (Resultat > 0)
           or ((Resultat = 0) and (Vars^[I].Pos <= P.Pos)) then
            Break;
           Inc(I);
          until False;
          repeat
           with Vars^[J] do
            Resultat:=StrIComp(Ptr(SegChaines+Nom shr 4, Nom and $F), NomVar2);
           if (Resultat < 0)
           or ((Resultat = 0) and (Vars^[J].Pos >= P.Pos)) then
            Break;
           Dec(J);
          until False;
          if I <= J then
          begin
            T := Vars^[I];
            Vars^[I] := Vars^[J];
            Vars^[J] := T;
            Inc(I);
            Dec(J);
          end;
        until I > J;
        if L < J then TrieVariables(L, J);
        L := I;
      until I >= R;
    end;

  begin
   SegChaines:=PtrRec(HeapEnd).Seg - (Entete.Entrees[5].Nb+15) shr 4;
   if SegChaines-32 <= PtrRec(HeapPtr).Seg then
    begin
     Str((PtrRec(HeapPtr).Seg-SegChaines) div 64 + 1, S);
     Error('Not enough memory to load Progs.dat (' + S + 'kb missing)');
    end;
  {HeapEnd0:=HeapEnd;
   HeapEnd:=Ptr(SegChaines, 0);}
   PosChaines:=0;
   P:=Ptr(SegChaines, 0);
   SEEK(Files[5], 0);
   while PosChaines<Entete.Entrees[5].Nb do
    begin
     if Entete.Entrees[5].Nb-PosChaines <= $8000 then
      Lire:=Entete.Entrees[5].Nb-PosChaines
     else
      Lire:=$8000;
     BlockRead(Files[5], P^, Lire);
     Inc(PosChaines, Lire);
     Inc(PtrRec(P).Seg, $800);
    end;
   TrieVariables(0, Entete.Entrees[2].Nb-2);
  {HeapEnd:=HeapEnd0;}
  end;

  procedure ReadProgsDat;
  const
   TailleTampon = 16384;
  var
   I: Integer;
   Reste: LongInt;
   Tampon: Pointer;
  begin
   GetMem(Tampon, TailleTampon);
   Origine:=Source^.GetPos;
   Source^.Read(Entete, SizeOf(Entete));
   if Entete.Version <> 6 then
    Error('Unknown file version in Quake''s Progs.dat');
   if Entete.Entrees[2].Nb*SizeOf(TVarStruct) > 65520 then
    Error('Too many variables (>64kb) in original Progs.dat');
   for I:=1 to 6 do
    begin
     Assign(Files[I], '~progs' + Chr(I+48) + '.tmp');
     Rewrite(Files[I], 1);
     Source^.Seek(Origine+Entete.Entrees[I].Pos);
     Reste:=Entete.Entrees[I].Nb * FacteurT[I];
     while Reste > TailleTampon do
      begin
       Source^.Read(Tampon^, TailleTampon);
       BlockWrite(Files[I], Tampon^, TailleTampon);
       Dec(Reste, TailleTampon);
      end;
     Source^.Read(Tampon^, Reste);
     BlockWrite(Files[I], Tampon^, Reste);
    end;
   FreeMem(Tampon, TailleTampon);
   Dispose(Source, Done);
  end;

var
 TE: TTypeEtendu;

begin
 Write('Compiling : ');
 FillChar(Zero, SizeOf(Zero), 0);
 NoImpulse:=Impulse0;
  { read informations from original Progs.dat }
{qmWrite('Analysing the original Progs.dat...', Yellow+16*Blue);}
 ReadProgsDat;
 GetMem(Vars, Pred(Entete.Entrees[2].Nb)*SizeOf(TVarStruct));
 Seek(Files[2], SizeOf(TVarStruct));
 BlockRead(Files[2], Vars^, Pred(Entete.Entrees[2].Nb)*SizeOf(TVarStruct));
 ChargerChaines;
   { compile patch }
 PIPos:=0;
 VarGlobales.Init(16,16);
 VarObjet.Init(16,16);
 NDatas:=Entete.Entrees[6].Nb;
 NoFrame:=Entete.Entrees[4].Nb;
 NQCode:=Entete.Entrees[1].Nb;
 NStrings:=Entete.Entrees[5].Nb;
{LigneCourante:=0;
 Ligne:='';
 PL:=PChar(Ligne);}
 PL:=Nil;
 CurrentFileIndex:=0;
 VarLocales:=Nil;
 MdlFrames:=Nil;
 StrCopy(SymboleMot, 'IMMEDIATE');
 Immediate:=EcrireChaine;
 Lire(symInconnu);
 while Symbole<>symEOF do
  begin
   case Symbole of
    symType: begin
              TypeEtendu(TE);
              DefVar(VarGlobales, TE);
             end;
    symPoint: DefObjVar;
    symBIND: DefCodeImpulse;
    symAUTOEXEC: DefCodeAutoexec;
    symDollar: DefMdlFrames;
    else Erreur(4110);
   end;
   Lire(symPointVirgule);
  end;
 LibererMdlFrames;
 EcrireResultat;
 ToutFermer;
 VarGlobales.Done;
 VarObjet.Done;
 FreeMem(Vars, Pred(Entete.Entrees[2].Nb)*SizeOf(TVarStruct));
 Writeln(' done.');
end;

procedure TVarCollection.Add;
var
 P: PVarStruct;
begin
 GetMem(P, SizeOf(TVarStruct)+StrLen(nNom)+1);
 P^:=St;
 StrCopy(PChar(P)+SizeOf(TVarStruct), nNom);
 Insert(P);
end;

procedure TVarCollection.FreeItem;
begin
 FreeMem(Item, SizeOf(TVarStruct)+StrLen(PChar(Item)+SizeOf(TVarStruct))+1);
end;

function TVarCollection.KeyOf;
begin
 KeyOf:=PChar(Item)+SizeOf(TVarStruct);
end;

function TVarCollection.Compare;
begin
 Compare:=StrIComp(PChar(Key1), PChar(Key2));
end;

end.