unit Textures;

interface

uses Objects, QmObj;

const
 SignatureBSP_private = $134ad853;

type
 TNomEntree = array[0..15] of Byte;
 TEnteteTex = record
               Nom: TNomEntree;
               W,H: LongInt;
               Indexes: array[0..3] of LongInt;
              end;
 TEntreesBsp = (eEntities, ePlanes, eMipTex, eVertices,
                eVisiList, eNodes, eUnknown, eSurfaces,
                eLightmaps, eBoundNodes, eLeaves, eListSurf,
                eEdges, eListEdges, eHulls);
 TEntreeBsp = record
               Position, Taille: LongInt;
              end;
 TEnteteBsp = record
               Signature: LongInt;
               Entrees: array[TEntreesBsp] of TEntreeBsp;
              end;

var
 AllTextures : PStringCollection;

procedure ExtraireTextures(Liste: PStringCollection; const NomFich: String);
procedure PreparerBSP(const NomFich: String; var Entree: TEntreeRepQM);

implementation

uses QMPak, QkUI;

const
 SignatureWad2 = $32444157;   { 'WAD2' }

type
 TEnteteWad = record
               Signature: LongInt;   { 'WAD2' }
               NbEntrees, PosRep: LongInt;
              end;
 PEntreeRep = ^TEntreeRep;
 TEntreeRep = record
               Position, Taille, Idem, InfoType: LongInt;
               Nom: TNomEntree;
              end;
 PTableauPos = ^TTableauPos;
 TTableauPos = array[0..0] of LongInt;

const
 NomEntreesBsp : array[TEntreesBsp] of String[10] =
  ('Entities', 'Planes', 'MipTex', 'Vertices',
   'VisiList', 'Nodes', 'TexInfo', 'Surfaces',
   'Lightmaps', 'BoundNodes', 'Leaves', 'ListSurf',
   'Edges', 'ListEdges', 'Hulls');

function ChercheTextureDans(const NomDir, NomBsp, Cherche: String; var EnteteTex: TEnteteTex; var SF: PStream) : Boolean;
var
 Entete: TEnteteBsp;
 L, Origine, I, Nb: LongInt;
 Positions: PTableauPos;
 ChercheNomTex: String[63];
 S: PStream;
begin
   { recherche de la texture dans le fichier .bsp }
 ChercheNomTex:=Cherche;
 if Cherche[Length(Cherche)]='*' then
  Dec(Byte(ChercheNomTex[0]));
 OpenQuakeEntry('maps/'+NomBsp+'.bsp', NomDir, S);
 Origine:=S^.GetPos;
 S^.Read(Entete, SizeOf(Entete));
 if (Entete.Signature = $1C) or (Entete.Signature = $1D)
 or (Entete.Signature = SignatureBSP_private) then
  begin
   L:=Origine + Entete.Entrees[eMipTex].Position;
   S^.Seek(L);
   S^.Read(Nb, 4);
   GetMem(Positions, Nb*4);
   S^.Read(Positions^, Nb*4);
   for I:=0 to Nb-1 do
    if Positions^[I]>0 then
     begin
      S^.Seek(Positions^[I]+L);
      S^.Read(EnteteTex, SizeOf(TEnteteTex));
      if CompareText(CharToPas(EnteteTex.Nom), ChercheNomTex) = 0 then
       begin
        PasToChar(EnteteTex.Nom, Cherche);  { ncessaire au cas o
         on a cherch un nom se terminant par *; dans ce cas,
         Entete contient le nom original d'ID, c'est--dire sans * }
        SF:=S;
        ChercheTextureDans:=True;
        FreeMem(Positions, Nb*4);
        Exit;
       end;
     end;
   FreeMem(Positions, Nb*4);
  end;
 Dispose(S, Done);
 ChercheTextureDans:=False;
end;

function EcrireTexture(const Nom: String; var Dest: TStream; Necessaire: Boolean) : Boolean;
var
 Cherche,S: String;
 Entete: TEnteteTex;
 I,J,K: Integer;
 SF: PStream;
begin
 Cherche:=Nom;
 LowerCase(Cherche);
 for K:=AllTextures^.Count-1 downto 0 do
  begin
   S:=PString(AllTextures^.At(K))^;
   I:=Pos('=',S);
   J:=Pos(#13,S);
   if (Copy(S,1,I-1) = Cherche)
   and ChercheTextureDans(Copy(S,J+1,255),
    Copy(S,I+1,J-I-1), Nom, Entete, SF) then
    begin
     Dest.Write(Entete, SizeOf(Entete));
     Dest.CopyFrom(SF^, (Entete.W*Entete.H*85) div 64);
     Dispose(SF, Done);
     EcrireTexture:=True;
     Exit;
    end;
  end;
 if Necessaire then
  Error('Texture not found : '+Nom);
 EcrireTexture:=False;
end;

procedure ExtraireTextures(Liste: PStringCollection; const NomFich: String);
var
 I, J: Integer;
 EnteteWad: TEnteteWad;
 Entree: TEntreeRep;
 OriginalTextures: TStringCollection;
 S: TNomTex;
 Ch: Char;
 Rep: TMemoryStream;
 Dest: TBufStream;
begin
 if (Liste^.Count>0) and (Liste^.At(0)=Nil) then
  Liste^.AtDelete(0);
 Writeln('Extracting ', Liste^.Count, ' textures...');
 Dest.Init(NomFich, stCreate, 1024);
 Dest.Write(EnteteWad, SizeOf(EnteteWad));
 Rep.Init(256,256);
 Entree.InfoType:=Ord('D');
 OriginalTextures.Init(Liste^.Count,1);
 for I:=0 to Liste^.Count-1 do
  OriginalTextures.AtInsert(I, Liste^.At(I));
 for I:=0 to OriginalTextures.Count-1 do
  begin
   S:=PString(OriginalTextures.At(I))^;
   if (Length(S)>=2)
   and (S[1]='+') and (S[2] in ['0'..'9', 'a'..'j']) then
    begin
     for Ch:='0' to '9' do
      begin
       S[2]:=Ch;
       if not Liste^.Search(@S, J) then
        Liste^.AtInsert(J, NewStr(S));
      end;
     for Ch:='a' to 'j' do
      begin
       S[2]:=Ch;
       if not Liste^.Search(@S, J) then
        Liste^.AtInsert(J, NewStr(S));
      end;
    end;
  end;
 EnteteWad.NbEntrees:=0;
 for I:=0 to Liste^.Count-1 do
  begin
   Entree.Position:=Dest.GetPos;
   S:=PString(Liste^.At(I))^;
   if EcrireTexture(S, Dest, OriginalTextures.Search(@S, J)) then
    begin
     PasToChar(Entree.Nom, S);
     Entree.Taille:=Dest.GetPos-Entree.Position;
     Entree.Idem:=Entree.Taille;
     Rep.Write(Entree, SizeOf(TEntreeRep));
     Inc(EnteteWad.NbEntrees);
    end;
  end;
 if EnteteWad.NbEntrees > OriginalTextures.Count then
  Writeln('Added ', EnteteWad.NbEntrees-OriginalTextures.Count,' animated texture frames');
 OriginalTextures.DeleteAll;
 OriginalTextures.Done;
 EnteteWad.PosRep:=Dest.GetPos;
 Rep.Seek(0);
 Dest.CopyFrom(Rep, EnteteWad.NbEntrees*SizeOf(TEntreeRep));
 Rep.Done;
 EnteteWad.Signature:=SignatureWad2;
 Dest.Seek(0);
 Dest.Write(EnteteWad, SizeOf(EnteteWad));
 Dest.Done;
end;

procedure PreparerBSP(const NomFich: String; var Entree: TEntreeRepQM);
var
 EnteteBsp: TEnteteBsp;
 E: TEntreesBsp;
 Liste, P: PChar;
 ListeTex: TStringCollection;
 S: String[63];
 I, Pos0, T: LongInt;
 Positions: PTableauPos;
 Dest: TBufStream;
begin
 ReadNXFEntry(Entree, 'Signature');
 SourceFile^.Read(EnteteBsp.Signature, SizeOf(EnteteBsp.Signature));
 if (EnteteBsp.Signature<>$1C) and (EnteteBsp.Signature<>$1D) then
  Error('The encapsulated file is not a valid .bsp');
 Dest.Init(NomFich, stCreate, 1024);
 Dest.Write(EnteteBsp, SizeOf(EnteteBsp));
 Pos0:=SizeOf(EnteteBsp);
 for E:=Low(E) to High(E) do
  begin
   T:=OpenNXFEntry(Entree, NomEntreesBsp[E]);
   if T<0 then
    Error('The encapsulated .bsp is invalid');
   case E of
    eMipTex: begin  { textures }
              if T>65520 then
               Error('Too many textures in .bsp');
              GetMem(Liste, T);
              SourceFile^.Read(Liste^, T);
              ListeTex.Init(16,16);
              P:=Liste;
              S:='';
              for I:=1 to T do
               begin
                if P^ in [#13,#10] then
                 begin
                  if S<>'' then
                   begin
                    ListeTex.AtInsert(ListeTex.Count, NewStr(S));
                    S:='';
                   end;
                 end
                else
                 S:=S+P^;
                Inc(P);
               end;
              if S<>'' then
               ListeTex.AtInsert(ListeTex.Count, NewStr(S));
              FreeMem(Liste, T);
              I:=ListeTex.Count;
              Dest.Write(I, SizeOf(I));
              T:=4*I;
              GetMem(Positions, T);
              Dest.Write(Positions^, T);
              for I:=0 to ListeTex.Count-1 do
               if PString(ListeTex.At(I))^=#1 then
                Positions^[I]:=-1
               else
                begin
                 Positions^[I]:=Dest.GetPos - Pos0;
                 EcrireTexture(PString(ListeTex.At(I))^, Dest, True);
                end;
              I:=Dest.GetPos;
              Dest.Seek(Pos0+SizeOf(I));
              Dest.Write(Positions^, T);
              Dest.Seek(I);
              FreeMem(Positions, T);
             end;
   else  { other entry types }
    Dest.CopyFrom(SourceFile^, T);
   end;
   EnteteBsp.Entrees[E].Taille:=Dest.GetPos-Pos0;
   EnteteBsp.Entrees[E].Position:=Pos0;
   Pos0:=Dest.GetPos;
   if Pos0 and 3 <> 0 then
    begin  { alignement sur double-mot }
     I:=0;
     Dest.Write(I, 4-(Pos0 and 3));
     Inc(Pos0, 4-(Pos0 and 3));
    end;
  end;
 Dest.Seek(0);
 Dest.Write(EnteteBsp, SizeOf(EnteteBsp));
 Dest.Done;
end;

end.