#ifndef __GL_SCRIPT__
#define __GL_SCRIPT__

#define TCMOD_STATIC		0
#define TCMOD_HSCROLL		1
#define TCMOD_VSCROLL		2
#define TCMOD_TURB			3

// Texture Coordinate Modifier
typedef struct {
	char		type;		// type of tcmod
	float		speed;		// speed of tcmod
} tcmod_t;

// Animation loop
typedef struct anim_stage_s {
	unsigned int			tex_id;		// OGL texture ID number
	struct anim_stage_s		*next;		// next anim stage
} anim_stage_t;

// Blending
typedef struct {
	float		source;		// source blend value
	float		dest;		// dest blend value
	qboolean	blend;		// are we going to blend?
} blendfunc_t;

typedef struct {
	float		min,max;	// min/max alpha values
	float		speed;		// shifting speed
} alphashift_t;

// Script stage
typedef struct rs_stage_s {
	unsigned int			tex_id;			// OGL texture ID number
	
	anim_stage_t			*anim_stage;	// first animation stage
	float					anim_delay;		// Delay between anim frames
	float					last_anim_time; // gametime of last frame change
	unsigned int			last_anim;		// texture ID of last frame

	blendfunc_t				blendfunc;		// image blending
	qboolean				alphafunc;		// alpha masking
	alphashift_t			alphashift;		// alpha shifting

	tcmod_t					tcmod[3];		// tex coord modifier (3 per stage)
} rs_stage_t;

// Base script
typedef struct rscript_s {
	char					name[24];	// name of script
	rs_stage_t				*stage;		// first rendering stage
	struct rscript_s		*next;		// next script in linked list
} rscript_t;

#endif // __GL_SCRIPT__