/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// snd_fmod.h -- client sound i/o functions based on the fmod API (By Robert 'Heffo' Heffernan)

#include "fmod.h"

typedef struct
{
	byte			*data;
	int				length;
	int				position;
	char			filename[MAX_QPATH];
} SND_OpenFiles_t;

typedef struct SND_Sample_s
{
	qboolean		loops;
	int				loopstart;
	int				loopstop;
	char			name[MAX_QPATH];
	FSOUND_SAMPLE	*sample;
} SND_Sample_t;

typedef struct
{
	int				ent;
	int				chan;
	float			attn;
	int				volume;
	int				subvolume;
	int				channel;
	int				pan;
	int				samplerate;
	qboolean		inuse;
	qboolean		locked;
	qboolean		is_static;
	qboolean		looping;
	vec3_t			origin;
	SND_Sample_t	*sample;
} SND_Channels_t;

typedef struct
{
	int				loopstart;
	int				looplength;
} SND_LoopInfo_t;

#define			MAX_CHANNELS						128
#define			MAX_DYNAMIC_CHANNELS				8
#define			MAX_SFX								512
#define			MAX_STATICFX						128

#define			CHAN_AUTO							0
#define			CHAN_WEAPON							1
#define			CHAN_VOICE							2
#define			CHAN_ITEM							3
#define			CHAN_BODY							4

#define			ATTN_NONE							0
#define			ATTN_NORM							1
#define			ATTN_IDLE							2
#define			ATTN_STATIC							3

#define			DEFAULT_SOUND_PACKET_VOLUME			255
#define			DEFAULT_SOUND_PACKET_ATTENUATION	ATTN_NORM

extern cvar_t			SND_MusicVolume;
extern cvar_t			SND_Volume;
extern cvar_t			SND_NoSound;
extern cvar_t			SND_Rate;
extern cvar_t			SND_AudioDriver;
extern cvar_t			SND_Performance;
extern cvar_t			SND_NoHardware3D;
extern cvar_t			SND_8bitOnly;
extern cvar_t			SND_FakeDolby;


// Functions
unsigned int SND_FOpen (const char *name);
void SND_FClose (unsigned int handle);
int SND_FRead (void *buffer, int size, unsigned int handle);
int SND_FSeek (unsigned int handle, int pos, signed char mode);
int SND_FTell (unsigned int handle);

void S_Restart (void);
void S_Init (void);
void S_Shutdown (void);

SND_Sample_t *S_PrecacheSound (const char *name);
void SND_FreeSample (SND_Sample_t *SND_Sample);
void S_TouchSound (char *sample);

void S_UpdateAmbientSounds (void);
void S_UpdateStaticSounds (void);
void S_Update (vec3_t origin, vec3_t v_forward, vec3_t v_right, vec3_t v_up);
void S_ExtraUpdate (void);
void S_BlockSound (void);
void S_UnblockSound (void);
SND_Channels_t *S_AllocateChannel(int entnum, int entchannel, int locked);
void S_Spatialize(SND_Channels_t *ch);
void S_StaticSpat(SND_Channels_t *ch);
void S_StartSound (int entnum, int entchannel, SND_Sample_t *sfx, vec3_t origin, float fvol,  float attenuation);
void S_StaticSound (SND_Sample_t *sfx, vec3_t origin, float vol, float attenuation);
void S_LocalSound (char *name);
void S_Play (void);
void S_PlayVol (void);
void S_StopSound (int entnum, int entchannel);
void S_StopAllSounds (qboolean clear);

void S_StartMusic (char *name, int loop);
void S_StopMusic (void);
void S_PauseMusic (void);
void S_ResumeMusic (void);
void S_StartMusicConsole (void);

void S_ChannelReport (void);
void S_SampleReport (void);

// Null Functions
void S_AmbientOff (void);
void S_AmbientOn (void);
void S_ClearBuffer (void);
void S_ClearPrecache (void);
void S_BeginPrecaching (void);
void S_EndPrecaching (void);